<?php
/***************************************************************************
 *                            admin_forumauth.php
 *                            -------------------
 *   begin                : Saturday, Feb 13, 2001
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *
 *   $Id: admin_forumauth.php,v 1.23.2.4 2002/05/21 16:52:08 psotfx Exp $
 *
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', 1);

if( !empty($setmodules) )
{
	$filename = basename(__FILE__);
	$module['Download']['Cat_Permissions']   = $filename;

	return;
}

//
// Load default header
//
$no_page_header = TRUE;
$phpbb_root_path = './../';
require($phpbb_root_path . 'extension.inc');
require('./pagestart.' . $phpEx);

include($phpbb_root_path . 'pafiledb/pafiledb_common.'.$phpEx);

$cat_auth_fields = array('auth_view', 'auth_read', 'auth_view_file', 'auth_upload', 'auth_download', 'auth_rate', 'auth_email', 'auth_view_comment', 'auth_post_comment', 'auth_edit_comment', 'auth_delete_comment');

$field_names = array(
	'auth_view' => $lang['View'],
	'auth_read' => $lang['Read'],
	'auth_view_file' => $lang['View_file'],
	'auth_upload' => $lang['Upload'],
	'auth_download' => $lang['Download_file'],
	'auth_rate' => $lang['Rate'],
	'auth_email' => $lang['Email'],
	'auth_view_comment' => $lang['View_comment'],
	'auth_post_comment' => $lang['Post_comment'],
	'auth_edit_comment' => $lang['Edit_comment'],
	'auth_delete_comment' => $lang['Delete_comment']);

$cat_auth_levels = array('ALL', 'REG', 'PRIVATE', 'MOD', 'ADMIN');
$cat_auth_const = array(AUTH_ALL, AUTH_REG, AUTH_ACL, AUTH_MOD, AUTH_ADMIN);

if(isset($_REQUEST['cat_id']))
{
	$cat_id = intval($_REQUEST['cat_id']);
	$cat_sql = "AND cat_id = $cat_id";
}
else
{
	unset($cat_id);
	$cat_sql = '';
}


//
// Start program proper
//
if( isset($_POST['submit']) )
{
	$sql = '';

	if(!empty($cat_id))
	{
		for($i = 0; $i < count($cat_auth_fields); $i++)
		{
			$value = $_POST[$cat_auth_fields[$i]];

			$sql .= ( ( $sql != '' ) ? ', ' : '' ) .$cat_auth_fields[$i] . ' = ' . $value;
		}
		$sql = "UPDATE " . PA_CATEGORY_TABLE . " 
			SET $sql WHERE cat_id = $cat_id";
	}

	if ( $sql != '' )
	{
		if ( !$db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, 'Could not update auth table', '', __LINE__, __FILE__, $sql);
		}
	}

	$cat_sql = '';

	$message = $lang['Category_auth_updated'] . '<br /><br />' . sprintf($lang['Click_return_catauth'],  '<a href="' . append_sid("admin_pa_catauth.$phpEx") . '">', "</a>");
	message_die(GENERAL_MESSAGE, $message);
} // End of submit

//
// Get required information, either all categoies if
// no id was specified or just the requsted if it
// was
//
if( empty($cat_id) )
{
	//
	// Output the selection table if no cat id was
	// specified
	//
	$pafiledb_template->set_filenames(array(
		'body' => 'admin/pa_auth_select_body.tpl')
	);

	$select_list = '<select name="cat_id">';
	$select_list .= jumpmenu('', 'admin', '', 'none_cat');
	$select_list .= '</select>';

	$pafiledb_template->assign_vars(array(
		'L_AUTH_TITLE' => $lang['Auth_Control_Category'],
		'L_AUTH_EXPLAIN' => $lang['Category_auth_explain'],
		'L_AUTH_SELECT' => $lang['Select_a_Category'],
		'L_LOOK_UP' => $lang['Look_up_Category'],

		'S_AUTH_ACTION' => append_sid("admin_pa_catauth.$phpEx"),
		'S_AUTH_SELECT' => $select_list)
	);

}
else
{

	$sql = "SELECT * 
		FROM " . PA_CATEGORY_TABLE . " 
		WHERE cat_id = '" . $cat_id . "'";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Couldnt Query category info', '', __LINE__, __FILE__, $sql);
	}
	$cat_rows = $db->sql_fetchrowset($result);
	$db->sql_freeresult($result);	
	
	//
	// Output the authorisation details if an id was
	// specified
	//
	$pafiledb_template->set_filenames(array(
		'body' => 'admin/pa_auth_cat_body.tpl')
	);

	//
	// Output values of individual
	// fields
	//
	for($j = 0; $j < count($cat_auth_fields); $j++)
	{
		$custom_auth[$j] = '&nbsp;<select name="' . $cat_auth_fields[$j] . '">';
		
		for($k = 0; $k < count($cat_auth_levels); $k++)
		{
			$selected = ( $cat_rows[0][$cat_auth_fields[$j]] == $cat_auth_const[$k] ) ? ' selected="selected"' : '';
			$custom_auth[$j] .= '<option value="' . $cat_auth_const[$k] . '"' . $selected . '>' . $lang['Category_' . $cat_auth_levels[$k]] . '</option>';
		}
		$custom_auth[$j] .= '</select>&nbsp;';

		$cell_title = $field_names[$cat_auth_fields[$j]];

		$pafiledb_template->assign_block_vars('cat_auth_titles', array(
				'CELL_TITLE' => $cell_title)
		);
		$pafiledb_template->assign_block_vars('cat_auth_data', array(
			'S_AUTH_LEVELS_SELECT' => $custom_auth[$j])
		);

		$s_column_span++;
	}
}
$cat_name = $cat_rows[0]['cat_name'];
$s_hidden_fields = '<input type="hidden" name="cat_id" value="' . $cat_id . '">';

$pafiledb_template->assign_vars(array(
	'CATEGORY_NAME' => $cat_name,

	'L_CATEGORY' => $lang['Category'], 
	'L_AUTH_TITLE' => $lang['Auth_Control_Category'],
	'L_AUTH_EXPLAIN' => $lang['Category_auth_explain'],
	'L_SUBMIT' => $lang['Submit'],
	'L_RESET' => $lang['Reset'],

	'S_CATAUTH_ACTION' => append_sid("admin_pa_catauth.$phpEx"),
	'S_COLUMN_SPAN' => $s_column_span,
	'S_HIDDEN_FIELDS' => $s_hidden_fields)
);



include('./page_header_admin.'.$phpEx);

$pafiledb_template->display('body');

include('./page_footer_admin.'.$phpEx);

?>