<?php
/***************************************************************************
 *                            admin_links_config.php
 *                            -------------------
 *  MOD add-on page. Contains GPL code copyright of phpBB group.
 *  Author: OOHOO < webdev@phpbb-tw.net >
 *  Author: Stefan2k1 and ddonker from www.portedmods.com
 *  Demo: http://phpbb-tw.net/
 *  Version: 1.0.X - 2002/03/22 - for phpBB RC serial, and was named Related_Links_MOD
 *  Version: 1.1.0 - 2002/04/25 - Re-packed for phpBB 2.0.0, and renamed to Links_MOD
 *  Version: 1.2.0 - 2003/06/15 - Enhanced and Re-packed for phpBB 2.0.4
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

/***************************************************************************
 * This file has been modified by Fully Moddded phpBB
 *
 *   $FMId: 2003/07/06 05:42:45 mj
 *
 ***************************************************************************/

define('IN_PHPBB', true);

if( !empty($setmodules) )
{
	$filename = basename(__FILE__);
	$module['Links']['Configuration'] = $filename;
	return;
}

//
// Let's set the root dir for phpBB
//
$phpbb_root_path = '../';
require($phpbb_root_path . 'extension.inc');
require('./pagestart.' . $phpEx);
require($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_admin_link.' . $phpEx);


//
// Pull all config data
//
$sql = "SELECT * FROM " . LINK_CONFIG_TABLE;
if(!$result = $db->sql_query($sql))
{
	message_die(CRITICAL_ERROR, "Could not query Links config information", "", __LINE__, __FILE__, $sql);
}
else
{
	while( $row = $db->sql_fetchrow($result) )
	{
		$config_name = $row['config_name'];
		$config_value = $row['config_value'];
		$default_config[$config_name] = $config_value;

		$new[$config_name] = ( isset($HTTP_POST_VARS[$config_name]) ) ? $HTTP_POST_VARS[$config_name] : $default_config[$config_name];

		if( isset($HTTP_POST_VARS['submit']) )
		{
			$sql = "UPDATE " . LINK_CONFIG_TABLE . " SET
				config_value = '" . str_replace("\'", "''", $new[$config_name]) . "'
				WHERE config_name = '$config_name'";
			if( !$db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, "Failed to update Link configuration for $config_name", "", __LINE__, __FILE__, $sql);
			}
		}
	}

	if( isset($HTTP_POST_VARS['submit']) )
	{
		$message = $lang['Link_config_updated'] . "<br /><br />" . sprintf($lang['Click_return_link_config'], "<a href=\"" . append_sid("admin_links_config.$phpEx") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=right") . "\">", "</a>");

		message_die(GENERAL_MESSAGE, $message);
	}
}
	
$template->set_filenames(array(
	"body" => "admin/admin_link_config_body.tpl")
);

$template->assign_vars(array(
	'L_LINK_CONFIG' => $lang['Link_Config'],
	'L_LINK_CONFIG_EXPLAIN' => $lang['Link_config_explain'],
	'S_LINK_CONFIG_ACTION' => append_sid('admin_links_config.'.$phpEx),

        'L_SITE_LOGO' => $lang['site_logo'],
	'L_SITE_URL' => $lang['site_url'],
	'L_WIDTH' => $lang['width'],
	'L_HEIGHT' => $lang['height'],
	'L_LINKSPP' => $lang['linkspp'],
	'L_DISPLAY_INTERVAL' => $lang['interval'],
	'L_DISPLAY_LOGO_NUM' => $lang['display_logo'],


	'INTERVAL' => $new['display_interval'],
	'LOGO_NUM' => $new['display_logo_num'],
	'SITE_LOGO' => $new['site_logo'],
	'SITE_URL' => $new['site_url'],
	'WIDTH' => $new['width'],
	'HEIGHT' => $new['height'],
	'LINKSPP' => $new['linkspp'],

	'L_SUBMIT' => $lang['Submit'],
	'L_RESET' => $lang['Reset'])
);

$template->pparse("body");

include('./page_footer_admin.'.$phpEx);


?>
