<?php
/***************************************************************************
 *                             admin_kb_config.php
 *                            -------------------
 *   begin                : Monday, Mar 31, 2003
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *
 *   $Id: admin_kb_config.php,v 1.0.0 2003/01/05 02:36:00 psotfx Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', 1);

if( !empty($setmodules) )
{
	$file = basename(__FILE__);
	$module['KB_title']['Configuration'] = $file . '?mode=config';
	return;
}

//
// Load default header
//
$phpbb_root_path = "./../";
require($phpbb_root_path . 'extension.inc');
require('./pagestart.' . $phpEx);
include($phpbb_root_path . 'config.'.$phpEx);
include($phpbb_root_path . 'includes/functions_admin.'.$phpEx);


	//
	// Pull all config data
	//
	$sql = "SELECT *
		 FROM " . KB_CONFIG_TABLE;
	if(!$result = $db->sql_query($sql))
	{
	 	message_die(CRITICAL_ERROR, "Could not query knowledge base configuration information", "", __LINE__, __FILE__, $sql);
	}
	else
	{
	 	while( $row = $db->sql_fetchrow($result) )
		{
		 	   $config_name = $row['config_name'];
			   $config_value = $row['config_value'];
			   $default_config[$config_name] = $config_value;
		
			   $new[$config_name] = ( isset($HTTP_POST_VARS[$config_name]) ) ? $HTTP_POST_VARS[$config_name] : $default_config[$config_name];

			   if( isset($HTTP_POST_VARS['submit']) )
			   {
			   	   $sql = "UPDATE " . KB_CONFIG_TABLE . " SET
				   		config_value = '" . str_replace("\'", "''", $new[$config_name]) . "'
						WHERE config_name = '$config_name'";
				   if( !$db->sql_query($sql) )
				   {
				   	   message_die(GENERAL_ERROR, "Failed to update general configuration for $config_name", "", __LINE__, __FILE__, $sql);
				   }
			   }
		}

		if( isset($HTTP_POST_VARS['submit']) )
		{
		 	$message = $lang['KB_config_updated'] . "<br /><br />" . sprintf($lang['Click_return_kb_config'], "<a href=\"" . append_sid("admin_kb_config.$phpEx?mode=config") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=right") . "\">", "</a>");

			message_die(GENERAL_MESSAGE, $message);
	    }
	}
	$new_yes = ( $new['allow_new'] ) ? "checked=\"checked\"" : "";
	$new_no = ( !$new['allow_new'] ) ? "checked=\"checked\"" : "";
	
	$approve_new_yes = ( $new['approve_new'] ) ? "checked=\"checked\"" : "";
	$approve_new_no = ( !$new['approve_new'] ) ? "checked=\"checked\"" : "";

	$edit_yes = ( $new['allow_edit'] ) ? "checked=\"checked\"" : "";
	$edit_no = ( !$new['allow_edit'] ) ? "checked=\"checked\"" : "";
	
	$approve_edit_yes = ( $new['approve_edit'] ) ? "checked=\"checked\"" : "";
	$approve_edit_no = ( !$new['approve_edit'] ) ? "checked=\"checked\"" : "";

	$pretext_show = (  $new['show_pretext'] ) ? "checked=\"checked\"" : "";
	$pretext_hide = ( !$new['show_pretext'] ) ? "checked=\"checked\"" : "";

	$pt_header = $new['pt_header'];
	$pt_body = $new['pt_body'];
	
	$notify_none = ( $new['notify'] == 0 ) ? "checked=\"checked\"" : "";
	$notify_pm = ( $new['notify'] == 1 ) ? "checked=\"checked\"" : "";
	$notify_email = ( $new['notify'] == 2 ) ? "checked=\"checked\"" : "";
	
	$admin_id = $new['admin_id'];

	$template->set_filenames(array(
		"body" => "admin/kb_config_body.tpl")
	);

	$template->assign_vars(array(
		'S_ACTION' => append_sid("admin_kb_config.$phpEx?mode=config"),
		'L_SUBMIT' => $lang['Submit'], 
		'L_RESET' => $lang['Reset'],
		
		'L_YES' => $lang['Yes'],
		'L_NO' => $lang['No'],
		'L_NONE' => $lang['Acc_None'], 
		
		'L_CONFIGURATION_TITLE' => $lang['KB_config_title'],
		'L_CONFIGURATION_EXPLAIN' => $lang['KB_config_explain'],
		
		'L_NEW_NAME' => $lang['New_title'],
		'L_NEW_EXPLAIN' => $lang['New_explain'],
		'S_NEW_YES' => $new_yes,
		'S_NEW_NO' => $new_no,
		
		'L_APPROVE_NEW_NAME' => $lang['Approve_new_name'],
		'L_APPROVE_NEW_EXPLAIN' => $lang['Approve_new_explain'],
		'S_APPROVE_NEW_YES' => $approve_new_yes,
		'S_APPROVE_NEW_NO' => $approve_new_no,
		
		'L_EDIT_NAME' => $lang['Edit_name'],
		'L_EDIT_EXPLAIN' => $lang['Edit_explain'],
		'S_EDIT_YES' => $edit_yes,
		'S_EDIT_NO' => $edit_no,
		
		'L_SHOW' => $lang['Show'],
		'L_HIDE' => $lang['Hide'],
		'L_PRE_TEXT_NAME' => $lang['Pre_text_name'],
		'L_PRE_TEXT_HEADER' => $lang['Pre_text_header'],
		'L_PRE_TEXT_BODY' => $lang['Pre_text_body'],
		'L_PRE_TEXT_EXPLAIN' => $lang['Pre_text_explain'],
		'S_SHOW_PRETEXT' => $pretext_show,
		'S_HIDE_PRETEXT' => $pretext_hide,
		'L_PT_HEADER' => $pt_header,
		'L_PT_BODY' => $pt_body,
		
		'L_APPROVE_EDIT_NAME' => $lang['Approve_edit_name'],
		'L_APPROVE_EDIT_EXPLAIN' => $lang['Approve_edit_explain'],
		'S_APPROVE_EDIT_YES' => $approve_edit_yes,
		'S_APPROVE_EDIT_NO' => $approve_edit_no,
		
		'L_NOTIFY_NAME' => $lang['Notify_name'],
		'L_NOTIFY_EXPLAIN' => $lang['Notify_explain'],
		'L_EMAIL' => $lang['Email'],
		'L_PM' => $lang['PM'],
		'S_NOTIFY_NONE' => $notify_none,
		'S_NOTIFY_EMAIL' => $notify_email,
		'S_NOTIFY_PM' => $notify_pm,
		
		'L_ADMIN_ID_NAME' => $lang['Admin_id_name'],
		'L_ADMIN_ID_EXPLAIN' => $lang['Admin_id_explain'],
		'ADMIN_ID' => $admin_id)
	);	

$template->pparse('body');

include('./page_footer_admin.'.$phpEx);

?>
