<?php
/***************************************************************************
 *                            admin_im_log.php [Enhanced]
 *                            -------------------
 *   begin                : Wednesday, May 21, 2003
 *   version              : 0.1.0
 *   date                 : 2003/06/08 16:32
 ***************************************************************************/

define('IN_PHPBB', 1);
define('IN_PRILLIAN', 1);

if( !empty($setmodules) )
{
	$filename = basename(__FILE__);
	$module['Prillian']['Message Log'] = $filename;
	return;
}
if ( isset($HTTP_POST_VARS['mode']) )
{
	if ( $HTTP_POST_VARS['mode'] == 'lookup' )
	{
		$no_page_header = true;
	}
}

$phpbb_root_path = './../';
$phpbb_im_path = $phpbb_root_path . 'mods/prillian/';
require($phpbb_root_path . 'extension.inc');
require('./pagestart.' . $phpEx);
require($phpbb_root_path . 'includes/bbcode.'.$phpEx);
require($phpbb_root_path . 'includes/functions_post.'.$phpEx);
require($phpbb_root_path . 'includes/functions_selects.'.$phpEx);
require($phpbb_root_path . 'includes/functions_validate.'.$phpEx);
require($phpbb_im_path . 'functions_im.'.$phpEx);

if ( !defined('IN_PRILLIAN_LANG') )
{
	include($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_prillian.' . $phpEx);
}

$im_userdata = array();
$im_userdata = init_imprefs($userdata['user_id']);

// Check possible variables
if( isset( $HTTP_POST_VARS['mode'] ) || isset( $HTTP_GET_VARS['mode'] ) )
{
	$mode = ( isset( $HTTP_POST_VARS['mode']) ) ? $HTTP_POST_VARS['mode'] : $HTTP_GET_VARS['mode'];
}
else
{
	$mode = '';
}

if( $mode == 'edit' && ( isset($HTTP_POST_VARS['username']) || isset($HTTP_GET_VARS[POST_USERS_URL]) || isset( $HTTP_POST_VARS[POST_USERS_URL]) ) )
{
	if( isset( $HTTP_POST_VARS[POST_USERS_URL] ) || isset( $HTTP_GET_VARS[POST_USERS_URL] ) )
	{
		$userid = (isset($HTTP_GET_VARS[POST_USERS_URL])) ? intval($HTTP_GET_VARS[POST_USERS_URL]): intval($HTTP_POST_VARS[POST_USERS_URL]);
		$sql_where = 'user_id=' . $userid;
	}
	elseif( isset($HTTP_POST_VARS['username']) )
	{
		$username = trim(strip_tags( $HTTP_POST_VARS['username'] ) );
		$sql_where = "username = '" . str_replace("\'", "''", $username) . "'";
	}

	$sql = 'SELECT username, user_id FROM ' . USERS_TABLE . ' WHERE ' . $sql_where;
	if ( !$result=$db->sql_query($sql) )
	{
		$msg = 'Could not get username/user id';
		message_die(GENERAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
	}
	$row = $db->sql_fetchrow($result);
	$username = $row['username'];
	$userid =  $row['user_id'];

	// $type - Possible values include "received", "sent", "offreceived", "offsent"
	if ( !empty($HTTP_POST_VARS['type']) || !empty($HTTP_GET_VARS['type']) )
	{
		$type = ( !empty($HTTP_POST_VARS['type']) ) ? $HTTP_POST_VARS['type'] : $HTTP_GET_VARS['type'];
	}
	else
	{
		$type = 'received';
	}

	// $sort_order & $start - used for pagination
	if(isset($HTTP_POST_VARS['order']))
	{
		$sort_order = ($HTTP_POST_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
	}
	else if(isset($HTTP_GET_VARS['order']))
	{
		$sort_order = ($HTTP_GET_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
	}
	else
	{
		$sort_order = 'ASC';
	}

	$start = ( isset($HTTP_GET_VARS['start']) ) ? intval($HTTP_GET_VARS['start']) : 0;

	$u_profile_base = $phpbb_root_path . "profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . '=';

	$offsite = false;
	$name_sql = '';
	$s2s_mark = '';

	// First, set up some options based on $type
	switch($type)
	{
		case 'offsent':
			$sender = $username;
			$u_sender = $u_profile_base . $userid;
			$adminfrom = $userid;
			$msg_sql = ' AND pm.privmsgs_from_userid = ' . $userid;
			$type_title = $lang['Offsite_Messages_Sent_by'] . $username;
			$name_sql = 'pm.privmsgs_to_username, ';
			$offsite = true;
			$s2s_mark = '&amp;sitesite=1';
			break;
		case 'offreceived':
			$receiver = $username;
			$u_receiver = $u_profile_base . $userid;
			$adminto = $userid;
			$msg_sql = ' AND pm.privmsgs_to_userid = ' . $userid;
			$type_title = $lang['Offsite_Messages_Received_by'] . $username;
			$name_sql = 'pm.privmsgs_from_username, ';
			$offsite = true;
			$s2s_mark = '&amp;sitesite=1';
			break;
		case 'sent':
			$sender = $username;
			$u_sender = $u_profile_base . $userid;
			$adminfrom = $userid;
			$msg_sql = ' AND pm.privmsgs_from_userid = ' . $userid . ' AND u.user_id = pm.privmsgs_to_userid';
			$type_title = $lang['Messages_Sent_by'] . $username;
			break;
		case 'received':
		default:
			$receiver = $username;
			$u_receiver = $u_profile_base . $userid;
			$adminto = $userid;
			$msg_sql = ' AND pm.privmsgs_to_userid = ' . $userid . ' AND u.user_id = pm.privmsgs_from_userid';
			$type_title = $lang['Messages_Received_by'] . $username;
			break;
	}

	$no_msg = $lang['No_match'];

	if( $offsite )
	{
		$msg_sql .= ' AND pm.site_id <> 0';
		$u_select_sql = '';
		$u_table_sql = '';
	}
	else
	{
		$msg_sql .= ' AND pm.site_id=0';
		$u_select_sql = ', u.username';
		$u_table_sql = ', ' . USERS_TABLE . ' u ';
	}

	// Let's get a list of all messages we may be working with. This includes new,
	// read, and unread instant messages. These may be messages sent or received
	// user depending on $type.

	$all_msgs = array();

	$sql = 'SELECT pm.privmsgs_type, pm.privmsgs_id, pm.privmsgs_subject, pm.privmsgs_from_userid, ' . $name_sql . 'pm.privmsgs_to_userid, pm.privmsgs_date' . $u_select_sql . ' 
	FROM ' . PRIVMSGS_TABLE . ' pm' . $u_table_sql . ' 
		WHERE pm.privmsgs_type IN (' . IM_NEW_MAIL . ', ' . IM_UNREAD_MAIL . ', ' . IM_READ_MAIL . ')' . $msg_sql;
	$sql .= ' ORDER BY pm.privmsgs_date ' . $sort_order;
	$sql .= ' LIMIT ' . (($start) ? $start . ', ' : '') . $board_config['topics_per_page'];

	$msg_count_sql = 'SELECT COUNT(*) AS total
		FROM ' . PRIVMSGS_TABLE . ' pm' . $u_table_sql . '
		WHERE pm.privmsgs_type IN (' . IM_NEW_MAIL . ', ' . IM_UNREAD_MAIL . ', ' . IM_READ_MAIL . ')' . $msg_sql;

	if ( !$result=$db->sql_query($sql) )
	{
		$msg = 'Could not get list of messages';
		message_die(GENERAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
	}

	$all_msgs = $db->sql_fetchrowset($result);
	$db->sql_freeresult($result);

	$msgs_total = (!empty($all_msgs)) ? count($all_msgs): false;
	if( $msgs_total )
	{
		sort($all_msgs);
	}
	else
	{
		$all_msgs = array();
	}

	$template->set_filenames(array(
		'body' => 'admin/imclient_admin_log_body.tpl')
	);

	// Define basic or common template variables
	$template->assign_vars(array(
		'L_ML_TITLE' => $lang['Message_Log'],
		'L_ML_EXPLAIN' => $lang['Message_Log_admin_explain'],

		'L_SENT' => $lang['Sent'],
		'L_RECEIVED' => $lang['Received'],
		'L_OFF_SENT' => $lang['Offsite_Sent'],
		'L_OFF_RECEIVED' => $lang['Offsite_Received'],

		'U_RECEIVED' => append_sid("admin_im_log.$phpEx?mode=edit&type=received&" . POST_USERS_URL . '=' . $userid),
		'U_SENT' => append_sid("admin_im_log.$phpEx?mode=edit&type=sent&" . POST_USERS_URL . '=' . $userid),
		'U_OFF_RECEIVED' => append_sid("admin_im_log.$phpEx?mode=edit&type=offreceived&" . POST_USERS_URL . '=' . $userid),
		'U_OFF_SENT' => append_sid("admin_im_log.$phpEx?mode=edit&type=offsent&" . POST_USERS_URL . '=' . $userid),
		'U_IM_PATH' => $phpbb_im_path,

		'S_FORM_ACTION' => append_sid('admin_im_log.' . $phpEx),
		'MESSAGES' => $type_title,
		'READ_WIDTH' => $im_userdata['win_read_width'],
		'READ_HEIGHT' => $im_userdata['win_read_height']
	));


	// Create message list
	if( $msgs_total )
	{
		$s_hidden_fields = '<input type="hidden" name="sid" value="' . $userdata['session_id'] . '" /><inout type="hidden" name="mode" value="' . $mode . '" />';

		$template->assign_block_vars('switch_msg_list', array(
			'S_HIDDEN_FIELDS' => $s_hidden_fields,

			'L_SUBJECT' => $lang['Subject'],
			'L_FROM' => $lang['From'],
			'L_TO' => $lang['To'],
			'L_DATE' => $lang['Date'],
			'L_MARK_ALL' => $lang['Mark_all'],
			'L_UNMARK_ALL' => $lang['Unmark_all'],
			'L_DELETE' => $lang['Delete']
		));

		$left_pixels = 0;
		$right_pixels = 0;
		$row_class = 'row1';

		reset($all_msgs);
		while( list($key, $im) = each($all_msgs) )
		{
			if( $left_pixels == 200 )
			{
				$left_pixels = 0;
				$right_pixels = 0;
			}
			else
			{
				$left_pixels += 20;
				$right_pixels += 40;
			}

			$post_subject = $im['privmsgs_subject'];
			$orig_word = array();
			$replacement_word = array();
			obtain_word_list($orig_word, $replacement_word);
			if ( count($orig_word) )
			{
				$post_subject = preg_replace($orig_word, $replacement_word, $post_subject);
			}

			switch($type)
			{
				case 'offsent':
					$receiver = $im['privmsgs_to_username'];
					$u_receiver = $u_profile_base . $im['privmsgs_to_userid'];
					$adminto = $im['privmsgs_to_userid'];
					break;
				case 'offreceived':
					$sender = $im['privmsgs_from_username'];
					$u_sender = $u_profile_base . $im['privmsgs_from_userid'];
					$adminfrom = $im['privmsgs_from_userid'];
					break;
				case 'sent':
					$receiver = $im['username'];
					$u_receiver = $u_profile_base . $im['privmsgs_to_userid'];
					$adminto = $im['privmsgs_to_userid'];
					break;
				case 'received':
				default:
					$sender = $im['username'];
					$u_sender = $u_profile_base . $im['privmsgs_from_userid'];
					$adminfrom = $im['privmsgs_from_userid'];
					break;
			}

			$template->assign_block_vars('switch_msg_list.switch_msg_row', array(
				'U_IMMSGS' => append_sid($phpbb_root_path . "imclient.$phpEx?mode=read&" . POST_POST_URL . '=' . $im['privmsgs_id'] . '&adminmode=1&adminfrom=' . $adminfrom . '&adminto=' . $adminto . $s2s_mark),
				'U_SENDER' => append_sid($u_sender),
				'U_RECEIVER' => append_sid($u_receiver),

				'S_MARK_ID' => $im['privmsgs_id'],

				'ROW_CLASS' => $row_class,
				'SUBJECT' => $post_subject,
				'SENDER' => $sender,
				'RECEIVER' => $receiver,
				'DATE' => create_date($board_config['default_dateformat'], $im['privmsgs_date'], $board_config['board_timezone']),
				'IMNUM' => $key,
				'LEFT_PX' => $left_pixels,
				'TOP_PX' => $right_pixels
			));

			$row_class = ($row_class == 'row1') ? 'row2' : 'row1';
		}

		if ( !$result=$db->sql_query($msg_count_sql) )
		{
			$msg = 'Could not get total number of messages';
			message_die(GENERAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
		}

		if ( !$row=$db->sql_fetchrow($result) )
		{
			$msg = 'Could not find total number of messages';
			message_die(GENERAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
		}

		$pagination = generate_pagination("admin_im_log.$phpEx?mode=$mode&amp;type=$type&amp;order=$sort_order", $row['total'], $board_config['topics_per_page'], $start). '&nbsp;';

		$template->assign_vars(array(
			'PAGINATION' => $pagination,
			'PAGE_NUMBER' => sprintf($lang['Page_of'], ( floor( $start / $board_config['topics_per_page'] ) + 1 ), ceil( $row['total'] / $board_config['topics_per_page'] ))
		));
	}
	else
	{
		// No messages.
		$template->assign_block_vars('switch_no_msg', array(
			'NO_MSG' => $no_msg
		));
		$template->assign_vars(array(
			'PAGINATION' => '',
			'PAGE_NUMBER' => ''
			)
		);
	}
	// That's the end of the message list!
}
else if ( $mode == 'lookup' )
{
	//
	// Lookup user
	//
	$username = ( !empty($HTTP_POST_VARS['username']) ) ? str_replace('%', '%%', trim(strip_tags( $HTTP_POST_VARS['username'] ) )) : '';
	$email = ( !empty($HTTP_POST_VARS['email']) ) ? trim(strip_tags(htmlspecialchars( $HTTP_POST_VARS['email'] ) )) : '';
	$posts = ( !empty($HTTP_POST_VARS['posts']) ) ? intval(trim(strip_tags( $HTTP_POST_VARS['posts'] ) )) : '';
	$joined = ( !empty($HTTP_POST_VARS['joined']) ) ? trim(strtotime( $HTTP_POST_VARS['joined'] ) ) : 0;

	$sql_where = ( !empty($username) ) ? 'u.username LIKE "%' . str_replace("\'", "''", $username) . '%"' : '';
	$sql_where .= ( !empty($email) ) ? ( ( !empty($sql_where) ) ? ' AND u.user_email LIKE "%' . $email . '%"' : 'u.user_email LIKE "%' . $email . '%"' ) : '';
	$sql_where .= ( !empty($posts) ) ? ( ( !empty($sql_where) ) ? ' AND u.user_posts >= ' . $posts : 'u.user_posts >= ' . $posts ) : '';
	$sql_where .= ( $joined ) ? ( ( !empty($sql_where) ) ? ' AND u.user_regdate >= ' . $joined : 'u.user_regdate >= ' . $joined ) : '';

	if ( !empty($sql_where) )
	{
		$sql = 'SELECT u.user_id, u.username, u.user_email, u.user_posts, u.user_active, u.user_regdate
			FROM ' . USERS_TABLE . " u
			WHERE $sql_where
			ORDER BY u.username ASC";

		if ( !( $result = $db->sql_query($sql) ) )
		{
			message_die(GENERAL_ERROR, 'Unable to query users', '', __LINE__, __FILE__, $sql);
		}
		else if ( !$db->sql_numrows($result) )
		{
			$message = $lang['No_user_id_specified'];
			$message .= '<br /><br />' . sprintf($lang['Click_return_useradmin'], '<a href="' . append_sid("admin_im_log.$phpEx") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_admin_index'], '<a href="' . append_sid("index.$phpEx?pane=right") . '">', '</a>');
			message_die(GENERAL_MESSAGE, $message);
		}
		else if ( $db->sql_numrows($result) == 1 )
		{
			// Redirect to this user
			$row = $db->sql_fetchrow($result);

			$template->assign_vars(array(
				"META" => '<meta http-equiv="refresh" content="3;url=' . append_sid("admin_im_log.$phpEx?mode=edit&" . POST_USERS_URL . "=" . $row['user_id']) . '">')
			);

			$message .= $lang['One_user_found'];
			$message .= '<br /><br />' . sprintf($lang['Click_goto_user'], '<a href="' . append_sid("admin_im_log.$phpEx?mode=edit&" . POST_USERS_URL . "=" . $row['user_id']) . '">', '</a>');

			message_die(GENERAL_MESSAGE, $message);
		}
		else
		{
			// Show select screen
			include('page_header_admin.'.$phpEx);

			$template->set_filenames(array(
				'body' => 'admin/user_lookup_body.tpl')
			);

			$template->assign_vars(array(
				'L_USERNAME' => $lang['Username'],
				'L_USER_TITLE' => $lang['User_admin'],
				'L_POSTS' => $lang['Posts'],
				'L_JOINED' => $lang['Sort_Joined'],
				'L_USER_EXPLAIN' => $lang['User_admin_explain'],
				'L_ACTIVE' => $lang['User_status'],
				'L_EMAIL_ADDRESS' => $lang['Email_address'])
			);

			$i = 0;
			while ( $row = $db->sql_fetchrow($result) )
			{
				$row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
				$row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];

				$template->assign_block_vars('user_row', array(
					'ROW_COLOR' => '#' . $row_color,
					'ROW_CLASS' => $row_class,
					'USERNAME' => $row['username'],
					'EMAIL' => $row['user_email'],
					'POSTS' => $row['user_posts'],
					'ACTIVE' => ( $row['user_active'] ) ? $lang['Yes'] : $lang['No'],
					'JOINED' => create_date($lang['DATE_FORMAT'], $row['user_regdate'], $board_config['board_timezone']),

					'U_USERNAME' => append_sid("admin_im_log.$phpEx?mode=edit&" . POST_USERS_URL . "=" . $row['user_id']))
				);

				$i++;
			}
		}
	}
	else
	{
		$message = $lang['No_user_id_specified'];
		$message .= '<br /><br />' . sprintf($lang['Click_return_useradmin'], '<a href="' . append_sid("admin_im_log.$phpEx") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_admin_index'], '<a href="' . append_sid("index.$phpEx?pane=right") . '">', '</a>');
		message_die(GENERAL_MESSAGE, $message);
	}
}
else
{
	//
	// Default user selection box
	//
	$template->set_filenames(array(
		'body' => 'admin/user_select_body.tpl')
	);

	$template->assign_vars(array(
		'L_USER_TITLE' => $lang['Message_Log'],
		'L_USER_EXPLAIN' => $lang['Message_Log_admin_explain'],
		'L_USER_SELECT' => $lang['Select_a_User'],
		'L_LOOK_UP' => $lang['Look_up_user'],
		'L_FIND_USERNAME' => $lang['Find_username'],
		'L_USERNAME' => $lang['Username'],
		'L_POSTS' => $lang['Posts'],
		'L_JOINED' => $lang['Sort_Joined'],
		'L_ACTIVE' => $lang['User_status'],

		'L_USER_LOOKUP_EXPLAIN' => $lang['User_lookup_explain'],
		'L_EMAIL_ADDRESS' => $lang['Email_address'],
		'L_JOINED_EXPLAIN' => $lang['User_joined_explain'],

		'U_SEARCH_USER' => append_sid($phpbb_root_path . "search.$phpEx?mode=searchuser"), 

		'S_USER_ACTION' => append_sid("admin_im_log.$phpEx"),
		'S_USER_SELECT' => $select_list)
	);

}

$template->pparse('body');
include('./page_footer_admin.'.$phpEx);
?>