<?php
/***************************************************************************
 *                              admin_forum_config.php
 *                            -------------------
 *   begin                : Thursday, Jul 12, 2001
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *
 *   $Id: admin_forum_config.php,v 1.0 2003/08/14 20:43:12 mj Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', 1);

if( !empty($setmodules) )
{
	$file = basename(__FILE__);
	$module['A_General']['Forum_settings'] = "$file";
	return;
}

//
// Let's set the root dir for phpBB
//
$phpbb_root_path = "./../";
require($phpbb_root_path . 'extension.inc');
require('./pagestart.' . $phpEx);
include($phpbb_root_path . 'includes/functions_selects.'.$phpEx);

//
// Pull all config data
//
$sql = "SELECT *
	FROM " . CONFIG_TABLE;
if(!$result = $db->sql_query($sql))
{
	message_die(CRITICAL_ERROR, "Could not query config information in admin_forum_config", "", __LINE__, __FILE__, $sql);
}
else
{
	while( $row = $db->sql_fetchrow($result) )
	{
		$config_name = $row['config_name'];
		$config_value = $row['config_value'];
		$default_config[$config_name] = $config_value;
		
		$new[$config_name] = ( isset($HTTP_POST_VARS[$config_name]) ) ? $HTTP_POST_VARS[$config_name] : $default_config[$config_name];

		if ($config_name == 'cookie_name')
		{
			$cookie_name = str_replace('.', '_', $new['cookie_name']);
		}

		if( isset($HTTP_POST_VARS['submit']) )
		{
			$sql = "UPDATE " . CONFIG_TABLE . " SET
				config_value = '" . str_replace("\'", "''", $new[$config_name]) . "'
				WHERE config_name = '$config_name'";
			if( !$db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, "Failed to update general configuration for $config_name", "", __LINE__, __FILE__, $sql);
			}
			//
			// Style Under Username
			//
			if( $config_name == 'default_style' )
			{
				$sql = "UPDATE " . USERS_TABLE . " SET user_style='" . $config_value . "'
					WHERE user_id='" . ANONYMOUS . "'";
				if( !$db->sql_query($sql) )
				{
					message_die(GENERAL_ERROR, "Failed to update anonymous user board style", "", __LINE__, __FILE__, $sql);
				}
			}
		}
	}

	if( isset($HTTP_POST_VARS['submit']) )
	{
		$message = $lang['Forum_config_updated'] . "<br /><br />" . sprintf($lang['Click_return_forum_config'], "<a href=\"" . append_sid("admin_forum_config.$phpEx") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=right") . "\">", "</a>");

		message_die(GENERAL_MESSAGE, $message);
	}
}

$page_transition_select = page_transition_select($new['page_transition']);

$html_tags = $new['allow_html_tags'];

$html_yes = ( $new['allow_html'] ) ? "checked=\"checked\"" : "";
$html_no = ( !$new['allow_html'] ) ? "checked=\"checked\"" : "";

$bbcode_yes = ( $new['allow_bbcode'] ) ? "checked=\"checked\"" : "";
$bbcode_no = ( !$new['allow_bbcode'] ) ? "checked=\"checked\"" : "";

$board_email_form_yes = ( $new['board_email_form'] ) ? "checked=\"checked\"" : "";
$board_email_form_no = ( !$new['board_email_form'] ) ? "checked=\"checked\"" : "";

$privmsg_on = ( !$new['privmsg_disable'] ) ? "checked=\"checked\"" : "";
$privmsg_off = ( $new['privmsg_disable'] ) ? "checked=\"checked\"" : "";

$prune_yes = ( $new['prune_enable'] ) ? "checked=\"checked\"" : "";
$prune_no = ( !$new['prune_enable'] ) ? "checked=\"checked\"" : "";

$msg_icons_yes = ( $new['msg_icons'] ) ? "checked=\"checked\"" : ""; 
$msg_icons_no = ( !$new['msg_icons'] ) ? "checked=\"checked\"" : ""; 

$hidde_last_logon_yes = ( $new['hidde_last_logon'] ) ? "checked=\"checked\"" : ""; 
$hidde_last_logon_no = ( !$new['hidde_last_logon'] ) ? "checked=\"checked\"" : ""; 

$birthday_greeting_yes = ( $new['birthday_greeting'] ) ? "checked=\"checked\"" : ""; 
$birthday_greeting_no = ( !$new['birthday_greeting'] ) ? "checked=\"checked\"" : ""; 

$birthday_required_yes = ( $new['birthday_required'] ) ? "checked=\"checked\"" : ""; 
$birthday_required_no = ( !$new['birthday_required'] ) ? "checked=\"checked\"" : ""; 

$smile_yes = ( $new['allow_smilies'] ) ? "checked=\"checked\"" : "";
$smile_no = ( !$new['allow_smilies'] ) ? "checked=\"checked\"" : "";

$sig_yes = ( $new['allow_sig'] ) ? "checked=\"checked\"" : "";
$sig_no = ( !$new['allow_sig'] ) ? "checked=\"checked\"" : "";

$namechange_yes = ( $new['allow_namechange'] ) ? "checked=\"checked\"" : "";
$namechange_no = ( !$new['allow_namechange'] ) ? "checked=\"checked\"" : "";

$avatars_local_yes = ( $new['allow_avatar_local'] ) ? "checked=\"checked\"" : "";
$avatars_local_no = ( !$new['allow_avatar_local'] ) ? "checked=\"checked\"" : "";
$avatars_remote_yes = ( $new['allow_avatar_remote'] ) ? "checked=\"checked\"" : "";
$avatars_remote_no = ( !$new['allow_avatar_remote'] ) ? "checked=\"checked\"" : "";
$avatars_upload_yes = ( $new['allow_avatar_upload'] ) ? "checked=\"checked\"" : "";
$avatars_upload_no = ( !$new['allow_avatar_upload'] ) ? "checked=\"checked\"" : "";
$avatars_sticky_yes = ( $new['allow_avatar_sticky'] ) ? "checked=\"checked\"" : "";
$avatars_sticky_no = ( !$new['allow_avatar_sticky'] ) ? "checked=\"checked\"" : "";

if ( isset($lang['Post_global_announcement']) )
{
	$split_global_announce_yes = ( $new['split_global_announce'] ) ? "checked=\"checked\"" : "";
	$split_global_announce_no  = (!$new['split_global_announce'] ) ? "checked=\"checked\"" : "";
}
$split_announce_yes = ( $new['split_announce'] ) ? "checked=\"checked\"" : "";
$split_announce_no  = (!$new['split_announce'] ) ? "checked=\"checked\"" : "";
$split_sticky_yes   = ( $new['split_sticky'] )   ? "checked=\"checked\"" : "";
$split_sticky_no    = (!$new['split_sticky'] )   ? "checked=\"checked\"" : "";

$template->set_filenames(array(
	"body" => "admin/forum_config_body.tpl")
);

//
// Profile Photo
//
if ( !file_exists($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_profilephoto.'.$phpEx) )
{
	include($phpbb_root_path . 'language/lang_english/lang_profilephoto.'.$phpEx);
}
else
{
	include($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_profilephoto.' . $phpEx);
}

$photo_remote_yes = ( $new['allow_photo_remote'] ) ? 'checked="checked"' : '';
$photo_remote_no = ( !$new['allow_photo_remote'] ) ? 'checked="checked"' : '';
$photo_upload_yes = ( $new['allow_photo_upload'] ) ? 'checked="checked"' : '';
$photo_upload_no = ( !$new['allow_photo_upload'] ) ? 'checked="checked"' : '';

$template->assign_vars(array(
	'L_PROFLE_PHOTO_SETTINGS' => $lang['Profile_photo_settings'],
	'L_ALLOW_PHOTO_REMOTE' => $lang['Allow_photo_remote'],
	'L_ALLOW_PHOTO_REMOTE_EXPLAIN' => $lang['Allow_photo_remote_explain'],
	'L_ALLOW_PHOTO_UPLOAD' => $lang['Allow_photo_upload'],
	'L_PHOTO_MAX_FILESIZE' => $lang['Photo_max_filesize'],
	'L_PHOTO_MAX_FILESIZE_EXPLAIN' => $lang['Photo_max_filesize_explain'],
	'L_MAX_PHOTO_SIZE' => $lang['Max_photo_size'],
	'L_PHOTO_STORAGE_PATH' => $lang['Photo_storage_path'],
	'L_PHOTO_STORAGE_PATH_EXPLAIN' => $lang['Photo_storage_path_explain'],

	'PHOTO_REMOTE_YES' => $photo_remote_yes,
	'PHOTO_REMOTE_NO' => $photo_remote_no,
	'PHOTO_UPLOAD_YES' => $photo_upload_yes,
	'PHOTO_UPLOAD_NO' => $photo_upload_no,
	'PHOTO_FILESIZE' => $new['photo_filesize'],
	'PHOTO_MAX_HEIGHT' => $new['photo_max_height'],
	'PHOTO_MAX_WIDTH' => $new['photo_max_width'],
	'PHOTO_PATH' => $new['photo_path'])
);

//
// Escape any quotes in the site description for proper display in the text
// box on the admin page 
//
$template->assign_vars(array(
	"S_CONFIG_ACTION" => append_sid("admin_forum_config.$phpEx"),

	"L_SPLIT_GLOBAL_ANNOUNCE" => $lang['split_global_announce'],
	"SPLIT_GLOBAL_ANNOUNCE_YES" => $split_global_announce_yes,
	"SPLIT_GLOBAL_ANNOUNCE_NO" => $split_global_announce_no,
	"L_SPLIT_ANNOUNCE" => $lang['split_announce'],
	"SPLIT_ANNOUNCE_YES" => $split_announce_yes,
	"SPLIT_ANNOUNCE_NO" => $split_announce_no,
	"L_SPLIT_STICKY" => $lang['split_sticky'],
	"SPLIT_STICKY_YES" => $split_sticky_yes,
	"SPLIT_STICKY_NO" => $split_sticky_no,

	"L_YES" => $lang['Yes'],
	"L_NO" => $lang['No'],
	"L_CONFIGURATION_TITLE" => $lang['Abilities_settings'],
	"L_CONFIGURATION_EXPLAIN" => $lang['Forum_Config_explain'],
	"L_DEBUG_VALUE" => $lang['Debug_value'], 
	"L_DEBUG_VALUE__EXPLAIN" => $lang['Debug_value_explain'], 
	"L_CUSTOM_FOOTER_AND_HEADER_SETTINGS" => $lang['Custom_Footer_and_Header_settings'],
	"L_CUSTOM_OVERALL_HEADER" => $lang['Custom_Overall_Header'],
	"L_CUSTOM_OVERALL_FOOTER" => $lang['Custom_Overall_Footer'],
	"L_CUSTOM_SIMPLE_HEADER" => $lang['Custom_Simple_Header'],
	"L_CUSTOM_SIMPLE_FOOTER" => $lang['Custom_Simple_Footer'],
	"L_WHOSONLINE_SETTINGS" => $lang['Whosonline_settings'], 
	"L_RECORD_ONLINE_USERS" => $lang['Record_Online_Users'], 
	"L_RECORD_ONLINE_USERS_ONEDAY" => $lang['Record_Online_Users_Oneday'], 
	"L_TOTAL_VISITORS" => $lang['Total_visitors'], 
	"L_PRIVATE_MESSAGING" => $lang['Private_Messaging'], 
	"L_INBOX_LIMIT" => $lang['Inbox_limits'], 
	"L_SENTBOX_LIMIT" => $lang['Sentbox_limits'], 
	"L_SAVEBOX_LIMIT" => $lang['Savebox_limits'], 
	"L_DISABLE_PRIVATE_MESSAGING" => $lang['Disable_privmsg'], 
	"L_ENABLED" => $lang['Enabled'], 
	"L_DISABLED" => $lang['Disabled'], 
	"L_ABILITIES_SETTINGS" => $lang['Abilities_settings'],
	"L_MAX_POLL_OPTIONS" => $lang['Max_poll_options'],
	"L_FLOOD_INTERVAL" => $lang['Flood_Interval'],
	"L_FLOOD_INTERVAL_EXPLAIN" => $lang['Flood_Interval_explain'], 
	"L_MESSAGE_LENGTH" => $lang['Message_length'],
	"L_MESSAGE_LENGTH_EXPLAIN" => $lang['Message_length_explain'],
	"L_BOARD_EMAIL_FORM" => $lang['Board_email_form'], 
	"L_BOARD_EMAIL_FORM_EXPLAIN" => $lang['Board_email_form_explain'], 
	"L_TOPICS_PER_PAGE" => $lang['Topics_per_page'],
	"L_POSTS_PER_PAGE" => $lang['Posts_per_page'],
	"L_HOT_THRESHOLD" => $lang['Hot_threshold'],
	"L_ENABLE_PRUNE" => $lang['Enable_prune'],
	"L_NO_POST_COUNT" => $lang['No_post_count'],
	"L_NO_POST_COUNT_EXPLAIN" => $lang['No_post_count_explain'],
	"L_MSG_ICONS" => $lang['Enable_msg_icons'], 
	"L_HIDDE_LAST_LOGON" => $lang['Hidde_last_logon'], 
	"L_HIDDE_LAST_LOGON_EXPLAIN" => $lang['Hidde_last_logon_expain'],
	"L_BIRTHDAY_SETTINGS" => $lang['Birthday_settings'], 
	"L_ENABLE_BIRTHDAY_GREETING" => $lang['Enable_birthday_greeting'], 
	"L_BIRTHDAY_GREETING_EXPLAIN" => $lang['Birthday_greeting_expain'], 
	"L_BIRTHDAY_REQUIRED" => $lang['Birthday_required'], 
	"L_MAX_USER_AGE" => $lang['Max_user_age'], 
	"L_MIN_USER_AGE" => $lang['Min_user_age'], 
	"L_BIRTHDAY_LOOKFORWARD" => $lang['Birthday_lookforward'], 
	"L_BIRTHDAY_LOOKFORWARD_EXPLAIN" => $lang['Birthday_lookforward_explain'], 
	"L_BOARD_SIG" => $lang['Board_Sig'],
	"L_BANCARD_SETTINGS" => $lang['Bancard_settings'],
	"L_BLUECARD_LIMIT" => $lang['Bluecard_limit'], 
	"L_BLUECARD_LIMIT_EXPLAIN" => $lang['Bluecard_limit_explain'], 
	"L_BLUECARD_LIMIT_2" => $lang['Bluecard_limit_2'], 
	"L_BLUECARD_LIMIT_2_EXPLAIN" => $lang['Bluecard_limit_2_explain'], 
	"L_MAX_USER_BANCARD" => $lang['Max_user_bancard'], 
	"L_MAX_USER_BANCARD_EXPLAIN" => $lang['Max_user_bancard_explain'], 
	"L_MAX_USER_VOTEBANCARD" => $lang['Max_user_votebancard'], 
	"L_MAX_USER_VOTEBANCARD_EXPLAIN" => $lang['Max_user_votebancard_explain'], 
	"L_REPORT_FORUM" => $lang['Report_forum'],
	"L_REPORT_FORUM_EXPLAIN" => $lang['Report_forum_explain'],
	"L_ALLOW_HTML" => $lang['Allow_HTML'],
	"L_ALLOW_BBCODE" => $lang['Allow_BBCode'],
	"L_ALLOWED_TAGS" => $lang['Allowed_tags'],
	"L_ALLOWED_TAGS_EXPLAIN" => $lang['Allowed_tags_explain'],
	"L_SMILIE_SETTINGS" => $lang['Smilie_settings'],
	"L_ALLOW_SMILIES" => $lang['Allow_smilies'],
	"L_SMILIE_TABLE_COLUMNS" => $lang['Smilie_table_columns'],
	"L_SMILIE_TABLE_ROWS" => $lang['Smilie_table_rows'],
	"L_SMILIE_WINDOW_COLUMNS" => $lang['Smilie_window_columns'],
	"L_SMILIES_PATH" => $lang['Smilies_path'],
	"L_SMILIES_PATH_EXPLAIN" => $lang['Smilies_path_explain'],
	"L_ALLOW_SIG" => $lang['Allow_sig'],
	"L_MAX_SIG_LENGTH" => $lang['Max_sig_length'],
	"L_MAX_SIG_LENGTH_EXPLAIN" => $lang['Max_sig_length_explain'],
	"L_YEAR_STARS" => $lang['Year_stars'],
	"L_YEAR_STARS_EXPLAIN" => $lang['Year_stars_explain'],
	"L_ALLOW_NAME_CHANGE" => $lang['Allow_name_change'],
	"L_AVATAR_SETTINGS" => $lang['Avatar_settings'],
	"L_ALLOW_LOCAL" => $lang['Allow_local'],
	"L_ALLOW_REMOTE" => $lang['Allow_remote'],
	"L_ALLOW_REMOTE_EXPLAIN" => $lang['Allow_remote_explain'],
	"L_ALLOW_UPLOAD" => $lang['Allow_upload'],
	"L_MAX_FILESIZE" => $lang['Max_filesize'],
	"L_MAX_FILESIZE_EXPLAIN" => $lang['Max_filesize_explain'],
	"L_MAX_AVATAR_SIZE" => $lang['Max_avatar_size'],
	"L_MAX_AVATAR_SIZE_EXPLAIN" => $lang['Max_avatar_size_explain'],
	"L_AVATAR_STORAGE_PATH" => $lang['Avatar_storage_path'],
	"L_AVATAR_STORAGE_PATH_EXPLAIN" => $lang['Avatar_storage_path_explain'],
	"L_AVATAR_GALLERY_PATH" => $lang['Avatar_gallery_path'],
	"L_AVATAR_GALLERY_PATH_EXPLAIN" => $lang['Avatar_gallery_path_explain'],
	"L_ALLOW_STICKY" => $lang['Avatars_Sticky'],
	"L_ALLOW_STICKY_EXPLAIN" => $lang['Avatars_Sticky_Explain'],
	"L_JOURNAL_FORUM" => $lang['Journal_Forum'],
	"L_JOURNAL_FORUM_EXPLAIN" => $lang['Journal_Forum_Explain'],

	"L_COPPA_SETTINGS" => $lang['COPPA_settings'],
	"L_COPPA_FAX" => $lang['COPPA_fax'],
	"L_COPPA_MAIL" => $lang['COPPA_mail'],
	"L_COPPA_MAIL_EXPLAIN" => $lang['COPPA_mail_explain'],
	"L_PAGE_TRANSITION" => $lang['Page_transition'], 
	"L_SUBMIT" => $lang['Submit'], 
	"L_RESET" => $lang['Reset'], 
	
	"PRUNE_YES" => $prune_yes,
	"PRUNE_NO" => $prune_no, 
	"RECORD_ONLINE_USERS" => $new['record_online_users'], 
	"RECORD_DAY_USERS" => $new['record_day_users'], 
	"TOTAL_VISITORS" => $new['visit_counter'], 
	"MAX_POLL_OPTIONS" => $new['max_poll_options'], 
	"FLOOD_INTERVAL" => $new['flood_interval'],
	"MESSAGE_LENGTH" => $new['message_length'],
	"TOPICS_PER_PAGE" => $new['topics_per_page'],
	"POSTS_PER_PAGE" => $new['posts_per_page'],
	"HOT_TOPIC" => $new['hot_threshold'],
	"PAGE_TRANSITION" => $page_transition_select,
	"BOARD_SIG" => $new['board_sig'],
	"S_PRIVMSG_ENABLED" => $privmsg_on, 
	"S_PRIVMSG_DISABLED" => $privmsg_off, 
	"INBOX_LIMIT" => $new['max_inbox_privmsgs'], 
	"SENTBOX_LIMIT" => $new['max_sentbox_privmsgs'],
	"SAVEBOX_LIMIT" => $new['max_savebox_privmsgs'],
	"CUSTOM_OVERALL_HEADER" => $new['custom_overall_header'],
	"CUSTOM_OVERALL_FOOTER" => $new['custom_overall_footer'],
	"CUSTOM_SIMPLE_HEADER" => $new['custom_simple_header'],
	"CUSTOM_SIMPLE_FOOTER" => $new['custom_simple_footer'],
	"COOKIE_DOMAIN" => $new['cookie_domain'], 
	"COOKIE_NAME" => $new['cookie_name'], 
	"COOKIE_PATH" => $new['cookie_path'], 
	"SESSION_LENGTH" => $new['session_length'], 
	"S_COOKIE_SECURE_ENABLED" => $cookie_secure_yes, 
	"S_COOKIE_SECURE_DISABLED" => $cookie_secure_no, 
	"S_DEBUG_VALUE_ENABLED" => $debug_value_yes, 
	"S_DEBUG_VALUE_DISABLED" => $debug_value_no, 
	"JOURNAL_FORUM_ID" => $new['journal_forum_id'],
	"NO_POST_COUNT_FORUM_ID" => $new['no_post_count_forum_id'],
	"MSG_ICONS_YES" => $msg_icons_yes, 
	"MSG_ICONS_NO" => $msg_icons_no, 
	"HIDDE_LAST_LOGON_YES" => $hidde_last_logon_yes, 
	"HIDDE_LAST_LOGON_NO" => $hidde_last_logon_no, 
	"BIRTHDAY_GREETING_YES" => $birthday_greeting_yes, 
	"BIRTHDAY_GREETING_NO" => $birthday_greeting_no,
	"BIRTHDAY_REQUIRED_YES" => $birthday_required_yes, 
	"BIRTHDAY_REQUIRED_NO" => $birthday_required_no, 
	"MAX_USER_AGE" => $new['max_user_age'], 
	"MIN_USER_AGE" => $new['min_user_age'],
	"BIRTHDAY_LOOKFORWARD" => $new['birthday_check_day'],
	"BLUECARD_LIMIT" => $new['bluecard_limit'], 
	"BLUECARD_LIMIT_2" => $new['bluecard_limit_2'], 
	"MAX_USER_BANCARD" => $new['max_user_bancard'], 
	"MAX_USER_VOTEBANCARD" => $new['max_user_votebancard'], 
	"REPORT_FORUM" => $new['report_forum'],
	"HTML_TAGS" => $html_tags, 
	"HTML_YES" => $html_yes,
	"HTML_NO" => $html_no,
	"BBCODE_YES" => $bbcode_yes,
	"BBCODE_NO" => $bbcode_no,
	"SMILE_YES" => $smile_yes,
	"SMILE_NO" => $smile_no,
	"SIG_YES" => $sig_yes,
	"SIG_NO" => $sig_no,
	"SIG_SIZE" => $new['max_sig_chars'], 
	"YEAR_STARS" => $new['year_stars'],
	"NAMECHANGE_YES" => $namechange_yes,
	"NAMECHANGE_NO" => $namechange_no,
	"AVATARS_LOCAL_YES" => $avatars_local_yes,
	"AVATARS_LOCAL_NO" => $avatars_local_no,
	"AVATARS_REMOTE_YES" => $avatars_remote_yes,
	"AVATARS_REMOTE_NO" => $avatars_remote_no,
	"AVATARS_UPLOAD_YES" => $avatars_upload_yes,
	"AVATARS_UPLOAD_NO" => $avatars_upload_no,
	"AVATAR_FILESIZE" => $new['avatar_filesize'],
	"AVATAR_MAX_HEIGHT" => $new['avatar_max_height'],
	"AVATAR_MAX_WIDTH" => $new['avatar_max_width'],
	"AVATAR_PATH" => $new['avatar_path'], 
	"AVATAR_GALLERY_PATH" => $new['avatar_gallery_path'], 
	"AVATARS_STICKY_YES" => $avatars_sticky_yes,
	"AVATARS_STICKY_NO" => $avatars_sticky_no,
	"SMILIE_COLUMNS" => $new['smilie_columns'],
	"SMILIE_ROWS" => $new['smilie_rows'],
	"SMILIE_WINDOW_COLUMNS" => $new['smilie_window_columns'],
	"SMILIES_PATH" => $new['smilies_path'], 
	"INBOX_PRIVMSGS" => $new['max_inbox_privmsgs'], 
	"SENTBOX_PRIVMSGS" => $new['max_sentbox_privmsgs'], 
	"SAVEBOX_PRIVMSGS" => $new['max_savebox_privmsgs'])
);

include($phpbb_root_path . 'admin/admin_usage_stats.'.$phpEx);

if ( isset($lang['Post_global_announcement']) ) $template->assign_block_vars('switch_global_announce', array());

$template->pparse("body");

include('./page_footer_admin.'.$phpEx);

?>
