<?php
/***************************************************************************
 *
 *                             admin_activity.php
 *                            --------------------
 *   begin                : Tuesday, October 15, 2002
 *   copyright            : (c)2002 www.GigaKnight.com
 *   email                : community@gigaknight.com
 *
 *   $Id : admin_activity.php,v 1.0.0 2002/10/15 07:43:00 GigaKnight Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

/***************************************************************************
 * This file has been modified by Fully Moddded phpBB
 *
 *   $FMId: 2003/08/06 04:58:12 mj 
 *
 ***************************************************************************/

define('IN_PHPBB', 1);
if( !empty($setmodules) )
{
  $file = basename(__FILE__);
  $module['Points_system']['Activity_Settings'] = $file;
  return;
}

// Let's set the root dir for phpBB
//
$phpbb_root_path = '../';
require($phpbb_root_path . 'extension.inc');
require('pagestart.' . $phpEx);

// include language file
$language = $board_config['default_lang'];

if( !file_exists($phpbb_root_path . 'language/lang_' . $language . '/lang_games.'.$phpEx) )
{
	$language = 'english';
}

include($phpbb_root_path . 'language/lang_' . $language . '/lang_games.' . $phpEx);

$sql = "SELECT *
        FROM " . CONFIG_TABLE . "
        WHERE config_name IN('use_point_system', 'use_allowance_system', 'use_rank_reward_system', 'use_forum_reward_system', 'pm_reward', 'pm_charge', 'nt_reward', 'nt_charge', 'pr_reward', 'pr_charge', 'allowance_payday', 'allowance', 'default_money', 'money_name', 'sig_charge')";

if( !$result = $db->sql_query($sql) )
{
	message_die(CRITICAL_ERROR,'Could not obtain Ganes Configuration information', '', __LINE__, __FILE__, $sql);
}
else
{
  while( $row = $db->sql_fetchrow($result) )
  {
    $config_name = $row['config_name'];
    $config_value = $row['config_value'];
    $default_config[$config_name] = $config_value;

    $new[$config_name] = ( isset($HTTP_POST_VARS[$config_name]) ) ? $HTTP_POST_VARS[$config_name] : $default_config[$config_name];

    if ( ($board_config['use_point_system'] && ($new['use_allowance_system'] == 1)) ||
         ($board_config['use_allowance_system'] && ($new['use_point_system'] == 1)))
    {    
      $message = 'The Allowance System will cause conflicts with the Point System. Please go into the Online Ganes Configuration Menu, turn one system off and <b>SUBMIT</b> your selection. Then turn on the system you wish to use.<br><br> Sorry for the inconvienance.';

      $message .= "<br /><br />" . sprintf('Click %sHere%s to return to Online Games Configuration', "<a href=\"" . append_sid("admin_activity.$phpEx") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=right") . "\">", "</a>");

      message_die(GENERAL_ERROR, $message, '', __LINE__, __FILE__, $sql);
    }

    if( isset($HTTP_POST_VARS['submit']) )
    {
      $sql = "UPDATE " . CONFIG_TABLE . "
              SET config_value = '" . str_replace("\'", "''", $new[$config_name]) . "'
              WHERE config_name = '$config_name'";

      if( !$db->sql_query($sql) )
      {
        message_die(GENERAL_ERROR, "Could not update Online Games Configuration for $config_name", '', __LINE__, __FILE__, $sql);
      }
    }
  }

  if( isset($HTTP_POST_VARS['submit']) )
  {
    $message = 'Online Games Configuration Updated Successfully.';
    $message .= "<br /><br />" . sprintf('Click %sHere%s to return to Online Games Configuration', "<a href=\"" . append_sid("admin_activity.$phpEx") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=right") . "\">", "</a>");
    message_die(GENERAL_MESSAGE, $message, '', __LINE__, __FILE__, $sql);
  }

  if( isset($HTTP_POST_VARS['pay_today']) && $board_config['use_allowance_system'] )
  {
    $pay_amount = $board_config['allowance'];

    $sql = "SELECT user_id,user_rank
            FROM " . USERS_TABLE . " 
            WHERE user_id != " . ANONYMOUS;

    if( !$result = $db->sql_query($sql) )
    {
      message_die(GENERAL_ERROR, 'Error Updating Daily Allowance', '', __LINE__, __FILE__, $sql);
    }

    $users = $db->sql_fetchrowset($result);
    $total_users = count($users);

    for($i = 0; $i < $total_users; $i++)
    {
      $reward = $pay_amount;
      $user_id = $users[$i]['user_id'];

      if($board_config['use_rank_reward_system']) // Check for Admin Okay
      {
        $user_rr = $users[$i]['user_rank'];

        $sql = "SELECT *
                FROM " . RANKS_TABLE . "
                ORDER BY rank_special, rank_min";
        if ( !($result = $db->sql_query($sql)) )
        {
          message_die(GENERAL_ERROR, 'Could not obtain ranks information', '', __LINE__, __FILE__, $sql);
        }

        while ( $row = $db->sql_fetchrow($result) )
        {
          $ranksrow[] = $row;
        }
        $db->sql_freeresult($result);

        $reward = $reward + $ranksrow[$user_rr]['rank_reward'];
      } // end rank rewards

      $sql = "UPDATE " . USERS_TABLE . " 
              SET user_money = user_money + $reward
              WHERE user_id = " . $user_id;

      if( !$db->sql_query($sql) )
      {
          message_die(GENERAL_ERROR, 'Could not updating user money information', '', __LINE__, __FILE__, $sql);
      }
    }
  }

  if( isset($HTTP_POST_VARS['reset_money']) )
  {
    $sql = "ALTER TABLE " .
            USERS_TABLE . " MODIFY user_money INT(11) UNSIGNED DEFAULT '" . $board_config['default_money'] . "' NOT NULL";

    if( !$result = $db->sql_query($sql) )
    {
		message_die(GENERAL_ERROR, 'Could not altering the user table.', '', __LINE__, __FILE__, $sql);
    }

    $sql = "SELECT user_id
            FROM " . USERS_TABLE . " 
            WHERE user_id != " . ANONYMOUS;

    if( !$result = $db->sql_query($sql) )
    {
		message_die(GENERAL_ERROR, 'Could not obtain user information', '', __LINE__, __FILE__, $sql);
    }
    $users = $db->sql_fetchrowset($result);
    $total_users = count($users);

    $today = date("d");

    for($i = 0; $i < $total_users; $i++)
    {
      $user_id = $users[$i]['user_id'];
      $money = $board_config['default_money'];

      $sql = "UPDATE " . USERS_TABLE . " 
              SET user_money = $money
              WHERE user_id = " . $user_id;

      if( !$db->sql_query($sql) )
      {
		message_die(GENERAL_ERROR, 'Could not update user money information', '', __LINE__, __FILE__, $sql);
      }
    }
    $message = 'Updated Successfully ' . $board_config['money_name'];
    $message .= "<br /><br />" . sprintf('Click %sHere%s to return to Online Games Configuration', "<a href=\"" . append_sid("admin_activity.$phpEx") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=right") . "\">", "</a>");
    message_die(GENERAL_MESSAGE, $message, '', __LINE__, __FILE__, $sql);
  }
}

$use_point_system_yes = ( $new['use_point_system'] ) ? 'checked="checked"' : '';
$use_point_system_no  = ( !$new['use_point_system'] ) ? 'checked="checked"' : '';

$use_allowance_system_yes = ( $new['use_allowance_system'] ) ? 'checked="checked"' : '';
$use_allowance_system_no  = ( !$new['use_allowance_system'] ) ? 'checked="checked"' : '';

$use_rank_reward_system_yes = ( $new['use_rank_reward_system'] ) ? 'checked="checked"' : '';
$use_rank_reward_system_no  = ( !$new['use_rank_reward_system'] ) ? 'checked="checked"' : '';

$use_forum_reward_system_yes = ( $new['use_forum_reward_system'] ) ? 'checked="checked"' : '';
$use_forum_reward_system_no  = ( !$new['use_forum_reward_system'] ) ? 'checked="checked"' : '';

$pm_reward = $new['pm_reward'];
$pm_charge = $new['pm_charge'];
$nt_reward = $new['nt_reward'];
$nt_charge = $new['nt_charge'];
$pr_reward = $new['pr_reward'];
$pr_charge = $new['pr_charge'];

$allowance_payday = $new['allowance_payday'];
$allowance = $new['allowance'];

$default_money = $new['default_money'];
$money_name = $new['money_name'];
$sig_charge = $new['sig_charge'];

$template->set_filenames(array(
	'body' => 'admin/activity_config_body.tpl')
);

$template->assign_vars(array(
	'S_CONFIG_ACTION' => append_sid("admin_activity.$phpEx"),

	'L_SUPPORT' => $lang['Support'],
	'L_GAMES_EXPLAIN' => $lang['Games_explain'],
	'L_GAMES_TITLE' => $lang['Games_title'],
	'L_USE_POINTS' => $lang['Use_points'],
	'L_USE_POINTS_EXPLAIN' => $lang['Use_points_explain'],
	'L_REWARD_SYSTEM' => $lang['Reward_system'],
	'L_USE_ALLOWANCE' => $lang['Use_allowance'],
	'L_USE_ALLOWANCE_EXPLAIN' => $lang['Use_allowance_explain'],
	'L_USE_FORUM_REWARD' => $lang['Use_forum_reward'],
	'L_USE_FORUM_REWARD_EXPLAIN' => $lang['Use_forum_reward_explain'],
	'L_USE_RANK_REWARD' => $lang['Use_rank_reward'],
	'L_USE_RANK_REWARD_EXPLAIN' => $lang['Use_rank_reward_explain'],
	'L_CONFIGURATION' => $lang['Configuration'],
	'L_CURRENCY_NAME' => $lang['Currency_name'],
	'L_CURRENCY_NAME_EXPLAIN' => $lang['Currency_name_explain'],
	'L_CURRENCY_AMOUNT' => $lang['Currency_amount'],
	'L_CURRENCY_AMOUNT_EXPLAIN' => $lang['Currency_amount_explain'],
	'L_PM_REWARD' => $lang['PM_reward'],
	'L_PM_REWARD_EXPLAIN' => $lang['PM_reward_explain'],
	'L_PM_CHARGE' => $lang['PM_charge'],
	'L_PM_CHARGE_EXPLAIN' => $lang['PM_charge_explain'],
	'L_NT_REWARD' => $lang['NT_reward'],
	'L_NT_REWARD_EXPLAIN' => $lang['NT_reward_explain'],
	'L_NT_CHARGE'=> $lang['NT_charge'],
	'L_NT_CHARGE_EXPLAIN' => $lang['NT_charge_explain'],
	'L_PR_REWARD' => $lang['PR_reward'],
	'L_PR_REWARD_EXPLAIN' => $lang['PR_reward_explain'],
	'L_PR_CHARGE' => $lang['PR_charge'],
	'L_PR_CHARGE_EXPLAIN' => $lang['PR_charge_explain'],
	'L_ALLOWANCE_PAYDAY' => $lang['Allowance_payday'],
	'L_ALLOWANCE_PAYDAY_EXPLAIN' => $lang['Allowance_payday_explain'],
	'L_ALLOWANCE' => $lang['Allowance'],
	'L_ALLOWANCE_EXPLAIN' => $lang['Allowance_explain'],
	'L_PAYDAY' => $lang['Payday'],
	'L_SIG_CHARGE' => $lang['Sig_charge'],
	'L_SIG_CHARGE_EXPLAIN' => $lang['Sig_charge_explain'],

	'L_YES' => $lang['Yes'],
	'L_NO' => $lang['No'],
	'L_SUBMIT' => $lang['Submit'],
	'L_RESET' => $lang['Reset'],
	'L_MONEY' => $money_name,
	'L_SIG' => $sig_charge,

	'L_DAILY' => $lang['Daily'],
	'L_WEEKLY' => $lang['Weekly'],
	'L_BIWEEKLY' => $lang['Biweekly'],
	'L_MONTHLY' => $lang['Monthly'],

	'S_USE_PSM_YES' => $use_point_system_yes,
	'S_USE_PSM_NO' => $use_point_system_no,
	
	'S_USE_ASM_YES' => $use_allowance_system_yes,
	'S_USE_ASM_NO' => $use_allowance_system_no,

	'S_USE_RRS_YES' => $use_rank_reward_system_yes,
	'S_USE_RRS_NO' => $use_rank_reward_system_no,

	'S_USE_FRS_YES' => $use_forum_reward_system_yes,
	'S_USE_FRS_NO' => $use_forum_reward_system_no,

	'S_PM_REWARD' => $pm_reward,
	'S_PM_CHARGE' => $pm_charge,
	'S_NT_REWARD' => $nt_reward,
	'S_NT_CHARGE' => $nt_charge,
	'S_PR_REWARD' => $pr_reward,
	'S_PR_CHARGE' => $pr_charge,

	'S_ALLOWANCE_PAYDAY' => $allowance_payday,
	'S_ALLOWANCE' => $allowance,

	'S_DEFAULT_MONEY' => $default_money,
	'S_MONEY' => $money_name,
	'S_SIG' => $sig_charge,

	'S_HIDDEN_FIELDS' => '')
);

// Generate the page
//
$template->pparse('body');

include('page_footer_admin.' . $phpEx);

?>