VERSION 1.0 CLASS
BEGIN
  MultiUse = 0   'False
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "HttpRequest"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Private Const INTERNET_OPEN_TYPE_PRECONFIG = 0 ' use registry configuration
Private Const INTERNET_OPEN_TYPE_DIRECT = 1 ' direct to net
Private Const INTERNET_OPEN_TYPE_PROXY = 3   'via named proxy
Private Const INTERNET_SERVICE_HTTP = 3
Private Const INTERNET_FLAG_RELOAD = &H80000000
Private Const INTERNET_FLAG_SECURE = &H800000
Private Const INTERNET_FLAG_NO_COOKIES = &H80000     ' no automatic cookie handling
Private Const INTERNET_OPTION_CONNECT_TIMEOUT = 2
Private Const INTERNET_OPTION_SEND_TIMEOUT = 5
Private Const INTERNET_OPTION_RECEIVE_TIMEOUT = 6
Private Const HTTP_QUERY_STATUS_CODE = 19
Private Const HTTP_QUERY_COOKIE = 44
Private Const HTTP_QUERY_SET_COOKIE = 43
Private Const HTTP_ADDREQ_FLAG_ADD_IF_NEW = &H10000000
Private Const HTTP_ADDREQ_FLAG_ADD = &H20000000
Private Const HTTP_ADDREQ_FLAG_REPLACE = &H80000000
' The timeout for 'connect', 'send' and 'receive' communications.
' Specify the timeout in miliseconds.
Private m_lTimeout As Long
' The response returned by the server.
Private m_sResponse As String
' The content type of the content.
Private m_sContentType As String
' The content of the request.
Private m_sContent As String
' Cookie from server
Private m_cRequestCookies As Collection
Private m_cResponseCookies As Collection

Private Declare Function InternetOpen Lib "wininet.dll" Alias "InternetOpenA" (ByVal sAgent As String, ByVal lAccessType As Long, ByVal sProxyName As String, ByVal sProxyBypass As String, ByVal lFlags As Long) As Long
Private Declare Function InternetConnect Lib "wininet.dll" Alias "InternetConnectA" (ByVal hInternetSession As Long, ByVal sServerName As String, ByVal nServerPort As Long, ByVal sUsername As String, ByVal sPassword As String, ByVal lService As Long, ByVal lFlags As Long, ByVal lContext As Long) As Long
Private Declare Function InternetReadFile Lib "wininet.dll" (ByVal hFile As Long, ByVal sBuffer As String, ByVal lNumBytesToRead As Long, lNumberOfBytesRead As Long) As Integer
Private Declare Function InternetSetOption Lib "wininet.dll" Alias "InternetSetOptionA" (ByVal hInternet As Long, ByVal dwOption As Long, lpBuffer As Any, ByVal dwBufferLength As Long) As Integer
Private Declare Function HttpOpenRequest Lib "wininet.dll" Alias "HttpOpenRequestA" (ByVal hHttpSession As Long, ByVal sVerb As String, ByVal sObjectName As String, ByVal sVersion As String, ByVal sReferer As String, ByVal something As Long, ByVal lFlags As Long, ByVal lContext As Long) As Long
Private Declare Function HttpSendRequest Lib "wininet.dll" Alias "HttpSendRequestA" (ByVal hHttpRequest As Long, ByVal sHeaders As String, ByVal lHeadersLength As Long, sOptional As Any, ByVal lOptionalLength As Long) As Integer
Private Declare Function HttpQueryInfo Lib "wininet.dll" Alias "HttpQueryInfoA" (ByVal hHttpRequest As Long, ByVal lInfoLevel As Long, ByRef sBuffer As Any, ByRef lBufferLength As Long, ByRef lIndex As Long) As Integer
Private Declare Function InternetCloseHandle Lib "wininet.dll" (ByVal hInet As Long) As Integer
Private Declare Function GetLastError Lib "kernel32" () As Long
Private Declare Function HttpAddRequestHeaders Lib "wininet.dll" Alias "HttpAddRequestHeadersA" (ByVal hHttpRequest As Long, ByVal sHeaders As String, ByVal lHeadersLength As Long, ByVal lModifiers As Long) As Integer
      

Option Explicit

'*-------------
'*  The timeout for 'connect', 'send' and 'receive' communications.
'*  Specify the timeout in miliseconds.
'*
'*  Input    : lTimeout
'*-------------
Public Property Let Timeout(ByVal lTimeout As Long)
Attribute Timeout.VB_Description = "The timeout for 'connect', 'send' and 'receive' communications.\r\nSpecify the timeout in miliseconds."

  m_lTimeout = lTimeout

End Property

'*-------------
'*  The response returned by the server.
'*
'*  Input    : None
'*  Returns  : The value of the Response property
'*-------------
Public Property Get Response() As String
Attribute Response.VB_Description = "The response returned by the server."

  Response = m_sResponse

End Property

'*-------------
'*  The content type of the content.
'*  Set this property if you want to POST content.
'*
'*  Input    : sContentType
'*-------------
Public Property Let ContentType(ByVal sContentType As String)

  m_sContentType = sContentType

End Property

'*-------------
'*  The content type of the content.
'*  Get this property after a GET.
'*
'*  Input    : None
'*  Returns  : The value of the ContentType property
'*-------------
Public Property Get ContentType() As String
Attribute ContentType.VB_Description = "The content type of the content."

  ContentType = m_sContentType

End Property

'*-------------
'*  The content of the request.
'*  Set this property if you want to POST content.
'*
'*  Input    : sContent
'*-------------
Public Property Let Content(ByVal sContent As String)

  m_sContent = sContent

End Property

'*-------------
'*  The content of the request.
'*  Get this property after a GET.
'*
'*  Input    : None
'*  Returns  : The value of the Content property
'*-------------
Public Property Get Content() As String
Attribute Content.VB_Description = "The content of the request."

  Content = m_sContent

End Property
'*-------------
'*  The cookies received in response.
'*
'*  Returns  : Collection of variant/string
'*-------------
Public Property Get ResponseCookies() As Collection

  Set ResponseCookies = m_cResponseCookies

End Property
'*-------------
'*  The cookies to be sent in request
'*-------------
Public Property Set RequestCookies(cCookies As Collection)
  
  Set m_cRequestCookies = cCookies

End Property

'*-------------
'*  This method will post the value of the Content property to the
'*  specified host. If a user ID and password have been specified, they
'*  will be passed to the host. If the content type of the actual content
'*  is different than text/html, you must set the ContentType property.
'*
'*  Input    : sHost    , The name of the host (without http etc.)
'*             lPort    , The port number (80 = HTTP, 443 = HTTPS)
'*             bSecure  , Use HTTPS/SSL True/False
'*             sPage    , Post the content to this page
'*-------------
Public Sub Request(bPost As Boolean, ByVal sHost As String, ByVal lPort As Long, ByVal bSecure As Boolean, _
                ByVal sPage As String, ByVal sProxyServer As String, ByVal sProxyBypass As String)

  Dim lSession As Long, lConnection As Long, lRequest As Long
  Dim lFlags As Long
  Dim iResult As Long
  Dim sBuffer As String * 256
  
  On Error GoTo ErrorHandler
  
  ' Intialize a session with WinInet
  If sProxyServer = vbNullString Then
    lSession = InternetOpen(App.ProductName, INTERNET_OPEN_TYPE_DIRECT, vbNullString, vbNullString, 0)
  Else
    lSession = InternetOpen(App.ProductName, INTERNET_OPEN_TYPE_PROXY, sProxyServer, sProxyBypass, 0)
  End If
  If lSession = 0 Then
    ' Unable to start a session
    Err.Raise GetLastError(), , "InternetOpen failed"
    
  Else
    ' Setup the timeout values
    InternetSetOption lSession, INTERNET_OPTION_CONNECT_TIMEOUT, m_lTimeout, Len(m_lTimeout)
    InternetSetOption lSession, INTERNET_OPTION_RECEIVE_TIMEOUT, m_lTimeout, Len(m_lTimeout)
    InternetSetOption lSession, INTERNET_OPTION_SEND_TIMEOUT, m_lTimeout, Len(m_lTimeout)
  
    ' Make a HTTP connection with the specified host
    lConnection = InternetConnect(lSession, sHost, lPort, vbNullString, vbNullString, INTERNET_SERVICE_HTTP, 0, 0)
      
    If lConnection = 0 Then
      ' Unable to start a session
      Err.Raise errInternetNotAvailable, , "InternetConnect failed. Error number: " & GetLastError()
    
    Else
      ' Open a HTTP request
      If bSecure = True Then
        lFlags = INTERNET_FLAG_SECURE
      End If
      
      lFlags = lFlags Or INTERNET_FLAG_NO_COOKIES
      If bPost Then
        lRequest = HttpOpenRequest(lConnection, "POST", sPage, "HTTP/1.1", vbNullString, 0, lFlags + INTERNET_FLAG_RELOAD, 0)
      Else
        lRequest = HttpOpenRequest(lConnection, "GET", sPage, "HTTP/1.1", vbNullString, 0, lFlags + INTERNET_FLAG_RELOAD, 0)
      End If
      
      If lRequest = 0 Then
        ' Unable to open an HTTP request
        Err.Raise errServerNotAvailable, , "HttpOpenRequest failed. Error Code: " & GetLastError()
      
      Else
        ' Send the HTTP request
        If bPost Then
          Dim sContentType As String
          sContentType = "Content-Type: " & m_sContentType
          iResult = HttpAddRequestHeaders(lRequest, sContentType, -1, 0)
          If iResult = False Then
            ' Unable to set content-type for HTTP request
            Err.Raise errSendRequestFailed, , "HTTP: Set Content failed. Error code: " & GetLastError()
          End If
        End If
        
        If Not (m_cRequestCookies Is Nothing) Then
          If m_cRequestCookies.Count > 0 Then
            Dim sCookies As String
            Dim I As Integer
            sCookies = ""
            For I = 1 To m_cRequestCookies.Count
              If sCookies <> "" Then
                sCookies = sCookies & vbCrLf
              End If
              sCookies = sCookies & "Cookie: " & m_cRequestCookies(I)
            Next I
            iResult = HttpAddRequestHeaders(lRequest, sCookies, -1, HTTP_ADDREQ_FLAG_REPLACE Or HTTP_ADDREQ_FLAG_ADD)
            If iResult = False Then
              ' Unable to set content-type for HTTP request
              Err.Raise errSendRequestFailed, , "HTTP: Set cookies failed. Error code: " & GetLastError()
            End If
          End If
        End If
        
        Debug.Print "Request"
        Debug.Print m_sContent
        iResult = HttpSendRequest(lRequest, "", -1, ByVal m_sContent, Len(m_sContent))
      
        If iResult = False Then
          ' Unable to send the HTTP request
          Err.Raise errServerNotAvailable, , "Either SIN Server or Internet connection is down."
        Else
        
          ' Retrieve the status code
          iResult = HttpQueryInfo(lRequest, HTTP_QUERY_STATUS_CODE, ByVal sBuffer, Len(sBuffer), 0)
          
          If iResult = False Then
            ' Unable to send the HTTP request
            Err.Raise GetLastError(), , "HttpQueryInfo failed"
          Else
            sBuffer = ZeroTerminatedToVB(sBuffer)
            If DebugEndSession Then
              iResult = 408
            Else
              iResult = Val(sBuffer)
            End If
            ' Get the XML result if available
            GetResponse lRequest
            If iResult <> 200 Then
              ' HTTP request failed
              If (iResult = 408) Then
                Err.Raise errSessionExpired, , "Session Expired"
              Else
                Err.Raise errServerError, , "HTTP POST failed. Server returned status code: " & iResult
              End If
            Else
              ' Get Cookie
              Dim l As Long
              l = 0
              iResult = 1
              While iResult = 1
                iResult = HttpQueryInfo(lRequest, HTTP_QUERY_SET_COOKIE, ByVal sBuffer, Len(sBuffer), l)
                If iResult <> 0 Then
                  If l = 1 Then
                    Set m_cResponseCookies = New Collection
                  End If
                  m_cResponseCookies.Add (ZeroTerminatedToVB(sBuffer))
                End If
              Wend
            End If
          End If
          InternetCloseHandle lRequest
        End If
      End If
      InternetCloseHandle lConnection
    End If
    InternetCloseHandle lSession
  End If
  
  Exit Sub
ErrorHandler:
  
  Dim lNumber As Long
  Dim sDescription As String

  '
  ' An error occured...
  '
  lNumber = Err.Number
  sDescription = Err.Description

  Resume Cleanup

Cleanup:
  ' Cleanup after error...
  On Error Resume Next

  InternetCloseHandle lRequest
  InternetCloseHandle lConnection
  InternetCloseHandle lSession

  On Error GoTo 0

  Err.Raise lNumber, TypeName(Me) & ".Post", sDescription

End Sub

'*-------------
'*  This method will retrieve the complete response from the server.
'*
'*  Input    : lRequest, The HINTERNET handle
'*  Return   : None
'*-------------
Private Sub GetResponse(ByVal lRequest As Long)

  Dim lBytes As Long
  Dim sBuffer As String * 1024
  Dim bEnd As Boolean, bRc As Boolean

  ' Retrieve the complete response from the server
  m_sResponse = ""
  
  Do While Not bEnd
   
    ' Get the next chunk
    sBuffer = vbNullString
    bRc = CBool(InternetReadFile(lRequest, sBuffer, Len(sBuffer), lBytes))
  
    If bRc = False Then
      ' Unable to read response
      Err.Raise GetLastError(), , "InternetReadFile failed"
    
    Else
      ' Append this chunk to the XML
      m_sResponse = m_sResponse & Left$(sBuffer, lBytes)
      bEnd = (lBytes = 0)
    
    End If
  
  Loop

End Sub

'*-------------
'*  This function will convert a zero terminated string
'*  to a normal Visual Basic string.
'*
'*  Input    : sz, Zero terminated string
'*  Modifies : None
'*  Return   : Visual Basic string with correct length
'*-------------
Private Function ZeroTerminatedToVB(ByVal sz As String) As String

  Dim iZero As Integer

  iZero = InStr(sz, Chr$(0))

  If iZero <> 0 Then
    ZeroTerminatedToVB = Left$(sz, iZero - 1)
  Else
    ZeroTerminatedToVB = sz
  End If

End Function

Private Sub Class_Initialize()

  '
  ' Initialize the class
  '
  m_sContentType = "text/xml"
End Sub

