Attribute VB_Name = "XmlUtils"

Option Explicit

'*-------------
'*  Format the properties of an IXMLDOMParseError object into a string that
'*  can be displayed or logged.
'*
'*  Input    : ParseError, The error object returned from a DOMDocument
'*  Returns  : A formatted error message
'*-------------
Public Function ParseErrorString(ByVal ParseError As IXMLDOMParseError) As String

  Dim sError As String

  '
  ' Format the error information
  '
  If Not (ParseError Is Nothing) Then

    sError = vbCrLf
    sError = sError & "MSXML Parser error. ErrorCode = " & Hex$(ParseError.errorCode) & vbCrLf
    sError = sError & "filepos = " & CStr(ParseError.filepos) & " "
    sError = sError & "line = " & CStr(ParseError.Line) & " "
    sError = sError & "linepos = " & CStr(ParseError.linepos) & vbCrLf
    sError = sError & "reason = " & ParseError.reason & vbCrLf
    'sError = sError & "srcText = " & ParseError.srcText & vbCrLf
    'sError = sError & "url = " & ParseError.URL & vbCrLf

  End If

  ParseErrorString = sError

End Function

Function FormatXSDDateTime(dt As Variant) As String
  Dim sYear As String
  Dim sMonth As String
  Dim sDay As String
  Dim sHour As String
  Dim sMin As String
  Dim sSec As String
  
  sYear = CStr(Year(dt))
  sMonth = CStr(Month(dt))
  If Len(sMonth) < 2 Then sMonth = "0" & sMonth
  
  sDay = CStr(Day(dt))
  If Len(sDay) < 2 Then sDay = "0" & sDay
  
  sHour = CStr(Hour(dt))
  If Len(sHour) < 2 Then sHour = "0" & sHour
  
  sMin = CStr(Minute(dt))
  If Len(sMin) < 2 Then sMin = "0" & sMin
  
  sSec = CStr(Second(dt))
  If Len(sSec) < 2 Then sSec = "0" & sSec
  
  FormatXSDDateTime = sYear & "-" & sMonth & "-" & sDay & "T" & sHour & ":" & sMin & ":" & sSec
End Function

