Attribute VB_Name = "DebugUtils"
Public DebugLog As DLog

' flag-file for session termination emulation for debug purposes
Private Const END_SESSION_FLAG As String = "C:\End-Session.FLAG"

Private Declare Function IsDebuggerPresent Lib "kernel32" () As Long
Private Declare Function GetModuleFileName Lib "kernel32" Alias "GetModuleFileNameA" (ByVal hModule As Long, ByVal lpFileName As String, ByVal nSize As Long) As Long
Private Declare Function GetModuleHandle Lib "kernel32" Alias "GetModuleHandleA" (ByVal lpModuleName As String) As Long

Public Declare Function GetFileAttributes Lib "kernel32" Alias "GetFileAttributesA" (ByVal file_name As String) As Long
Public Declare Function DeleteFile Lib "kernel32" Alias "DeleteFileA" (ByVal file_name As String) As Boolean


'if a debutter is present it returns 1 otherwise 0:
Public Function IsUnderDebug() As Boolean
  IsUnderDebug = (GetCallingProcess = "VB6.EXE")
   'IsUnderDebug = IsDebuggerPresent
End Function

Public Function GetCallingProcess() As String
   On Error GoTo GetCallingProcess_EH
   
   Dim strFilePath As String
   
   
   'get the name of the current executable
   strFilePath = Space$(256)
   GetModuleFileName GetModuleHandle(0), strFilePath, Len(strFilePath)
   
   'trim out extra blanks
   strFilePath = Left$(strFilePath, InStr(strFilePath, vbNullChar) - 1)
   
   'get just the executable name
   strFilePath = Right$(strFilePath, Len(strFilePath) - InStrRev(strFilePath, "\"))
   GetCallingProcess = strFilePath
   
   Exit Function
   
GetCallingProcess_EH:
   GetCallingProcess = Err.Number & " : Error.exe"
End Function

Public Function DebugEndSession(Optional reset As Boolean = False)
  If reset Then
    DeleteFile (END_SESSION_FLAG)
    DebugEndSession = False
  Else
    DebugEndSession = GetFileAttributes(END_SESSION_FLAG) <> -1
    If DebugEndSession Then DebugLog.Log "!!! DebugEndSession !!! END_SESSION_FLAG detected !!!"
  End If
End Function

