Attribute VB_Name = "Compatibilities"
Private bPicturesInCmdButtons As Boolean
Private iAppVersion As Integer

Public Sub SetOfficeApp(oApp As Outlook.Application)
  On Error GoTo ErrorHandler
  
  Dim aAppVersion() As String
  
  aAppVersion = Split(oApp.Version, ".")
  iAppVersion = aAppVersion(0)
  
  bPicturesInCmdButtons = (iAppVersion > 9) And Not IsUnderDebug
  Exit Sub
ErrorHandler:
  Err.Raise Err.Number, , Err.Description & vbCrLf & "At SetOfficeApp"
End Sub

Public Function UseButtonPictures() As Boolean
  UseButtonPictures = bPicturesInCmdButtons
End Function

Public Function isOutlookWordMode() As Boolean
  Dim sRootKey As String
  sRootKey = "Software\Microsoft\Office\" & iAppVersion & ".0\Outlook\Options\Mail"
  Dim vEditorPreference
  vEditorPreference = regQuery_A_Key(HKEY_CURRENT_USER, sRootKey, "EditorPreference")
  If IsNumeric(vEditorPreference) Then
    Dim Value As Long
    Value = vEditorPreference
    isOutlookWordMode = ((Value Mod 4) = 1)
  Else
    isOutlookWordMode = False
  End If
End Function

Public Function FindCreateOutlookButton(Explorer As Outlook.Explorer) As Office.CommandBarButton
  If isOutlookWordMode Then
    If iAppVersion > 9 Then
      Set FindCreateOutlookButton = Explorer.CommandBars.ActiveMenuBar.FindControl(msoControlButton, 5660, , , True)
    Else
      Set FindCreateOutlookButton = Nothing
    End If
  Else
    Set FindCreateOutlookButton = Explorer.CommandBars.ActiveMenuBar.FindControl(msoControlButton, 5610, , , True)
  End If
End Function

Public Function AppVer() As Integer
  AppVer = iAppVersion
End Function
