VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "SINSession"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Member0" ,"Configuration"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Private m_oProtocol As SINProtocol
Private m_oConfig As Configuration

Public Event OnLoginRejected(ByRef sUserId As String, ByRef sUserPswd As String, ByRef Retry As Boolean)
Public Event OnShowError(ByVal sMessage As String)
Public Event OnSessionExpired(ByRef continue As Boolean)

Public Sub InvalidateProtocol()
  Set m_oProtocol = Nothing
End Sub

Private Function Login() As Boolean
  Dim loginResp As logInResponse
  Dim sUserId As String
  Dim sUserPswd As String
  Dim loginReq As New logInRequest
  Dim bRetry As Boolean
  Dim saveErrNumber As Long
  Dim saveErrorDescr As String
  
  sUserId = m_oConfig.userName
  sUserPswd = m_oConfig.Password
  
  ' for debug purposes: reset end-session-flag
  DebugEndSession True
    
TryLogin:

  loginReq.userId = sUserId
  loginReq.userPswd = sUserPswd
  
  On Error GoTo LoginFailed
  Set loginResp = m_oProtocol.Execute(loginReq)
  Login = Not (loginResp Is Nothing)
  Exit Function
  
LoginFailed:
  Select Case Err.Number
    Case errServerError:
      'either userid or password are invalid
      bRetry = False
      'RaiseEvent OnLoginRejected(sUserId, sUserPswd, bRetry)
      If bRetry Then
        ' User has entered another login/password
        Err.Clear
        Resume TryLogin
      Else
        ' User cancelled relogin dialog or no OnLoginRejected handler installed
        Err.Raise errLoginFailed, , Err.Description
      End If
      Exit Function
    Case Else
      saveErrNumber = Err.Number
      saveErrorDescr = Err.Description
      Resume Reraise
  End Select
  Exit Function
Reraise:
  On Error GoTo 0
  Err.Raise saveErrNumber, , saveErrorDescr
End Function

Friend Property Set Configuration(ByRef oConfig As Configuration)
  InvalidateProtocol
  Set m_oConfig = oConfig
End Property

'*-------------
'* Entry method for all calls
'* Shows Error MsgBox and returns Nothing in case of error
'*-------------
Private Function Execute(oReq As Object) As Object
  ' Check configuration is already assigned
  If m_oConfig Is Nothing Then
    Debug.Assert False
  End If
  
  'Create protocol if required
  If m_oProtocol Is Nothing Then
    Set m_oProtocol = New SINProtocol
    With m_oProtocol
      .Host = m_oConfig.ServerHost
      .Page = m_oConfig.ServerPage
      .Port = m_oConfig.ServerPort
      .Secure = False
      If m_oConfig.UseProxy Then
        .ProxyServer = m_oConfig.ProxyServer
        .ProxyBypass = m_oConfig.ProxyBypass
      Else
        .ProxyServer = vbNullString
        .ProxyBypass = vbNullString
      End If
    End With
    On Error GoTo LoginError
    Login
  End If
  
  ' set error handler for all the errors
  On Error GoTo AnyError
  
Retry:
  Set Execute = m_oProtocol.Execute(oReq)
  Exit Function
  
LoginError:
  InvalidateProtocol
  RaiseEvent OnShowError("Cannot login to SIN Server." & vbCrLf & Err.Description)
  Set Execute = Nothing
  Exit Function
  
AnyError:
  Select Case Err.Number
    Case errSessionExpired:
      On Error GoTo ReloginError
      Login
      Dim continue As Boolean
      continue = True
      RaiseEvent OnSessionExpired(continue)
      If Not continue Then
        Set Execute = Nothing
        Exit Function
      End If
      Resume Retry
      
    Case errServerError:
      RaiseEvent OnShowError(Err.Description)
      
    Case errXMLParseError:
      RaiseEvent OnShowError(Err.Description)
      
    Case Else
      RaiseEvent OnShowError(Err.Description)
      
  End Select
  Exit Function

ReloginError:
  RaiseEvent OnShowError("You must be logged to SIN server to continue.")
  Set Execute = Nothing
  Exit Function

End Function

Friend Function GetDomainsAndPackages() As XDomains
  
  Dim oReq As New getDomainsAndPackagesRequest
  Dim oResp As getDomainsAndPackagesResponse
  
  Set oResp = Execute(oReq)
  If oResp Is Nothing Then
    Set GetDomainsAndPackages = Nothing
  Else
    Set GetDomainsAndPackages = oResp.domain
  End If
End Function

Friend Function GetPreviewUrl(ByVal SelDomain As XSelectedDomain) As String
  
  Dim oReq As New previewPackageRequest
  Dim oResp As previewPackageResponse
  
  Set oReq.SelectedDomain = SelDomain
  Set oResp = Execute(oReq)
  If oResp Is Nothing Then
     GetPreviewUrl = ""
  Else
    If InStr(oResp.packageHyperLink, "?") = 0 Then
      GetPreviewUrl = oResp.packageHyperLink & "?" & m_oProtocol.ExtractWebLogicSession()
    Else
      GetPreviewUrl = oResp.packageHyperLink & "&" & m_oProtocol.ExtractWebLogicSession()
    End If
  End If
End Function

Friend Function CustomizePackage(ByVal SelDomain As Integer) As String

  Dim oReq As New customizePackageRequest
  Dim oResp As customizePackageResponse
  
  oReq.SelectedDomain = SelDomain
  Set oResp = Execute(oReq)
  If oResp Is Nothing Then
    CustomizePackage = ""
  Else
    CustomizePackage = oResp.URL
  End If
End Function

Friend Function GetLinks(ByVal SelDomain As XSelectedDomain, ByVal contactInfos As XContactInfos) As XContacts
  Dim oReq As New getLinksRequest
  Dim oResp As getLinksResponse

  Set oReq.contactInfo = contactInfos
  Set oReq.SelectedDomain = SelDomain
  
  Set oResp = Execute(oReq)
  If oResp Is Nothing Then
    Set GetLinks = Nothing
  Else
    Set GetLinks = oResp.contact
  End If
End Function

Friend Function NotifyPackageSent(ByVal oSelDomain As XSelectedDomain, sSubject As String, sBody As String, cRecipients As Collection) As Boolean
  Dim oReq As New packageNotificationRequest
  Dim sRecipient As Variant
  Dim oResp As packageNotificationResponse
  
  Set oReq.SelectedDomain = oSelDomain
  For Each sRecipient In cRecipients
    oReq.recipients.contactEmail.Add (sRecipient)
  Next
  oReq.subject = sSubject
  oReq.textBody = sBody
  oReq.sentDateTime = FormatXSDDateTime(Now)
  
  Set oResp = Execute(oReq)
  NotifyPackageSent = Not (oResp Is Nothing)
  
  Set oReq = Nothing
  
End Function

Friend Function TerminateSession() As Boolean
  Dim oReq As New sessionTerminationRequest
  Dim oResp As sessionTerminationResponse
  TerminateSession = True
    
  If Not (m_oProtocol Is Nothing) Then
    Set oResp = Execute(oReq)
    InvalidateProtocol
    TerminateSession = Not oResp Is Nothing
  End If
End Function
