VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "SINProtocol"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Private m_bSecure As Boolean
Private m_lPort As Long
Private m_oMarshaler As Marshaller
Private m_oResponseRegistry As ResponseRegistry
Private m_sHost As String
Private m_sPage As String
Private m_cCookies As Collection
Private m_sProxyServer As String
Private m_sProxyBypass As String
Private m_ErrorDetails As String
Option Explicit

'*-------------
'*  Use SSL (e.g. HTTPS) to communicate with the SIN server.
'*-------------
Public Property Let Secure(ByVal bSecure As Boolean)
Attribute Secure.VB_Description = "Use SSL (e.g. HTTPS) to communicate with the XML-RPC server."
  m_bSecure = bSecure
End Property
'*-------------
'*  Host part or URL to SIN server.
'*-------------
Public Property Let Host(ByVal sHost As String)
Attribute Host.VB_Description = "The port used to communicate with the XML-RPC server."
  m_sHost = sHost
End Property
'*-------------
'*  Page(Path inside server) part or URL to SIN server.
'*-------------
Public Property Let Page(ByVal sPage As String)
  m_sPage = sPage
End Property
'*-------------
'*  The port used to communicate with the SIN server.
'*-------------
Public Property Let Port(ByVal lPort As Long)
  m_lPort = lPort
End Property

Public Property Let ProxyServer(ByVal sProxyServer As String)
  m_sProxyServer = sProxyServer
End Property

Public Property Let ProxyBypass(ByVal sProxyBypass As String)
  m_sProxyBypass = sProxyBypass
End Property

Public Property Get ErrorDetails()
  ErrorDetails = m_ErrorDetails
End Property

'*-------------
'*  This method will execute the specified method using an SIN Protocol(lightweight XML-RPC) call.
'*  It will format the request object using TypLib info into a XML request and the result
'*  of the call is parsed back to Object.
'*-------------
Public Function Execute(ByRef oReq As Object) As Object
Attribute Execute.VB_Description = "Execute the specified method using an XML-RPC call and pass the specified parameters."
  Dim sXML As String
  Dim DOMDocument As DOMDocument

  If TypeOf oReq Is customizePackageRequest Then
   Set Execute = CustomizePackage(oReq)
   Exit Function
  End If
  
  If TypeOf oReq Is sessionTerminationRequest Then
   TerminateServletSession
  End If
  
  If TypeOf oReq Is logInRequest Then
    Set m_cCookies = Nothing
  End If
  
  ' Marshal request to XML string
  sXML = m_oMarshaler.SaveAsXML(oReq)
  
  ' Call the specified XML-RPC on the specified URL
  Set DOMDocument = Post(sXML)
  
  ' Search through mesaage registry for response appropriate to reqest and check root node
  Set Execute = m_oResponseRegistry.Find(TypeName(oReq), DOMDocument.documentElement.nodeName)
  
  ' Unmarshal message content
  Call m_oMarshaler.LoadFromDom(Execute, DOMDocument)
  
End Function

Public Function ExtractWebLogicSession() As String
  Dim SessionCookie As String
  Dim I As Integer
  
  SessionCookie = vbNullString
  For I = 1 To m_cCookies.Count
    If InStr(m_cCookies.Item(I), "WebLogicSession") = 1 Then
      SessionCookie = m_cCookies.Item(I)
      Exit For
    End If
  Next I
  
  If SessionCookie = vbNullString Then
    Err.Raise errProtocolError, , "No weblogic session cookie"
  End If
  
  I = InStr(SessionCookie, ";")
  If I > 0 Then
    SessionCookie = Left(SessionCookie, I - 1)
  End If
  
  ExtractWebLogicSession = SessionCookie
End Function

Function CustomizePackage(Req As customizePackageRequest) As Object
  Dim HttpRequest As New HttpRequest
  
  Set HttpRequest.RequestCookies = m_cCookies
  Call HttpRequest.Request(False, m_sHost, m_lPort, m_bSecure, "outlook/outlook.jsp?domainId=" & Req.SelectedDomain, m_sProxyServer, m_sProxyBypass)
  Set CustomizePackage = New customizePackageResponse
  CustomizePackage.URL = "http://" & m_sHost & ":" & m_lPort & "/outlook/outlook.jsp?" & _
    ExtractWebLogicSession() & "&command=jump&page=content"
End Function

Sub TerminateServletSession()
  Dim HttpRequest As New HttpRequest
  Set HttpRequest.RequestCookies = m_cCookies
  Call HttpRequest.Request(False, m_sHost, m_lPort, m_bSecure, "outlook/outlook.jsp?command=cancel", m_sProxyServer, m_sProxyBypass)
End Sub

'*-------------
'*  Posts a SIN XML-RPC request to the previously specified URL and
'*  retrieves, parses XML and returns the reponse of the call.
'*
'*  Raises errXMLParseError if XML validation failed (malformed response from server)
'*-------------
Private Function Post(ByVal sXML As String) As DOMDocument

  Dim HttpRequest As New HttpRequest
  Dim DOMDocument As New DOMDocument40
  Dim sResponse As String
  
  m_ErrorDetails = ""

  ' Open a connection to the specified URL and send the XML
  HttpRequest.Content = sXML
  Set HttpRequest.RequestCookies = m_cCookies
  Call HttpRequest.Request(True, m_sHost, m_lPort, m_bSecure, m_sPage, m_sProxyServer, m_sProxyBypass)
  If Not (HttpRequest.ResponseCookies Is Nothing) Then
    Set m_cCookies = HttpRequest.ResponseCookies
  End If
  
  ' Parse the XML response of the XML-RPC call
  sResponse = HttpRequest.Response
  DOMDocument.loadXML sResponse

  If DOMDocument.ParseError.errorCode <> 0 Then
    ' Parsing failed, raise an error to the caller
    Err.Raise errXMLParseError, , "Unable to parse the XML response " _
    & ParseErrorString(DOMDocument.ParseError)
  End If
  
  ParseFault DOMDocument
  
  Set Post = DOMDocument
  
End Function

Private Function FindNodeByName(ByVal nodes As IXMLDOMNodeList, ByVal name As String) As IXMLDOMNode
  Dim I As Integer
  Dim curNode As IXMLDOMNode
  Set FindNodeByName = Nothing
  For Each curNode In nodes
    If curNode.nodeName = name Then
      Set FindNodeByName = curNode
    ElseIf curNode.childNodes.Length > 0 Then
      Set FindNodeByName = FindNodeByName(curNode.childNodes, name)
    End If
    If Not FindNodeByName Is Nothing Then Exit For
  Next
End Function


'*-------------
'* Checks the result of the SIN-RPC call for a presense of <errorDetails> element.
'*
'* Raises errServerError if a <errorDetails> element is found
'*-------------
Private Sub ParseFault(ByVal DOMDocument As DOMDocument40)
  Dim Fault As IXMLDOMNode
  ' Check for a <errorDetails> element
  'Set Fault = DOMDocument.selectSingleNode(".//errorDetails")
  Set Fault = FindNodeByName(DOMDocument.childNodes, "errorDetails")

  If Not (Fault Is Nothing) Then
    m_ErrorDetails = Fault.Text
    ' Raise an error using the errorDetails
    Err.Raise errServerError, TypeName(Me) & ".ParseFault", Fault.Text
  End If
End Sub

Private Sub Class_Initialize()
  m_lPort = 80
  m_bSecure = False
  Set m_cCookies = New Collection
  Set m_oMarshaler = New Marshaller
  Set m_oResponseRegistry = New ResponseRegistry
  '
  ' Register all known request/response pairs
  '
  Call m_oResponseRegistry.Add(New logInRequest, _
                               New logInResponse)
  Call m_oResponseRegistry.Add(New customizePackageRequest, _
                               New customizePackageResponse)
  Call m_oResponseRegistry.Add(New getDomainsAndPackagesRequest, _
                               New getDomainsAndPackagesResponse)
  Call m_oResponseRegistry.Add(New previewPackageRequest, _
                               New previewPackageResponse)
  Call m_oResponseRegistry.Add(New getLinksRequest, _
                               New getLinksResponse)
  Call m_oResponseRegistry.Add(New customizePackageRequest, _
                               New customizePackageResponse)
  Call m_oResponseRegistry.Add(New packageNotificationRequest, _
                               New packageNotificationResponse)
  Call m_oResponseRegistry.Add(New sessionTerminationRequest, _
                               New sessionTerminationResponse)
End Sub

Private Sub Class_Terminate()
  Set m_oMarshaler = Nothing
  Set m_oResponseRegistry = Nothing
End Sub
