VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "MailItemView"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private mvarControl As MailItemControl
Private FStreamItNowCommandBar As Office.CommandBar
Private WithEvents FCBDomain As Office.CommandBarComboBox
Attribute FCBDomain.VB_VarHelpID = -1
Private WithEvents FCBPackage As Office.CommandBarComboBox
Attribute FCBPackage.VB_VarHelpID = -1
Private WithEvents FBtnCustomizePackage As Office.CommandBarButton
Attribute FBtnCustomizePackage.VB_VarHelpID = -1
Private WithEvents FBtnPreviewPackage As Office.CommandBarButton
Attribute FBtnPreviewPackage.VB_VarHelpID = -1
Private NeedToInit As Boolean

Friend Sub Init()
  If NeedToInit Then
    NeedToInit = False
    
    Set FStreamItNowCommandBar = Me.Control.Inspector.CommandBars.Add("Stream It Now", msoBarTop, False, True)
    FStreamItNowCommandBar.Visible = True
    Load frmPictures
    Set FCBDomain = FStreamItNowCommandBar.Controls.Add(msoControlDropdown)
    With FCBDomain
      .Visible = True
      .AddItem ("--- Select A Domain ---")
      .Width = 150
      .ListIndex = 1
      .Enabled = False
    End With
    Set FCBPackage = FStreamItNowCommandBar.Controls.Add(msoControlDropdown)
    With FCBPackage
      .Visible = True
      .AddItem ("--- Select A Package ---")
      .Width = 150
      .ListIndex = 1
      .Enabled = False
    End With
    
    Set FBtnCustomizePackage = FStreamItNowCommandBar.Controls.Add(msoControlButton)
    With FBtnCustomizePackage
      .Caption = "Customize Package"
      .Visible = True
      .Style = msoButtonIconAndCaption
    
      CopyBitmapAsButtonFace frmPictures.imgVideoSpheres.Picture, &HFFFFFF

      .PasteFace
      .Enabled = False
    End With
    
    Set FBtnPreviewPackage = FStreamItNowCommandBar.Controls.Add(msoControlButton)
    With FBtnPreviewPackage
      .Caption = "Preview Package"
      .Visible = True
      .Style = msoButtonIconAndCaption
    
      CopyBitmapAsButtonFace frmPictures.imgVideoSpheres.Picture, &HFFFFFF

      .PasteFace
      .Enabled = False
    End With
    
    Clipboard.Clear
    InitPackage
    
  End If
End Sub

Friend Sub Release()
End Sub

Friend Property Set Control(ByVal vData As MailItemControl)
  Set mvarControl = vData
End Property

Friend Property Get Control() As MailItemControl
  Set Control = mvarControl
End Property

Private Sub Class_Initialize()
  NeedToInit = True
End Sub

Private Sub Class_Terminate()
  Set mvarControl = Nothing
  Set FStreamItNowCommandBar = Nothing
  Set FCBDomain = Nothing
  Set FCBPackage = Nothing
  Set FBtnCustomizePackage = Nothing
  Set FBtnPreviewPackage = Nothing
End Sub

Private Sub FBtnCustomizePackage_Click(ByVal Ctrl As Office.CommandBarButton, CancelDefault As Boolean)
  Me.Control.CustomizePackage
  SetPackages True
  SetButtons
End Sub

Private Sub FBtnPreviewPackage_Click(ByVal Ctrl As Office.CommandBarButton, CancelDefault As Boolean)
  Me.Control.PreviewPackage
End Sub

Private Sub SetDomains()
  Dim ii As Integer
  If Control.Model.Domains Is Nothing Then
    With FCBDomain
      .Clear
      .AddItem ("--- Not Logged In ---")
      .ListIndex = 1
      .Enabled = False
    End With
  ElseIf Control.Model.Domains.Count = 1 Then
    With FCBDomain
      .Clear
      .AddItem (Control.Model.Domains.Item(1).domainName)
      .Enabled = True
      .ListIndex = 1
      Control.Model.domain = 1
      .Enabled = False
    End With
  ElseIf Control.Model.Domains.Count > 0 Then
    With FCBDomain
      .Clear
      .AddItem ("--- Select A Domain ---")
      For ii = 1 To Control.Model.Domains.Count
        .AddItem (Control.Model.Domains.Item(ii).domainName)
      Next
      .Enabled = True
      .ListIndex = 1
    End With
  Else
    With FCBDomain
      .Clear
      .AddItem ("--- No Domains Available ---")
      .Enabled = True
      .ListIndex = 1
    End With
  End If
End Sub

Private Sub SetPackages(CustomPackage As Boolean)
  Dim ii As Integer
  If Control.Model.Domains Is Nothing Then
    With FCBPackage
      .Clear
      .AddItem ("--- Not Logged In ---")
      .ListIndex = 1
      .Enabled = True
    End With
  ElseIf Control.Model.Domains.Count = 0 Then
    With FCBPackage
      .Clear
      .AddItem ("--- No domains available ---")
      .ListIndex = 1
      .Enabled = True
    End With
  ElseIf Control.Model.Domains.Count > 1 Then
    With FCBPackage
      .Clear
      .Enabled = True
      .AddItem ("--- Select A Package ---")
      .ListIndex = 1
      If FCBDomain.ListIndex > 1 Then
        .Enabled = True
        For ii = 1 To Control.Model.Domains.Item(FCBDomain.ListIndex - 1).package.Count
          .AddItem (Control.Model.Domains.Item(FCBDomain.ListIndex - 1).package.Item(ii).packageName)
        Next
        If CustomPackage Then
          .ListIndex = 2
          Control.Model.package = 1
        End If
      Else
        .Enabled = False
      End If
    End With
  Else
    With FCBPackage
      .Clear
      .AddItem ("--- Select A Package ---")
      .Enabled = True
      .ListIndex = 1
      For ii = 1 To Control.Model.Domains.Item(1).package.Count
        .AddItem (Control.Model.Domains.Item(1).package.Item(ii).packageName)
      Next
      If CustomPackage Then
        .ListIndex = 2
        Control.Model.package = 1
      End If
    End With
  End If
End Sub

Private Sub SetButtons()
  If Control.Model.Domains.Count > 1 Then
    If FCBDomain.ListIndex > 1 Then
      FBtnCustomizePackage.Enabled = True
    Else
      FBtnCustomizePackage.Enabled = False
    End If
  Else
    FBtnCustomizePackage.Enabled = True
  End If
  
  If FCBPackage.Enabled Then
    If FCBPackage.ListIndex > 1 Then
      FBtnPreviewPackage.Enabled = True
    Else
      FBtnPreviewPackage.Enabled = False
    End If
  Else
    FBtnPreviewPackage.Enabled = False
  End If
End Sub

Private Sub InitPackage()
  Control.Model.Mode = 1
  If Control.RefreshDomains Then
    SetDomains
    SetPackages False
    SetButtons
    InitHeaders
    InitBody
  Else
    Control.CloseView
  End If
End Sub

Private Sub ShowBCCField()
  Dim cbc As CommandBarControl
  
  On Error GoTo ErrorHandler
  
  Control.Inspector.Display
  DoEvents
  For Each cbc In Control.Inspector.CommandBars.FindControl(, 30004, , True).Controls
    If cbc.Id = 1860 Then
      cbc.Execute
      DoEvents
      If cbc.State = msoButtonDown Then
        cbc.Execute
        DoEvents
      End If
      Exit For
    End If
  Next
  
  Exit Sub
ErrorHandler:
  ' ignore errors
End Sub

Private Sub InitHeaders()
  If Not Control.Item.UserProperties("SIN-DRAFT") Is Nothing Then Exit Sub
  'If Trim(Control.AddIn.Config.NotifyAddress) <> "" Then
  '  Control.SafeItem.recipients.Add(Control.AddIn.Config.NotifyAddress).Type = olBCC
  '  Control.SafeItem.recipients.ResolveAll
  '  ShowBCCField
  'End If
  Control.SafeItem.subject = "Invitation package"
End Sub

Private Sub InitBody()
  If Not Control.Item.UserProperties("SIN-DRAFT") Is Nothing Then Exit Sub
  Control.Item.Display
  Control.Item.HTMLBody = _
    "<HTML><HEAD></HEAD>" & _
    "<BODY><span>" & _
    "<span Id='Salutation' ContentEditable='false' style='color:silver'>Salutation/Name</span>" & _
    "<br><br>" & _
    "Type here..." & _
    "<br><br>" & _
    "<span Id='ClickHere' ContentEditable='false' style='color:silver'>Please Click Here</span>" & _
    "<br><br>" & _
    "</span></BODY></HTML>"
End Sub

Private Sub FCBDomain_Change(ByVal Ctrl As Office.CommandBarComboBox)
  If Me.Control.Model.Mode = 1 Then
    Dim newDomain As Integer
    If Not Control.Model.Domains Is Nothing Then
      Select Case Control.Model.Domains.Count
        Case 0: newDomain = 0
        Case 1: newDomain = 1
        Case Else
          newDomain = FCBDomain.ListIndex - 1
      End Select
    Else
      newDomain = 0
    End If
    If Me.Control.Model.domain <> newDomain Then
      If Not Control.Model.Domains Is Nothing Then
        Dim I As Integer
        For I = 1 To Control.Model.Domains.Count
          Control.Model.Domains(I).package.RemoveCustom
        Next
      End If
      Me.Control.Model.domain = newDomain
      Me.Control.Model.package = 0
      SetPackages False
      SetButtons
    End If
  End If
End Sub

Private Sub FCBPackage_Change(ByVal Ctrl As Office.CommandBarComboBox)
  If Me.Control.Model.Mode = 1 Then
    Me.Control.Model.package = FCBPackage.ListIndex - 1
    SetButtons
  End If
End Sub

Public Sub ResetCustomPackage()
  SetPackages False
  SetButtons
End Sub

Public Sub SetPackageTo(ByVal sPackageName As String)
  Dim I As Integer
  Dim Found As Boolean
  Found = False
  For I = 1 To FCBPackage.ListCount
    If FCBPackage.List(I) = sPackageName Then
      Found = True
      FCBPackage.ListIndex = I
      Exit For
    End If
  Next
  If Not Found Then
    If FCBPackage.ListCount > 0 Then
      FCBPackage.ListIndex = 1
    End If
  End If
  SetButtons
End Sub

Public Sub Update()
  SetDomains
  If Control.Model.domain > 0 Then
    FCBDomain.ListIndex = Control.Model.domain + 1
    SetButtons
    SetPackages False
    DoEvents
    If Control.Model.package > 0 Then
      FCBPackage.ListIndex = Control.Model.package + 1
      SetButtons
      DoEvents
    End If
  End If
End Sub
