VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "MailItemControl"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private mvarAddIn As AddInControl
Private WithEvents mvarInspector As Outlook.Inspector
Attribute mvarInspector.VB_VarHelpID = -1
Private WithEvents mvarItem As Outlook.MailItem
Attribute mvarItem.VB_VarHelpID = -1
Private mvarSafeItem As Redemption.SafeMailItem
Private mvarView As MailItemView
Private mvarModel As MailItemModel
Private WithEvents m_oSession As SINSession
Attribute m_oSession.VB_VarHelpID = -1
Private mCustomizedUrl As String
Private mCustomizedDomainId As Integer
Private Const sCustomPackage As String = "Custom Package"
Const PR_ICON_INDEX = &H10800003
Private Declare Sub Sleep Lib "kernel32" (ByVal delay As Long)

Public Property Set Model(ByVal vData As MailItemModel)
  Set mvarModel = vData
End Property

Public Property Get Model() As MailItemModel
  Set Model = mvarModel
End Property

Public Sub Release()
  Set mvarSafeItem = Nothing
  Set mvarAddIn = Nothing
  Set mvarInspector = Nothing
  Set mvarItem = Nothing
  Set mvarModel = Nothing
  Set mvarView = Nothing
  Set m_oSession = Nothing
End Sub

Public Property Set Item(ByRef vData As Outlook.MailItem)
  Set mvarSafeItem = CreateObject("Redemption.SafeMailItem")
  mvarSafeItem.Item = vData
  Set mvarItem = vData
End Property

Public Property Get Item() As Outlook.MailItem
  Set Item = mvarItem
End Property

Public Property Get SafeItem() As Redemption.SafeMailItem
  Set SafeItem = mvarSafeItem
End Property

Public Property Set Inspector(ByVal vData As Outlook.Inspector)
  Set mvarInspector = vData
End Property

Public Property Get Inspector() As Outlook.Inspector
  Set Inspector = mvarInspector
End Property

Public Property Set AddIn(ByVal vData As AddInControl)
  Set mvarAddIn = vData
  Set m_oSession.Configuration = vData.Config
End Property

Public Property Get AddIn() As AddInControl
  Set AddIn = mvarAddIn
End Property

Private Sub Class_Initialize()
  Set mvarView = New MailItemView
  Set mvarView.Control = Me
  Set mvarModel = New MailItemModel
  Set m_oSession = New SINSession
End Sub

Private Sub Class_Terminate()
  Set m_oSession = Nothing
  Release
End Sub

Private Sub m_oSession_OnLoginRejected(sUserId As String, sUserPswd As String, Retry As Boolean)
 Dim sDlgUserName As String
 Dim sDlgUserPswd As String
 
 sDlgUserName = sUserId
 sDlgUserPswd = sUserPswd
 
 Retry = AddIn.LoginDialog(sDlgUserName, sDlgUserPswd)
 If Retry Then
   sUserId = sDlgUserName
   sUserPswd = sDlgUserPswd
 End If
End Sub

Private Sub m_oSession_OnSessionExpired(ByRef continue As Boolean)
  Dim I As Integer
  continue = (Trim(mCustomizedUrl) = "")
  If Not continue Then
    mCustomizedUrl = ""
    For I = 1 To mvarModel.Domains.Count
      mvarModel.Domains(I).package.RemoveCustom
    Next
    mvarView.ResetCustomPackage
    AddIn.MsgBox "The session is expired or terminated. Please recreate custom package."
  End If
End Sub

Private Sub m_oSession_OnShowError(ByVal sMessage As String)
  AddIn.MsgBox sMessage
End Sub

Private Sub mvarInspector_Activate()
On Error GoTo ErrorHandler
  'do nothing
  Exit Sub
ErrorHandler:
  MsgBox "Error in MailItemInspector.Activate: " & Err.Description
End Sub

Private Sub mvarInspector_Close()
  Dim delIndex As Integer
  On Error GoTo ErrorHandler
  
  delIndex = AddIn.MailItems.IndexOf(Me)
  If delIndex > 0 Then
    AddIn.MailItems.Remove (delIndex)
  End If
  
  Exit Sub
ErrorHandler:
  MsgBox "Error in MailItemInspector.Close: " & Err.Description
End Sub

Private Sub mvarItem_Close(Cancel As Boolean)
  On Error GoTo ErrorHandler

  m_oSession.TerminateSession

  Exit Sub
ErrorHandler:
  MsgBox "Error in MailItem.Close: " & Err.Description
End Sub

Private Sub mvarItem_Open(Cancel As Boolean)
  On Error GoTo ErrorHandler
  
  mvarView.Init
  
  On Error GoTo SkipSINProp
  If Not mvarItem.UserProperties("SIN-DOMAIN") Is Nothing Then
    mvarModel.domain = mvarItem.UserProperties("SIN-DOMAIN")
    If Not mvarItem.UserProperties("SIN-PACKAGE") Is Nothing Then
      mvarModel.package = mvarItem.UserProperties("SIN-PACKAGE")
    End If
    mvarView.Update
  End If
SkipSINProp:
  On Error GoTo ErrorHandler
  
  Dim prop As UserProperty
  Set prop = mvarItem.UserProperties.Add("SINADDIN", olYesNo)
  prop.Value = True

  Exit Sub
ErrorHandler:
  MsgBox "Error in MailItem.Open: " & Err.Description
End Sub

Private Sub FillName(ByRef cont As ContactItem, EMail As String)
  Dim solutation As String
  frmNameSalutation.FirstNameEdit.Text = cont.FirstName
  frmNameSalutation.LastNameEdit.Text = cont.LastName
  solutation = GetSalutation(cont)
  If solutation = "" Then
    frmNameSalutation.SalutationEdit.Text = "Dear " & cont.FirstName & " " & cont.LastName & ", "
  Else
    frmNameSalutation.SalutationEdit.Text = solutation
  End If
  frmNameSalutation.InfoLabel.Caption = "Please enter additional information for " & EMail
  frmNameSalutation.Show vbModal
  cont.FirstName = frmNameSalutation.FirstNameEdit.Text
  cont.LastName = frmNameSalutation.LastNameEdit.Text
  If Len(Trim(frmNameSalutation.SalutationEdit.Text)) > 0 Then
    cont.UserProperties.Add(sSalutation, olText).Value = frmNameSalutation.SalutationEdit.Text
  End If
End Sub

Private Function UpdateRecipients() As Boolean
  Dim wRecipient As MailItemRecipientModel
  Dim oRecipient As SafeRecipient
  Dim contact As ContactItem
  
  UpdateRecipients = False
  mvarItem.Save
  mvarSafeItem.recipients.ResolveAll
  DoEvents
  For Each oRecipient In mvarSafeItem.recipients
    If oRecipient.address = "" Then
      Exit Function
    End If
    If (oRecipient.Type = olTo) Or (oRecipient.Type = olCC) Then
      Set contact = FindContact(oRecipient.address)
      If contact Is Nothing Then
        Set contact = Application.CreateItem(olContactItem)
        contact.Email1Address = oRecipient.address
        FillName contact, oRecipient.address
      ElseIf GetSalutation(contact) = "" Then
        FillName contact, oRecipient.address
      End If
      If contact.FullName = "" Then
        Set contact = Nothing
      Else
        contact.Save
      End If
    Else
      oRecipient.Delete
    End If
  Next
  mvarSafeItem.recipients.ResolveAll
  DoEvents
  
  While Model.MailItemRecipients.Count > 0
    Model.MailItemRecipients.Remove (1)
  Wend
    
  For Each oRecipient In mvarSafeItem.recipients
    If (oRecipient.Type = olTo) Or (oRecipient.Type = olCC) Then
      Set contact = FindContact(oRecipient.address)
      If Not (contact Is Nothing) Then
        Set wRecipient = Me.Model.MailItemRecipients.Add(oRecipient.name, oRecipient.address)
        Set wRecipient.contact = contact
      End If
    End If
  Next
  Set oRecipient = Nothing
  UpdateRecipients = True
End Function

Private Function GetSalutation(ByRef oContact As ContactItem) As String
  Dim oUserProperty As UserProperty
  Dim oSalutationProperty As UserProperty
    
  For Each oUserProperty In oContact.UserProperties
    If oUserProperty.name = sSalutation Then
      Set oSalutationProperty = oUserProperty
      Exit For
    End If
  Next
  
  If oSalutationProperty Is Nothing Then
    GetSalutation = ""
  Else
    GetSalutation = oSalutationProperty.Value
  End If
  Set oSalutationProperty = Nothing
  Set oUserProperty = Nothing
End Function

Function PleaseClickHere(HRef As String) As String
  Dim I, j As Integer
  If HRef = "" Then
    PleaseClickHere = ""
  Else
    PleaseClickHere = "<a href='" & HRef & "'>Please Click Here</a>"
  End If
End Function

Private Sub mvarItem_Send(Cancel As Boolean)
  Dim cContacts As XContacts
  Dim RcptItem As Outlook.MailItem
  Dim SafeRcpt As Redemption.SafeMailItem
  Dim sOriginalBody As String
  Dim sOriginalSubj As String
  Dim sSalutations As New Collection
  Dim PostItem As Outlook.PostItem
  Dim SafeMail, SafePost As Redemption.SafeMailItem
  Dim sNewEntryId As String
  Dim Utils As Redemption.MAPIUtils
  Dim I As Integer
  
  On Error GoTo ErrorHandler
  
  If Me.Model.Mode <> 1 Then
    Exit Sub
  End If
  
  If Not UpdateRecipients Then
    AddIn.MsgBox "Mailing List is not allowed as e-mail address"
    Cancel = True
    Exit Sub
  End If
  
  If Me.Model.Mode = 1 Then
    If Me.Model.domain = 0 Then
      AddIn.MsgBox "Please select domain before send"
      Cancel = True
      Exit Sub
    End If
    
    If Me.Model.package = 0 Then
      AddIn.MsgBox "Please select package before send"
      Cancel = True
      Exit Sub
    End If
      
    If Me.Model.MailItemRecipients.Count = 0 Then
      AddIn.MsgBox "Please specify any recipients in TO: field"
      Cancel = True
      Exit Sub
    End If
    
    Set cContacts = GetContactLinks
    
    If cContacts Is Nothing Then
      mvarItem.Close olSave
      Cancel = True
      Exit Sub
    End If
    
    If cContacts.Count = 0 Then
      AddIn.MsgBox "Server returns no personalized links"
      Cancel = True
      Exit Sub
    End If
    
    If cContacts.Count <> Model.MailItemRecipients.Count Then
      AddIn.MsgBox "Server returns " & cContacts.Count & " personalized links, but " & Model.MailItemRecipients.Count & " are expected"
      Cancel = True
      Exit Sub
    End If
    
    'sOriginalBody = mvarItem.HTMLBody
    sOriginalBody = mvarItem.GetInspector.HTMLEditor.Body.innerHTML
    sOriginalSubj = mvarItem.subject
    
    For I = 1 To cContacts.Count
      sSalutations.Add (GetSalutation(Model.MailItemRecipients.Item(I).contact))
    Next
    
    If Not m_oSession.TerminateSession Then
      mvarItem.Close olSave
      Cancel = True
      Exit Sub
    End If
    
    Dim element As Object
    Set element = mvarItem.GetInspector.HTMLEditor.getElementById("ClickHere")
    If element Is Nothing Then
      mvarItem.GetInspector.HTMLEditor.Body.innerHTML = mvarItem.GetInspector.HTMLEditor.Body.innerHTML & "<br><span id='ClickHere'></span>"
      sOriginalBody = sOriginalBody & "<br><span Id='ClickHere' ContentEditable='false' style='color:silver'>Please Click Here</span>"
    Else
      element.removeAttribute "style"
    End If
    
    For I = 1 To cContacts.Count
      Set RcptItem = Session.GetDefaultFolder(olFolderOutbox).Items.Add(olMailItem)
      Set SafeRcpt = CreateObject("Redemption.SafeMailItem")
      SafeRcpt.Item = RcptItem
      RcptItem.DeleteAfterSubmit = True
      
      Set element = mvarItem.GetInspector.HTMLEditor.getElementById("Salutation")
      If Not (element Is Nothing) Then
        element.removeAttribute "style"
        element.innerHTML = CStr(sSalutations.Item(I))
      End If
      Set element = mvarItem.GetInspector.HTMLEditor.getElementById("ClickHere")
      element.innerHTML = PleaseClickHere(cContacts(I).personalizedLink)
      RcptItem.HTMLBody = mvarItem.GetInspector.HTMLEditor.documentElement.outerHTML ' Body.innerHTML
      
      SafeRcpt.recipients.Add (Model.MailItemRecipients.Item(I).address)
      SafeRcpt.recipients.ResolveAll
      RcptItem.subject = mvarItem.subject
      RcptItem.UserProperties.Add("sin-rcpt", olYesNo) = True
      On Error Resume Next
      SafeRcpt.send
      Set SafeRcpt = Nothing
      Set RcptItem = Nothing
    Next I
    
    ' send BCC
    'mvarInspector.HTMLEditor.Body.innerHTML = sOriginalBody
    'Set element = mvarInspector.HTMLEditor.getElementById("Salutation")
    'If Not element Is Nothing Then element.removeNode True
    'For I = 1 To mvarSafeItem.recipients.Count
    '  If mvarSafeItem.recipients(I).Type = olBCC Then
    '    Set RcptItem = Session.GetDefaultFolder(olFolderOutbox).Items.Add(olMailItem)
    '    Set SafeRcpt = CreateObject("Redemption.SafeMailItem")
    '    SafeRcpt.Item = RcptItem
    '    RcptItem.DeleteAfterSubmit = True
    '    RcptItem.HTMLBody = mvarInspector.HTMLEditor.Body.innerHTML
    '    SafeRcpt.recipients.Add mvarSafeItem.recipients(I).address
    '    RcptItem.subject = mvarItem.subject
    '    On Error Resume Next
    '    SafeRcpt.send
    '    Set SafeRcpt = Nothing
    '    Set RcptItem = Nothing
    '  End If
    'Next
    
    On Error GoTo ErrorHandler
    
    I = 1
    While I <= mvarSafeItem.recipients.Count
      If (mvarSafeItem.recipients.Item(I).Type = olTo) Or (mvarSafeItem.recipients.Item(I).Type = olCC) Then
        I = I + 1
      Else
        mvarSafeItem.recipients.Remove (I)
      End If
    Wend
    
    ' Create sent item
    mvarItem.GetInspector.HTMLEditor.Body.innerHTML = sOriginalBody
    mvarItem.UserProperties.Add("sin-master", olYesNo) = True
    mvarItem.DeferredDeliveryTime = CDate("1-1-2099 00:00:00")
    mvarItem.DeleteAfterSubmit = True
    
    Set PostItem = AddIn.App.CreateItem(olPostItem)      'create a Post item instead of a regular (unsent) message
    PostItem.Save                                        'otherwise EntryId is inaccessible
    sNewEntryId = PostItem.EntryID
    Set PostItem = Nothing                               'dereference and reopen the item, otherwise Outlook overwrites our change to the MessageClass property
    Set PostItem = AddIn.App.Session.GetItemFromID(sNewEntryId)
    PostItem.MessageClass = "IPM.Note"
    Set element = mvarItem.GetInspector.HTMLEditor.getElementById("Salutation")
    If Not element Is Nothing Then element.removeNode True
    If AppVer <= 9 Then
      PostItem.HTMLBody = mvarItem.HTMLBody
    Else
      PostItem.HTMLBody = ""
      PostItem.Body = mvarItem.Body
    End If
    PostItem.subject = mvarItem.subject
    PostItem.UserProperties.Add("sin-master", olYesNo) = True
    PostItem.Save
        
    Set SafePost = CreateObject("Redemption.SafeMailItem")
    SafePost.Item = PostItem
    SafePost.fields(PR_ICON_INDEX) = Empty         'delete the property, otherwise the message is shown with a wrong icon
    Set SafeMail = CreateObject("Redemption.SafeMailItem")
    SafeMail.Item = mvarItem
    For I = 1 To SafeMail.recipients.Count
      SafePost.recipients.Add (SafeMail.recipients.Item(I).address)
    Next
    SafePost.recipients.ResolveAll
    SafePost.Save
    PostItem.Move Session.GetDefaultFolder(olFolderSentMail)
    DoEvents
    Set PostItem = Nothing
    Set SafeMail = Nothing
    Set SafePost = Nothing
        
    ' Create sent item
    
    mvarItem.Save
    sNewEntryId = mvarItem.EntryID
    mvarItem.Delete
    Set mvarItem = Nothing
    Set RcptItem = Session.GetItemFromID(sNewEntryId)
    RcptItem.Delete
    Set RcptItem = Nothing
    Cancel = True
        
    Set Utils = CreateObject("Redemption.MAPIUtils")
    Utils.DeliverNow
    Utils.Cleanup
    Set Utils = Nothing
    
    ' find and execute send button
    Set Application.ActiveExplorer.CurrentFolder = Session.GetDefaultFolder(olFolderInbox)
    Application.ActiveExplorer.Activate
    Application.ActiveExplorer.Display
    DoEvents
    Dim sendBtn, CmdBar, tmpBtn As Object
    Set sendBtn = Nothing
    For Each CmdBar In Application.ActiveExplorer.CommandBars
      For Each tmpBtn In CmdBar.Controls
        If tmpBtn.Id = 5488 Then
          Set sendBtn = tmpBtn
          Exit For
        End If
      Next
      If Not sendBtn Is Nothing Then Exit For
    Next
    If Not sendBtn Is Nothing Then sendBtn.Execute
    DoEvents
    Set sendBtn = Nothing
    Set CmdBar = Nothing
    Set tmpBtn = Nothing
    Exit Sub
  End If
  Cancel = False

  Exit Sub
ErrorHandler:
  Cancel = True
  MsgBox "Error in MailItem.Send: " & Err.Description
  If Not mvarItem Is Nothing Then
    Call mvarItem.Close(olSave)
  End If
End Sub

Friend Function GetContactLinks() As XContacts
  Dim contactInfos As New XContactInfos
  Dim oAddress As XAddressDetails
  Dim oEMail As XEmailDetails
  Dim oPhone As XPhoneDetails
  Dim contacts As XContacts
  Dim I As Integer
  Dim Recipient As MailItemRecipientModel
  Dim oSafeContact As New Redemption.SafeContactItem
  
  ' for every invitee setup contact info
  For I = 1 To Model.MailItemRecipients.Count
    Set Recipient = Model.MailItemRecipients.Item(I)
    ' set address
    Set oAddress = New XAddressDetails
    If Recipient.contact.BusinessAddress <> "" Then
      With Recipient.contact
        oAddress.addressCategory = Business_Address
        oAddress.city = .BusinessAddressCity
        oAddress.country = .BusinessAddressCountry
        oAddress.postalCode = .BusinessAddressPostalCode
        oAddress.stateOrProvince = .BusinessAddressState
        oAddress.street = .BusinessAddressStreet
      End With
    Else
      With Recipient.contact
        oAddress.addressCategory = Home_Address
        oAddress.city = .HomeAddressCity
        oAddress.country = .HomeAddressCountry
        oAddress.postalCode = .HomeAddressPostalCode
        oAddress.stateOrProvince = .HomeAddressState
        oAddress.street = .HomeAddressStreet
      End With
    End If
    
    ' EMail
    Set oEMail = New XEmailDetails
    oSafeContact.Item = Recipient.contact
   
    If oSafeContact.Email1Address <> "" Then
      oEMail.contactEmail = oSafeContact.Email1Address
      oEMail.emailCategory = Business_Email
    ElseIf oSafeContact.Email2Address <> "" Then
      oEMail.contactEmail = oSafeContact.Email2Address
      oEMail.emailCategory = Business_Email
    ElseIf oSafeContact.Email3Address <> "" Then
      oEMail.contactEmail = oSafeContact.Email3Address
      oEMail.emailCategory = Business_Email
    End If
    
    'Phone
    Set oPhone = New XPhoneDetails
    If oSafeContact.BusinessTelephoneNumber <> "" Then
      oPhone.phoneCategory = Business_Phone
      oPhone.phoneNumber = oSafeContact.BusinessTelephoneNumber
    ElseIf oSafeContact.BusinessTelephoneNumber <> "" Then
      oPhone.phoneCategory = Business_Phone
      oPhone.phoneNumber = oSafeContact.BusinessTelephoneNumber
    ElseIf oSafeContact.HomeTelephoneNumber <> "" Then
      oPhone.phoneCategory = Home_Phone
      oPhone.phoneNumber = oSafeContact.HomeTelephoneNumber
    ElseIf oSafeContact.Home2TelephoneNumber <> "" Then
      oPhone.phoneCategory = Home_Phone
      oPhone.phoneNumber = oSafeContact.Home2TelephoneNumber
    End If
    
    Call contactInfos.Add(Recipient.contact.LastName & ", " & Recipient.contact.FirstName, Recipient.contact.jobTitle, _
      oSafeContact.CompanyName, oPhone, oAddress, oEMail)
  Next
  
  Set oSafeContact = Nothing
  Set GetContactLinks = m_oSession.GetLinks(SelectedDomain, contactInfos)
End Function

Private Function SelectedDomain() As XSelectedDomain
  Set SelectedDomain = New XSelectedDomain
  With Model.Domains(Model.domain)
    SelectedDomain.domainId = .domainId
    SelectedDomain.domainName = .domainName
    SelectedDomain.package.packageId = .package(Model.package).packageId
    SelectedDomain.package.packageName = .package(Model.package).packageName
  End With
End Function

Public Sub PreviewPackage()
  Dim URL As String
  URL = GetPackagePreviewURL
  If URL <> "" Then
    Navigate URL
  End If
End Sub

Friend Function GetPackagePreviewURL() As String
  GetPackagePreviewURL = m_oSession.GetPreviewUrl(SelectedDomain)
End Function

Friend Function GetCustomizePackageURL() As String
  Dim packages As XPackages
  Dim package As XPackage
  Dim ii As Integer
  Dim addCustom As Boolean
    
  If mCustomizedUrl <> "" Then
    If mCustomizedDomainId <> Model.Domains(Model.domain).domainId Then
      mCustomizedDomainId = 0
      m_oSession.InvalidateProtocol
      mCustomizedUrl = ""
    End If
  End If
  
  If mCustomizedUrl = "" Then
    mCustomizedUrl = m_oSession.CustomizePackage(Model.Domains(Model.domain).domainId)
    
    Set packages = New XPackages
    
    addCustom = True
    
    For ii = 1 To mvarModel.Domains.Item(Model.domain).package.Count
      Set package = mvarModel.Domains.Item(Model.domain).package.Item(ii)
      addCustom = addCustom And (package.packageId <> 0)
    Next
    
    If addCustom Then
      Call packages.Add(sCustomPackage, 0)
    End If
      
    For ii = 1 To mvarModel.Domains.Item(Model.domain).package.Count
      Set package = mvarModel.Domains.Item(Model.domain).package.Item(ii)
      Call packages.Add(package.packageName, package.packageId)
    Next
  
    Set mvarModel.Domains.Item(Model.domain).package = packages
    mCustomizedDomainId = Model.Domains(Model.domain).domainId
  End If
  
  GetCustomizePackageURL = mCustomizedUrl
End Function

Public Sub CustomizePackage()
  Dim URL As String
  URL = GetCustomizePackageURL
  If URL <> "" Then
    Navigate URL
  End If
End Sub

Friend Sub CloseView()
  mvarInspector.Close (olDiscard)
End Sub

Friend Function RefreshDomains() As Boolean
  Set mvarModel.Domains = m_oSession.GetDomainsAndPackages
  RefreshDomains = Not (mvarModel.Domains Is Nothing)
End Function

Function NotifyPackageSent(ByVal subject As String, ByVal Body As String) As Boolean
  Dim cRecipients As New Collection
  Dim oRecipient As MailItemRecipientModel
  Dim I As Integer
  
  For I = 1 To Model.MailItemRecipients.Count
    Set oRecipient = Model.MailItemRecipients.Item(I)
    cRecipients.Add (oRecipient.address)
  Next I
  NotifyPackageSent = m_oSession.NotifyPackageSent(SelectedDomain, subject, Body, cRecipients)
End Function

Private Sub mvarItem_Write(Cancel As Boolean)
  Dim prop As UserProperty
  Set prop = mvarItem.UserProperties.Add("SIN-DOMAIN", olText)
  prop.Value = mvarModel.domain
  Set prop = mvarItem.UserProperties.Add("SIN-PACKAGE", olText)
  If (mCustomizedUrl <> "") And (mvarModel.package = 1) Then
    prop.Value = 0
  Else
    prop.Value = mvarModel.package
  End If
  Set prop = mvarItem.UserProperties.Add("SIN-DRAFT", olText)
  prop.Value = True
  Set prop = Nothing
End Sub
