VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "ExplorerControl"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private mvarAddIn As AddInControl
Private FView As ExplorerView
Private FNeedInitView As Boolean
Private WithEvents mvarExplorer As Outlook.Explorer
Attribute mvarExplorer.VB_VarHelpID = -1

Friend Sub InitView()
On Error GoTo ErrorHandler
  
  If FNeedInitView Then
    FNeedInitView = False
    FView.Init
  End If
  
  Exit Sub
ErrorHandler:
  Err.Raise Err.Number, , Err.Description + vbCrLf & "At ExplorerControl.InitView"
End Sub

Friend Sub Release()
  Set mvarAddIn = Nothing
  Set mvarExplorer = Nothing
  Set FView = Nothing
End Sub

Friend Property Set Explorer(ByVal vData As Outlook.Explorer)
  Set mvarExplorer = vData
End Property

Friend Property Get Explorer() As Outlook.Explorer
  Set Explorer = mvarExplorer
End Property

Friend Property Set AddIn(ByVal vData As AddInControl)
  Set mvarAddIn = vData
End Property

Friend Property Get AddIn() As AddInControl
  Set AddIn = mvarAddIn
End Property

Private Sub Class_Initialize()
  Set FView = New ExplorerView
  Set FView.Control = Me
  FNeedInitView = True
End Sub

Private Sub Class_Terminate()
  Set mvarAddIn = Nothing
  Set mvarExplorer = Nothing
  Set FView = Nothing
End Sub

Private Sub mvarExplorer_Activate()
  On Error GoTo ErrorHandler
  InitView
  Exit Sub
ErrorHandler:
  MsgBox "Error in Explorer.Activate: " & Err.Description
End Sub

Private Sub mvarExplorer_Close()
  Dim delIndex As Integer
  On Error GoTo ErrorHandler
  delIndex = AddIn.Explorers.IndexOf(Me)
  If delIndex > 0 Then
    AddIn.Explorers.Remove (delIndex)
  End If
  Set mvarAddIn = Nothing
  Set mvarExplorer = Nothing
  Set FView = Nothing
  Exit Sub
ErrorHandler:
  MsgBox "Error in Explorer.Close: " & Err.Description
End Sub

Public Sub CreateNewMessage()
  On Error GoTo ErrorHandler
  
  Set Explorer.CurrentFolder = Application.GetNamespace("MAPI").GetDefaultFolder(olFolderInbox)
  Explorer.Activate
  Explorer.Display
  DoEvents
  
  Dim btn As Office.CommandBarButton
  Set btn = FindCreateOutlookButton(mvarExplorer)
  If btn Is Nothing Then
    AddIn.NotifyDoNotUseWord
  Else
    AddIn.PinpointMode = True
    btn.Execute
    Set btn = Nothing
  End If
  
  Exit Sub
ErrorHandler:
  MsgBox "Error in AddInControl.CreateNewMessage: " & Err.Description
End Sub

