VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "AddInControl"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Attribute VB_Ext_KEY = "Member0" ,"Explorers"
Attribute VB_Ext_KEY = "Member1" ,"MailItems"
Option Explicit

Private WithEvents FApp As Outlook.Application
Attribute FApp.VB_VarHelpID = -1
Private mvarExplorers As Explorers

Private WithEvents FExplorers As Outlook.Explorers
Attribute FExplorers.VB_VarHelpID = -1
Private WithEvents FInspectors As Outlook.Inspectors
Attribute FInspectors.VB_VarHelpID = -1
Private WithEvents mSentItems As Outlook.Items
Attribute mSentItems.VB_VarHelpID = -1
Private WithEvents mOutbox As Outlook.Items
Attribute mOutbox.VB_VarHelpID = -1

Private m_oConfig As Configuration
Private mvarMailItems As MailItems

Private mvarPinpointMode As Boolean

Const PR_ICON_INDEX = &H10800003
Const PR_InetMailOverrideFormat = &H59020003
Const ENCODING_PREFERENCE = &H20000
Const BODY_ENCODING_TEXT_AND_HTML = &H100000
Const ENCODING_MIME = &H40000
Const PR_MSG_EDITOR_FORMAT = &H59090003
Const EDITOR_FORMAT_PLAINTEXT = 1
Const EDITOR_FORMAT_HTML = 2

Public Sub ShowOptions()
  Call m_oConfig.EditConfiguration(FApp)
End Sub

Public Sub MsgBox(ByVal sMessage As String)
  frmMsgBox.Message = sMessage
  frmMsgBox.Show (vbModal)
End Sub

Public Function InputBox(Prompt, Caption, DefaultValue As String) As String
  frmInputBox.Caption = Caption
  frmInputBox.lblPrompt.Caption = Prompt
  frmInputBox.txtValue.Text = DefaultValue
  frmInputBox.Show (vbModal)
  InputBox = Trim(frmInputBox.txtValue.Text)
  If InputBox = "" Then
    InputBox = DefaultValue
  End If
End Function

Friend Property Get Config() As Configuration
  Set Config = m_oConfig
End Property

Friend Property Get PinpointMode() As Boolean
  PinpointMode = mvarPinpointMode
End Property

Friend Property Let PinpointMode(Value As Boolean)
  mvarPinpointMode = Value
End Property

Friend Sub Release()
  While mvarExplorers.Count > 0
    mvarExplorers.Item(1).Release
    mvarExplorers.Remove (1)
  Wend
  While mvarMailItems.Count > 0
    mvarMailItems.Item(1).Release
    mvarMailItems.Remove (1)
  Wend
  Set FExplorers = Nothing
  Set FInspectors = Nothing
  Set FApp = Nothing
  Set DebugLog = Nothing
End Sub

Friend Property Get MailItems() As MailItems
  If mvarMailItems Is Nothing Then
    Set mvarMailItems = New MailItems
  End If
  Set MailItems = mvarMailItems
End Property

Friend Property Set MailItems(vData As MailItems)
  Set mvarMailItems = vData
End Property

Friend Property Get Explorers() As Explorers
  If mvarExplorers Is Nothing Then
    Set mvarExplorers = New Explorers
  End If
  Set Explorers = mvarExplorers
End Property

Friend Property Set Explorers(vData As Explorers)
  Set mvarExplorers = vData
End Property

Function GetCurrentUser()
    Dim objTopFolder As MAPIFolder
    Dim strTopFolder As String
    Set objTopFolder = FApp.GetNamespace("MAPI") _
       .GetDefaultFolder(olFolderInbox).Parent
    strTopFolder = objTopFolder.name
    If InStr(1, strTopFolder, "-") Then
        GetCurrentUser = _
          Trim(Right(strTopFolder, _
          Len(strTopFolder) - InStr(1, strTopFolder, "-")))
    Else
        GetCurrentUser = strTopFolder
    End If
    objTopFolder = Nothing
End Function

Friend Sub NotifyDoNotUseWord()
    MsgBox "Please turn off option ""Use Microsoft Word to edit e-mail messages"" in order to be able to use the Pinpoint Selling feature"
End Sub

Private Sub Class_Initialize()
  Set mvarExplorers = New Explorers
  Set mvarMailItems = New MailItems
  Set m_oConfig = New Configuration
End Sub

Private Sub Class_Terminate()
  Set mvarMailItems = Nothing
  Set mvarExplorers = Nothing
  Set FApp = Nothing
  Set FExplorers = Nothing
  Set FInspectors = Nothing
  Set mSentItems = Nothing
  Set mOutbox = Nothing
End Sub

Friend Property Set App(ByVal vData As Outlook.Application)
  Set FApp = vData
  Set FExplorers = FApp.Explorers
  Set FInspectors = FApp.Inspectors
  Set mSentItems = FApp.Session.GetDefaultFolder(olFolderSentMail).Items
  Set mOutbox = FApp.Session.GetDefaultFolder(olFolderOutbox).Items
End Property

Friend Property Get App() As Outlook.Application
  Set App = FApp
End Property

Private Sub CheckConfiguration()
  On Error GoTo ErrorHandler
  
  'If m_oConfig.NotifyAddress = vbNullString Then
  '  MsgBox ("Notification address should be specified!")
  '  Call m_oConfig.EditConfiguration(FApp)
  'End If
  Exit Sub
  
ErrorHandler:
  Err.Raise Err.Number, , Err.Description & vbCrLf & "At CheckConfiguration"
End Sub


Friend Sub Init(aApp As Outlook.Application, strProgID As String)
  On Error GoTo ErrorHandler
  Set DebugLog = New DLog
  Set App = aApp
  Call SetOfficeApp(aApp)
  CheckConfiguration
  
  Exit Sub
ErrorHandler:
  Err.Raise Err.Number, , Err.Description & vbCrLf & "At AddInControl.Init"
End Sub

Private Sub FExplorers_NewExplorer(ByVal Explorer As Outlook.Explorer)
  Dim wExplorer As ExplorerControl
  On Error GoTo ErrorHandler
  Set wExplorer = mvarExplorers.Add()
  Set wExplorer.AddIn = Me
  Set wExplorer.Explorer = Explorer
  Set wExplorer = Nothing
  PinpointMode = False

  Exit Sub
ErrorHandler:
  MsgBox "Error in Explorers.NewExplorer: " & Err.Description
End Sub

Friend Function LoginDialog(ByRef userName As String, ByRef userPass As String) As Boolean
  LoginDialog = m_oConfig.RequestLogin()
  If LoginDialog Then
    userName = m_oConfig.userName
    userPass = m_oConfig.Password
  End If
End Function

Private Sub FInspectors_NewInspector(ByVal Inspector As Outlook.Inspector)
  Dim wMailItem As MailItemControl
  On Error GoTo ErrorHandler
  
  Dim sinaddinFlag As Boolean
  sinaddinFlag = False
    
  Dim prop As UserProperty
  On Error GoTo Label10
  Set prop = Inspector.CurrentItem.UserProperties.Find("SINADDIN")
  If prop.Value = True Then
    sinaddinFlag = True
  End If
  
Label10:

  On Error GoTo ErrorHandler
  
  If PinpointMode Or sinaddinFlag Then
    Set wMailItem = mvarMailItems.Add()
    Set wMailItem.AddIn = Me
    Set wMailItem.Inspector = Inspector
    Set wMailItem.Item = Inspector.CurrentItem
    Set wMailItem = Nothing
    PinpointMode = False
  End If

  Exit Sub
ErrorHandler:
  MsgBox "Error in Inspectors.NewInspector: " & Err.Description
End Sub

