VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Marshaller"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit
Implements CustomSort
Private m_oSchemaCache As MSXML2.XMLSchemaCache40
Private Function SetupSchemaCache() As Boolean
  SetupSchemaCache = False
  If m_oSchemaCache Is Nothing Then
    Dim I As Integer
    Dim s As String
    Dim sTargetNS As String
    Dim xNSNode As IXMLDOMNode
    Dim xSchemaDoc As DOMDocument
    
    Set m_oSchemaCache = New MSXML2.XMLSchemaCache40
    Set xSchemaDoc = New DOMDocument40
    xSchemaDoc.async = False
    xSchemaDoc.preserveWhiteSpace = True
    
    s = ""
    For I = 1 To frmSinSchema.List1.ListCount
      s = s & vbCrLf & frmSinSchema.List1.List(I)
    Next
    
    On Error Resume Next
    
    xSchemaDoc.loadXML (s)
    If Err.Number = 0 Then
      Set xNSNode = xSchemaDoc.selectSingleNode("//*/@targetNamespace")
      If Not (xNSNode Is Nothing) Then
        sTargetNS = xNSNode.Text
        m_oSchemaCache.Add sTargetNS, xSchemaDoc
        If Err.Number = 0 Then
          SetupSchemaCache = True
        End If
      End If
    End If
    If Not SetupSchemaCache Then
      Set m_oSchemaCache = Nothing
    End If
  End If
  
  SetupSchemaCache = Not (m_oSchemaCache Is Nothing)
End Function
Private Function EscapeSpace(s As String) As String
  EscapeSpace = StringReplace(s, " ", "_")
End Function
Private Function UnEscapeSpace(s As String) As String
  UnEscapeSpace = StringReplace(s, "_", " ")
End Function

Private Function PersistAsCollection(xmlDoc As DOMDocument, xMain As IXMLDOMNode, sNodeName As String, oMain As Object) As Boolean
  Dim x As Integer
  Dim xmlNode As IXMLDOMNode
  Dim TLI As TLIApplication
  Dim Interface As InterfaceInfo
  Dim oMembers As SearchResults
  Dim oMember As SearchItem
  Dim oObject As Object
  Dim sCountName As String
  Dim sItemName As String
  
  PersistAsCollection = False
  
  Set TLI = New TLIApplication
  Set Interface = TLI.InterfaceInfoFromObject(oMain)
  Set oMembers = Interface.Members.GetFilteredMembers
  For Each oMember In oMembers
    If InStr(1, oMember.name, "count", vbTextCompare) > 0 And oMember.InvokeKinds = INVOKE_PROPERTYGET Then
      PersistAsCollection = True
      sCountName = oMember.name
      sItemName = Replace(sCountName, "Count", "Item")
      For x = 1 To TLI.InvokeHook(oMain, sCountName, INVOKE_PROPERTYGET)
        Set xmlNode = xmlDoc.createNode(NODE_ELEMENT, sNodeName, "")
        xMain.appendChild xmlNode
        If IsObject(TLI.InvokeHook(oMain, sItemName, INVOKE_PROPERTYGET, x)) Then
          Set oObject = TLI.InvokeHook(oMain, sItemName, INVOKE_PROPERTYGET, x)
          Call PersistObject(xmlDoc, xmlNode, oObject)
        Else
          xmlNode.Text = TLI.InvokeHook(oMain, sItemName, INVOKE_PROPERTYGET, x)
        End If
      Next
    End If
  Next
  Set xmlNode = Nothing
  Set TLI = Nothing
  Set Interface = Nothing
  Set oMembers = Nothing
  Set oMember = Nothing
  Set oObject = Nothing
End Function
Private Static Sub CustomSort_Compare(ByVal Item1 As SearchItem, ByVal Item2 As SearchItem, Compare As Long)
  Compare = Item1.MemberId - Item2.MemberId
End Sub
Private Sub PersistObject(xmlDoc As DOMDocument, xMain As IXMLDOMNode, oMain As Object)
  Dim x As Integer
  Dim xmlNode As IXMLDOMNode
  Dim TLI As TLIApplication
  Dim Interface As InterfaceInfo
  Dim oMembers As SearchResults
  Dim oMember As SearchItem
  Dim oObject As Object
  Dim sCountName As String
  Dim sItemName As String
  Dim oMemberInfo As MemberInfo
  Dim oTypeInfo As TypeInfo
  Dim oEnumItem As MemberInfo
  Dim bIsEnum As Boolean
  
  On Error GoTo Error
  Set TLI = New TLIApplication
  Set Interface = TLI.InterfaceInfoFromObject(oMain)
  Set oMembers = Interface.Members.GetFilteredMembers
  Dim Comparator As CustomSort
  Call oMembers.Sort(Me)
  For Each oMember In oMembers
    If oMember.InvokeKinds = INVOKE_PROPERTYPUT + INVOKE_PROPERTYGET Then
      Set oMemberInfo = GetMemberByID(Interface.Members, oMember.MemberId, INVOKE_PROPERTYGET)
      Set oTypeInfo = oMemberInfo.ReturnType.TypeInfo
      bIsEnum = Not (oTypeInfo Is Nothing)
      If bIsEnum Then bIsEnum = oTypeInfo.TypeKind = TKIND_ENUM
      If bIsEnum Then
        Dim Value As Variant
        Dim sEscapedValue As String
        Dim Elem As IXMLDOMElement
        Value = TLI.InvokeHook(oMain, oMember.name, INVOKE_PROPERTYGET)
        sEscapedValue = ""
        For Each oEnumItem In oTypeInfo.Members
          If oEnumItem.Value = Value Then
            sEscapedValue = UnEscapeSpace(oEnumItem.name)
          End If
        Next
        Set Elem = xMain
        Call Elem.setAttribute(oMember.name, sEscapedValue)
      Else
        Set xmlNode = xmlDoc.createNode(NODE_ELEMENT, oMember.name, "")
        xmlNode.Text = TLI.InvokeHook(oMain, xmlNode.nodeName, INVOKE_PROPERTYGET)
        Call xMain.appendChild(xmlNode)
      End If
    ElseIf oMember.InvokeKinds = INVOKE_PROPERTYGET + INVOKE_PROPERTYPUTREF Then
        Set oObject = TLI.InvokeHook(oMain, oMember.name, INVOKE_PROPERTYGET)
        If Not PersistAsCollection(xmlDoc, xMain, oMember.name, oObject) Then
            Dim sName As String
            sName = oMember.name
            If sName = "EMail" Then sName = "email"   'workaround strange bug in VB6
            If sName = "SelectedDomain" Then sName = "selectedDomain"   'workaround strange bug in VB6
            Set xmlNode = xmlDoc.createNode(NODE_ELEMENT, sName, "")
            xMain.appendChild xmlNode
            Call PersistObject(xmlDoc, xmlNode, oObject)
        End If
    End If
  Next
  
  Set xmlNode = Nothing
  Set TLI = Nothing
  Set Interface = Nothing
  Set oMembers = Nothing
  Set oMember = Nothing
  Set oObject = Nothing
  Exit Sub
Error:
  Err.Raise Err.Number, TypeName(Me) & ".PersistObject", Err.Description & vbCrLf & "At " & TypeName(oMain)
  Exit Sub
End Sub

Public Function SaveAsXML(oMain As Object) As String
  Dim xmlDoc As DOMDocument40
  Dim xMain As IXMLDOMNode
  Dim xPI As IXMLDOMProcessingInstruction
  
  Set xmlDoc = New DOMDocument40
  
  xmlDoc.preserveWhiteSpace = True
  Set xPI = xmlDoc.createProcessingInstruction("xml", "version='1.0'")
  Call xmlDoc.appendChild(xPI)
  Set xPI = Nothing

  Set xMain = xmlDoc.createNode(NODE_ELEMENT, TypeName(oMain), "")
  Dim xElem As IXMLDOMElement
  Set xElem = xMain
  Call xElem.setAttribute("xmlns", "http://www.pinpointselling.com/outlookIntegration")
  Call xElem.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance")
  Call xElem.setAttribute("xsi:schemaLocation", "http://www.pinpointselling.com/outlookIntegration outlookIntegration.xsd")
  
  xmlDoc.appendChild xMain
  
  Call PersistObject(xmlDoc, xMain, oMain)
  
  SaveAsXML = xmlDoc.xml
  
  If SetupSchemaCache Then
    Dim xmlTestDoc As New DOMDocument40
    Set xmlTestDoc.schemas = m_oSchemaCache
    If Not xmlTestDoc.loadXML(SaveAsXML) Then
      Err.Raise errXMLParseError, , ParseErrorString(xmlTestDoc.ParseError)
    End If
    Set xmlTestDoc = Nothing
  End If
  
    
  Set xmlDoc = Nothing
  Set xMain = Nothing
End Function
Public Sub LoadFromDom(oMain As Object, oDom As DOMDocument)
  Dim rootNode As IXMLDOMNode
    
  For Each rootNode In oDom.childNodes
    If rootNode.nodeType = NODE_ELEMENT Then
      If UnPersistObject(rootNode, oMain) Then
      End If
      Exit Sub
    End If
  Next
  Err.Raise vbObjectError + 513, "", "Invalid Packet. At least two nodes expected, <?xml> and <name-of-command>. Found only " & vbCrLf & oDom.Text
End Sub


Public Sub LoadFromXML(oMain As Object, sXML As String)
  Dim xmlDoc As New DOMDocument40
  If xmlDoc.loadXML(sXML) Then
    Call LoadFromDom(oMain, xmlDoc)
  End If
  
  Set xmlDoc = Nothing
End Sub
Function GetMemberByID(objMembers As TLI.Members, memID As Long, FlagMask As Long) As MemberInfo
  Dim I As Long

  For I = 1 To objMembers.Count
    If objMembers(I).MemberId = memID And (objMembers(I).InvokeKind And FlagMask) > 0 Then
      Set GetMemberByID = objMembers(I)
      Exit For
    End If
  Next I
End Function

Private Function UnPersistAsCollection(xmlNode As IXMLDOMNode, oMain As Object) As Boolean
  Dim x As Integer
  Dim TLI As TLIApplication
  Dim Interface As InterfaceInfo
  Dim oMembers As SearchResults
  Dim oMember As SearchItem
  Dim oObject As Object
  Dim oChild As Object
  Dim I As Integer
  Dim ClassMember As MemberInfo
  Dim vArg() As Variant
    
  UnPersistAsCollection = False
  
  Set TLI = New TLIApplication
  Set Interface = TLI.InterfaceInfoFromObject(oMain)
  Set oMembers = Interface.Members.GetFilteredMembers
  For Each oMember In oMembers
    If InStr(1, oMember.name, "Add", vbTextCompare) > 0 And oMember.InvokeKinds = INVOKE_FUNC Then
      UnPersistAsCollection = True
      Set ClassMember = GetMemberByID(Interface.Members, oMember.MemberId, INVOKE_FUNC)
      ReDim vArg(ClassMember.Parameters.Count - 1) As Variant
      Dim Vt As Integer
      Dim j As Integer
      For I = 0 To ClassMember.Parameters.Count - 1
        j = ClassMember.Parameters.Count - I - 1
        Vt = ClassMember.Parameters(I + 1).VarTypeInfo.VarType
        If (Vt And VT_ARRAY) Or (Vt And VT_VECTOR) Then
          Err.Raise vbObjectError + 513, "", "Lengthly properties are not supported"
        End If
        Select Case Vt
          Case VT_INT, VT_I2: vArg(j) = 0
          Case VT_I4: vArg(j) = 0&
          Case VT_BSTR: vArg(j) = ""
          Case VT_DECIMAL: vArg(j) = 0
          Case Else
            Err.Raise vbObjectError + 513, "", "Unsupported intrinsic type: " & Vt
        End Select
      Next I
      Set oChild = TLI.InvokeHookArray(oMain, ClassMember.name, INVOKE_FUNC, vArg)
      If UnPersistObject(xmlNode, oChild) Then
      End If
    End If
  Next
  Set TLI = Nothing
  Set Interface = Nothing
  Set oMembers = Nothing
  Set oMember = Nothing
  Set oObject = Nothing
End Function

Private Function UnPersistObject(xmlParentNode As IXMLDOMNode, oMain As Object) As Boolean
  Dim xmlChildNode As IXMLDOMNode
  Dim TLI As TLIApplication
  Dim Interface As InterfaceInfo
  Dim oMembers As SearchResults
  Dim oMember As SearchItem
  Dim oObject As Object
  Dim oMemberInfo As MemberInfo
  Dim oTypeInfo As TypeInfo
  Dim oEnumItem As MemberInfo
  
  Set TLI = New TLIApplication
  For Each xmlChildNode In xmlParentNode.childNodes
    Set Interface = TLI.InterfaceInfoFromObject(oMain)
    Set oMembers = Interface.Members.GetFilteredMembers
    For Each oMember In oMembers
      If oMember.name = xmlChildNode.nodeName Then
        If oMember.InvokeKinds = INVOKE_PROPERTYPUT + INVOKE_PROPERTYGET Then
          TLI.InvokeHook oMain, oMember.name, INVOKE_PROPERTYPUT, xmlChildNode.Text
        ElseIf oMember.InvokeKinds = INVOKE_PROPERTYGET + INVOKE_PROPERTYPUTREF Then
            Set oObject = TLI.InvokeHook(oMain, oMember.name, INVOKE_PROPERTYGET)
            If Not UnPersistAsCollection(xmlChildNode, oObject) Then
                If UnPersistObject(xmlChildNode, oObject) Then
                End If
            End If
        End If
      End If
    Next
  Next
  For Each xmlChildNode In xmlParentNode.Attributes
    Set Interface = TLI.InterfaceInfoFromObject(oMain)
    Set oMembers = Interface.Members.GetFilteredMembers
    For Each oMember In oMembers
      If oMember.name = xmlChildNode.nodeName Then
        If oMember.InvokeKinds = INVOKE_PROPERTYPUT + INVOKE_PROPERTYGET Then
          Set oMemberInfo = GetMemberByID(Interface.Members, oMember.MemberId, INVOKE_PROPERTYPUT)
          Set oTypeInfo = oMemberInfo.ReturnType.TypeInfo
          If oTypeInfo.TypeKind = TKIND_ENUM Then
            Dim sEscapedName As String
            Dim bEnumFound As Boolean
            sEscapedName = EscapeSpace(xmlChildNode.Text)
            bEnumFound = False
            For Each oEnumItem In oTypeInfo.Members
              If oEnumItem.name = sEscapedName Then
                bEnumFound = True
                TLI.InvokeHook oMain, oMember.name, INVOKE_PROPERTYPUT, oEnumItem.MemberId
              End If
            Next
            If Not bEnumFound Then
              Err.Raise vbObjectError + 512, , "Cannot found enumeration value named " & xmlChildNode.Text
            End If
          Else
              TLI.InvokeHook oMain, oMember.name, INVOKE_PROPERTYPUT, xmlChildNode.Text
          End If
        End If
      End If
    Next
  Next
  Set xmlChildNode = Nothing
  Set TLI = Nothing
  Set Interface = Nothing
  Set oMembers = Nothing
  Set oMember = Nothing
  Set oObject = Nothing
  Set oMemberInfo = Nothing
  Set oTypeInfo = Nothing
End Function
