Attribute VB_Name = "FindApp98"
Option Explicit

'==========================================
'WINDOWS 95/98 ONLY, ToolHelp32 APIs don't
'exist on Windows NT, use PSAPI.DLL instead
'==========================================

Public Declare Function CreateToolhelp32Snapshot Lib "kernel32" (ByVal dwFlags As Long, ByVal th32ProcessID As Long) As Long

Public Declare Function Process32First Lib "kernel32" (ByVal hSnapshot As Long, lppe As PROCESSENTRY32) As Long
      
Public Declare Function Process32Next Lib "kernel32" (ByVal hSnapshot As Long, lppe As PROCESSENTRY32) As Long

Public Declare Function Module32First Lib "kernel32" (ByVal hSnapshot As Long, lpme As MODULEENTRY32) As Long
    
Public Declare Function Module32Next Lib "kernel32" (ByVal hSnapshot As Long, lpme As MODULEENTRY32) As Long
Public Declare Function CloseHandle Lib "kernel32" (ByVal hHandle As Long) As Long
    
Private Const MAX_MODULE_NAME32 As Integer = 255
Private Const MAX_MODULE_NAME32plus As Integer = MAX_MODULE_NAME32 + 1
Private Const MAX_PATH = 260
Public Const TH32CS_SNAPPROCESS = &H2&
Public Const TH32CS_SNAPMODULE = &H8&

Public Type PROCESSENTRY32
   dwSize               As Long 'Specifies the length, in bytes, of the structure.
   cntUsage             As Long 'Number of references to the process.
   th32ProcessID        As Long 'Identifier of the process.
   th32DefaultHeapID    As Long 'Identifier of the default heap for the process.
   th32ModuleID         As Long 'Module identifier of the process. (Associated exe)
   cntThreads           As Long 'Number of execution threads started by the process.
   th32ParentProcessID  As Long 'Identifier of the process that created the process being examined.
   pcPriClassBase       As Long 'Base priority of any threads created by this process.
   dwFlags              As Long 'Reserved; do not use.
   szExeFile            As String * MAX_PATH 'Path and filename of the executable file for the process.
End Type

Public Type MODULEENTRY32
    dwSize          As Long 'Specifies the length, in bytes, of the structure.
    th32ModuleID    As Long 'Module identifier in the context of the owning process.
    th32ProcessID   As Long 'Identifier of the process being examined.
    GlblcntUsage    As Long 'Global usage count on the module.
    ProccntUsage    As Long 'Module usage count in the context of the owning process.
    modBaseAddr     As Long 'Base address of the module in the context of the owning process.
    modBaseSize     As Long 'Size, in bytes, of the module.
    hModule         As Long 'Handle to the module in the context of the owning process.
    szModule        As String * MAX_MODULE_NAME32plus 'String containing the module name.
    szExePath       As String * MAX_PATH 'String containing the location (path) of the module.
End Type

Public Function StrZToStr(s As String) As String
   StrZToStr = Left$(s, Len(s) - 1)
End Function

Public Function FindApp98(ExeName As String) As Boolean
    Dim lReturnID       As Long
    Dim hSnapProcess    As Long
    Dim proc            As PROCESSENTRY32
    Dim module          As MODULEENTRY32
    Dim iProcesses      As Integer
    Dim iModules        As Integer
    
    'Get a 'at this moment' snapshot of all the processes
    hSnapProcess = CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0)
    
    If hSnapProcess = hNull Then
        'If the snapshot is empty, then exit
        'Return the number of Processes found
        FindApp98 = False
    Else
        'Initialize the processentry structure
        proc.dwSize = Len(proc)
        
        'Get first process
        lReturnID = Process32First(hSnapProcess, proc)
                
        'Iterate through each process with an ID that <> 0
        Do While lReturnID
            
            'Add the process to the listbox
            If InStr(UCase(Trim(proc.szExeFile)), UCase(Trim(ExeName))) > 0 Then
              FindApp98 = True
              CloseHandle hSnapProcess
              Exit Function
            End If
            
            'Increment the count of processes we've added
            iProcesses = iProcesses + 1
            
            'Get next process
            lReturnID = Process32Next(hSnapProcess, proc)
        Loop
        
        'Close the Process snapshot handle
        CloseHandle hSnapProcess
        FindApp98 = False
    End If
End Function
