;Written by i-Vortex Inc.

!define MUI_PRODUCT "Pinpoint Selling Outlook Integration" ;Define your own software name here
!define MUI_VERSION "1.0" ;Define your own software version here

!include "MUI.nsh"

;--------------------------------
;Configuration

  ;General
  OutFile "..\..\bin\Setup.exe"

  ;Folder selection page
  InstallDir "$PROGRAMFILES\${MUI_PRODUCT}"
  
  ;Remember install folder
  InstallDirRegKey HKCU "Software\${MUI_PRODUCT}" ""

;--------------------------------
;Modern UI Configuration

  !define MUI_WELCOMEPAGE
  !define MUI_LICENSEPAGE
  !define MUI_DIRECTORYPAGE
  
  !define MUI_ABORTWARNING
  
  !define MUI_FINISHPAGE
  ;!define MUI_FINISHPAGE_NOAUTOCLOSE

  !define MUI_UNINSTALLER
  !define MUI_UNCONFIRMPAGE

  !define MUI_HEADERBITMAP "Contrib\header.bmp"
  !define MUI_HEADERBITMAP_RIGHT
  
  !define MUI_ICON "..\..\src\images\icon3_32X32.ico"
  
  !define MUI_UNICON "..\..\src\images\icon3_32X32.ico"

  !define MUI_BRANDINGTEXT " "

;--------------------------------
;Languages

  !insertmacro MUI_LANGUAGE "English"

;--------------------------------
;Language Strings

  ;Description
  LangString DESC_SecCopyUI ${LANG_ENGLISH} "Copy the modern.exe file to the application folder."

;--------------------------------
;Reserve Files
  
  ;Things that need to be extracted on first (keep these lines before any File command!)
  ;Only useful for BZIP2 compression
  
  ReserveFile "${NSISDIR}\Contrib\Icons\modern-header.bmp"

;--------------------------------
;License Data

  LicenseData "Contrib\license.txt"


function UnregOldDll
  Push $1
  ReadRegStr $1 HKCU "Software\${MUI_PRODUCT}" ""
  IfErrors L100
    UnRegDLL "$1\Redemption.dll"
    UnRegDLL "$1\SINAddin.dll"
  L100:
  Pop $1
FunctionEnd

;--------------------------------
;Installer Sections
Section "modern.exe" SecCopyUI

  ;ADD YOUR OWN STUFF HERE!

  SetOutPath "$INSTDIR"
  File "..\..\bin\CheckOutlook.exe"

  ExecWait "$INSTDIR\CheckOutlook.exe"
  IfErrors CancelInstall

  Call UnregOldDll

  SetOutPath "$SYSDIR"
  File "..\MSXML4\msxml4.dll"
  File "..\MSXML4\msxml4a.dll"
  File "..\MSXML4\msxml4r.dll"
  RegDll "$SYSDIR\msxml4.dll"
  File "..\..\bin\TLBINF32.DLL"
  RegDll "$SYSDIR\TLBINF32.DLL"

  SetOutPath "$INSTDIR"
  File "..\..\bin\Redemption.dll"
  File "..\..\bin\SINAddin.dll"
  RegDll "$INSTDIR\Redemption.dll"
  RegDll "$INSTDIR\SINAddin.dll"
  File "..\..\bin\ConfigAddin.exe"
  ExecWait "$INSTDIR\ConfigAddin.exe"

  ;Store install folder
  WriteRegStr HKCU "Software\${MUI_PRODUCT}" "" $INSTDIR
  ;Store other info
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${MUI_PRODUCT}" "DisplayName" "${MUI_PRODUCT}"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${MUI_PRODUCT}" "UninstallString" "$INSTDIR\Uninstall.exe"
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${MUI_PRODUCT}" "NoModify" 1
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${MUI_PRODUCT}" "NoRepair" 1
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${MUI_PRODUCT}" "DisplayIcon" "$INSTDIR\Uninstall.exe"

  ;Create uninstaller
  WriteUninstaller "$INSTDIR\Uninstall.exe"

  GoTo EndInstall

CancelInstall:
  Delete /REBOOTOK "$INSTDIR\CheckOutlook.exe"
  RMDir "$INSTDIR"
  Abort "Install Aborted by customer"
  
EndInstall:

SectionEnd

;--------------------------------
;Descriptions

!insertmacro MUI_FUNCTIONS_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SecCopyUI} $(DESC_SecCopyUI)
!insertmacro MUI_FUNCTIONS_DESCRIPTION_END

;--------------------------------
;Uninstaller Section

Section "Uninstall"

  ;ADD YOUR OWN STUFF HERE!

  ExecWait "$INSTDIR\CheckOutlook.exe"
  IfErrors CancelUnInstall

  UnRegDll "$INSTDIR\Redemption.dll"
  UnRegDll "$INSTDIR\SINAddin.dll"

  Delete /REBOOTOK "$INSTDIR\CheckOutlook.exe"
  Delete /REBOOTOK "$INSTDIR\Redemption.dll"
  Delete /REBOOTOK "$INSTDIR\SINAddin.dll"
  Delete /REBOOTOK "$INSTDIR\ConfigAddin.exe"
  Delete /REBOOTOK "$INSTDIR\Uninstall.exe"

  RMDir /r "$INSTDIR"

  DeleteRegKey HKCU "Software\${MUI_PRODUCT}"
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${MUI_PRODUCT}"
  DeleteRegKey HKCU "Software\VB and VBA Program Settings\${MUI_PRODUCT}"

  ;Display the Finish header
  !insertmacro MUI_UNFINISHHEADER
  GoTo EndUnInstall

CancelUnInstall:
  Abort "UnInstall Aborted by customer"

EndUnInstall:

SectionEnd
