<!--
   - Formats the top level of the template.  header.xsl assumes the XTP
   - has been read in as HTML.  So it can assume the existence of the
   - html and body tags.
  -->

<xsl:stylesheet>
<xsl:output disable-output-escaping=yes/>
<#@ page import='com.caucho.web.*'
         import='com.caucho.vfs.*'
         import='com.caucho.server.http.*' #>
<#@ cache #>
<#!
  String top = "/";
  String title = null;
  String section = "";
  Navigation nav = null;

  String topnav(Object a, Object b, Object c) { return ""; }
  void initNavigation(XslWriter out)
    throws IOException
  {
    PageContext page = (PageContext) out.getProperty("caucho.page.context");
    ServletContext app = page.getServletContext();
    HttpServletRequest req = (HttpServletRequest) page.getRequest();

    String url = req.getRequestURI();
    int p = url.lastIndexOf('/');
    String base = url.substring(0, p);

    ArrayList paths = new ArrayList();
    while (p >= 0) {
      String prefix = url.substring(0, p + 1);

      CauchoApplication subapp = (CauchoApplication) app.getContext(prefix);
      String rel = prefix.substring(subapp.getContextPath().length());

      String realPath = subapp.getRealPath(rel);
      Path path = ((Path) out.getProperty("caucho.pwd")).lookupNative(realPath);

      paths.add(path);
      if (path.lookup("toc.xml").exists())
        out.addCacheDepend(path.lookup("toc.xml"));

      p = url.lastIndexOf('/', p - 1);
    }

    nav = Navigation.createNested(paths, base);
    if (nav == null)
      nav = new Navigation();

    top = nav.getAttribute("top");

    top = req.getContextPath() + top;
    if (! top.endsWith("/"))
      top = top + "/";
  }

  void writeFamilyNavigation(XslWriter out)
    throws IOException, SAXException, XPathException
  {
    PageContext page = out.getPage();
    HttpServletRequest req = (HttpServletRequest) page.getRequest();

    NavItem item = nav.findURL(req.getRequestURI());

    ArrayList list = null;
    if (item != null)
      list = item.familyNavigation();

    if (list == null || list.size() == 0)
      return;

    for (int i = 0; i < list.size(); i++) {
      NavItem child = (NavItem) list.get(i);
      if (child == null) {
        out.pushElement("hr");
        out.popElement();
      }
      else {
        String link = child.getLink();
        if (link.startsWith("/"));
          link = link.substring(1);

        out.pushElement("a");
        out.setAttribute("class", "leftnav");
        out.setAttribute("href", top + link);
        out.println(child.getTitle());
        out.popElement();

        out.pushElement("br");
        out.popElement();
      }
    }
  }

  void writeThreaded(XslWriter out, boolean allowComments)
    throws IOException, SAXException, XPathException
  {
    PageContext page = out.getPage();
    HttpServletRequest req = (HttpServletRequest) page.getRequest();

    NavItem item = nav.findURL(req.getRequestURI());
    if (item == null)
      return;

    out.pushElement("table");
    out.setAttribute("border", "0");
    out.setAttribute("cellspacing", "0");
    out.setAttribute("width", "100%");
    out.pushElement("tr");
    out.pushElement("td");

    NavItem prev = item.getPreviousPreorder();
    if (prev == null)
      out.print("&nbsp;");
    else {
      out.pushElement("a");
      out.setAttribute("href", prev.getLink());
      out.print(prev.getTitle());
      out.popElement();
    }

    out.popElement();

    if (allowComments && ! nav.getAttribute("comment").equals("")) {
      out.pushElement("td");
      out.setAttribute("width", "100%");

      out.pushElement("jsp:scriptlet");
      out.print("String headerUrl = request.getContextPath() + request.getServletPath();");
      out.popElement();

      out.pushElement("center");
      out.pushElement("a");
      out.setAttribute("href", "/quercus/comment/commentServlet?cmd=add_comment&comment_url=<%= headerUrl %>");
      out.print("add documentation note");
      out.popElement();
      out.popElement();
      out.popElement();
    }
    else if (item.getParent() != null) {
      NavItem parent = item.getParent();

      out.pushElement("td");
      out.setAttribute("width", "100%");

      out.pushElement("center");
      out.pushElement("a");
      out.setAttribute("href", parent.getLink());
      out.print(parent.getTitle());
      out.popElement();
      out.popElement();
      out.popElement();
    }
    else {
      out.pushElement("td");
      out.setAttribute("width", "100%");
      out.print("&nbsp;");
      out.popElement();
    }

    out.pushElement("td");
    out.setAttribute("align", "right");

    NavItem next = item.getNextPreorder();
    if (next == null)
      out.print("&nbsp;");
    else {
      out.pushElement("a");
      out.setAttribute("href", next.getLink());
      out.print(next.getTitle());
      out.popElement();
    }

    out.popElement();
    out.popElement();
    out.popElement();
  }

  void topnav(XslWriter out, String name, String href)
    throws IOException, SAXException, XPathException
  {
    out.pushElement("a");
    out.setAttribute("class", "topnav");
    out.setAttribute("href", "/" + href);
    out.println(name);
    out.popElement();
  }

  void printDescription(XslWriter out, Node node, int count)
    throws IOException, SAXException, XPathException
  {
    if (node == null)
      return;

    CharBuffer cb = CharBuffer.allocate();

    Iterator iter = XPath.select(".//text()|.//resin|.//resintm", node);
    while (iter.hasNext()) {
      Node subnode = (Node) iter.next();

      if (subnode.getNodeName().equals("#text")) {
        String str = subnode.getNodeValue();
        for (int i = 0; i < str.length(); i++) {
          char ch = str.charAt(i);
          if (ch == '<' && i + 1 < str.length() && str.charAt(i + 1) == '%') {
            for (; i + 1 < str.length(); i++) {
              if (str.charAt(i) == '%' && str.charAt(i + 1) == '>') {
                i += 1;
                break;
              }
            }
          }
          else if (ch == '<')
            cb.append("&lt;");
	  else if (ch == '>')
            cb.append("&gt;");
	  else if (ch == '&')
            cb.append("&amp;");
	  else if (Character.isWhitespace(ch) && i < 0 &&
                   Character.isWhitespace(str.charAt(i - 1))) {
          }
          else if (ch != '"' && ch != '\'')
            cb.append(ch);
        }
      }
      else if (subnode.getNodeName().equals("resin"))
        cb.append("Resin");
      else if (subnode.getNodeName().equals("resintm"))
        cb.append("Resin(tm)");

      if (cb.length() >= count)
        break;
    }

    if (cb.length() > count)
      cb.setLength(count);

    if (cb.length() > 0) {
      out.pushElement("meta");
      out.setAttribute("name", "description");
      out.setAttribute("content", cb.close());
      out.popElement();
    }
  }
#>

html
<<
$apply-templates(head/ct:prefix/node());
<# 
  initNavigation(out);
  title = XPath.evalString("head/title", node);
  if (title == null)
    title = "";
#>
<html>
<head>
$if (head/title/@browser-title) <<
  <title>$(head/title/@browser-title)</title>
>>
$else $if (head/title/@section) <<
  <title>$(head/title/@section)<#= title #></title>
>>
$else <<
  <title><#= section + title #></title>
>>
<link rel="STYLESHEET" type="text/css">
  <xsl:attribute name='href'>/css/default.css</xsl:attribute>
</link>
$if (head/title/@description) <<
  <meta name="description" content="{head/title/@description}"/>
>>
$else $if (head/meta[@name="description"]) <<
>>
$else <#
     printDescription(out, XPath.find("/html/body", node), 256);
#>

$for-each(head/meta) <<
  $copy << $apply-templates(@*|node()); >>
>>

$if (head/title/@keywords) <<
  <meta name="keywords" content="{head/title/@keywords}"/>
>>

</head>
<xsl:apply-templates select='body'/>
</html>
>>

html[body/s1]
<<
$apply-templates(head/ct:prefix/node());
<# 
  initNavigation(out);
  title = XPath.evalString("if(body/s1/title,body/s1/title,body/s1/@title)", node);
  if (title == null)
    title = "";
#>
<html>
<head>
$if (body/s1/@browser-title) <<
  <title>$(body/s1/@browser-title)</title>
>>
$else $if (body/s1/@section) <<
  <title>$(body/s1/@section)<#= title #></title>
>>
$else <<
  <title><#= section + title #></title>
>>
<link rel="STYLESHEET" type="text/css">
  <xsl:attribute name='href'>/css/default.css</xsl:attribute>
</link>
$if (body/s1/@description) <<
  <meta name="description" content="{body/s1/@description}"/>
>>
$else $if (body/s1[@name="description"]) <<
>>
$else <#
     printDescription(out, XPath.find("body/s1", node), 256);
#>

$for-each(head/meta) <<
  $copy << $apply-templates(@*|node()); >>
>>

$if (body/s1/@keywords) <<
  <meta name="keywords" content="{body/s1/@keywords}"/>
>>

</head>
<xsl:apply-templates select='body'/>
</html>
>>

html/body
<<
  <body bgcolor=white>
    <xsl:attribute name='background'>/images/background.gif</xsl:attribute>

  <table cellpadding="1" cellspacing="0" border="0" width="100%" summary="">
  <tr valign="top"><td width="120">
    <img width="120" height="40" alt="caucho">
       <xsl:attribute name='src'>/images/caucho.gif</xsl:attribute>
    </img><br/>
    Search<br/>
    <form action='/search'>
    <input name='query' size='12'/>
    </form>
    <!-- Left Navigation -->
    <# writeFamilyNavigation(out); #>
  </td>
  <td width="30">
    <img alt="" width="30" height="1">
      <xsl:attribute name='src'>/images/pixel.gif</xsl:attribute>
    </img>
  </td>
  <td width="100%">
    <xsl:comment> top navigation </xsl:comment>
    <table width="100%" cellspacing="0" cellpadding="0" border="0" summary="">
    <tr class="toptitle">
      <td>
        <xsl:attribute name='background'>/images/hbleed.gif</xsl:attribute>
        <xsl:choose>
          <xsl:when test="/html/body/s1/title">
            <font class=toptitle size="+3">
              &nbsp;<xsl:apply-templates select='/html/body/s1/title/node()'/>
            </font>
          </xsl:when>
          <xsl:when test="/html/body/s1/@title">
            <font class=toptitle size="+3">
              &nbsp;<xsl:value-of select='/html/body/s1/@title'/>
            </font>
          </xsl:when>
          <xsl:otherwise>
            <font class=toptitle size="+3">
              &nbsp;<xsl:apply-templates select='/html/head/title/node()'/>
            </font>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:for-each select='/html/head/title/@subtitle'>
          <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<{.}>
        </xsl:for-each>
        <xsl:for-each select='/html/body/s1/@subtitle'>
          <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<{.}>
        </xsl:for-each>
        <xsl:for-each select='/html/body/s1/title/subtitle'>
          <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<xsl:apply-templates/>
        </xsl:for-each>
        <xsl:for-each select='/html/head/title/subtitle'>
          <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<xsl:apply-templates/>
        </xsl:for-each>
        <xsl:for-each select='/html/head/title/@author'>
          <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<em>By <{.}></em>
        </xsl:for-each>
        <xsl:for-each select='/html/body/s1/@author'>
          <br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<em>By <{.}></em>
        </xsl:for-each>
      </td>
      <td align=right>
      <table cellspacing="0" cellpadding="0" border="0" summary="">
      <tr>
        <td align="left">&nbsp;&nbsp;<# topnav(out, "Home", "index.xtp"); #></td>
        <td align="left">&nbsp;&nbsp;<# topnav(out, "Site&nbsp;Map", "sitemap.xtp"); #></td>
        <td align="left">&nbsp;&nbsp;<# topnav(out, "FAQ", "quercus/faq/overview.xtp"); #></td>
      </tr>
      <tr>
        <td align="left">&nbsp;&nbsp;<# topnav(out, "Products", "products/"); #></td>
        <td align="left">&nbsp;&nbsp;<# topnav(out, "Download", "download/"); #></td>
        <td align="left">&nbsp;&nbsp;<# topnav(out, "Sales", "sales/"); #></td>
      </tr>
      </table>
      </td>
     </tr>
  </table>
  <!-- vspace -->
  <img alt="" width="1" height="20">
    <xsl:attribute name='src'>/images/pixel.gif</xsl:attribute>
  </img>
  <br/>

  <#
     if (nav != null && nav.getAttribute("threaded").equals("true")) {
       writeThreaded(out, false);
       out.pushElement("hr");
       out.popElement();
     }
  #>

  <!-- Actual Contents -->
  <xsl:apply-templates/>

  <!-- comments -->
  <# if (nav != null && ! nav.getAttribute("comment").equals("")) { #>
    <% try {
        ServletContext root = application.getContext("/");
        RequestDispatcher disp;
        disp = root.getRequestDispatcher("/quercus/comment/list.xtp");
        disp.include(request, response);
       } catch (Exception e) { application.log("comment error", e); } %>
  <# } #>

  <!-- footer -->
  <hr/>

  <# if (nav != null && nav.getAttribute("threaded").equals("true"))
       writeThreaded(out, true);
  #>

  <center>
    <a href="/index.xtp">Home</a> |
    <a href="/resin/">Resin</a> | 
    <a href="/resin-ee/">Resin Enterprise</a> | 
    <a href="/download/index.xtp">Download</a> | 
    <a href="/sales/">Sales</a> | 
    <a href="/quercus/faq/overview.xtp">FAQ</a> |
    <a href="/sitemap.xtp">Site Map</a> |
    <a href="/sales/contact.xtp">Contact Caucho</a>
    <br/>
  </center>
  <table border=0 cellspacing=0 width='100%'>
  <tr><td><em><small>Copyright &copy; 1998-2002 Caucho Technology, Inc. All rights reserved.<br/>
Resin<sup><font size='-1'>&#174;</font></sup> is a registered trademark,
and HardCore<sup>tm</sup> and Quercus<sup>tm</sup> are trademarks of Caucho Technology, Inc.</small></em>
    </td>
    <td align=right><img width=96 height=32>
      <xsl:attribute name='src'>/images/logo.gif</xsl:attribute>
    </img></td>
  </tr>
  </table>

  </td>
  </tr>
  </table>
  </body>
>>

<xsl:template match="subtitle">
</xsl:template>

</xsl:stylesheet>

