<?xml version="1.0"?>
<xsl:stylesheet>
<xsl:output resin:disable-output-escaping="true"/>

<!--
   - macros
  -->

<!-- anchor name handling -->
<xsl:template name="aname">
  <a name="{translate(if(@name,@name,@title),' ', '-'))}"/>
</xsl:template>

<!-- title handling -->
<xsl:template name="m_title">
  <xsl:choose>
  <xsl:when test="@title">
    <xsl:value-of select="@title"/>
  </xsl:when>
  <xsl:otherwise>
    <xsl:apply-templates select="title/node()"/>
  </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!--
   - Sections
  -->

<!--
   - s1 is a separate web page, i.e. a main section.
  -->
<xsl:template match="body/s1">
  <xsl:apply-templates select="*"/>
</xsl:template>

<!--
   - s2 is the main section of a page
  -->
<xsl:template match="s1/s2[@title or title]">
  <xsl:call-template name="aname"/>
  <p/>
  <table border=0 cellpadding=5 cellspacing=0 width='100%'>
  <tr class=section>
  <td><font size="+2"><b><xsl:call-template name="m_title"/></b></font>
  </td>

  <xsl:if test="@version">
    <td align="right"><xsl:value-of select="@version"/></td>
  </xsl:if>

  </tr>
  </table>

  <xsl:apply-templates select='node()[name(.)!="title"]'/>
</xsl:template>

<!--
   - s3 is a subsection of a section
  -->
<xsl:template match="s2/s3[@title or title]">
  <xsl:call-template name=aname/>
  <h3><xsl:call-template name="m_title"/></h3>

  <xsl:apply-templates select='node()[name(.)!="title"]'/>
</xsl:template>

<!--
   - s4 is a subsubsection of a section
  -->
<xsl:template match="s3/s4[@title or title]">
  <xsl:call-template name=aname/>
  <h4><xsl:call-template name="m_title"/></h4>

  <xsl:apply-templates select='node()[name(.)!="title"]'/>
</xsl:template>

<!--
   - defun is a definition.
  -->
<xsl:template match="defun[@title or title]">
  <xsl:call-template name=aname/>
  <xsl:choose>
  <xsl:when test="@version">
    <h4><xsl:call-template name="m_title"/></h4>
  </xsl:when>
  <xsl:otherwise>
    <p/>
    <table border="0" cellspacing="0" cellpadding="0" width="100%">
    <tr><td><h4><xsl:call-template name="m_title"/></h4></td>
        <td align="right"><xsl:value-of select="@version"/></td>
    </tr>
    </table>
  </xsl:otherwise>
  </xsl:choose>

  <div class="desc">
    <xsl:apply-templates select='node()[name(.)!="title"]'/>
  </div>
</xsl:template>

<xsl:template match="s1/title|s2/title|s3/title|s4/title"/>

<!--
   - Website-specific
  -->
<xsl:template match="website">
  <xsl:apply-templates select="node()"/>
</xsl:template>


<!--
   - TABLES
  -->

<!-- plain tables -->
<xsl:template match="table">
  <xsl:copy>
    <xsl:apply-templates select="node()|@*"/>
  </xsl:copy>
</xsl:template>

<!-- definition tables -->
<xsl:template match="deftable">
  <p/>
  <table width='90%' cellpadding=2 cellspacing=0 class=deftable border>
    <xsl:if test='@title'>
      <caption><font size="+1"><{@title}></font></caption>
    </xsl:if>
    <xsl:apply-templates/>
  </table>
</xsl:template>

<xsl:template match="table/tr|deftable/tr">
  <tr>
  <xsl:apply-templates select="@*|node()"/>
  </tr>
</xsl:template>

<xsl:template match="tr/th|tr/td">
  <xsl:copy>
  <xsl:apply-templates select="@*|node()"/>
  </xsl:copy>
</xsl:template>

<xsl:template match="table/caption">
  <xsl:copy>
  <xsl:apply-templates select="@*|node()"/>
  </xsl:copy>
</xsl:template>

<!--
   - LISTS
  -->

<!--
   - ul is an unordered list
  -->
<xsl:template match="ul">
  <ul>
  <xsl:apply-templates select="li"/>
  </ul>
</xsl:template>

<!--
   - ol is an ordered list
  -->
<xsl:template match="ol">
  <ol>
  <xsl:apply-templates select="li"/>
  </ol>
</xsl:template>

<!--
   - li is a list item
  -->
<xsl:template match="ul/li|ol/li">
  <li>
    <xsl:apply-templates select="node()"/>
  </li>
</xsl:template>

<!--
   - dl is a definition list
  -->
<xsl:template match="dl">
  <dl>
  <xsl:for-each select="dt|dd">
    <xsl:copy>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:for-each>
  </dl>
</xsl:template>

<!--
   - BOXES and FIGURES
  -->

<!--
   - figure is an image
  -->
<xsl:template match="figure">
  <center>
  <#
   String name = ((Element) node).getAttribute("src");
   PageContext page = (PageContext) out.getProperty("caucho.page.context");
   ServletContext cxt = page.getServletContext();
   String realPath = cxt.getRealPath("/images/" + name);

   com.caucho.graphics.Images img = null;
   // img = com.caucho.graphics.Images.getImage(realPath);

   out.pushElement("img");
   out.setAttribute("src", top + "images/" + name);
   if (img != null) {
     out.setAttribute("width", String.valueOf(img.getWidth()));
     out.setAttribute("height", String.valueOf(img.getHeight()));
   }
   out.popElement();
  #>
  </center>
</xsl:template>

<!--
   - <example>
  -->
<xsl:template match="example">
  <xsl:if test='not(@title)'>
    <p/>
  </xsl:if>
  <table class='egpad' cellspacing='0' width='90%'>
    <xsl:if test='@title'>
      <caption><font size="+1"><{@title}></font></caption>
    </xsl:if>

    <tr><td class="example" bgcolor="#ffeecc">
      <pre><xsl:apply-templates/></pre>
    </td></tr>
  </table>
</xsl:template>

<!--
   - <results>
  -->
<xsl:template match="results">
  <xsl:if test='not(@title)'>
    <p/>
  </xsl:if>
  <table class='egpad' cellspacing='0' width='90%'>
    <xsl:if test='@title'>
      <caption><font size="+1"><{@title}></font></caption>
    </xsl:if>

    <tr><td class="result" bgcolor="#ffccdd">
      <pre><xsl:apply-templates/></pre>
    </td></tr>
  </table>
</xsl:template>

<!--
   - <def>
  -->
<xsl:template match="def">
  <xsl:if test='not(@title)'>
    <p/>
  </xsl:if>
  <table class='egpad' cellspacing='0' width='90%'>
    <xsl:if test='@title'>
      <caption><font size="+1"><{@title}></font></caption>
    </xsl:if>

    <tr><td class="def" bgcolor="#cccccc">
      <pre><xsl:apply-templates/></pre>
    </td></tr>
  </table>
</xsl:template>

<xsl:template match="center">
  <xsl:copy>
  <xsl:apply-templates select="@*|node()"/>
  </xsl:copy>
</xsl:template>

<!--
   - <objsummary>
  -->

<#!
String href(String name)
{
  if (name == null)
    return null;

  CharBuffer cb = CharBuffer.allocate();
  for (int i = 0; i < name.length(); i++) {
    char ch = name.charAt(i);
    if (Character.isWhitespace(ch))
      cb.append("_");
    else
      cb.append(ch);
  }

  return cb.close();
}

void writeSummaryName(XslWriter out, Node node)
  throws IOException, SAXException
{
  Element elt = (Element) node;

  String name = elt.getAttribute("name");

  String title = elt.getAttribute("title");
  if (name.equals(""))
    name = title;

  if (title.equals(""))
    title = name;

  int p1 = title.indexOf('(');
  int p2 = title.lastIndexOf(')');

  String head = null;
  String tail = null;
  if (p1 < 0 || p1 < 0) {
    if (name.equals(""))
      name = elt.getAttribute("title");

    out.pushElement("a");
    out.setAttribute("href", "#" + href(name));
    out.print(title);
    out.popElement();
  }
  else if (p1 == 0) {
    out.pushElement("a");
    out.setAttribute("href", "#" + href(name));
    out.print(title.substring(p1 + 1, p2));
    out.popElement();
  }
  else {
    out.pushElement("a");
    out.setAttribute("href", "#" + href(name));
    out.print(title.substring(0, p1));
    out.popElement();
    out.print(title.substring(p1));
  }
}

void writeSummary(XslWriter out, Node node)
  throws IOException, SAXException
{

}
#>

<xsl:template match='node()' mode=objsummary/>
<xsl:template match='node()' mode=defunsummary/>

<xsl:template match='defun' mode=objsummary>
  <tr><td class=code width="40%">
  <# writeSummaryName(out, node); #>
  </td><td>
  <xsl:value-of select="substring-before(p[1],'.')"/>
  </td></tr>
</xsl:template>

<xsl:template match='objsummary'>
  <p/>
  <table border="1" cellpadding="3" cellspacing="0" width="100%">
  <tr class=section><td colspan="2">
    <font size="+2"><b><xsl:value-of select="if(@title,@title,'Index')"/></b></font>
  </td></tr>

  <xsl:apply-templates select='following::defun' mode=objsummary>
    <xsl:sort select="@title"/>
  </xsl:apply-templates>
  </table>
</xsl:template>

<!--
   - <summarylist>
  -->

<xsl:template match='text()|er()' mode=summarylist/>

<xsl:template match='s2|s3' mode=summarylist>
  <li><a>
         <xsl:attribute name='href'>#<xsl:value-of select="translate(if(@name,@name,@title),' ', '-'))"/></xsl:attribute>
         <{@title}></a>
  <xsl:if test='s2|s3'>
    <ol>
    <xsl:apply-templates mode=summarylist/>
    </ol>
  </xsl:if></li>
</xsl:template>

<xsl:template match='summarylist'>
  <center>
  <table width="90%" class=toc border=3>
  <tr><td>
    <ol>
    <xsl:apply-templates select='..' mode=summarylist/> 
    </ol></td>
  </tr>
  </table>
  </center>
</xsl:template>

<!--
   - INLINE FORMATTING
  -->

<!--
   - p is the main paragraph text
  -->
<xsl:template match="p">
  <p>
  <xsl:apply-templates select="node()"/>
  </p>
</xsl:template>

<!--
   - note adds a note
  -->
<xsl:template match="note">
  <p>
<b>Note: </b> <xsl:apply-templates/>
  </p>
</xsl:template>

<!--
   - blockquote
  -->
<xsl:template match="blockquote">
  <xsl:copy>
    <xsl:apply-templates/>
  </xsl:copy>
</xsl:template>

<!--
   - sidebar/callout
  -->
sidebar <<
<div class=side>
<table cellspacing=0 border=0 width='100%'>
$if (@title) <<
  <tr><th class=sidetitle>$(@title)</th></tr>
>>
<tr><td class=sidebody>
  $apply-templates();
</td></tr>
</table>
</div>
>>

<!--
   - br is a line breaksup/font/small is any code
  -->
<xsl:template match="br">
  <xsl:copy>
    <xsl:apply-templates/>
  </xsl:copy>
</xsl:template>

<!--
   - var is a variable name
  -->
<xsl:template match="var">
  <span class=meta><xsl:apply-templates/></span>
</xsl:template>

<!--
   - ct:img is an image
  -->
ct:img <#
   String name = ((Element) node).getAttribute("src");
   PageContext page = (PageContext) out.getProperty("caucho.page.context");
   ServletContext cxt = page.getServletContext();
   String realPath = cxt.getRealPath("/images/" + name);

   com.caucho.graphics.Images img = null;
   // img = com.caucho.graphics.Images.getImage(realPath);

   out.pushElement("img");
   out.setAttribute("src", top + "images/" + name);
   if (img != null) {
     out.setAttribute("width", String.valueOf(img.getWidth()));
     out.setAttribute("height", String.valueOf(img.getHeight()));
   }
   out.popElement();
#>

<!--
   - code is any code
  -->
<xsl:template match="code">
  <tt><xsl:apply-templates/></tt>
</xsl:template>

<!--
   - sup/font/small is any code
  -->
<xsl:template match="sup|font|small|em|b|jsp:expression|h3">
  <xsl:copy>
    <xsl:apply-templates select="node()|@*"/>
  </xsl:copy>
</xsl:template>

<!--
   - a[@href] is a link
  -->
<xsl:template match="a[@href]">
  <a href="{@href}">
    <xsl:apply-templates select="node()"/>
  </a>
</xsl:template>

</xsl:stylesheet>
