/*
 * Copyright (c) 1999-2000 Caucho Technology.  All rights reserved.
 *
 * Caucho Technology permits redistribution, modification and use
 * of this file in source and binary form ("the Software") under the
 * Caucho Public License ("the License").  In particular, the following
 * conditions must be met:
 *
 * 1. Each copy or derived work of the Software must preserve the copyright
 *    notice and this notice unmodified.
 *
 * 2. Redistributions of the Software in source or binary form must include 
 *    an unmodified copy of the License, normally in a plain ASCII text
 *
 * 3. The names "Resin" or "Caucho" are trademarks of Caucho Technology and
 *    may not be used to endorse products derived from this software.
 *    "Resin" or "Caucho" may not appear in the names of products derived
 *    from this software.
 *
 * 4. Caucho Technology requests that attribution be given to Resin
 *    in any manner possible.  We suggest using the "Resin Powered"
 *    button or creating a "powered by Resin(tm)" link to
 *    http://www.caucho.com for each page served by Resin.
 *
 * This Software is provided "AS IS," without a warranty of any kind. 
 * ALL EXPRESS OR IMPLIED REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED.

 * CAUCHO TECHNOLOGY AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE OR ANY THIRD PARTY AS A RESULT OF USING OR
 * DISTRIBUTING SOFTWARE. IN NO EVENT WILL Caucho OR ITS LICENSORS BE LIABLE
 * FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL,
 * CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND
 * REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR
 * INABILITY TO USE SOFTWARE, EVEN IF HE HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGES.      
 */

#include <stdlib.h>
#include <string.h>

typedef struct entry_t {
  char *name;
  int value;
} entry_t;

typedef struct int_map_t {
  int capacity;
  int mask;
  entry_t **entries;
} int_map_t;

int_map_t *
int_map_create()
{
  int_map_t *map = malloc(sizeof(int_map_t));
  
  map->capacity = 32;
  map->mask = map->capacity - 1;
  map->entries = malloc(map->capacity * sizeof(entry_t *));

  memset(map->entries, 0, map->capacity * sizeof(entry_t *));

  return map;
}

static int
int_map_hash(char *name)
{
  int hash = 61;
  int ch;

  for (; (ch = *name); name++) {
    if (ch >= 'A' && ch <= 'Z')
      ch += 'a' - 'A';
    
    hash = 53 * hash + *name;
  }

  return hash;
}

void
int_map_set(int_map_t *map, char *name, int value)
{
  int hash = int_map_hash(name) & map->mask;
  int i;

  for (i = 0; i < map->capacity; i++) {
    entry_t *entry = map->entries[hash];
    
    if (! entry || ! strcasecmp(entry->name, name)) {
      map->entries[hash] = malloc(sizeof(entry_t));
      map->entries[hash]->name = strdup(name);
      map->entries[hash]->value = value;
      return;
    }
    
    hash = (hash + 1) & map->mask;
  }
}

int
int_map_get(int_map_t *map, char *name)
{
  int hash = int_map_hash(name) & map->mask;
  int i;

  for (i = 0; i < map->capacity; i++) {
    entry_t *entry = map->entries[hash];
    
    if (entry && ! strcasecmp(entry->name, name))
      return entry->value;
    
    hash = (hash + 1) & map->mask;
  }

  return 0x80000000;
}
