/*
 * Copyright (c) 1998-2001 Caucho Technology -- all rights reserved
 *
 * Caucho Technology permits redistribution, modification and use
 * of this file in source and binary form ("the Software") under the
 * Caucho Developer Source License ("the License").  The following
 * conditions must be met:
 *
 * 1. Each copy or derived work of the Software must preserve the copyright
 *    notice and this notice unmodified.
 *
 * 2. Redistributions of the Software in source or binary form must include 
 *    an unmodified copy of the License, normally in a plain ASCII text
 *
 * 3. The names "Resin" or "Caucho" are trademarks of Caucho Technology and
 *    may not be used to endorse products derived from this software.
 *    "Resin" or "Caucho" may not appear in the names of products derived
 *    from this software.
 *
 * 4. Caucho Technology requests that attribution be given to Resin
 *    in any manner possible.  We suggest using the "Resin Powered"
 *    button or creating a "powered by Resin(tm)" link to
 *    http://www.caucho.com for each page served by Resin.
 *
 * This Software is provided "AS IS," without a warranty of any kind. 
 * ALL EXPRESS OR IMPLIED REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED.
 *
 * CAUCHO TECHNOLOGY AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE OR ANY THIRD PARTY AS A RESULT OF USING OR
 * DISTRIBUTING SOFTWARE. IN NO EVENT WILL CAUCHO OR ITS LICENSORS BE LIABLE
 * FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL,
 * CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND
 * REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR
 * INABILITY TO USE SOFTWARE, EVEN IF HE HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGES.      
 *
 * @author Scott Ferguson
 */

#include <linux/kernel.h>
#include <linux/tty.h>
#include <linux/in.h>

#include "hardcore.h"

#define SEG_STRING   1
#define SEG_METHOD   2
#define SEG_URL      3
#define SEG_PROTOCOL 4
#define SEG_LENGTH   5

static char log_buf[4096];
static char *log_end = log_buf + sizeof(buf);
static char *log_offset = log_buf;

static char buf[4096];

typedef struct segment_t {
  int code;

  char *data;
} segment_t;

static void
log_flush()
{
  log_offset = log_buf;
}

static void
log_segment(segment_t *segment, browser_t *browser)
{
  char *data;
  
  switch (segment->code) {
  case SEG_STRING:
    data = segment->data;
    break;

  case SEG_METHOD:
    data = browser->method;
    if (! data)
      data = "GET";
    break;

  case SEG_URL:
    data = browser->url;
    if (! data)
      data = "/bad-request";
    break;

  case SEG_PROTOCOL:
    data = browser->protocol;
    if (! data)
      data = "HTTP/0.9";
    break;

  case SEG_LENGTH:
    sprintf(buf, browser->request_length);
    data = buf;
    break;
    
  default:
    data = "";
  }
    
  for (; *data; data++) {
    if (log_offset == log_end)
      log_flush();

    *log_offset++ = *data;
  }
}
