/*
 * Copyright (c) 1998-2001 Caucho Technology -- all rights reserved
 *
 * Caucho Technology permits redistribution, modification and use
 * of this file in source and binary form ("the Software") under the
 * Caucho Developer Source License ("the License").  The following
 * conditions must be met:
 *
 * 1. Each copy or derived work of the Software must preserve the copyright
 *    notice and this notice unmodified.
 *
 * 2. Redistributions of the Software in source or binary form must include 
 *    an unmodified copy of the License, normally in a plain ASCII text
 *
 * 3. The names "Resin" or "Caucho" are trademarks of Caucho Technology and
 *    may not be used to endorse products derived from this software.
 *    "Resin" or "Caucho" may not appear in the names of products derived
 *    from this software.
 *
 * 4. Caucho Technology requests that attribution be given to Resin
 *    in any manner possible.  We suggest using the "Resin Powered"
 *    button or creating a "powered by Resin(tm)" link to
 *    http://www.caucho.com for each page served by Resin.
 *
 * This Software is provided "AS IS," without a warranty of any kind. 
 * ALL EXPRESS OR IMPLIED REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED.
 *
 * CAUCHO TECHNOLOGY AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE OR ANY THIRD PARTY AS A RESULT OF USING OR
 * DISTRIBUTING SOFTWARE. IN NO EVENT WILL CAUCHO OR ITS LICENSORS BE LIABLE
 * FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL,
 * CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND
 * REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR
 * INABILITY TO USE SOFTWARE, EVEN IF HE HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGES.      
 */

/*
 * Java classes should always be put in packages, even if you're just
 * experimenting.
 *
 * The package name matches the directory structure.  So this file
 * belongs in something like WEB-INF/classes/test/servlet/HelloServlet.java.
 */
package example.servlet.basic;
/*
 * java.io.* contains Java's standard I/O library.  The example uses
 * IOException and PrintWriter from java.io.
 */
import java.io.*;
/*
 * javax.servlet contains HTTP-independent servlet definitions.
 *
 * Since this trivial example doesn't use anything HTTP-specific, it
 * just uses classes in javax.servlet.  Most real servlets will also use
 * javax.servlet.http.
 */
import javax.servlet.*;

/**
 * Most servlets will extend HttpServlet and implement the doGet method.
 * Servlets which handle POST request will implement the doPost method.
 *
 * <p>Resin will map the calling URL to the servlet using the
 * &lt;servlet-mapping> configuration in the resin.conf or web.xml.
 *
 * <p>For example, this servlet could be called as 
 *Some may extend
 * GenericServlet.
 */
public class HelloServlet extends HttpServlet {
  public void doGet(HttpServletRequest request, HttpServletResponse response)
    throws IOException, ServletException
  {
    PrintWriter pw = response.getWriter();

    pw.println("Hello, World!");
  }
}
