#! /bin/sh
#
# iiopc.sh classname
#
# Stub compiler.
#
# Customized arguments, e.g. -resin_home or -java_home or -pid.
#
# -java_home <java_home> -- use a non-default Java home
# -native                -- force native threads
# -green                 -- force green threads
# -verbose               -- prints Java arguments before starting.
# -no-auto-restart       -- disable automatic server restart
#                        -- (this only appled to start and restart)
#
# Extra arguments to Java.  If you're passing arguments to the JVM, you'll
# need to use -Jxxx.  For example, -J-ms48m.
#
args=
#
# class to start
#
class=com.caucho.iiop.IiopStubCompiler
#
# name of the server
#
name=jspc
#
# location of perl executable
#
perl=perl

#
# trace script and simlinks to find thw wrapper
#
script=`/bin/ls -l $0 | awk '{ print $NF; }'`

while test -h "$script"
do
  script=`/bin/ls -l $script | awk '{ print $NF; }'`
done

bin=`dirname $script`

exec $perl $bin/wrapper.pl -chdir -name "$name" -class "$class" $args $*
