/*
 * Copyright (c) 1998-2001 Caucho Technology -- all rights reserved
 *
 * Caucho Technology permits redistribution, modification and use
 * of this file in source and binary form ("the Software") under the
 * Caucho Developer Source License ("the License").  The following
 * conditions must be met:
 *
 * 1. Each copy or derived work of the Software must preserve the copyright
 *    notice and this notice unmodified.
 *
 * 2. Redistributions of the Software in source or binary form must include 
 *    an unmodified copy of the License, normally in a plain ASCII text
 *
 * 3. The names "Resin" or "Caucho" are trademarks of Caucho Technology and
 *    may not be used to endorse products derived from this software.
 *    "Resin" or "Caucho" may not appear in the names of products derived
 *    from this software.
 *
 * This Software is provided "AS IS," without a warranty of any kind. 
 * ALL EXPRESS OR IMPLIED REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED.
 *
 * CAUCHO TECHNOLOGY AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE OR ANY THIRD PARTY AS A RESULT OF USING OR
 * DISTRIBUTING SOFTWARE. IN NO EVENT WILL CAUCHO OR ITS LICENSORS BE LIABLE
 * FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL,
 * CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND
 * REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR
 * INABILITY TO USE SOFTWARE, EVEN IF HE HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGES.      
 */

/*
 * Java classes should always be put in packages, even if you're just
 * experimenting.
 *
 * The package name matches the directory structure.  So this file
 * belongs in something like WEB-INF/classes/test/servlet/HelloServlet.java.
 */
package example.servlet.basic;
/*
 * java.io.* contains Java's standard I/O library.  The example uses
 * IOException and PrintWriter from java.io.
 */
import java.io.*;
/*
 * javax.servlet contains HTTP-independent servlet definitions.  This example
 * uses ServletException from javax.servlet.
 */
import javax.servlet.*;
/*
 * javax.servlet.http contains HTTP servlet definitions.  This example uses
 * HttpServletRequest and HttpServletResponse from javax.servlet.http.
 */
import javax.servlet.http.*;

/**
 * Introduces servlets with the hello, world example.
 *
 * <p>Most servlets will extend HttpServlet and implement the doGet method.
 * Servlets which handle POST request will implement the doPost method.
 *
 * <p>Resin maps the calling URL to the servlet using the
 * &lt;servlet-mapping> configuration in the resin.conf or web.xml.
 *
 * <p>For example, this servlet is called with the URL
 * /tutorial/servlet/example.servlet.basic.HelloServlet.  That mapping
 * is configured in the doc/tutorial/WEB-INF/web.xml with the special
 * "invoker" servlet:
 *
 * <code><pre>
 * &lt;servlet-mapping>
 *   &lt;url-pattern>/servlet/*&lt;/url-pattern>
 *   &lt;servlet-name>invoker&lt;/servlet-name>
 * &lt;/servlet-mapping>
 * </pre></code>
 *
 * <p>Every URL matching /servlet/* will use the invoker.  The invoker
 * finds the classname "example.servlet.basic.HelloServlet" following
 * the /servlet, instantiates it and sends it the request.
 *
 * <p>This servlet belongs in
 * WEB-INF/classes/example/servlet/basic/HelloServlet.java.  In the standard
 * Resin installation, it will be something like
 * resin-2.0.2/doc/java_tut/WEB-INF/...
 *
 * <p>When the servlet .java file is changed, Resin will automatically
 * recompile it.  It's a good idea to go to the HelloServlet.java and
 * modify it (change the string to "Hi, World"), to get the basic idea.
 */
public class HelloServlet extends HttpServlet {
  /**
   * Handles GET requests.  Resin will call the doGet method when
   * the browser sends a GET request.
   *
   * @param request the request object contains the data from
   * the browser's request.
   * @param response the response object contains methods to send
   * data back to the browser.
   */
  public void doGet(HttpServletRequest request, HttpServletResponse response)
    throws IOException, ServletException
  {
    // Get a PrintWriter from the response object so we can send some data.
    PrintWriter out = response.getWriter();

    // Write the hello, world text.
    out.println("Hello, World!");
  }
}
