/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

class MultiList
extends Panel
implements Serializable,
ItemSelectable {
    Instabase parent;
    public static final long CLICKTHRESHOLD = 250L;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    protected static final int BORDER = 1;
    protected static final int RESIZE_FUDGE_FACTOR = 3;
    private static boolean isWindows95 = false;
    private static boolean isWindowsNT = false;
    private static boolean isMacintosh = false;
    private static boolean isSolaris = false;
    private static boolean isCaseSensitive = false;
    static Color thirtyThreePercentGray;
    static Color sixtySixPercentGray;
    protected Color colorBg = Color.white;
    protected Color colorFg = Color.black;
    protected Color colorHBg = MultiList.isMacintosh() ? new Color(0, 0, 128) : SystemColor.textHighlight;
    protected Color colorHFg = MultiList.isMacintosh() ? Color.white : SystemColor.textHighlightText;
    protected Color headingBg = Color.lightGray;
    protected Color headingFg = Color.black;
    protected boolean allowSorting = true;
    protected boolean focusIndicatedVisually = true;
    protected boolean multiSelect = false;
    protected boolean allowResizingOfColumns = true;
    protected String[] headings;
    protected boolean headingVisible = true;
    protected int headingHeight = 0;
    protected Font headingFont;
    protected int[] splitters;
    protected int[] columnAlignments;
    protected int defaultColumnAlignment = 0;
    protected int[] columnSizes = null;
    protected int columnClicked = -1;
    protected int lastColumnClicked = -1;
    protected int memoryClick = -1;
    protected int selectedRow = -1;
    protected BitSet highlightedRows = new BitSet();
    protected Matrix cells;
    protected Font cellFont;
    protected int cellHeight = 0;
    protected int cellAscent = 0;
    protected int cellDescent = 0;
    protected int topRow;
    protected int cachedHeight = -1;
    protected int cachedWidth = -1;
    protected int cachedLastSplitter = -1;
    protected int dragColumn = -1;
    protected int xDragLast = -1;
    protected int sbVPosition = 0;
    protected int sbHPosition = 0;
    protected int verticalScrollbarWidth = 0;
    protected int scrollbarHeight = 0;
    protected int hScrollbarLineIncrement = 4;
    protected int minColumnWidth = 10;
    protected transient long clickTime = 0L;
    protected String actionCommand = "RowSelected:";
    protected Scrollbar verticalScrollbar;
    protected Scrollbar horizontalScrollbar;
    protected CompareCells defaultColumnSorter = new CompareTextAndImageCells();
    protected Hashtable columnCompareCellsRoutines = new Hashtable();
    protected ActionListener actionListener = null;
    protected ItemListener itemListener = null;
    protected FocusListener focusListener = null;
    private Mouse mouse = null;
    private MouseMotion mouseMotion = null;
    private Key key = null;
    private Adjustment adjustment = null;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    protected transient boolean isDragging = false;
    protected transient boolean clickedInHeadings = false;
    protected transient boolean sbVShow = false;
    protected transient boolean sbHShow = false;
    protected transient boolean forceRedraw = false;
    protected transient boolean forceColumnSizeRecalc = false;
    protected transient boolean forceFullRedraw = false;
    protected transient boolean isSuppressRedraw = false;
    protected transient boolean redrawWasSupressed = false;
    protected transient boolean hasFocus = false;
    protected transient Image offscreenImage = null;
    protected transient Graphics offscreenImageGraphics = null;
    protected static boolean isSun1_1;

    public MultiList(Instabase instabase) {
        this(instabase, 0, false, Color.white);
    }

    public MultiList(Instabase instabase, int n) {
        this(instabase, n, false, Color.white);
    }

    public MultiList(Instabase instabase, int n, boolean bl) {
        this(instabase, n, bl, Color.white);
    }

    public MultiList(Instabase instabase, int n, boolean bl, Color color) {
        this.parent = instabase;
        this.cells = new Matrix(this.parent);
        this.internalCreateColumns(n);
        this.multiSelect = bl;
        super.setLayout(null);
        Font font = new Font("SansSerif", 0, 12);
        try {
            this.setHeadingFont(font);
            this.setCellFont(font);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.colorBg = color;
        this.setBackground(this.colorBg);
        this.verticalScrollbar = new Scrollbar(1);
        this.verticalScrollbar.setVisible(false);
        this.add(this.verticalScrollbar);
        this.horizontalScrollbar = new Scrollbar(0);
        this.horizontalScrollbar.setVisible(false);
        this.add(this.horizontalScrollbar);
    }

    public boolean isMultipleMode() {
        return this.multiSelect;
    }

    public int getNumberOfCols() {
        return this.headings.length;
    }

    public int getNumberOfRows() {
        return this.cells.rows();
    }

    public void setHeadingVisible(boolean bl) throws PropertyVetoException {
        if (this.headingVisible != bl) {
            Boolean bl2 = new Boolean(this.headingVisible);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("headingVisible", bl2, bl3);
            this.headingVisible = bl;
            this.changes.firePropertyChange("headingVisible", bl2, bl3);
            if (this.headingVisible) {
                this.calculateHeadingHeight();
            } else {
                this.headingHeight = 0;
            }
            this.forceFullRedraw = true;
            this.triggerRedraw();
        }
    }

    public boolean isHeadingVisible() {
        return this.headingVisible;
    }

    public String getHeading(int n) {
        return this.headings[n];
    }

    public static boolean objectsEqual(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public static boolean isWindows() {
        return MultiList.isWindows95() || MultiList.isWindowsNT();
    }

    public static boolean isWindows95() {
        return isWindows95;
    }

    public static boolean isWindowsNT() {
        return isWindowsNT;
    }

    public static boolean isMacintosh() {
        return isMacintosh;
    }

    public static boolean isSolaris() {
        return isSolaris;
    }

    public static boolean isCaseSensitive() {
        return isCaseSensitive;
    }

    public void setHeading(String string, int n) throws PropertyVetoException {
        String string2 = this.headings[n];
        if (!MultiList.objectsEqual(string2, string)) {
            String string3 = string;
            this.vetos.fireVetoableChange("heading", string2, string3);
            this.headings[n] = string;
            this.changes.firePropertyChange("heading", string2, string3);
            this.triggerRedraw();
        }
    }

    public void setHeading(String string, int n, int n2) throws PropertyVetoException {
    }

    public String[] getHeadings() {
        return this.headings;
    }

    public void setHeadings(String[] stringArray) throws PropertyVetoException {
        boolean bl = this.setSupressRedraw(true);
        try {
            stringArray = this.tokenizeStringArrayIfNeeded(stringArray);
            String[] stringArray2 = this.getHeadings();
            this.vetos.fireVetoableChange("headings", stringArray2, stringArray);
            if (stringArray.length == 0) {
                this.internalCreateColumns(0);
            } else {
                this.calcHeadings(stringArray);
            }
            this.changes.firePropertyChange("headings", stringArray2, stringArray);
            Object var5_4 = null;
            this.forceColumnSizeRecalc = true;
            this.triggerRedraw();
            this.setSupressRedraw(bl);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.forceColumnSizeRecalc = true;
            this.triggerRedraw();
            this.setSupressRedraw(bl);
            throw throwable;
        }
    }

    public Font getHeadingFont() {
        return this.headingFont;
    }

    public void setHeadingFont(Font font) throws PropertyVetoException {
        if (!MultiList.objectsEqual(this.headingFont, font)) {
            Font font2 = this.getHeadingFont();
            this.vetos.fireVetoableChange("headingFont", font2, font);
            this.headingFont = font;
            this.changes.firePropertyChange("headingFont", font2, font);
            if (this.headingVisible) {
                this.calculateHeadingHeight();
                this.triggerRedraw();
            }
        }
    }

    public Font getCellFont() {
        return this.cellFont;
    }

    public void setCellFont(Font font) throws PropertyVetoException {
        if (!MultiList.objectsEqual(this.cellFont, font)) {
            Font font2 = this.cellFont;
            this.vetos.fireVetoableChange("cellFont", font2, font);
            this.cellFont = font;
            FontMetrics fontMetrics = this.getFontMetrics(font);
            this.cellAscent = fontMetrics.getAscent();
            this.cellDescent = fontMetrics.getDescent();
            this.cellHeight = fontMetrics.getHeight();
            this.changes.firePropertyChange("cellFont", font2, font);
            this.triggerRedraw();
        }
    }

    public void setHeadingColors(Color color, Color color2) throws PropertyVetoException {
        boolean bl = this.setSupressRedraw(true);
        try {
            this.setHeadingFg(color);
            this.setHeadingBg(color2);
            Object var5_4 = null;
            this.triggerRedraw();
            this.setSupressRedraw(bl);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.triggerRedraw();
            this.setSupressRedraw(bl);
            throw throwable;
        }
    }

    public Color getHeadingFg() {
        return this.headingFg;
    }

    public void setHeadingFg(Color color) throws PropertyVetoException {
        if (!MultiList.objectsEqual(this.headingFg, color)) {
            Color color2 = this.headingFg;
            this.vetos.fireVetoableChange("headingFg", color2, color);
            this.headingFg = color;
            this.changes.firePropertyChange("headingFg", color2, color);
            this.triggerRedraw();
        }
    }

    public Color getHeadingBg() {
        return this.headingBg;
    }

    public void setHeadingBg(Color color) throws PropertyVetoException {
        if (!MultiList.objectsEqual(this.headingBg, color)) {
            Color color2 = this.headingBg;
            this.vetos.fireVetoableChange("headingBg", color2, color);
            this.headingBg = color;
            this.changes.firePropertyChange("headingBg", color2, color);
            this.triggerRedraw();
        }
    }

    public void setCellColors(Color color, Color color2) throws PropertyVetoException {
        boolean bl = this.setSupressRedraw(true);
        try {
            this.setCellFg(color);
            this.setCellBg(color2);
            Object var5_4 = null;
            this.triggerRedraw();
            this.setSupressRedraw(bl);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.triggerRedraw();
            this.setSupressRedraw(bl);
            throw throwable;
        }
    }

    public Color getCellFg() {
        return this.colorFg;
    }

    public void setCellFg(Color color) throws PropertyVetoException {
        if (!MultiList.objectsEqual(this.colorFg, color)) {
            Color color2 = this.colorFg;
            this.vetos.fireVetoableChange("cellFg", color2, color);
            this.colorFg = color;
            this.changes.firePropertyChange("cellFg", color2, color);
            this.triggerRedraw();
        }
    }

    public void setCellBg(Color color) throws PropertyVetoException {
        if (!MultiList.objectsEqual(this.colorBg, color)) {
            Color color2 = this.colorBg;
            this.vetos.fireVetoableChange("cellBg", color2, color);
            this.colorBg = color;
            this.changes.firePropertyChange("cellBg", color2, color);
            this.triggerRedraw();
        }
    }

    public Color getCellBg() {
        return this.colorBg;
    }

    public void setColumnAlignments(String[] stringArray) throws PropertyVetoException {
        if (stringArray != null && stringArray.length == 0) {
            stringArray = null;
        }
        stringArray = this.tokenizeStringArrayIfNeeded(stringArray);
        String[] stringArray2 = this.getColumnAlignments();
        this.vetos.fireVetoableChange("columnAlignments", stringArray2, stringArray);
        if (stringArray != null) {
            this.columnAlignments = new int[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                int n2 = this.defaultColumnAlignment;
                if (string != null) {
                    if (string.equalsIgnoreCase("Left")) {
                        n2 = 0;
                    } else if (string.equalsIgnoreCase("Center")) {
                        n2 = 1;
                    } else if (string.equalsIgnoreCase("Right")) {
                        n2 = 2;
                    }
                }
                this.columnAlignments[n] = n2;
                ++n;
            }
        } else {
            this.columnAlignments = null;
        }
        this.changes.firePropertyChange("columnAlignments", stringArray2, stringArray);
        this.triggerRedraw();
    }

    public String[] getColumnAlignments() {
        if (this.columnAlignments == null) {
            return null;
        }
        String[] stringArray = new String[this.columnAlignments.length];
        int n = 0;
        while (n < stringArray.length) {
            String string;
            switch (this.getColumnAlignment(n)) {
                default: {
                    string = "Left";
                    break;
                }
                case 1: {
                    string = "Center";
                    break;
                }
                case 2: {
                    string = "Right";
                }
            }
            stringArray[n] = string;
            ++n;
        }
        return stringArray;
    }

    public void setColumnAlignment(int n, int n2) throws PropertyVetoException {
        this.rangeCheckAlignment(n2);
        this.rangeCheckColumn(n);
        Integer n3 = new Integer(this.getColumnAlignment(n));
        Integer n4 = new Integer(n2);
        this.vetos.fireVetoableChange("columnAlignment", n3, n4);
        if (this.columnAlignments == null) {
            this.columnAlignments = new int[this.headings.length];
            int n5 = 0;
            while (n5 < this.headings.length) {
                this.columnAlignments[n5] = -1;
                ++n5;
            }
        }
        this.columnAlignments[n] = n2;
        this.changes.firePropertyChange("columnAlignment", n3, n4);
        this.triggerRedraw();
    }

    public int getColumnAlignment(int n) {
        int n2;
        if (this.columnAlignments != null && n < this.columnAlignments.length && (n2 = this.columnAlignments[n]) != -1) {
            return this.columnAlignments[n];
        }
        return this.getDefaultColumnAlignment();
    }

    public int getDefaultColumnAlignment() {
        return this.defaultColumnAlignment;
    }

    public void setDefaultColumnAlignment(int n) throws PropertyVetoException {
        this.rangeCheckAlignment(n);
        if (this.defaultColumnAlignment != n) {
            Integer n2 = new Integer(this.defaultColumnAlignment);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("defaultColumnAlignment", n2, n3);
            this.defaultColumnAlignment = n;
            this.changes.firePropertyChange("defaultColumnAlignment", n2, n3);
            this.triggerRedraw();
        }
    }

    public void setColumnSizes(String[] stringArray) throws PropertyVetoException {
        boolean bl = this.setSupressRedraw(true);
        try {
            if (stringArray != null && stringArray.length == 0) {
                stringArray = null;
            }
            stringArray = this.tokenizeStringArrayIfNeeded(stringArray);
            String[] stringArray2 = this.getColumnSizes();
            this.vetos.fireVetoableChange("columnSizes", stringArray2, stringArray);
            if (stringArray != null) {
                this.columnSizes = new int[stringArray.length];
                int n = 0;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    int n3 = 10;
                    try {
                        String string = stringArray[n2];
                        if (string != null) {
                            n3 = Integer.parseInt(string);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.columnSizes[n2] = n3;
                    if (this.splitters.length > n2 + 1) {
                        this.splitters[n2 + 1] = n += this.columnSizes[n2];
                    }
                    ++n2;
                }
                if (this.splitters.length > 1) {
                    this.splitters[0] = 0;
                }
            } else {
                this.columnSizes = null;
                this.adjustHeadings();
            }
            this.changes.firePropertyChange("columnSizes", stringArray2, stringArray);
            Object var9_9 = null;
            this.triggerRedraw();
            this.setSupressRedraw(bl);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.triggerRedraw();
            this.setSupressRedraw(bl);
            throw throwable;
        }
    }

    public String[] getColumnSizes() {
        return this.intArrayToStringArray(this.columnSizes);
    }

    public int getColumnSize(int n) {
        return this.splitters[n + 1];
    }

    public void setSelectedRow(int n) throws IllegalArgumentException {
        if (n < 0 || n > this.cells.rows() - 1) {
            // empty if block
        }
        this.selectRow(n);
    }

    public int getSelectedRow() {
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 1) {
            return nArray[0];
        }
        return -1;
    }

    public int[] getSelectedRows() {
        int n = this.highlightedRows.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (this.highlightedRows.get(n3)) {
                ++n2;
            }
            ++n3;
        }
        int[] nArray = new int[n2];
        n2 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (this.highlightedRows.get(n4)) {
                nArray[n2++] = n4;
            }
            ++n4;
        }
        return nArray;
    }

    public Object[] getSelectedObjects() {
        int[] nArray = this.getSelectedRows();
        int n = nArray.length;
        Object[] objectArray = new Integer[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = new Integer(nArray[n2]);
            ++n2;
        }
        return objectArray;
    }

    public void setMinColumnWidth(int n) throws PropertyVetoException {
        if (this.minColumnWidth != n && n > 0) {
            Integer n2 = new Integer(this.minColumnWidth);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("minColumnWidth", n2, n3);
            this.minColumnWidth = n;
            this.changes.firePropertyChange("minColumnWidth", n2, n3);
        }
    }

    public boolean setSupressRedraw(boolean bl) {
        boolean bl2 = this.isSuppressRedraw;
        this.isSuppressRedraw = bl;
        if (this.isSuppressRedraw != bl2 && !this.isSuppressRedraw && this.redrawWasSupressed) {
            this.redrawWasSupressed = false;
            this.triggerRedraw();
        }
        return bl2;
    }

    protected void resizeHeadings(int n) {
        if (n == this.headings.length) {
            return;
        }
        int n2 = n - this.headings.length;
        String[] stringArray = new String[this.headings.length + n2];
        int[] nArray = new int[stringArray.length + 1];
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (n3 < this.headings.length) {
                stringArray[n3] = this.headings[n3];
                nArray[n3 + 1] = this.splitters[n3 + 1];
            } else {
                stringArray[n3] = "Column " + (n3 + 1);
                nArray[n3 + 1] = nArray[n3] + this.getMinColumnWidth();
            }
            ++n3;
        }
        this.headings = stringArray;
        this.splitters = nArray;
        if (this.columnSizes == null) {
            this.forceColumnSizeRecalc = true;
        }
    }

    public void setListItems(String[] stringArray) throws PropertyVetoException {
        boolean bl = this.setSupressRedraw(true);
        try {
            this.clear();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                if (string == null) {
                    string = "";
                }
                int n2 = string.length();
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                while (n5 <= n2) {
                    if (n5 == n2 || string.charAt(n5) == ';') {
                        this.addCell(n, n4++, string.substring(n3, n5), null);
                        n3 = n5 + 1;
                        if (n4 > this.headings.length) {
                            this.resizeHeadings(n4);
                        }
                    }
                    ++n5;
                }
                while (n4 < this.headings.length) {
                    this.addCell(n, n4++, "", null);
                }
                ++n;
            }
            Object var10_9 = null;
            this.triggerRedraw();
            this.setSupressRedraw(bl);
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.triggerRedraw();
            this.setSupressRedraw(bl);
            throw throwable;
        }
    }

    public String[] getListItems() {
        Vector vector = new Vector();
        boolean bl = false;
        String[] stringArray = new String[this.cells.rows()];
        int n = 0;
        while (n < this.cells.rows()) {
            String string = "";
            int n2 = 0;
            while (n2 < this.headings.length) {
                String string2 = this.getCellText(n, n2);
                if (n2 != 0) {
                    string = string + ";";
                }
                string = string + (string2 != null ? string2 : "");
                ++n2;
            }
            stringArray[n] = string;
            ++n;
        }
        return stringArray;
    }

    public void setAllowSorting(boolean bl) throws PropertyVetoException {
        if (this.allowSorting != bl) {
            Boolean bl2 = new Boolean(this.allowSorting);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("allowSorting", bl2, bl3);
            this.allowSorting = bl;
            this.changes.firePropertyChange("allowSorting", bl2, bl3);
        }
    }

    public boolean isAllowSorting() {
        return this.allowSorting;
    }

    public void setAllowResizingOfColumns(boolean bl) throws PropertyVetoException {
        if (this.allowResizingOfColumns != bl) {
            Boolean bl2 = new Boolean(this.allowResizingOfColumns);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("allowResizingOfColumns", bl2, bl3);
            this.allowResizingOfColumns = bl;
            this.changes.firePropertyChange("allowResizingOfColumns", bl2, bl3);
        }
    }

    public boolean isAllowResizingOfColumns() {
        return this.allowResizingOfColumns;
    }

    public int getMinColumnWidth() {
        return this.minColumnWidth;
    }

    public void adjustHeadings() {
        if (this.headings.length == 0) {
            this.internalCreateColumns(0);
            this.triggerRedraw();
        } else {
            Dimension dimension = this.size();
            int n = 0;
            int n2 = (dimension.width - this.verticalScrollbarWidth) / this.headings.length;
            int n3 = dimension.width - this.verticalScrollbarWidth - this.headings.length * n2;
            this.splitters[0] = 0;
            int n4 = 0;
            while (n4 < this.headings.length) {
                this.splitters[n4 + 1] = n += n2 + (n4 < n3 ? 1 : 0);
                ++n4;
            }
        }
    }

    public void createColumns(int n) {
        this.internalCreateColumns(n);
        this.triggerRedraw();
    }

    protected void internalCreateColumns(int n) {
        this.headings = new String[n];
        this.splitters = new int[n + 1];
        this.columnAlignments = null;
        this.columnSizes = null;
    }

    public void clear() {
        this.cells.removeAllElements();
        this.xDragLast = -1;
        this.isDragging = false;
        this.selectedRow = -1;
        this.highlightedRows = new BitSet();
        this.topRow = 0;
        this.sbVPosition = 0;
        this.triggerRedraw();
    }

    public CompareCells getColumnSorter(int n) {
        CompareCells compareCells = (CompareCells)this.columnCompareCellsRoutines.get(new Integer(n));
        if (compareCells == null) {
            compareCells = this.getDefaultColumnSorter();
        }
        return compareCells;
    }

    public void setColumnSorter(int n, CompareCells compareCells) {
        this.columnCompareCellsRoutines.put(new Integer(n), compareCells);
    }

    public CompareCells getDefaultColumnSorter() {
        return this.defaultColumnSorter;
    }

    public void setDefaultColumnSorter(CompareCells compareCells) {
        this.defaultColumnSorter = compareCells;
    }

    public void addCell(int n, int n2, String string, Image image) {
        TextAndImageCell textAndImageCell = new TextAndImageCell(this, string, image);
        this.addCellImpl(n, n2, textAndImageCell);
    }

    public void addCell(int n, int n2, TextAndImageCell textAndImageCell) {
        this.addCellImpl(n, n2, textAndImageCell);
    }

    protected void addCellImpl(int n, int n2, TextAndImageCell textAndImageCell) {
        this.cells.updateElement(n, n2, textAndImageCell);
        this.triggerRedraw();
    }

    public String getCellText(int n, int n2) {
        try {
            TextAndImageCell textAndImageCell = (TextAndImageCell)this.cells.elementAt(n, n2);
            if (textAndImageCell != null) {
                return textAndImageCell.getText();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return "";
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.offscreenImage == null) {
            this.redraw();
        }
        if (this.offscreenImage != null) {
            Font font = graphics.getFont();
            if (font == null) {
                font = this.headingFont;
                this.setFont(font);
                return;
            }
            Dimension dimension = this.size();
            if (this.cachedWidth != dimension.width || this.cachedHeight != dimension.height || this.forceRedraw) {
                this.redraw();
            }
            int n = dimension.height - this.scrollbarHeight;
            int n2 = dimension.width - this.verticalScrollbarWidth;
            graphics.translate(-this.sbHPosition, 0);
            if (this.sbVShow && this.sbHShow) {
                graphics.setColor(Color.lightGray);
                graphics.fillRect(this.sbHPosition + n2, n, this.verticalScrollbarWidth, this.scrollbarHeight);
                graphics.setColor(Color.black);
                graphics.drawRect(this.sbHPosition + n2 - 1, n - 1, this.verticalScrollbarWidth, this.scrollbarHeight);
            }
            graphics.clipRect(this.sbHPosition, 0, n2, n);
            graphics.drawImage(this.offscreenImage, 0, 0, this);
            graphics.setColor(Color.black);
            graphics.drawRect(this.sbHPosition, 0, n2 - 1, n - 1);
        }
    }

    protected void rangeCheckColumn(int n) {
    }

    protected void rangeCheckAlignment(int n) {
        if (n == 0 || n == 1 || n != 2) {
            // empty if block
        }
    }

    protected void calcVerticalScrollbarPosition(boolean bl) {
        Dimension dimension = this.size();
        if (this.cells.rows() * this.cellHeight > dimension.height - this.headingHeight - 1 - (this.headingHeight > 0 ? 0 : 1) - (bl ? this.scrollbarHeight : 0)) {
            this.sbVShow = true;
            this.verticalScrollbarWidth = this.verticalScrollbar.preferredSize().width - 1;
        } else {
            this.sbVShow = false;
            this.verticalScrollbarWidth = 0;
        }
        if (this.columnSizes == null && (this.forceColumnSizeRecalc || this.cachedWidth != dimension.width - this.verticalScrollbarWidth)) {
            this.adjustHeadings();
        }
        this.forceColumnSizeRecalc = false;
    }

    public void redraw() {
        Dimension dimension = this.size();
        this.forceRedraw = false;
        if (dimension.width == 0 || dimension.height == 0) {
            return;
        }
        boolean bl = this.isSuppressRedraw;
        this.isSuppressRedraw = true;
        try {
            this.calcVerticalScrollbarPosition(false);
            Object var4_3 = null;
            this.isSuppressRedraw = bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.isSuppressRedraw = bl;
            throw throwable;
        }
        int n = this.splitters[this.splitters.length - 1];
        if (n > dimension.width - this.verticalScrollbarWidth) {
            this.sbHShow = true;
            this.scrollbarHeight = this.horizontalScrollbar.preferredSize().height - 1;
            bl = this.isSuppressRedraw;
            this.isSuppressRedraw = true;
            try {
                this.calcVerticalScrollbarPosition(true);
                Object var6_7 = null;
                this.isSuppressRedraw = bl;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.isSuppressRedraw = bl;
                throw throwable;
            }
        } else {
            this.sbHShow = false;
            this.scrollbarHeight = 0;
        }
        if (!this.sbVShow) {
            this.sbVPosition = 0;
        }
        if (!this.sbHShow) {
            this.sbHPosition = 0;
        }
        int n2 = Math.max(n, dimension.width + this.sbHPosition);
        if (this.offscreenImage == null || this.offscreenImageGraphics == null || this.cachedWidth != n2 || this.cachedHeight != dimension.height || this.cachedLastSplitter != n || this.offscreenImage.getWidth(this) != n2 || this.forceFullRedraw) {
            this.forceFullRedraw = false;
            if (this.offscreenImage != null) {
                this.offscreenImage.flush();
                this.offscreenImage = null;
            }
            this.offscreenImage = this.createImage(n2, dimension.height);
            this.cachedWidth = dimension.width;
            this.cachedHeight = dimension.height;
            this.cachedLastSplitter = n;
            if (this.offscreenImageGraphics != null) {
                this.offscreenImageGraphics.dispose();
                this.offscreenImageGraphics = null;
            }
            if (this.offscreenImage != null) {
                this.offscreenImageGraphics = this.offscreenImage.getGraphics();
            }
        }
        if (this.offscreenImageGraphics != null) {
            this.offscreenImageGraphics.setColor(this.colorBg);
            this.offscreenImageGraphics.fillRect(0, 0, this.offscreenImage.getWidth(this), dimension.height);
        }
        n2 = this.cells.rows();
        if (this.sbVShow) {
            int n3 = this.getNumVisibleRows();
            this.verticalScrollbar.reshape(dimension.width - this.verticalScrollbarWidth, 0, this.verticalScrollbarWidth, dimension.height - this.scrollbarHeight);
            this.verticalScrollbar.setValues(this.sbVPosition, n3, 0, n2 - (isSun1_1 ? 0 : n3));
            this.verticalScrollbar.setPageIncrement(n3 - 1);
            this.verticalScrollbar.setVisible(true);
        } else {
            this.topRow = 0;
            this.verticalScrollbar.setVisible(false);
        }
        if (this.sbHShow) {
            this.horizontalScrollbar.reshape(0, dimension.height - this.scrollbarHeight, dimension.width - this.verticalScrollbarWidth, this.scrollbarHeight);
            this.horizontalScrollbar.setValues(this.sbHPosition, dimension.width - this.verticalScrollbarWidth, 0, n - (isSun1_1 ? 0 : dimension.width - this.verticalScrollbarWidth));
            this.horizontalScrollbar.setPageIncrement(dimension.width - this.verticalScrollbarWidth);
            this.horizontalScrollbar.setLineIncrement(this.hScrollbarLineIncrement);
            this.horizontalScrollbar.setVisible(true);
        } else {
            this.horizontalScrollbar.setVisible(false);
        }
        if (this.offscreenImageGraphics != null && this.headings.length > 0) {
            int n4;
            this.drawHeading(false);
            if (n > 0) {
                this.offscreenImageGraphics.clipRect(0, 0, n, dimension.height);
            }
            int n5 = n4 = this.cellHeight > 0 ? this.getNumVisibleRows() : 0;
            if (n4 > n2) {
                n4 = n2;
            }
            this.offscreenImageGraphics.setFont(this.cellFont);
            this.drawRows(this.topRow, n4, false);
        }
    }

    public void changeSelection(int n, int n2) {
        int[] nArray;
        int n3;
        boolean bl = this.setSupressRedraw(true);
        try {
            block11: {
                n3 = this.getNumberOfRows();
                if (n < n3 && n > -1) break block9;
                nArray = this.getSelectedRows();
                if (!this.multiSelect) break block10;
                if ((n2 & 1) == 1) break block11;
                if ((n2 & 2) != 2) break block12;
            }
            Object var7_6 = null;
            this.triggerRedraw();
            this.setSupressRedraw(bl);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.triggerRedraw();
            this.setSupressRedraw(bl);
            throw throwable;
        }
        {
            block10: {
                block12: {
                    return;
                }
                this.deselectEvent(n, nArray);
            }
            this.highlightedRows = new BitSet();
            this.paintSelection(nArray);
            this.repaint();
        }
        Object var7_7 = null;
        this.triggerRedraw();
        this.setSupressRedraw(bl);
        {
            block9: {
                return;
            }
            this.singleSel(n, n2);
            if (n < this.topRow) {
                this.topRow = n;
                if (this.topRow < 0) {
                    this.topRow = 0;
                }
                this.sbVPosition = this.topRow;
                this.verticalScrollbar.setValue(this.sbVPosition);
                this.triggerRedraw();
            }
            if (n - this.topRow + 1 > this.getNumVisibleRows()) {
                ++this.topRow;
                if (this.topRow > n3 - 1) {
                    this.topRow = n;
                }
                this.sbVPosition = this.topRow;
                this.verticalScrollbar.setValue(this.sbVPosition);
                this.triggerRedraw();
            }
            this.selectedRow = n;
            this.drawRows(this.selectedRow, 1, true);
        }
        Object var7_8 = null;
        this.triggerRedraw();
        this.setSupressRedraw(bl);
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        if (this.mouseMotion == null) {
            this.mouseMotion = new MouseMotion();
            this.addMouseMotionListener(this.mouseMotion);
        }
        if (this.key == null) {
            this.key = new Key();
            this.addKeyListener(this.key);
        }
        if (this.adjustment == null) {
            this.adjustment = new Adjustment();
            this.verticalScrollbar.addAdjustmentListener(this.adjustment);
            this.horizontalScrollbar.addAdjustmentListener(this.adjustment);
        }
    }

    public synchronized void removeNotify() {
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.mouseMotion != null) {
            this.removeMouseMotionListener(this.mouseMotion);
            this.mouseMotion = null;
        }
        if (this.key != null) {
            this.removeKeyListener(this.key);
            this.key = null;
        }
        if (this.adjustment != null) {
            this.verticalScrollbar.removeAdjustmentListener(this.adjustment);
            this.horizontalScrollbar.removeAdjustmentListener(this.adjustment);
            this.adjustment = null;
        }
        super.removeNotify();
    }

    private void singleSel(int n, int n2) {
        if (this.selectedRow >= 0 && this.highlightedRows.get(this.selectedRow)) {
            if (this.selectedRow != n) {
                this.deselectRow(this.selectedRow);
                this.selectRow(n);
            } else if ((n2 & 2) == 2) {
                this.deselectRow(this.selectedRow);
            }
        } else {
            this.removeSelectionBorder();
            this.selectRow(n);
        }
    }

    private void deselectEvent(int n, int[] nArray) {
        int n2 = nArray.length;
        if (n2 > 1 || n2 == 1 && this.selectedRow != n) {
            this.sourceItemEvent(2);
        }
    }

    protected void paintSelection(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            if (n2 - this.sbVPosition >= 0 && n2 - this.sbVPosition <= this.getNumVisibleRows() + 1) {
                this.drawRows(n2, 1, true);
            }
            ++n;
        }
    }

    public void selectRow(int n) {
        if (!this.highlightedRows.get(n)) {
            int n2;
            if (!this.multiSelect && (n2 = this.getSelectedRow()) != -1 && n2 != n) {
                this.deselectRow(n2);
            }
            this.highlightedRows.set(n);
            this.sourceItemEvent(1);
            this.drawRows(n, 1, true);
        }
    }

    public void deselectRow(int n) {
        if (this.highlightedRows.get(n)) {
            this.highlightedRows.clear(n);
            this.sourceItemEvent(2);
            if (n == this.selectedRow) {
                this.removeSelectionBorder();
            } else {
                this.drawRows(n, 1, true);
            }
        }
    }

    protected void removeSelectionBorder() {
        if (this.selectedRow != -1) {
            int n = this.selectedRow;
            this.selectedRow = -1;
            this.drawRows(n, 1, true);
            this.selectedRow = n;
        }
    }

    public synchronized Dimension preferredSize() {
        return new Dimension(175, 125);
    }

    public synchronized Dimension minimumSize() {
        return new Dimension(50, 50);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    protected void sourceItemEvent(int n) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, this, n));
        }
    }

    protected void repaintFocus() {
        if (this.selectedRow != -1) {
            this.drawRows(this.selectedRow, 1, true);
        }
        this.paintSelection(this.getSelectedRows());
    }

    protected void sourceActionEvent(int n) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand + n));
        }
    }

    protected int getNumVisibleRows() {
        return (this.size().height - this.headingHeight - this.scrollbarHeight - 1 - (this.headingHeight > 0 ? 0 : 1)) / this.cellHeight;
    }

    protected void drawRows(int n, int n2, boolean bl) {
        int n3 = n - this.sbVPosition;
        if (n3 < 0 || n3 > this.getNumVisibleRows() - 1) {
            return;
        }
        MatrixEnumeration matrixEnumeration = this.cells.elements();
        TextAndImageCell textAndImageCell = null;
        if (n > 0) {
            textAndImageCell = (TextAndImageCell)matrixEnumeration.advanceTo(n);
        }
        while (matrixEnumeration.hasMoreElements() || textAndImageCell != null) {
            Rectangle rectangle;
            Rectangle rectangle2;
            int n4 = 1;
            boolean bl2 = this.highlightedRows.get(n);
            int n5 = this.headingHeight + (this.headingHeight > 0 ? 0 : 1) + n3 * this.cellHeight;
            int n6 = this.headings.length;
            int n7 = 0;
            while (n7 < n6) {
                int n8 = this.splitters[n7 + 1] - this.splitters[n7];
                if (this.offscreenImage != null) {
                    this.offscreenImageGraphics.setColor(bl2 ? this.colorHBg : this.colorBg);
                    this.offscreenImageGraphics.fillRect(n4, n5, n8 + 4, this.cellHeight);
                    this.offscreenImageGraphics.setColor(bl2 ? this.colorHFg : this.colorFg);
                }
                if (textAndImageCell == null) {
                    textAndImageCell = (TextAndImageCell)matrixEnumeration.nextElement();
                }
                if (this.offscreenImage != null && textAndImageCell != null && matrixEnumeration.currRow() == n && matrixEnumeration.currCol() == n7) {
                    textAndImageCell.drawCell(this.offscreenImageGraphics, this.getColumnAlignment(n7), this.splitters[n7] + 3, n5, n8, this.cellHeight, this.cellAscent);
                    textAndImageCell = null;
                }
                if (textAndImageCell != null && matrixEnumeration.currRow() < n) {
                    textAndImageCell = null;
                }
                n4 = this.splitters[n7 + 1] - 3;
                ++n7;
            }
            if (this.hasFocus & this.focusIndicatedVisually && this.offscreenImage != null && n == this.selectedRow && (rectangle2 = this.offscreenImageGraphics.getClipRect()) != null) {
                this.offscreenImageGraphics.setColor(this.colorBg);
                this.offscreenImageGraphics.setXORMode(Color.gray);
                this.offscreenImageGraphics.drawRect(1, n5, rectangle2.width - 3, this.cellHeight - 1);
                this.offscreenImageGraphics.setPaintMode();
            }
            if (this.offscreenImage != null && bl && (rectangle = this.offscreenImageGraphics.getClipRect()) != null) {
                this.repaint(0, n5, rectangle.width, this.cellHeight);
            }
            if (--n2 == 0) break;
            ++n;
            ++n3;
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public boolean isFocusTraversable() {
        return true;
    }

    protected void drawColumnHeading(Rectangle rectangle, boolean bl) {
        if (MultiList.isMacintosh()) {
            this.offscreenImageGraphics.setColor(Color.black);
            this.offscreenImageGraphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            this.offscreenImageGraphics.setColor(bl ? Color.gray : this.headingBg);
            this.offscreenImageGraphics.fillRect(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
            if (bl) {
                this.offscreenImageGraphics.setColor(Color.black);
            }
            this.offscreenImageGraphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 2, rectangle.x + 1, rectangle.y + rectangle.height - 2);
            this.offscreenImageGraphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y + 1, rectangle.x + rectangle.width - 2, rectangle.y + 1);
            this.offscreenImageGraphics.setColor(bl ? thirtyThreePercentGray : Color.white);
            this.offscreenImageGraphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, rectangle.y + rectangle.height - 3);
            this.offscreenImageGraphics.drawLine(rectangle.x + 2, rectangle.y + 1, rectangle.x + rectangle.width - 3, rectangle.y + 1);
            this.offscreenImageGraphics.setColor(bl ? sixtySixPercentGray : Color.gray);
            this.offscreenImageGraphics.drawLine(rectangle.x + 2, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
            this.offscreenImageGraphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y + 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        } else {
            ++rectangle.x;
            ++rectangle.y;
            rectangle.width -= 2;
            rectangle.height -= 2;
            this.draw3DBox(rectangle, !bl);
            this.offscreenImageGraphics.setColor(this.headingBg);
            this.offscreenImageGraphics.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 1, rectangle.height - 1);
        }
    }

    protected void draw3DBox(Rectangle rectangle, boolean bl) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y + rectangle.height;
        this.offscreenImageGraphics.setColor(bl ? Color.black : Color.white);
        this.offscreenImageGraphics.drawLine(n3, n2, n3, n4);
        this.offscreenImageGraphics.drawLine(n3 + 1, n2, n3 + 1, n4);
        this.offscreenImageGraphics.drawLine(n, n4, n3, n4);
        this.offscreenImageGraphics.drawLine(n, n4 + 1, n3, n4 + 1);
        this.offscreenImageGraphics.setColor(bl ? Color.white : Color.gray);
        this.offscreenImageGraphics.drawLine(n, n2, n3 - 2, n2);
        this.offscreenImageGraphics.drawLine(n, n2, n, n4 - 1);
    }

    protected void calculateHeadingHeight() {
        FontMetrics fontMetrics = this.getFontMetrics(this.headingFont);
        this.headingHeight = fontMetrics.getHeight() + fontMetrics.getLeading() + 7;
    }

    protected void drawHeading(boolean bl) {
        Serializable serializable;
        if (!this.headingVisible) {
            return;
        }
        if (this.headings.length > 0) {
            serializable = this.offscreenImageGraphics.getFont();
            this.offscreenImageGraphics.setFont(this.headingFont);
            FontMetrics fontMetrics = this.offscreenImageGraphics.getFontMetrics();
            int n = this.splitters[0];
            int n2 = 0;
            while (n2 < this.headings.length) {
                int n3 = this.splitters[n2 + 1];
                int n4 = n3 - n;
                Rectangle rectangle = new Rectangle(n, 0, n4, this.headingHeight);
                boolean bl2 = this.columnClicked == n2;
                this.drawColumnHeading(rectangle, bl2);
                String string = this.headings[n2];
                if (string != null) {
                    this.offscreenImageGraphics.setColor(this.headingFg);
                    int n5 = fontMetrics.stringWidth(string);
                    int n6 = n4 - 3;
                    int n7 = bl && bl2 ? 1 : 0;
                    int n8 = this.headingHeight - 6 + n7;
                    Shape shape = this.offscreenImageGraphics.getClip();
                    this.offscreenImageGraphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    switch (this.getColumnAlignment(n2)) {
                        case 0: {
                            this.offscreenImageGraphics.drawString(string, n + 8 + n7, n8);
                            break;
                        }
                        case 1: {
                            if (n5 > n6) {
                                this.offscreenImageGraphics.drawString(string, n + 8 + n7, n8);
                                break;
                            }
                            this.offscreenImageGraphics.drawString(string, n + (n6 - n5) / 2 + n7, n8);
                            break;
                        }
                        case 2: {
                            if (n5 > n6) {
                                this.offscreenImageGraphics.drawString(string, n + 8 + n7, n8);
                                break;
                            }
                            this.offscreenImageGraphics.drawString(string, n + n6 - n5 - 6 + n7, n8);
                        }
                    }
                    this.offscreenImageGraphics.setClip(shape);
                    if (bl2) {
                        this.offscreenImageGraphics.drawLine(rectangle.x + 1, this.headingHeight - 1, n3 - 3, this.headingHeight - 1);
                    }
                    n = n3 - 1;
                }
                ++n2;
            }
            this.offscreenImageGraphics.setFont((Font)serializable);
        }
        serializable = this.size();
        int n = this.splitters[this.splitters.length - 1];
        if (n < this.sbHPosition + serializable.width - this.verticalScrollbarWidth) {
            Rectangle rectangle = new Rectangle(n - 1, 0, this.sbHPosition + serializable.width - this.verticalScrollbarWidth - n + 1, this.headingHeight);
            this.drawColumnHeading(rectangle, false);
        }
    }

    protected String[] intArrayToStringArray(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            String string = "";
            try {
                string = String.valueOf(nArray[n]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stringArray[n] = string;
            ++n;
        }
        return stringArray;
    }

    protected int[] getColumnSizesFromSplitters() {
        int[] nArray = new int[this.headings.length];
        int n = 0;
        while (n < this.headings.length) {
            nArray[n] = this.splitters[n + 1] - this.splitters[n];
            ++n;
        }
        return nArray;
    }

    protected void triggerRedraw() {
        if (!this.isSuppressRedraw) {
            this.forceRedraw = true;
            this.repaint();
        } else {
            this.redrawWasSupressed = true;
        }
    }

    protected String[] tokenizeStringArrayIfNeeded(String[] stringArray) {
        if (stringArray != null && stringArray.length == 1 && stringArray[0].indexOf(";") != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[0], ";");
            int n = stringTokenizer.countTokens();
            String[] stringArray2 = new String[n];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string;
                stringArray2[n2] = string = stringTokenizer.nextToken();
                ++n2;
            }
            stringArray = stringArray2;
        }
        return stringArray;
    }

    protected void calcHeadings(String[] stringArray) {
        this.headings = new String[stringArray.length];
        this.splitters = new int[stringArray.length + 1];
        int n = 0;
        while (n < stringArray.length) {
            try {
                this.setHeading(stringArray[n], n);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            ++n;
        }
        if (this.columnSizes != null) {
            try {
                this.setColumnSizes(this.intArrayToStringArray(this.columnSizes));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    static {
        String string = System.getProperty("os.name");
        if (string.equals("Windows NT")) {
            isWindowsNT = true;
        } else if (string.equals("Windows 95")) {
            isWindows95 = true;
        } else if (string.equals("Windows 98")) {
            isWindows95 = true;
        } else if (string.indexOf("Windows") >= 0) {
            isWindows95 = true;
        } else if (string.equals("Macintosh") || string.equals("macos") || string.equals("Mac OS") || string.equals("MacOS")) {
            isMacintosh = true;
        } else if (string.equals("SunOS") || string.equals("Solaris")) {
            isSolaris = true;
            isCaseSensitive = true;
        }
        thirtyThreePercentGray = new Color(0x212121);
        sixtySixPercentGray = new Color(0x434343);
        string = System.getProperty("java.vendor");
        String string2 = System.getProperty("java.version");
        isSun1_1 = string.startsWith("Sun Microsystems Inc.") || string.startsWith("Apple") || string.startsWith("Symantec Corporation") || string.startsWith("Microsoft Corp") || string.startsWith("Netscape");
    }

    class Adjustment
    implements AdjustmentListener,
    Serializable {
        Adjustment() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (adjustmentEvent.getSource() == MultiList.this.verticalScrollbar) {
                if (MultiList.this.topRow != MultiList.this.verticalScrollbar.getValue()) {
                    MultiList.this.sbVPosition = MultiList.this.topRow = MultiList.this.verticalScrollbar.getValue();
                    MultiList.this.triggerRedraw();
                }
            } else if (adjustmentEvent.getSource() == MultiList.this.horizontalScrollbar && MultiList.this.sbHPosition != MultiList.this.horizontalScrollbar.getValue()) {
                MultiList.this.sbHPosition = MultiList.this.horizontalScrollbar.getValue();
                MultiList.this.triggerRedraw();
            }
        }
    }

    class Key
    extends KeyAdapter
    implements Serializable {
        Key() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getModifiers();
            switch (keyEvent.getKeyCode()) {
                case 40: {
                    if (MultiList.this.selectedRow >= MultiList.this.cells.rows() - 1) break;
                    MultiList.this.changeSelection(MultiList.this.selectedRow + 1, n);
                    break;
                }
                case 34: {
                    MultiList.this.changeSelection(Math.min(MultiList.this.selectedRow + MultiList.this.getNumVisibleRows(), MultiList.this.cells.rows() - 1), n);
                    break;
                }
                case 38: {
                    if (MultiList.this.selectedRow <= 0) break;
                    MultiList.this.changeSelection(MultiList.this.selectedRow - 1, n);
                    break;
                }
                case 33: {
                    MultiList.this.changeSelection(Math.max(MultiList.this.selectedRow - MultiList.this.getNumVisibleRows(), 0), n);
                    break;
                }
                case 39: {
                    int n2 = MultiList.this.horizontalScrollbar.getMaximum() - (isSun1_1 ? MultiList.this.size().width - MultiList.this.verticalScrollbarWidth : 0);
                    if (!MultiList.this.sbHShow || MultiList.this.sbHPosition >= n2) break;
                    MultiList.this.horizontalScrollbar.setValue(Math.min(MultiList.this.sbHPosition += MultiList.this.hScrollbarLineIncrement, n2));
                    MultiList.this.repaint();
                    break;
                }
                case 37: {
                    if (MultiList.this.sbHPosition <= 0) break;
                    MultiList.this.horizontalScrollbar.setValue(Math.max(MultiList.this.sbHPosition -= MultiList.this.hScrollbarLineIncrement, 0));
                    MultiList.this.repaint();
                    break;
                }
                case 10: {
                    if (MultiList.this.selectedRow <= -1) break;
                    MultiList.this.sourceActionEvent(MultiList.this.selectedRow);
                }
            }
        }
    }

    class MouseMotion
    implements MouseMotionListener,
    Serializable {
        MouseMotion() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (MultiList.this.allowResizingOfColumns) {
                int n;
                boolean bl = false;
                if (mouseEvent.getY() < MultiList.this.headingHeight) {
                    n = mouseEvent.getX();
                    int n2 = 1;
                    while (n2 < MultiList.this.splitters.length - 1) {
                        int n3 = MultiList.this.splitters[n2];
                        if (n < Math.min(n3 - MultiList.this.sbHPosition + 3, MultiList.this.size().width - MultiList.this.verticalScrollbarWidth) && n > n3 - MultiList.this.sbHPosition - 3) {
                            bl = true;
                            break;
                        }
                        ++n2;
                    }
                }
                int n4 = n = bl ? 10 : 0;
                if (n != MultiList.this.getCursor().getType()) {
                    MultiList.this.setCursor(new Cursor(n));
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            Dimension dimension = MultiList.this.size();
            if (!MultiList.this.isDragging) {
                if (MultiList.this.clickedInHeadings) {
                    if (MultiList.this.columnClicked > -1) {
                        int n3 = MultiList.this.columnClicked == 0 ? 0 : MultiList.this.splitters[MultiList.this.columnClicked] - MultiList.this.sbHPosition;
                        int n4 = MultiList.this.columnClicked == MultiList.this.headings.length - 1 ? dimension.width : MultiList.this.splitters[MultiList.this.columnClicked + 1] - MultiList.this.sbHPosition;
                        if (n < n3 || n > n4 || n2 > MultiList.this.headingHeight || n2 < 0) {
                            MultiList.this.memoryClick = MultiList.this.columnClicked;
                            MultiList.this.columnClicked = -1;
                            MultiList.this.drawHeading(false);
                            Graphics graphics = MultiList.this.getGraphics();
                            MultiList.this.paint(graphics);
                        }
                    } else if (MultiList.this.memoryClick > -1) {
                        int n5 = MultiList.this.memoryClick == 0 ? 0 : MultiList.this.splitters[MultiList.this.memoryClick] - MultiList.this.sbHPosition;
                        int n6 = MultiList.this.memoryClick == MultiList.this.headings.length - 1 ? dimension.width : MultiList.this.splitters[MultiList.this.memoryClick + 1] - MultiList.this.sbHPosition;
                        if (n > n5 && n < n6 && n2 < MultiList.this.headingHeight && n2 > 0) {
                            MultiList.this.columnClicked = MultiList.this.memoryClick;
                            MultiList.this.memoryClick = -1;
                            MultiList.this.drawHeading(true);
                            Graphics graphics = MultiList.this.getGraphics();
                            MultiList.this.paint(graphics);
                        }
                    }
                }
            } else {
                if (n < 0) {
                    n = 0;
                }
                if (n + MultiList.this.sbHPosition < MultiList.this.splitters[MultiList.this.dragColumn - 1] + MultiList.this.minColumnWidth) {
                    return;
                }
                int n7 = Math.min(n, MultiList.this.xDragLast - MultiList.this.sbHPosition);
                int n8 = Math.max(n, MultiList.this.xDragLast - MultiList.this.sbHPosition);
                MultiList.this.offscreenImageGraphics.setColor(MultiList.this.colorBg);
                MultiList.this.offscreenImageGraphics.setXORMode(Color.gray);
                MultiList.this.offscreenImageGraphics.drawLine(MultiList.this.xDragLast, 0, MultiList.this.xDragLast, dimension.height);
                MultiList.this.offscreenImageGraphics.drawLine(n + MultiList.this.sbHPosition, 0, n + MultiList.this.sbHPosition, dimension.height);
                MultiList.this.offscreenImageGraphics.setColor(MultiList.this.getForeground());
                MultiList.this.offscreenImageGraphics.setPaintMode();
                MultiList.this.xDragLast = n + MultiList.this.sbHPosition;
                MultiList.this.repaint(n7, 0, n8 - n7 + 1, MultiList.this.size().height);
            }
        }
    }

    class Mouse
    extends MouseAdapter
    implements Serializable {
        String booS;

        Mouse() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            long l;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            MultiList.this.requestFocus();
            MultiList.this.clickedInHeadings = false;
            if (n2 < MultiList.this.headingHeight) {
                int n3;
                if (MultiList.this.allowResizingOfColumns) {
                    n3 = 1;
                    while (n3 < MultiList.this.splitters.length - 1) {
                        int n4 = MultiList.this.splitters[n3];
                        if (n < Math.min(n4 - MultiList.this.sbHPosition + 3, MultiList.this.size().width - MultiList.this.verticalScrollbarWidth) && n > n4 - MultiList.this.sbHPosition - 3) {
                            MultiList.this.dragColumn = n3;
                            MultiList.this.isDragging = true;
                            MultiList.this.offscreenImageGraphics.setClip(0, 0, Math.max(MultiList.this.splitters[MultiList.this.splitters.length - 1], MultiList.this.size().width + MultiList.this.sbHPosition), MultiList.this.size().height);
                            MultiList.this.mouseMotion.mouseDragged(mouseEvent);
                            return;
                        }
                        ++n3;
                    }
                }
                if (MultiList.this.allowSorting) {
                    n3 = 0;
                    while (n3 < MultiList.this.headings.length) {
                        if (n > MultiList.this.splitters[n3] - MultiList.this.sbHPosition && n < MultiList.this.splitters[n3 + 1] - MultiList.this.sbHPosition) {
                            MultiList.this.clickedInHeadings = true;
                            MultiList.this.columnClicked = n3;
                            MultiList.this.drawHeading(true);
                            MultiList.this.repaint();
                            this.booS = MultiList.this.parent.templabel.getText();
                            MultiList.this.parent.lmess.setVisible(false);
                            MultiList.this.parent.label_bar.setText(MultiList.this.parent.s_xx[3]);
                            MultiList.this.parent.move_bar(MultiList.this.parent.x1, MultiList.this.parent.y1 - 18);
                            MultiList.this.parent.BNext.setEnabled(false);
                            MultiList.this.parent.BLast.setEnabled(false);
                            MultiList.this.parent.BFirst.setEnabled(false);
                            MultiList.this.parent.BPrev.setEnabled(false);
                            if (MultiList.this.parent.barThread.barThread == null) {
                                MultiList.this.parent.barThread = new BarThread(MultiList.this.parent);
                                MultiList.this.parent.barThread.start();
                            }
                            return;
                        }
                        ++n3;
                    }
                }
                return;
            }
            Dimension dimension = MultiList.this.getSize();
            if (n >= dimension.width - MultiList.this.verticalScrollbarWidth || n2 >= dimension.height - MultiList.this.scrollbarHeight) {
                return;
            }
            int n5 = (n2 - MultiList.this.headingHeight) / MultiList.this.cellHeight + MultiList.this.topRow;
            if (n5 < 0 || n5 > MultiList.this.cells.rows() - 1) {
                return;
            }
            int n6 = MultiList.this.selectedRow;
            MultiList.this.changeSelection(n5, mouseEvent.getModifiers());
            long l2 = mouseEvent.getWhen();
            if ((MultiList.this.selectedRow == n6 || n6 < 0) && (l = l2 - MultiList.this.clickTime) < 250L) {
                MultiList.this.sourceActionEvent(MultiList.this.selectedRow);
            }
            MultiList.this.clickTime = l2;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            if (MultiList.this.isDragging) {
                if (n < 0) {
                    n = 0;
                }
                boolean bl = false;
                MultiList.this.xDragLast = Math.max(MultiList.this.splitters[MultiList.this.dragColumn - 1] + MultiList.this.minColumnWidth, n + MultiList.this.sbHPosition);
                int n2 = MultiList.this.xDragLast - MultiList.this.splitters[MultiList.this.dragColumn];
                int n3 = MultiList.this.dragColumn + 1;
                while (n3 < MultiList.this.splitters.length) {
                    int n4 = MultiList.this.splitters[n3];
                    int n5 = n3;
                    MultiList.this.splitters[n5] = MultiList.this.splitters[n5] + n2;
                    if (n4 != MultiList.this.splitters[n3]) {
                        bl = true;
                    }
                    ++n3;
                }
                if (MultiList.this.splitters[MultiList.this.dragColumn] != MultiList.this.xDragLast) {
                    MultiList.this.splitters[MultiList.this.dragColumn] = MultiList.this.xDragLast;
                    bl = true;
                }
                MultiList.this.xDragLast = -1;
                MultiList.this.isDragging = false;
                if (mouseEvent.getY() > MultiList.this.headingHeight) {
                    MultiList.this.setCursor(new Cursor(0));
                }
                if (bl && MultiList.this.columnSizes == null) {
                    try {
                        MultiList.this.setColumnSizes(MultiList.this.intArrayToStringArray(MultiList.this.getColumnSizesFromSplitters()));
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
                MultiList.this.triggerRedraw();
                return;
            }
            if (MultiList.this.columnClicked != -1) {
                CompareCells compareCells = MultiList.this.getColumnSorter(MultiList.this.columnClicked);
                compareCells.setCurrentBitSet(MultiList.this.highlightedRows);
                compareCells.setSelectedRow(MultiList.this.selectedRow);
                if (MultiList.this.columnClicked == MultiList.this.lastColumnClicked) {
                    compareCells.reverse();
                }
                MultiList.this.cells.sort(compareCells, MultiList.this.columnClicked);
                MultiList.this.selectedRow = compareCells.getSelectedRow();
                MultiList.this.lastColumnClicked = MultiList.this.columnClicked;
                MultiList.this.columnClicked = -1;
                MultiList.this.triggerRedraw();
                if (MultiList.this.parent.barThread.barThread != null) {
                    MultiList.this.parent.barThread.stop();
                    MultiList.this.parent.templabel.setText(this.booS);
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (MultiList.this.getCursor().getType() != 0 && !MultiList.this.isDragging) {
                MultiList.this.setCursor(new Cursor(0));
            }
            if (MultiList.this.parent.barThread.barThread != null) {
                MultiList.this.parent.barThread.stop();
            }
            if (MultiList.this.parent.templabel != null && this.booS != null) {
                MultiList.this.parent.templabel.setText(this.booS);
            }
        }
    }
}

