/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.multimedia;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.net.URL;
import java.util.ResourceBundle;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.util.GeneralUtils;

public class ScrollingText
extends Canvas
implements Runnable {
    public static final int SCROLL_LEFT = 0;
    public static final int SCROLL_RIGHT = 1;
    protected int scrollDirection = 0;
    protected int scrollUnit = 10;
    protected int sleepTime = 150;
    protected Color hiliteColor = Color.red;
    protected String[] messageList;
    protected URL[] linkToList;
    protected String frame;
    protected transient AppletContext context;
    protected transient Thread scrollThread;
    protected transient boolean suspended = false;
    protected transient int textX;
    protected transient int textY;
    protected transient int textWidth;
    protected transient int textHeight;
    protected transient boolean isMouseOver = false;
    protected transient int lastMouseX;
    protected transient int lastMouseY;
    protected transient boolean wasMouseOverText = false;
    protected transient String wasStatusMessage = "";
    protected String currMessage;
    protected URL currLinkTo;
    protected int currIndex;
    protected transient Image textImage;
    private VetoableChangeSupport vetos;
    private PropertyChangeSupport changes;
    private Mouse mouse;
    private MouseMotion mouseMotion;

    public ScrollingText() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("symantec.itools.resources.ResBundle");
        this.messageList = new String[5];
        this.messageList[0] = resourceBundle.getString("put");
        this.messageList[1] = resourceBundle.getString("some");
        this.messageList[2] = resourceBundle.getString("text");
        this.messageList[3] = resourceBundle.getString("in");
        this.messageList[4] = resourceBundle.getString("here");
        this.linkToList = new URL[0];
        this.frame = null;
        this.currMessage = "";
        this.currLinkTo = null;
        this.currIndex = -1;
        this.vetos = new VetoableChangeSupport(this);
        this.changes = new PropertyChangeSupport(this);
    }

    public void setScrollInterval(int n) throws PropertyVetoException {
        if (n < 30) {
            n = 30;
        }
        if (n != this.sleepTime) {
            Integer n2 = new Integer(this.sleepTime);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("ScrollInterval", n2, n3);
            this.sleepTime = n;
            this.changes.firePropertyChange("ScrollInterval", n2, n3);
        }
    }

    public int getScrollInterval() {
        return this.sleepTime;
    }

    public void setScrollUnit(int n) throws PropertyVetoException {
        if (n < 1) {
            n = 1;
        }
        if (this.scrollUnit != n) {
            Integer n2 = new Integer(this.scrollUnit);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("ScrollUnit", n2, n3);
            this.scrollUnit = n;
            this.changes.firePropertyChange("ScrollUnit", n2, n3);
        }
    }

    public int getScrollUnit() {
        return this.scrollUnit;
    }

    public void setScrollDirection(int n) throws PropertyVetoException {
        if (n != 0 && n != 1) {
            n = 1;
        }
        if (this.scrollDirection != n) {
            Integer n2 = new Integer(this.scrollDirection);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("ScrollDirection", n2, n3);
            this.scrollDirection = n;
            this.changes.firePropertyChange("ScrollDirection", n2, n3);
        }
    }

    public int getScrollDirection() {
        return this.scrollDirection;
    }

    public void setHiliteColor(Color color) throws PropertyVetoException {
        if (!this.hiliteColor.equals(color)) {
            Color color2 = this.hiliteColor;
            Color color3 = color;
            this.vetos.fireVetoableChange("HiliteColor", color2, color3);
            this.hiliteColor = color;
            this.changes.firePropertyChange("HiliteColor", color2, color3);
        }
    }

    public Color getHiliteColor() {
        return this.hiliteColor;
    }

    public void setMessageList(String[] stringArray) throws PropertyVetoException {
        if (this.messageList != stringArray) {
            String[] stringArray2 = this.messageList;
            String[] stringArray3 = stringArray;
            this.currIndex = 0;
            this.vetos.fireVetoableChange("MessageList", stringArray2, stringArray3);
            this.messageList = stringArray;
            this.changes.firePropertyChange("MessageList", stringArray2, stringArray3);
            this.updateCurrentMessage(false);
        }
    }

    public String[] getMessageList() {
        return this.messageList;
    }

    public void setLinkToList(URL[] uRLArray) throws PropertyVetoException {
        if (this.linkToList != uRLArray) {
            URL[] uRLArray2 = this.linkToList;
            URL[] uRLArray3 = uRLArray;
            this.currIndex = 0;
            this.vetos.fireVetoableChange("LinkToList", uRLArray2, uRLArray3);
            this.linkToList = uRLArray;
            this.changes.firePropertyChange("LinkToList", uRLArray2, uRLArray3);
            this.updateCurrentMessage(false);
        }
    }

    public URL[] getLinkToList() {
        return this.linkToList;
    }

    public void setFrame(String string) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.frame, string)) {
            String string2 = this.frame;
            this.vetos.fireVetoableChange("Frame", string2, string);
            this.frame = string;
            this.changes.firePropertyChange("Frame", string, string);
        }
    }

    public String getFrame() {
        return this.frame;
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        if (this.mouseMotion == null) {
            this.mouseMotion = new MouseMotion();
            this.addMouseMotionListener(this.mouseMotion);
        }
        this.scrollThread = new Thread(this);
        this.scrollThread.setPriority(1);
        this.scrollThread.start();
    }

    public synchronized void removeNotify() {
        if (this.scrollThread != null) {
            this.scrollThread.stop();
            this.scrollThread = null;
        }
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.mouseMotion != null) {
            this.removeMouseMotionListener(this.mouseMotion);
            this.mouseMotion = null;
        }
        super.removeNotify();
    }

    public void startScrollingText() {
        this.suspended = false;
        this.show();
    }

    public void stopScrollingText() {
        this.suspended = true;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.scrollThread != null) {
            Thread thread = this.scrollThread;
            synchronized (thread) {
                if (bl) {
                    this.scrollThread.resume();
                } else {
                    this.scrollThread.suspend();
                }
                return;
            }
        }
    }

    public void run() {
        this.createTextParams();
        while (true) {
            if (this.suspended) {
                continue;
            }
            this.nextPos();
            try {
                Thread.sleep(this.sleepTime);
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    protected void updateCurrentMessage(boolean bl) {
        try {
            if (bl) {
                ++this.currIndex;
            }
            if (this.currIndex >= this.messageList.length) {
                this.currIndex = 0;
            }
            this.currMessage = this.messageList[this.currIndex];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            try {
                this.currIndex = 0;
                this.currMessage = this.messageList[0];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2) {
                this.currMessage = "";
            }
        }
        this.currLinkTo = this.currIndex < this.linkToList.length ? this.linkToList[this.currIndex] : null;
        this.createTextParams();
    }

    protected synchronized void nextPos() {
        Dimension dimension = this.size();
        if (this.scrollDirection == 0) {
            this.textX -= this.scrollUnit;
            if (this.textX + this.textWidth < 0) {
                this.updateCurrentMessage(true);
                this.textX = dimension.width;
            }
        } else {
            this.textX += this.scrollUnit;
            if (this.textX > dimension.width) {
                this.updateCurrentMessage(true);
                this.textX = -this.textWidth;
            }
        }
        this.repaint();
    }

    protected void createTextParams() {
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            this.textHeight = fontMetrics.getHeight();
            Dimension dimension = this.size();
            this.textX = dimension.width;
            this.textY = (dimension.height - this.textHeight >> 1) + fontMetrics.getAscent();
            this.textWidth = fontMetrics.stringWidth(this.currMessage);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    protected boolean isMouseOverText(int n, int n2) {
        return this.isMouseOver && n >= this.textX && n <= this.textX + this.textWidth && n2 >= this.textY - this.textHeight && n2 <= this.textY;
    }

    public void paint(Graphics graphics) {
        Object object;
        Dimension dimension = this.size();
        if (this.isImageInvalid()) {
            this.textImage = this.createImage(dimension.width, dimension.height);
            try {
                object = new MediaTracker(this);
                ((MediaTracker)object).addImage(this.textImage, 0);
                ((MediaTracker)object).waitForID(0);
            }
            catch (InterruptedException interruptedException) {}
        }
        object = this.textImage.getGraphics();
        ((Graphics)object).setColor(this.getBackground());
        ((Graphics)object).fillRect(0, 0, dimension.width, dimension.height);
        ((Graphics)object).setFont(this.getFont());
        boolean bl = this.isMouseOverText(this.lastMouseX, this.lastMouseY);
        if (bl != this.wasMouseOverText) {
            String string;
            if (this.context != null && !this.wasStatusMessage.equals(string = this.wasMouseOverText || this.currLinkTo == null ? "" : this.currLinkTo.toString())) {
                this.context.showStatus(string);
                this.wasStatusMessage = string;
            }
            this.wasMouseOverText = bl;
        }
        ((Graphics)object).setColor(bl && this.currLinkTo != null ? this.hiliteColor : this.getForeground());
        ((Graphics)object).drawString(this.currMessage, this.textX, this.textY);
        graphics.drawImage(this.textImage, 0, 0, this);
        if (object != null) {
            ((Graphics)object).dispose();
        }
    }

    public void validate() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Applet) {
                this.setAppletContext(((Applet)container).getAppletContext());
                return;
            }
            container = container.getParent();
        }
    }

    protected void setAppletContext(AppletContext appletContext) {
        this.context = appletContext;
    }

    public synchronized void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.createTextParams();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    protected boolean isImageInvalid() {
        Dimension dimension = this.getSize();
        return this.textImage == null || dimension.width != this.textImage.getWidth(this) || dimension.height != this.textImage.getHeight(this);
    }

    class MouseMotion
    extends MouseMotionAdapter
    implements Serializable {
        public void mouseMoved(MouseEvent mouseEvent) {
            ScrollingText.this.isMouseOver = true;
            ScrollingText.this.lastMouseX = mouseEvent.getX();
            ScrollingText.this.lastMouseY = mouseEvent.getY();
        }

        MouseMotion() {
            ScrollingText.this = ScrollingText.this;
        }
    }

    class Mouse
    extends MouseAdapter
    implements Serializable {
        public void mouseExited(MouseEvent mouseEvent) {
            ScrollingText.this.isMouseOver = false;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (ScrollingText.this.currLinkTo != null && ScrollingText.this.isMouseOverText(mouseEvent.getX(), mouseEvent.getY()) && ScrollingText.this.context != null) {
                if (ScrollingText.this.frame == null || ScrollingText.this.frame.length() == 0) {
                    ScrollingText.this.context.showDocument(ScrollingText.this.currLinkTo);
                    return;
                }
                ScrollingText.this.context.showDocument(ScrollingText.this.currLinkTo, ScrollingText.this.frame);
            }
        }

        Mouse() {
            ScrollingText.this = ScrollingText.this;
        }
    }
}

