/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.image;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.RGBImageFilter;
import java.util.ResourceBundle;
import symantec.itools.util.GeneralUtils;

public class FadeFilter
extends RGBImageFilter {
    protected double percent;
    protected int to_r;
    protected int to_g;
    protected int to_b;
    protected transient ResourceBundle errors = ResourceBundle.getBundle("symantec.itools.resources.ErrorsBundle");

    public FadeFilter() {
        this(0.5, Color.lightGray);
    }

    public FadeFilter(double d) {
        this(d, Color.lightGray);
    }

    public FadeFilter(Color color) {
        this(0.5, color);
    }

    public FadeFilter(double d, Color color) {
        this.canFilterIndexColorModel = true;
        try {
            this.setPercent(d);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            new Double(d);
            System.err.println("FadeFilter: " + this.errors.getString("InvalidPercent1"));
            System.err.println("     " + this.errors.getString("InvalidPercent2"));
            System.err.println("     " + this.errors.getString("InvalidPercent3"));
            try {
                this.setPercent(0.5);
            }
            catch (IllegalArgumentException illegalArgumentException2) {}
        }
        try {
            this.setFadeToColor(color);
            return;
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("FadeFilter: Null parameter value passed to constructor:");
            System.err.println("     fadeToColor is null");
            System.err.println("     Defaulting to Color.lightGray.");
            this.setFadeToColor(Color.lightGray);
            return;
        }
    }

    public void setFadeToColor(Color color) {
        this.to_r = color.getRed();
        this.to_g = color.getGreen();
        this.to_b = color.getBlue();
    }

    public Color getFadeToColor() {
        return new Color(this.to_r, this.to_g, this.to_b);
    }

    public void setPercent(double d) throws IllegalArgumentException {
        GeneralUtils.checkValidPercent(d);
        this.percent = d;
    }

    public double getPercent() {
        return this.percent;
    }

    public int filterRGB(int n, int n2, int n3) {
        DirectColorModel directColorModel = (DirectColorModel)ColorModel.getRGBdefault();
        int n4 = directColorModel.getAlpha(n3);
        int n5 = directColorModel.getRed(n3);
        int n6 = directColorModel.getGreen(n3);
        int n7 = directColorModel.getBlue(n3);
        int n8 = n5 > this.to_r ? this.to_r + (int)((double)(n5 - this.to_r) * (1.0 - this.percent)) : this.to_r - (int)((double)(this.to_r - n5) * (1.0 - this.percent));
        int n9 = n6 > this.to_r ? this.to_g + (int)((double)(n6 - this.to_g) * (1.0 - this.percent)) : this.to_g - (int)((double)(this.to_g - n6) * (1.0 - this.percent));
        int n10 = n7 > this.to_b ? this.to_b + (int)((double)(n7 - this.to_b) * (1.0 - this.percent)) : this.to_b - (int)((double)(this.to_b - n7) * (1.0 - this.percent));
        return (n4 <<= 24) | (n8 <<= 16) | (n9 <<= 8) | n10;
    }
}

