/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.RGBImageFilter;
import java.util.ResourceBundle;
import symantec.itools.util.GeneralUtils;

public class DarkenFilter
extends RGBImageFilter {
    protected double percent;
    protected transient ResourceBundle errors = ResourceBundle.getBundle("symantec.itools.resources.ErrorsBundle");

    public DarkenFilter() {
        this(0.5);
    }

    public DarkenFilter(double d) {
        this.canFilterIndexColorModel = true;
        try {
            this.setPercent(d);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            new Double(d);
            System.err.println("DarkenFilter: " + this.errors.getString("InvalidPercent1"));
            System.err.println("     " + this.errors.getString("InvalidPercent2"));
            System.err.println("     " + this.errors.getString("InvalidPercent3"));
            try {
                this.setPercent(0.5);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                return;
            }
        }
    }

    public void setPercent(double d) throws IllegalArgumentException {
        GeneralUtils.checkValidPercent(d);
        this.percent = d;
    }

    public double getPercent() {
        return this.percent;
    }

    public int filterRGB(int n, int n2, int n3) {
        DirectColorModel directColorModel = (DirectColorModel)ColorModel.getRGBdefault();
        int n4 = directColorModel.getAlpha(n3);
        int n5 = directColorModel.getRed(n3);
        int n6 = directColorModel.getGreen(n3);
        int n7 = directColorModel.getBlue(n3);
        n5 = Math.max((int)((double)n5 * (1.0 - this.percent)), 0);
        n6 = Math.max((int)((double)n6 * (1.0 - this.percent)), 0);
        n7 = Math.max((int)((double)n7 * (1.0 - this.percent)), 0);
        return (n4 <<= 24) | (n5 <<= 16) | (n6 <<= 8) | n7;
    }
}

