/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import symantec.itools.awt.SimpleWizardController;
import symantec.itools.awt.WizardController;
import symantec.itools.awt.WizardInterface;
import symantec.itools.awt.shape.HorizontalLine;

public class Wizard
extends Panel
implements WizardInterface,
Serializable {
    private WizardController controller;
    private boolean controllerPrepared = false;
    private boolean ignoreDesignTime = false;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private Vector vPages;
    private int firstPageIndex;
    private int curIndex = -1;
    private Component userComponent;
    private Action action;
    private Mouse mouse;
    protected Panel panel1;
    protected HorizontalLine horizontalLine1;
    protected Panel panel2;
    protected Panel panel3;
    protected Panel panel4;
    protected Button previousButton;
    protected Button nextButton;
    protected Button finishButton;
    protected Button cancelButton;
    protected Button helpButton;
    private boolean helpButtonVisible = true;
    private boolean combinedButton = false;
    private Vector actionListeners;
    protected static String PREVIOUS_LABEL;
    protected static String NEXT_LABEL;
    protected static String FINISH_LABEL;
    protected static String CANCEL_LABEL;
    protected static String HELP_LABEL;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    protected static boolean newButtonOrder;

    static {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("symantec.itools.resources.ResBundle");
        PREVIOUS_LABEL = resourceBundle.getString("wizard_label_previous");
        NEXT_LABEL = resourceBundle.getString("wizard_label_next");
        FINISH_LABEL = resourceBundle.getString("wizard_label_finish");
        CANCEL_LABEL = resourceBundle.getString("wizard_label_cancel");
        HELP_LABEL = resourceBundle.getString("wizard_label_help");
    }

    public Wizard() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        super.setLayout(gridBagLayout);
        this.panel1 = new Panel();
        this.panel1.setLayout(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        ((GridBagLayout)super.getLayout()).setConstraints(this.panel1, gridBagConstraints);
        super.addImpl(this.panel1, null, -1);
        this.horizontalLine1 = new HorizontalLine();
        try {
            this.horizontalLine1.setBevelStyle(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        ((GridBagLayout)super.getLayout()).setConstraints(this.horizontalLine1, gridBagConstraints);
        super.addImpl(this.horizontalLine1, null, -1);
        this.panel2 = new Panel();
        this.panel2.setLayout(new FlowLayout(2, 5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)super.getLayout()).setConstraints(this.panel2, gridBagConstraints);
        super.addImpl(this.panel2, null, -1);
        this.panel3 = new Panel();
        this.panel3.setLayout(new GridLayout());
        this.previousButton = new Button();
        this.previousButton.setActionCommand("button");
        this.previousButton.setLabel(PREVIOUS_LABEL);
        this.previousButton.setEnabled(false);
        this.panel3.add(this.previousButton);
        this.nextButton = new Button();
        this.nextButton.setActionCommand("button");
        this.nextButton.setLabel(NEXT_LABEL);
        this.nextButton.setEnabled(false);
        this.panel3.add(this.nextButton);
        this.finishButton = new Button();
        this.finishButton.setActionCommand("button");
        this.finishButton.setLabel(FINISH_LABEL);
        this.finishButton.setEnabled(false);
        this.panel3.add(this.finishButton);
        this.panel4 = new Panel();
        this.panel4.setLayout(new GridLayout(1, 2, 6, 0));
        this.cancelButton = new Button();
        this.cancelButton.setActionCommand("button");
        this.cancelButton.setLabel(CANCEL_LABEL);
        if (!this.ignoreDesignTime && Beans.isDesignTime()) {
            this.cancelButton.setEnabled(false);
        }
        this.helpButton = new Button();
        this.helpButton.setActionCommand("button");
        this.helpButton.setLabel(HELP_LABEL);
        if (!this.ignoreDesignTime && Beans.isDesignTime()) {
            this.helpButton.setEnabled(false);
        }
        if (newButtonOrder) {
            this.panel2.add(this.panel4);
            this.panel2.add(this.panel3);
            this.panel4.add(this.helpButton);
            this.panel4.add(this.cancelButton);
        } else {
            this.panel2.add(this.panel3);
            this.panel2.add(this.panel4);
            this.panel4.add(this.cancelButton);
            this.panel4.add(this.helpButton);
        }
        this.vPages = new Vector();
        this.actionListeners = new Vector();
        this.controller = new SimpleWizardController(this);
    }

    public void setFirstPageIndex(int n) {
        if (n >= 0) {
            this.firstPageIndex = n;
        }
    }

    public void setIgnoreDesignTime(boolean bl) {
        this.ignoreDesignTime = bl;
    }

    public boolean getIgnoreDesignTime() {
        return this.ignoreDesignTime;
    }

    public void setWizardController(WizardController wizardController) {
        WizardController wizardController2 = this.controller;
        this.controller = wizardController;
        if (this.controllerPrepared) {
            wizardController2.doCancel();
            this.controllerPrepared = false;
            this.initiateController(this.firstPageIndex);
        }
        this.updateButtonsState();
    }

    private void initiateController(int n) {
        Component component = this.getComponentAt(n);
        if (!this.controllerPrepared) {
            if (this.controller instanceof SimpleWizardController) {
                ((SimpleWizardController)this.controller).doPrepare(n);
            } else {
                this.controller.doPrepare();
            }
            this.controllerPrepared = true;
            this.controller.resetChainInfo();
            this.controller.preparePage(component, 1);
            this.showPage(component);
            this.curIndex = n;
            this.controller.pageShown(component);
        }
    }

    public void restart() {
        if (this.controllerPrepared) {
            this.controller.doCancel();
            this.controllerPrepared = false;
        }
        this.initiateController(this.firstPageIndex);
    }

    public WizardController getWizardController() {
        return this.controller;
    }

    public int getSelectedIndex() {
        return this.curIndex;
    }

    public void setComponentAt(int n, Component component) throws PropertyVetoException {
        if (!this.isIndexValid(n)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        Component component2 = this.getComponentAt(n);
        this.vetos.fireVetoableChange("ComponentAt", component2, component);
        this.vPages.setElementAt(component, n);
        if (n == this.curIndex) {
            this.hidePage();
            this.showPage(component);
        }
        this.changes.firePropertyChange("ComponentAt", component2, component);
    }

    public Component getComponentAt(int n) {
        if (!this.isIndexValid(n)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (Component)this.vPages.elementAt(n);
    }

    public void setHelpButtonVisible(boolean bl) throws PropertyVetoException {
        if (bl == this.helpButtonVisible) {
            return;
        }
        Boolean bl2 = new Boolean(this.helpButtonVisible);
        Boolean bl3 = new Boolean(bl);
        this.vetos.fireVetoableChange("HelpButtonVisible", bl2, bl3);
        if (bl && !this.helpButtonVisible) {
            this.panel4.add(this.helpButton);
            this.helpButtonVisible = true;
        } else if (!bl && this.helpButtonVisible) {
            this.panel4.remove(this.helpButton);
            this.helpButtonVisible = false;
        }
        this.changes.firePropertyChange("HelpButtonVisible", bl2, bl3);
    }

    public boolean isHelpButtonVisible() {
        return this.helpButtonVisible;
    }

    public void setCombinedButton(boolean bl) throws PropertyVetoException {
        if (bl == this.combinedButton) {
            return;
        }
        Boolean bl2 = new Boolean(this.combinedButton);
        Boolean bl3 = new Boolean(bl);
        this.vetos.fireVetoableChange("combinedButton", bl2, bl3);
        if (bl && !this.combinedButton) {
            this.panel3.remove(this.finishButton);
            this.combinedButton = true;
        } else if (!bl && this.combinedButton) {
            this.panel3.add(this.finishButton);
            this.combinedButton = false;
        }
        this.changes.firePropertyChange("combinedButton", bl2, bl3);
    }

    public boolean isCombinedButton() {
        return this.combinedButton;
    }

    public void setButtonsAlignment(int n) throws PropertyVetoException {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        Integer n2 = new Integer(this.getButtonsAlignment());
        Integer n3 = new Integer(n);
        this.vetos.fireVetoableChange("buttonsAlignment", n2, n3);
        ((FlowLayout)this.panel2.getLayout()).setAlignment(n);
        this.panel2.invalidate();
        this.changes.firePropertyChange("buttonsAlignment", n2, n3);
    }

    public int getButtonsAlignment() {
        return ((FlowLayout)this.panel2.getLayout()).getAlignment();
    }

    public int getPageIndex(Component component) {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        return this.vPages.indexOf(component);
    }

    private void showPageAt(int n) {
        if (!this.isIndexValid(n)) {
            return;
        }
        if (n != this.curIndex) {
            this.hidePage();
            this.showPage(this.getComponentAt(n));
            this.curIndex = n;
        }
    }

    private void hidePage() {
        if (this.userComponent != null) {
            this.userComponent.setVisible(false);
            this.userComponent = null;
        }
    }

    private void showPage(Component component) {
        this.userComponent = component;
        if (this.userComponent != null) {
            Component[] componentArray = this.panel1.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (componentArray[n2] == this.userComponent) break;
                ++n2;
            }
            if (n2 == n) {
                this.panel1.add(this.userComponent, -1);
            }
            this.userComponent.setVisible(true);
            this.userComponent.requestFocus();
            this.validate();
        }
    }

    private boolean isIndexValid(int n) {
        return n >= 0 && n < this.getPageCount();
    }

    public void removePageAt(int n) {
        if (!this.isIndexValid(n)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n2 = this.getPageCount();
        if (n == this.curIndex) {
            if (this.getPageCount() == 1) {
                if (this.userComponent != null) {
                    this.userComponent.setVisible(false);
                }
                this.curIndex = -1;
                if (this.controllerPrepared) {
                    this.controller.doCancel();
                    this.controllerPrepared = false;
                }
            } else if (this.curIndex == this.getPageCount() - 1) {
                this.showPageAt(this.curIndex - 1);
            } else {
                this.showPageAt(this.curIndex + 1);
            }
        }
        Component component = this.getComponentAt(n);
        this.panel1.remove(component);
        this.vPages.removeElementAt(n);
        if (this.curIndex != -1 && n < this.curIndex) {
            --this.curIndex;
        }
        this.updateButtonsState();
        int n3 = this.getPageCount();
        this.changes.firePropertyChange("PageCount", new Integer(n2), new Integer(n3));
    }

    public void removeAllPages() {
        if (this.userComponent != null) {
            this.userComponent.setVisible(false);
        }
        this.userComponent = null;
        this.vPages = new Vector();
        this.curIndex = -1;
        if (this.controllerPrepared) {
            this.controller.doCancel();
            this.controllerPrepared = false;
        }
        this.panel1.removeAll();
        this.updateButtonsState();
    }

    public int getPageCount() {
        return this.vPages.size();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.removeElement(actionListener);
    }

    private void fireActionEvent(String string) {
        ActionEvent actionEvent = new ActionEvent(this, 0, string);
        Enumeration enumeration = this.actionListeners.elements();
        while (enumeration.hasMoreElements()) {
            ActionListener actionListener = (ActionListener)enumeration.nextElement();
            actionListener.actionPerformed(actionEvent);
        }
    }

    protected void addImpl(Component component, Object object, int n) {
        int n2;
        if (component == null) {
            throw new IllegalArgumentException();
        }
        int n3 = this.getPageCount();
        if (n == -1) {
            n2 = this.getPageCount();
            this.vPages.addElement(component);
        } else {
            n2 = n;
            this.vPages.insertElementAt(component, n2);
        }
        if (this.curIndex != -1 && n2 <= this.curIndex) {
            ++this.curIndex;
        }
        if (!this.ignoreDesignTime && Beans.isDesignTime()) {
            this.showPageAt(n2);
        } else if (!this.controllerPrepared && n2 == this.firstPageIndex) {
            this.initiateController(this.firstPageIndex);
        }
        this.updateButtonsState();
        int n4 = this.getPageCount();
        this.changes.firePropertyChange("PageCount", new Integer(n3), new Integer(n4));
    }

    public void remove(Component component) {
        if (component == null) {
            return;
        }
        this.removePageAt(this.getPageIndex(component));
    }

    public void remove(int n) {
        this.removePageAt(n);
    }

    public void addNotify() {
        super.addNotify();
        if (this.mouse == null && !this.ignoreDesignTime && Beans.isDesignTime()) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        if (this.action == null) {
            this.action = new Action();
            this.previousButton.addActionListener(this.action);
            this.nextButton.addActionListener(this.action);
            this.finishButton.addActionListener(this.action);
            this.cancelButton.addActionListener(this.action);
            this.helpButton.addActionListener(this.action);
        }
    }

    public void removeNotify() {
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.action != null) {
            this.previousButton.removeActionListener(this.action);
            this.nextButton.removeActionListener(this.action);
            this.finishButton.removeActionListener(this.action);
            this.cancelButton.removeActionListener(this.action);
            this.helpButton.removeActionListener(this.action);
            this.action = null;
        }
        super.removeNotify();
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public LayoutManager getLayout() {
        return null;
    }

    public void doLayout() {
        super.doLayout();
        if (this.userComponent != null) {
            Rectangle rectangle = this.panel1.getBounds();
            this.userComponent.setBounds(0, 0, rectangle.width, rectangle.height);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.panel1.setBackground(color);
        this.panel2.setBackground(color);
        this.panel3.setBackground(color);
        this.panel4.setBackground(color);
    }

    public void doFinish() {
        Component component;
        Component component2 = component = this.curIndex != -1 ? this.getComponentAt(this.curIndex) : null;
        if (component == null) {
            return;
        }
        if (this.controller.validatePage(component, null, 2)) {
            this.controller.doFinish();
            this.controllerPrepared = false;
            this.fireActionEvent("Finish");
        }
    }

    public void doCancel() {
        Component component;
        Component component2 = component = this.curIndex != -1 ? this.getComponentAt(this.curIndex) : null;
        if (component == null) {
            return;
        }
        if (this.controller.validatePage(component, null, 3)) {
            this.controller.doCancel();
            this.controllerPrepared = false;
            this.fireActionEvent("Cancel");
        }
    }

    public void doHelp() {
        Component component;
        Component component2 = component = this.curIndex != -1 ? this.getComponentAt(this.curIndex) : null;
        if (component == null) {
            return;
        }
        if (this.controller.validatePage(component, null, 4)) {
            this.controller.doHelp();
            this.fireActionEvent("Help");
        }
    }

    public void setPreviousPageIndex(int n) {
        this.controller.setPreviousPageIndex(n);
    }

    public void setNextPageIndex(int n) {
        this.controller.setNextPageIndex(n);
    }

    public void setPreviousPage(Component component) {
        this.controller.setPreviousPage(component);
    }

    public void setNextPage(Component component) {
        this.controller.setNextPage(component);
    }

    public void goPrevious() {
        Component component = this.curIndex != -1 ? this.getComponentAt(this.curIndex) : null;
        Component component2 = this.controller.getPreviousPage();
        int n = this.getPageIndex(component2);
        if (this.curIndex != -1 && !this.controller.validatePage(component, component2, 0)) {
            return;
        }
        component2 = this.controller.getPreviousPage();
        if (component2 == null) {
            return;
        }
        n = this.getPageIndex(component2);
        if (this.curIndex != -1) {
            this.hidePage();
            this.controller.pageHidden(component);
        }
        this.controller.resetChainInfo();
        this.controller.preparePage(component2, 0);
        this.showPage(component2);
        this.curIndex = n;
        this.controller.pageShown(component2);
        this.updateButtonsState();
    }

    public void goNext() {
        Component component = this.curIndex != -1 ? this.getComponentAt(this.curIndex) : null;
        Component component2 = this.controller.getNextPage();
        int n = this.getPageIndex(component2);
        if (this.curIndex != -1 && !this.controller.validatePage(component, component2, 1)) {
            return;
        }
        component2 = this.controller.getNextPage();
        if (component2 == null) {
            return;
        }
        n = this.getPageIndex(component2);
        if (this.curIndex != -1) {
            this.hidePage();
            this.controller.pageHidden(component);
        }
        this.controller.resetChainInfo();
        this.controller.preparePage(component2, 1);
        this.showPage(component2);
        this.curIndex = n;
        this.controller.pageShown(component2);
        this.updateButtonsState();
    }

    public void updateButtonsState() {
        this.previousButton.setEnabled(this.controller.isPreviousEnabled());
        if (this.combinedButton) {
            this.updateCombinedButton();
        } else {
            this.nextButton.setEnabled(this.controller.isNextEnabled());
            this.finishButton.setEnabled(this.controller.isFinishEnabled());
        }
        this.cancelButton.setEnabled(this.controller.isCancelEnabled());
        this.helpButton.setEnabled(this.controller.isHelpEnabled());
    }

    private void updateCombinedButton() {
        String string = NEXT_LABEL;
        boolean bl = true;
        boolean bl2 = this.controller.isNextEnabled();
        boolean bl3 = this.controller.isFinishEnabled();
        if (!bl2 && !bl3) {
            bl = false;
        } else if (!bl2 && bl3) {
            string = FINISH_LABEL;
        }
        this.nextButton.setLabel(string);
        this.nextButton.setEnabled(bl);
    }

    public void setPreviousEnabled(boolean bl) {
        this.controller.setPreviousEnabled(bl);
    }

    public void setNextEnabled(boolean bl) {
        this.controller.setNextEnabled(bl);
    }

    public void setFinishEnabled(boolean bl) {
        this.controller.setFinishEnabled(bl);
    }

    public void setCancelEnabled(boolean bl) {
        this.controller.setCancelEnabled(bl);
    }

    public void setHelpEnabled(boolean bl) {
        this.controller.setHelpEnabled(bl);
    }

    public Button getPreviousButton() {
        return this.previousButton;
    }

    public Button getNextButton() {
        return this.nextButton;
    }

    public Button getFinishButton() {
        return this.finishButton;
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }

    public Button getHelpButton() {
        return this.helpButton;
    }

    public static void setAlternativeButtonOrder(boolean bl) {
        newButtonOrder = bl;
    }

    public static boolean getAlternativeButtonOrder() {
        return newButtonOrder;
    }

    class Mouse
    extends MouseAdapter
    implements Serializable {
        public void mousePressed(MouseEvent mouseEvent) {
            Component component = Wizard.this.getComponentAt(mouseEvent.getPoint());
            if (component == Wizard.this.panel2) {
                mouseEvent.translatePoint(-Wizard.this.panel2.getLocation().x, -Wizard.this.panel2.getLocation().y);
                component = Wizard.this.panel2.getComponentAt(mouseEvent.getPoint());
                if (component == Wizard.this.panel3) {
                    mouseEvent.translatePoint(-Wizard.this.panel3.getLocation().x, -Wizard.this.panel3.getLocation().y);
                    component = Wizard.this.panel3.getComponentAt(mouseEvent.getPoint());
                    if (component == Wizard.this.previousButton) {
                        Wizard.this.goPrevious();
                        return;
                    }
                    if (component == Wizard.this.nextButton) {
                        Wizard.this.goNext();
                        return;
                    }
                } else if (component == Wizard.this.panel4) {
                    mouseEvent.translatePoint(-Wizard.this.panel4.getLocation().x, -Wizard.this.panel4.getLocation().y);
                    component = Wizard.this.panel4.getComponentAt(mouseEvent.getPoint());
                    System.err.println("  panel4: " + mouseEvent.getPoint());
                }
            }
        }

        Mouse() {
            Wizard.this = Wizard.this;
        }
    }

    class Action
    implements ActionListener,
    Serializable {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == Wizard.this.previousButton) {
                Wizard.this.goPrevious();
                return;
            }
            if (!(object != Wizard.this.nextButton || Wizard.this.combinedButton && Wizard.this.controller.isFinishEnabled())) {
                Wizard.this.goNext();
                return;
            }
            if (object == Wizard.this.finishButton || object == Wizard.this.nextButton && Wizard.this.combinedButton && Wizard.this.controller.isFinishEnabled()) {
                Wizard.this.doFinish();
                return;
            }
            if (object == Wizard.this.cancelButton) {
                Wizard.this.doCancel();
                return;
            }
            if (object == Wizard.this.helpButton) {
                Wizard.this.doHelp();
            }
        }

        Action() {
            Wizard.this = Wizard.this;
        }
    }
}

