/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Component;
import java.beans.Beans;
import java.util.Vector;
import symantec.itools.awt.WizardController;
import symantec.itools.awt.WizardInterface;

public class SimpleWizardController
implements WizardController {
    protected WizardInterface wizard;
    protected Vector stack = new Vector();
    protected int previousPageIndex = -1;
    protected int nextPageIndex = -1;
    protected Component previousPage;
    protected Component nextPage;
    protected int previousEnabled = -1;
    protected int nextEnabled = -1;
    protected int finishEnabled = -1;
    protected int cancelEnabled = -1;
    protected int helpEnabled = -1;
    private boolean ignoreDesignTime = false;

    public SimpleWizardController(WizardInterface wizardInterface) {
        this.wizard = wizardInterface;
    }

    public void doPrepare() {
        this.stack.removeAllElements();
    }

    public void doPrepare(int n) {
        this.doPrepare();
        int n2 = 0;
        while (n2 < n) {
            this.stack.addElement(this.wizard.getComponentAt(n2));
            ++n2;
        }
    }

    public void preparePage(Component component, int n) {
        if (!this.getIgnoreDesignTime() && Beans.isDesignTime()) {
            return;
        }
        if (n == 1) {
            this.stack.addElement(component);
            return;
        }
        if (n == 0 && this.stack.size() > 0) {
            this.stack.removeElementAt(this.stack.size() - 1);
        }
    }

    public void pageShown(Component component) {
    }

    public boolean validatePage(Component component, Component component2, int n) {
        switch (n) {
            case 1: {
                return this.isNextEnabled();
            }
            case 0: {
                return this.isPreviousEnabled();
            }
            case 2: {
                return this.isFinishEnabled();
            }
            case 3: {
                return this.isCancelEnabled();
            }
            case 4: {
                return this.isHelpEnabled();
            }
        }
        return false;
    }

    public void pageHidden(Component component) {
    }

    public void doFinish() {
    }

    public void doCancel() {
    }

    public void doHelp() {
    }

    public boolean isPreviousEnabled() {
        if (this.previousEnabled == 0) {
            return false;
        }
        if (this.previousEnabled == 1) {
            return true;
        }
        return this.getPreviousPage() != null;
    }

    public boolean isNextEnabled() {
        if (this.nextEnabled == 0) {
            return false;
        }
        if (this.nextEnabled == 1) {
            return true;
        }
        return this.getNextPage() != null;
    }

    public boolean isFinishEnabled() {
        if (this.finishEnabled == 0) {
            return false;
        }
        if (this.finishEnabled == 1) {
            return true;
        }
        int n = this.wizard.getSelectedIndex();
        int n2 = this.wizard.getPageCount();
        if (this.getIgnoreDesignTime() || !Beans.isDesignTime()) {
            if (n2 > 0 && n != -1) {
                return n == n2 - 1;
            }
            return false;
        }
        return false;
    }

    public boolean isCancelEnabled() {
        if (this.cancelEnabled == 0) {
            return false;
        }
        if (this.cancelEnabled == 1) {
            return true;
        }
        return this.getIgnoreDesignTime() || !Beans.isDesignTime();
    }

    public boolean isHelpEnabled() {
        if (this.helpEnabled == 0) {
            return false;
        }
        if (this.helpEnabled == 1) {
            return true;
        }
        return this.getIgnoreDesignTime() || !Beans.isDesignTime();
    }

    public Component getPreviousPage() {
        if (this.getIgnoreDesignTime() || !Beans.isDesignTime()) {
            if (this.previousPage != null) {
                return this.previousPage;
            }
            if (this.previousPageIndex != -1) {
                return this.wizard.getComponentAt(this.previousPageIndex);
            }
            if (this.stack.size() > 1) {
                return (Component)this.stack.elementAt(this.stack.size() - 2);
            }
            return null;
        }
        int n = this.wizard.getSelectedIndex();
        int n2 = this.wizard.getPageCount();
        if (n2 > 0 && n > 0) {
            return this.wizard.getComponentAt(n - 1);
        }
        return null;
    }

    public Component getNextPage() {
        int n = this.wizard.getSelectedIndex();
        int n2 = this.wizard.getPageCount();
        if (this.getIgnoreDesignTime() || !Beans.isDesignTime()) {
            if (this.nextPage != null) {
                return this.nextPage;
            }
            if (this.nextPageIndex != -1) {
                return this.wizard.getComponentAt(this.nextPageIndex);
            }
            if (n2 > 0 && n != -1 && n != n2 - 1) {
                return this.wizard.getComponentAt(n + 1);
            }
            if (n2 > 0 && n == -1) {
                return this.wizard.getComponentAt(0);
            }
            return null;
        }
        if (n2 > 0 && n != -1 && n != n2 - 1) {
            return this.wizard.getComponentAt(n + 1);
        }
        return null;
    }

    public void setPreviousPageIndex(int n) {
        this.previousPageIndex = n;
    }

    public void setNextPageIndex(int n) {
        this.nextPageIndex = n;
    }

    public void setPreviousPage(Component component) {
        this.previousPage = component;
    }

    public void setNextPage(Component component) {
        this.nextPage = component;
    }

    public void setPreviousEnabled(boolean bl) {
        this.previousEnabled = bl ? 1 : 0;
        this.wizard.updateButtonsState();
    }

    public void setNextEnabled(boolean bl) {
        this.nextEnabled = bl ? 1 : 0;
        this.wizard.updateButtonsState();
    }

    public void setFinishEnabled(boolean bl) {
        this.finishEnabled = bl ? 1 : 0;
        this.wizard.updateButtonsState();
    }

    public void setCancelEnabled(boolean bl) {
        this.cancelEnabled = bl ? 1 : 0;
        this.wizard.updateButtonsState();
    }

    public void setHelpEnabled(boolean bl) {
        this.helpEnabled = bl ? 1 : 0;
        this.wizard.updateButtonsState();
    }

    public void resetChainInfo() {
        this.previousPage = null;
        this.previousPageIndex = -1;
        this.nextPage = null;
        this.nextPageIndex = -1;
        this.previousEnabled = -1;
        this.nextEnabled = -1;
        this.finishEnabled = -1;
        this.cancelEnabled = -1;
        this.helpEnabled = -1;
    }

    public void setIgnoreDesignTime(boolean bl) {
        this.ignoreDesignTime = bl;
    }

    public boolean getIgnoreDesignTime() {
        return this.ignoreDesignTime;
    }
}

