/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.net.URL;
import symantec.itools.awt.InvisibleButton;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.util.GeneralUtils;

public class InvisibleHTMLLink
extends InvisibleButton {
    protected URL url = null;
    protected transient AppletContext context = null;
    protected String frame = null;
    private Action action;
    private Mouse mouse;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public void setURL(URL uRL) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.url, uRL)) {
            URL uRL2 = this.url;
            this.vetos.fireVetoableChange("URL", uRL2, uRL);
            this.url = uRL;
            this.context = null;
            this.changes.firePropertyChange("URL", uRL2, uRL);
        }
    }

    public URL getURL() {
        return this.url;
    }

    public void setFrame(String string) throws PropertyVetoException {
        String string2 = this.frame;
        this.vetos.fireVetoableChange("Frame", string2, string);
        this.frame = string;
        this.changes.firePropertyChange("Frame", string2, string);
    }

    public String getFrame() {
        return this.frame;
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.action == null) {
            this.action = new Action();
            this.addActionListener(this.action);
        }
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Applet) {
                this.setAppletContext(((Applet)container).getAppletContext());
                return;
            }
            container = container.getParent();
        }
    }

    public synchronized void removeNotify() {
        if (this.action != null) {
            this.removeActionListener(this.action);
            this.action = null;
        }
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        super.removeNotify();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.addVetoableChangeListener(vetoableChangeListener);
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.removeVetoableChangeListener(vetoableChangeListener);
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    protected void setAppletContext(AppletContext appletContext) {
        this.context = appletContext;
    }

    class Mouse
    extends MouseAdapter {
        boolean statusChanged = false;

        public void mouseEntered(MouseEvent mouseEvent) {
            if (InvisibleHTMLLink.this.context != null && InvisibleHTMLLink.this.url != null) {
                this.statusChanged = true;
                InvisibleHTMLLink.this.context.showStatus(InvisibleHTMLLink.this.url.toString());
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (InvisibleHTMLLink.this.context != null && this.statusChanged) {
                this.statusChanged = false;
                InvisibleHTMLLink.this.context.showStatus("");
            }
        }

        Mouse() {
            InvisibleHTMLLink.this = InvisibleHTMLLink.this;
        }
    }

    class Action
    implements ActionListener,
    Serializable {
        public void actionPerformed(ActionEvent actionEvent) {
            if (InvisibleHTMLLink.this.context != null && InvisibleHTMLLink.this.url != null) {
                if (InvisibleHTMLLink.this.frame == null || InvisibleHTMLLink.this.frame.length() == 0) {
                    InvisibleHTMLLink.this.context.showDocument(InvisibleHTMLLink.this.url);
                    return;
                }
                InvisibleHTMLLink.this.context.showDocument(InvisibleHTMLLink.this.url, InvisibleHTMLLink.this.frame);
            }
        }

        Action() {
            InvisibleHTMLLink.this = InvisibleHTMLLink.this;
        }
    }
}

