/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.FilteredImageSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import symantec.itools.awt.ButtonBase;
import symantec.itools.awt.image.DarkenFilter;
import symantec.itools.awt.image.FadeFilter;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;

public class ImageButton
extends ButtonBase {
    public static final int IMAGE_TILED = 0;
    public static final int IMAGE_CENTERED = 1;
    public static final int IMAGE_SCALED_TO_FIT = 2;
    public static final int IMAGE_NORMAL = 3;
    protected int imageStyle;
    protected URL imageURL;
    protected transient Image enabledImage;
    protected transient Image disabledImage;
    protected transient Image pressedImage;
    protected transient ResourceBundle errors;
    private StyleVeto styleVeto;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public ImageButton() {
        try {
            this.setImageStyle(1);
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
    }

    public void setImageURL(URL uRL) throws PropertyVetoException {
        MediaTracker mediaTracker;
        Image image;
        if (uRL.getFile() == "/") {
            return;
        }
        URL uRL2 = this.imageURL;
        this.vetos.fireVetoableChange("ImageURL", uRL2, uRL);
        this.enabledImage = null;
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = null;
        if (this.pressedImage != null) {
            this.pressedImage.flush();
        }
        this.pressedImage = null;
        this.imageURL = uRL;
        if (this.imageURL != null && (image = this.getToolkit().getImage(this.imageURL)) != null && (mediaTracker = new MediaTracker(this)) != null) {
            try {
                mediaTracker.addImage(image, 0);
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {}
            if (mediaTracker.isErrorAny()) {
                Object[] objectArray = new Object[]{image.toString()};
                System.err.println(MessageFormat.format(this.errors.getString("ErrorLoadingImage"), objectArray));
                return;
            }
            this.enabledImage = image;
            this.disabledImage = this.createImage(new FilteredImageSource(image.getSource(), new FadeFilter(0.333)));
            this.pressedImage = this.createImage(new FilteredImageSource(image.getSource(), new DarkenFilter(0.25)));
            this.changes.firePropertyChange("ImageURL", uRL2, uRL);
        }
        this.repaint();
    }

    public URL getImageURL() {
        return this.imageURL;
    }

    public void setImageStyle(int n) throws PropertyVetoException {
        if (n != this.imageStyle) {
            Integer n2 = new Integer(this.imageStyle);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("ImageStyle", n2, n3);
            this.imageStyle = n;
            this.repaint();
            this.changes.firePropertyChange("ImageStyle", n2, n3);
        }
    }

    public int getImageStyle() {
        return this.imageStyle;
    }

    public void setScaleMode(boolean bl) throws PropertyVetoException {
        if (bl) {
            this.setImageStyle(2);
            return;
        }
        this.setImageStyle(3);
    }

    public boolean isScaleMode() {
        return this.getImageStyle() == 2;
    }

    public boolean getScaleMode() {
        return this.isScaleMode();
    }

    public void setCenterMode(boolean bl) throws PropertyVetoException {
        if (bl) {
            this.setImageStyle(1);
            return;
        }
        this.setImageStyle(3);
    }

    public boolean isCenterMode() {
        return this.getImageStyle() == 1;
    }

    public boolean getCenterMode() {
        return this.isCenterMode();
    }

    public boolean isValidImageStyle(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.enabledImage == null) {
            return dimension;
        }
        return new Dimension(dimension.width + this.enabledImage.getWidth(this), dimension.height + this.enabledImage.getHeight(this));
    }

    public synchronized void addNotify() {
        super.addNotify();
        this.errors = ResourceBundle.getBundle("symantec.itools.resources.ErrorsBundle");
        if (this.styleVeto == null) {
            this.styleVeto = new StyleVeto();
            this.addImageStyleListener(this.styleVeto);
        }
    }

    public synchronized void removeNotify() {
        if (this.styleVeto != null) {
            this.removeImageStyleListener(this.styleVeto);
            this.styleVeto = null;
        }
        super.removeNotify();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.addVetoableChangeListener(vetoableChangeListener);
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.removeVetoableChangeListener(vetoableChangeListener);
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void addImageStyleListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener("ImageStyle", propertyChangeListener);
    }

    public synchronized void removeImageStyleListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener("ImageStyle", propertyChangeListener);
    }

    public synchronized void addImageStyleListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener("ImageStyle", vetoableChangeListener);
    }

    public synchronized void removeImageStyleListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener("ImageStyle", vetoableChangeListener);
    }

    protected void updateButtonImage() {
        super.updateButtonImage();
        Image image = this.pressed ? this.pressedImage : (this.isEnabled() ? this.enabledImage : this.disabledImage);
        Dimension dimension = this.size();
        int n = this.bevel + 1 + this.pressedAdjustment;
        int n2 = this.bevel + 1 + this.pressedAdjustment;
        int n3 = dimension.width - this.bevel - this.bevel - 2;
        int n4 = dimension.height - this.bevel - this.bevel - 2;
        if (image == null) {
            this.buttonImageGraphics.clearRect(n, n2, n3, n4);
            return;
        }
        int n5 = image.getWidth(this);
        int n6 = image.getHeight(this);
        switch (this.imageStyle) {
            default: {
                this.buttonImageGraphics.drawImage(image, n + (n3 - n5) / 2, n2 + (n4 - n6) / 2, this);
                return;
            }
            case 0: {
                int n7 = n3 / n5;
                if (n3 % n5 != 0) {
                    ++n7;
                }
                int n8 = n4 / n6;
                if (n4 % n6 != 0) {
                    ++n8;
                }
                int n9 = n2;
                int n10 = 0;
                while (n10 < n8) {
                    int n11 = n;
                    int n12 = 0;
                    while (n12 < n7) {
                        this.buttonImageGraphics.drawImage(image, n11, n9, n5, n6, this);
                        n11 += n5;
                        ++n12;
                    }
                    n9 += n6;
                    ++n10;
                }
                return;
            }
            case 2: {
                this.buttonImageGraphics.drawImage(image, n, n2, n3, n4, this);
                return;
            }
            case 3: 
        }
        this.buttonImageGraphics.drawImage(image, n, n2, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        MediaTracker mediaTracker;
        Image image;
        objectInputStream.defaultReadObject();
        if (this.imageURL != null && (image = this.getToolkit().getImage(this.imageURL)) != null && (mediaTracker = new MediaTracker(this)) != null) {
            try {
                mediaTracker.addImage(image, 0);
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {}
            if (mediaTracker.isErrorAny()) {
                Object[] objectArray = new Object[]{image.toString()};
                System.err.println(MessageFormat.format(this.errors.getString("ErrorLoadingImage"), objectArray));
                return;
            }
            this.enabledImage = image;
            this.disabledImage = this.createImage(new FilteredImageSource(image.getSource(), new FadeFilter(0.333)));
            this.pressedImage = this.createImage(new FilteredImageSource(image.getSource(), new DarkenFilter(0.25)));
        }
    }

    class StyleVeto
    implements VetoableChangeListener,
    Serializable {
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            int n = (Integer)propertyChangeEvent.getNewValue();
            if (!ImageButton.this.isValidImageStyle(n)) {
                throw new PropertyVetoException(String.valueOf(ImageButton.this.errors.getString("InvalidImageStyle")) + n, propertyChangeEvent);
            }
        }

        StyleVeto() {
            ImageButton.this = ImageButton.this;
        }
    }
}

