/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

final class Matrix
implements Serializable {
    Kaztrix parent;
    Matrix rowHead;
    Matrix nextRow;
    Matrix nextElt;
    int row;
    int col;
    Object o;

    public Matrix(Kaztrix kaztrix) {
        this.parent = kaztrix;
        this.rowHead = this;
    }

    private Matrix(Kaztrix kaztrix, int n, int n2, Object object) {
        this(kaztrix, n, n2, object, null);
    }

    private Matrix(Kaztrix kaztrix, int n, int n2, Object object, Matrix matrix, Matrix matrix2, Matrix matrix3) {
        this.parent = kaztrix;
        this.rowHead = matrix == null ? (n2 != 0 ? new Matrix(kaztrix, n, 0, null, null, matrix2, this) : this) : matrix;
        this.row = n;
        this.col = n2;
        this.o = object;
        this.nextRow = matrix2;
        this.nextElt = matrix3;
    }

    private Matrix(Kaztrix kaztrix, int n, int n2, Object object, Matrix matrix, Matrix matrix2) {
        this(kaztrix, n, n2, object, null, matrix, matrix2);
    }

    private Matrix(Kaztrix kaztrix, int n, int n2, Object object, Matrix matrix) {
        this(kaztrix, n, n2, object, null, matrix, null);
    }

    public synchronized void addElement(int n, int n2, Object object) throws IllegalArgumentException {
        Matrix matrix = this.nearest(n, n2);
        if (matrix.row != n) {
            matrix.setNextRow(new Matrix((Kaztrix)this.parent, (int)n, (int)n2, (Object)object, (Matrix)matrix.nextRow).rowHead);
            return;
        }
        if (n2 == matrix.col && n2 == 0 && matrix.o == null) {
            matrix.o = object;
            return;
        }
        matrix.nextElt = new Matrix(this.parent, n, n2, object, matrix.rowHead, matrix.nextRow, matrix.nextElt);
    }

    public synchronized void updateElement(int n, int n2, Object object) {
        Matrix matrix = this.nearest(n, n2);
        try {
            if (matrix == null) {
                this.addElement(n, n2, object);
            } else if (matrix.row != n || matrix.col != n2) {
                matrix.addElement(n, n2, object);
            } else {
                matrix.o = object;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
    }

    public synchronized void removeAllElements() {
        this.nextRow = null;
        this.nextElt = null;
        this.o = null;
    }

    public synchronized Object elementAt(int n, int n2) throws ArrayIndexOutOfBoundsException {
        Matrix matrix = this.nearest(n, n2);
        if (matrix == null || matrix.row != n || matrix.col != n2 || matrix.o == null) {
            // empty if block
        }
        return matrix.o;
    }

    public synchronized void removeElementAt(int n, int n2) throws ArrayIndexOutOfBoundsException {
        Matrix matrix = this.nearest(n, n2);
        if (matrix == null || matrix.row != n || matrix.col != n2) {
            // empty if block
        }
        if (n2 == 0) {
            matrix.o = null;
            return;
        }
        Matrix matrix2 = matrix = matrix.rowHead;
        while (matrix.col != n2) {
            matrix2 = matrix;
            matrix = matrix.nextElt;
        }
        matrix2.nextElt = matrix.nextElt;
    }

    public synchronized void sort(CompareFunc compareFunc, int n) {
        boolean bl = true;
        Matrix matrix = this;
        Matrix matrix2 = null;
        while (matrix != null) {
            matrix2 = this.findLeast(compareFunc, matrix, n, bl);
            if (matrix2 != null) {
                Integer n2;
                if (matrix.row == 0 && bl) {
                    bl = false;
                    if (compareFunc instanceof CompareFuncCB) {
                        ((CompareFuncCB)compareFunc).callBackSwap(matrix, matrix2.nextRow);
                    }
                    n2 = (Integer)this.parent.searchV.elementAt(matrix.row);
                    this.parent.searchV.setElementAt(this.parent.searchV.elementAt(matrix2.nextRow.row), matrix.row);
                    this.parent.searchV.setElementAt(n2, matrix2.nextRow.row);
                    this.swapRows(matrix2);
                    matrix = this;
                    continue;
                }
                if (compareFunc instanceof CompareFuncCB) {
                    ((CompareFuncCB)compareFunc).callBackSwap(matrix.nextRow, matrix2.nextRow);
                }
                n2 = (Integer)this.parent.searchV.elementAt(matrix.nextRow.row);
                this.parent.searchV.setElementAt(this.parent.searchV.elementAt(matrix2.nextRow.row), matrix.nextRow.row);
                this.parent.searchV.setElementAt(n2, matrix2.nextRow.row);
                this.swapRows(matrix, matrix2);
            }
            if (bl) {
                bl = false;
                continue;
            }
            matrix = matrix.nextRow;
        }
    }

    public synchronized int rows() {
        Matrix matrix = this;
        while (matrix.nextRow != null) {
            matrix = matrix.nextRow;
        }
        return matrix.nextElt == null && matrix.o == null ? matrix.row : matrix.row + 1;
    }

    private synchronized void updateRowNum(int n) {
        Matrix matrix = this;
        while (matrix != null) {
            matrix.row = n;
            matrix = matrix.nextElt;
        }
    }

    public synchronized MatrixEnumeration elements() {
        return new MatrixEnumeration(this);
    }

    public synchronized String toString() {
        return "Matrix: row=" + this.row + " col=" + this.col + " o=" + this.o;
    }

    private synchronized Matrix nearest(int n, int n2) {
        Matrix matrix = this;
        while (n > matrix.row) {
            if (matrix.nextRow != null && matrix.nextRow.row <= n) {
                matrix = matrix.nextRow;
                continue;
            }
            return matrix;
        }
        while (matrix.nextElt != null && n2 >= matrix.nextElt.col) {
            matrix = matrix.nextElt;
        }
        return matrix;
    }

    private synchronized void setRowHead() {
        Matrix matrix = this.nextElt;
        Matrix matrix2 = this;
        while (matrix != null) {
            matrix.rowHead = matrix2;
            matrix = matrix.nextElt;
        }
    }

    private synchronized void setNextRow(Matrix matrix) {
        Matrix matrix2 = this;
        while (matrix2 != null) {
            matrix2.nextRow = matrix;
            matrix2 = matrix2.nextElt;
        }
    }

    private synchronized void swapRows(Matrix matrix, Matrix matrix2) {
        Matrix matrix3 = matrix.nextRow;
        Matrix matrix4 = matrix3.nextRow;
        Matrix matrix5 = matrix2.nextRow;
        Matrix matrix6 = matrix5.nextRow;
        matrix.setNextRow(matrix5);
        matrix2.setNextRow(matrix3);
        if (matrix2 == matrix3) {
            matrix5.setNextRow(matrix3);
        } else {
            matrix5.setNextRow(matrix4);
        }
        matrix3.setNextRow(matrix6);
        int n = matrix3.row;
        matrix3.updateRowNum(matrix5.row);
        matrix5.updateRowNum(n);
    }

    private synchronized void swapRows(Matrix matrix) {
        Matrix matrix2 = matrix.nextRow;
        Matrix matrix3 = new Matrix(this.parent, -1, matrix2.col, this.o, null, this.nextElt);
        matrix.rowHead.setNextRow(matrix3);
        matrix3.setNextRow(matrix2.nextRow);
        matrix3.updateRowNum(matrix2.row);
        matrix3.setRowHead();
        this.nextElt = matrix2.nextElt;
        this.o = matrix2.o;
        this.setNextRow(this.nextRow);
        this.updateRowNum(0);
        this.setRowHead();
    }

    private synchronized Matrix findLeast(CompareFunc compareFunc, Matrix matrix, int n, boolean bl) {
        if (!bl) {
            matrix = matrix.nextRow;
        }
        if (matrix == null || matrix.nextRow == null) {
            return null;
        }
        Matrix matrix2 = matrix.nextRow.rowHead;
        Matrix matrix3 = matrix.rowHead;
        Matrix matrix4 = null;
        matrix = matrix.nearest(matrix.row, n);
        while (matrix2 != null) {
            matrix2 = matrix2.nearest(matrix2.row, n);
            if (matrix2.col != n) {
                matrix3 = matrix2.rowHead;
                matrix2 = matrix2.nextRow;
                continue;
            }
            if (matrix.col != n) {
                matrix = matrix2;
                matrix4 = matrix3;
                continue;
            }
            if (compareFunc.lessThan(matrix2.o, matrix.o)) {
                matrix = matrix2;
                matrix4 = matrix3;
            }
            matrix3 = matrix2.rowHead;
            matrix2 = matrix2.nextRow;
        }
        return matrix4;
    }
}

