/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.mortbay.util.Code;
import org.mortbay.util.MultiMap;
import org.mortbay.util.StringUtil;

public class UrlEncoded
extends MultiMap {
    public void decode(String query) {
        UrlEncoded.decodeTo(query, this, StringUtil.__ISO_8859_1);
    }

    public void decode(String query, String charset) {
        UrlEncoded.decodeTo(query, this, charset);
    }

    public String encode() {
        return this.encode(StringUtil.__ISO_8859_1, false);
    }

    public String encode(String charset) {
        return this.encode(charset, false);
    }

    public String encode(boolean equalsForNullValue) {
        return this.encode(StringUtil.__ISO_8859_1, equalsForNullValue);
    }

    public synchronized String encode(String charset, boolean equalsForNullValue) {
        StringBuffer result;
        if (charset == null) {
            charset = StringUtil.__ISO_8859_1;
        }
        StringBuffer stringBuffer = result = new StringBuffer(128);
        synchronized (stringBuffer) {
            Iterator iter = this.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = entry.getKey().toString();
                Object value = entry.getValue();
                if (value == null) {
                    result.append(URLEncoder.encode(key));
                    if (equalsForNullValue) {
                        result.append('=');
                    }
                } else if (value instanceof List) {
                    List values = (List)value;
                    int v = 0;
                    while (v < values.size()) {
                        if (v > 0) {
                            result.append('&');
                        }
                        Object val = values.get(v);
                        result.append(UrlEncoded.encodeString(key, charset));
                        if (val != null) {
                            String str = val.toString();
                            if (str.length() > 0) {
                                result.append('=');
                                result.append(UrlEncoded.encodeString(str, charset));
                            } else if (equalsForNullValue) {
                                result.append('=');
                            }
                        } else if (equalsForNullValue) {
                            result.append('=');
                        }
                        ++v;
                    }
                } else {
                    result.append(UrlEncoded.encodeString(key, charset));
                    if (value != null) {
                        String str = value.toString();
                        if (str.length() > 0) {
                            result.append('=');
                            result.append(UrlEncoded.encodeString(str, charset));
                        } else if (equalsForNullValue) {
                            result.append('=');
                        }
                    } else if (equalsForNullValue) {
                        result.append('=');
                    }
                }
                if (!iter.hasNext()) continue;
                result.append('&');
            }
            String string = result.toString();
            Object var5_14 = null;
            return string;
        }
    }

    public static void decodeTo(String content, MultiMap map) {
        UrlEncoded.decodeTo(content, map, StringUtil.__ISO_8859_1);
    }

    public static void decodeTo(String content, MultiMap map, String charset) {
        if (charset == null) {
            charset = StringUtil.__ISO_8859_1;
        }
        MultiMap multiMap = map;
        synchronized (multiMap) {
            StringTokenizer tokenizer = new StringTokenizer(content, "&", false);
            while (tokenizer.hasMoreTokens()) {
                String value;
                String string;
                String name;
                String token = tokenizer.nextToken();
                int i = token.indexOf(61);
                if (i < 0) {
                    name = UrlEncoded.decodeString(token, charset);
                    string = "";
                } else {
                    name = UrlEncoded.decodeString(token.substring(0, i++), charset);
                    if (i >= token.length()) {
                        string = "";
                    } else {
                        value = UrlEncoded.decodeString(token.substring(i), charset);
                    }
                }
                if (name.length() <= 0) continue;
                map.add(name, value);
            }
        }
    }

    public static String decodeString(String encoded) {
        return UrlEncoded.decodeString(encoded, StringUtil.__ISO_8859_1);
    }

    public static String decodeString(String encoded, String charset) {
        if (charset == null) {
            charset = StringUtil.__ISO_8859_1;
        }
        int len = encoded.length();
        byte[] bytes = null;
        int n = 0;
        StringBuffer buf = null;
        int i = 0;
        while (i < len) {
            char c = encoded.charAt(i);
            if (c < '\u0000' || c > '\u00ff') {
                throw new IllegalArgumentException("Not decoded");
            }
            if (c == '+') {
                if (buf == null) {
                    buf = new StringBuffer(len);
                    int j = 0;
                    while (j < i) {
                        buf.append(encoded.charAt(j));
                        ++j;
                    }
                }
                if (n > 0) {
                    try {
                        buf.append(new String(bytes, 0, n, charset));
                    }
                    catch (UnsupportedEncodingException e) {
                        buf.append(new String(bytes, 0, n));
                    }
                    n = 0;
                }
                buf.append(' ');
            } else if (c == '%' && i + 2 < len) {
                byte b;
                byte e;
                char cn = encoded.charAt(i + 1);
                if (cn >= 'a' && cn <= 'z') {
                    e = (byte)(10 + cn - 97);
                } else if (cn >= 'A' && cn <= 'Z') {
                    e = (byte)(10 + cn - 65);
                } else {
                    b = (byte)(cn - 48);
                }
                cn = encoded.charAt(i + 2);
                b = cn >= 'a' && cn <= 'z' ? (byte)(b * 16 + 10 + cn - 97) : (cn >= 'A' && cn <= 'Z' ? (byte)(b * 16 + 10 + cn - 65) : (byte)(b * 16 + cn - 48));
                if (buf == null) {
                    buf = new StringBuffer(len);
                    int j = 0;
                    while (j < i) {
                        buf.append(encoded.charAt(j));
                        ++j;
                    }
                }
                i += 2;
                if (bytes == null) {
                    bytes = new byte[len];
                }
                bytes[n++] = b;
            } else if (buf != null) {
                if (n > 0) {
                    try {
                        buf.append(new String(bytes, 0, n, charset));
                    }
                    catch (UnsupportedEncodingException e) {
                        buf.append(new String(bytes, 0, n));
                    }
                    n = 0;
                }
                buf.append(c);
            }
            ++i;
        }
        if (buf == null) {
            return encoded;
        }
        if (n > 0) {
            try {
                buf.append(new String(bytes, 0, n, charset));
            }
            catch (UnsupportedEncodingException e) {
                buf.append(new String(bytes, 0, n));
            }
        }
        return buf.toString();
    }

    public static String encodeString(String string) {
        return UrlEncoded.encodeString(string, StringUtil.__ISO_8859_1);
    }

    public static String encodeString(String string, String charset) {
        if (charset == null) {
            charset = StringUtil.__ISO_8859_1;
        }
        byte[] bytes = null;
        try {
            bytes = string.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            Code.warning(e);
            bytes = string.getBytes();
        }
        int len = bytes.length;
        byte[] encoded = new byte[bytes.length * 3];
        int n = 0;
        boolean noEncode = true;
        int i = 0;
        while (i < len) {
            byte b = bytes[i];
            if (b == 32) {
                noEncode = false;
                encoded[n++] = 43;
            } else if (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57) {
                encoded[n++] = b;
            } else {
                noEncode = false;
                encoded[n++] = 37;
                byte nibble = (byte)((b & 0xF0) >> 4);
                encoded[n++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
                nibble = (byte)(b & 0xF);
                encoded[n++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
            }
            ++i;
        }
        if (noEncode) {
            return string;
        }
        try {
            return new String(encoded, 0, n, charset);
        }
        catch (UnsupportedEncodingException e) {
            Code.warning(e);
            return new String(encoded, 0, n);
        }
    }

    public Object clone() {
        return new UrlEncoded(this);
    }

    public UrlEncoded(UrlEncoded url) {
        super(url);
    }

    public UrlEncoded() {
        super(10);
    }

    public UrlEncoded(String s) {
        super(6);
        this.decode(s, StringUtil.__ISO_8859_1);
    }

    public UrlEncoded(String s, String charset) {
        super(6);
        this.decode(s, charset);
    }
}

