/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.mortbay.util.Code;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.Log;
import org.mortbay.util.ThreadPool;

public abstract class ThreadedServer
extends ThreadPool {
    private InetAddrPort _address = null;
    private ServerSocket _listen = null;
    private int _soTimeOut = -1;
    private int _maxReadTimeMs = 0;
    private int _lingerTimeSecs = 30;
    private Acceptor _acceptor = null;

    public ServerSocket getServerSocket() {
        return this._listen;
    }

    public synchronized void setAddress(InetAddrPort address) {
        if (this._address == null) {
            this._address = address;
        } else if (this.isStarted()) {
            if (!this._address.equals(address)) {
                throw new IllegalStateException(this + " is started");
            }
        } else {
            this._address = address;
        }
    }

    public synchronized void setHost(String host) throws UnknownHostException {
        if (this._address == null) {
            this._address = new InetAddrPort(host, 0);
        } else if (this.isStarted()) {
            if (!this._address.getHost().equals(host)) {
                throw new IllegalStateException(this + " is started");
            }
        } else {
            this._address.setHost(host);
        }
    }

    public synchronized void setInetAddress(InetAddress addr) {
        if (this._address == null) {
            this._address = new InetAddrPort(addr, 0);
        } else if (this.isStarted()) {
            if (!this._address.getInetAddress().equals(addr)) {
                throw new IllegalStateException(this + " is started");
            }
        } else {
            this._address.setInetAddress(addr);
        }
    }

    public synchronized void setPort(int port) {
        if (this._address == null) {
            this._address = new InetAddrPort(port);
        } else if (this.isStarted()) {
            if (this._address.getPort() != port) {
                throw new IllegalStateException(this + " is started");
            }
        } else {
            this._address.setPort(port);
        }
    }

    public void setMaxReadTimeMs(int ms) {
        this._maxReadTimeMs = ms;
    }

    public int getMaxReadTimeMs() {
        return this._maxReadTimeMs;
    }

    public void setLingerTimeSecs(int ls) {
        this._lingerTimeSecs = ls;
    }

    public int getLingerTimeSecs() {
        return this._lingerTimeSecs;
    }

    public InetAddrPort getInetAddrPort() {
        if (this._address == null) {
            return null;
        }
        return new InetAddrPort(this._address);
    }

    public InetAddress getInetAddress() {
        if (this._address == null) {
            return null;
        }
        return this._address.getInetAddress();
    }

    public String getHost() {
        if (this._address == null || this._address.getInetAddress() == null) {
            return null;
        }
        return this._address.getHost();
    }

    public int getPort() {
        if (this._address == null) {
            return 0;
        }
        return this._address.getPort();
    }

    protected void handleConnection(InputStream in, OutputStream out) {
        throw new Error("Either handlerConnection must be overridden");
    }

    protected void handleConnection(Socket connection) throws IOException {
        Code.debug((Object)"Handle ", (Object)connection);
        InputStream in = connection.getInputStream();
        OutputStream out = connection.getOutputStream();
        this.handleConnection(in, out);
        out.flush();
        in = null;
        Object var3_3 = null;
    }

    /*
     * Loose catch block
     */
    public void handle(Object job) {
        block8: {
            Socket socket = (Socket)job;
            this.handleConnection(socket);
            Object var4_3 = null;
            try {
                socket.close();
            }
            catch (Exception e2) {
                Code.warning("Connection problem", e2);
            }
            break block8;
            {
                catch (Exception e) {
                    Code.warning("Connection problem", e);
                    Object var4_4 = null;
                    try {
                        socket.close();
                    }
                    catch (Exception e2) {
                        Code.warning("Connection problem", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                try {
                    socket.close();
                }
                catch (Exception e2) {
                    Code.warning("Connection problem", e2);
                }
                throw throwable;
            }
        }
    }

    protected ServerSocket newServerSocket(InetAddrPort address, int acceptQueueSize) throws IOException {
        if (address == null) {
            return new ServerSocket(0, acceptQueueSize);
        }
        return new ServerSocket(address.getPort(), acceptQueueSize, address.getInetAddress());
    }

    /*
     * WARNING - void declaration
     */
    protected Socket acceptSocket(ServerSocket serverSocket, int timeout) {
        try {
            void e;
            if (this._soTimeOut != timeout) {
                this._soTimeOut = timeout;
                this._listen.setSoTimeout(this._soTimeOut);
            }
            Socket s = this._listen.accept();
            try {
                if (this._maxReadTimeMs >= 0) {
                    s.setSoTimeout(this._maxReadTimeMs);
                }
                if (this._lingerTimeSecs >= 0) {
                    s.setSoLinger(true, this._lingerTimeSecs);
                } else {
                    s.setSoLinger(false, 0);
                }
            }
            catch (Exception e2) {
                Code.ignore(e2);
            }
            return e;
        }
        catch (SocketException e) {
            Code.ignore(e);
        }
        catch (InterruptedIOException e) {
            if (Code.verbose(99)) {
                Code.ignore(e);
            }
        }
        catch (IOException e) {
            Code.warning(e);
        }
        return null;
    }

    public synchronized void start() throws Exception {
        if (this.isStarted()) {
            Code.warning("Already started on " + this._address);
            return;
        }
        this._listen = this.newServerSocket(this._address, this.getMaxThreads() > 0 ? this.getMaxThreads() + 1 : 50);
        if (this._address == null) {
            this._address = new InetAddrPort(this._listen.getInetAddress(), this._listen.getLocalPort());
        } else {
            if (this._address.getInetAddress() == null) {
                this._address.setInetAddress(this._listen.getInetAddress());
            }
            if (this._address.getPort() == 0) {
                this._address.setPort(this._listen.getLocalPort());
            }
        }
        this._soTimeOut = this.getMaxIdleTimeMs();
        if (this._soTimeOut >= 0) {
            this._listen.setSoTimeout(this._soTimeOut);
        }
        this._acceptor = new Acceptor();
        this._acceptor.start();
        super.start();
    }

    public void stop() throws InterruptedException {
        if (this._acceptor != null) {
            this._acceptor._running = false;
            this._acceptor.interrupt();
            Thread.yield();
        }
        ThreadedServer threadedServer = this;
        synchronized (threadedServer) {
            if (this._acceptor != null) {
                this._acceptor.forceStop();
            }
            this._acceptor = null;
        }
        try {
            super.stop();
        }
        catch (Exception e) {
            Code.warning(e);
        }
        this._listen = null;
        this._acceptor = null;
    }

    public synchronized void destroy() {
        if (this._acceptor != null) {
            this._acceptor._running = false;
            this._acceptor.interrupt();
            Thread.yield();
        }
        ThreadedServer threadedServer = this;
        synchronized (threadedServer) {
            if (this._acceptor != null) {
                this._acceptor.forceStop();
            }
            this._acceptor = null;
        }
        try {
            super.destroy();
            ThreadedServer threadedServer2 = this;
            synchronized (threadedServer2) {
                if (this._listen != null) {
                    this._listen.close();
                }
            }
        }
        catch (Exception e) {
            Code.warning(e);
        }
        this._listen = null;
        this._acceptor = null;
    }

    protected void stopJob(Thread thread, Object job) {
        ThreadPool.PoolThread poolThread;
        if (job instanceof Socket && thread instanceof ThreadPool.PoolThread && !(poolThread = (ThreadPool.PoolThread)thread).isActive()) {
            Log.event("close " + job);
            try {
                ((Socket)job).close();
            }
            catch (Exception e) {
                Code.ignore(e);
            }
        }
        super.stopJob(thread, job);
    }

    protected void killJob(Thread thread, Object job) {
        if (job instanceof Socket) {
            Log.event("close " + job);
            try {
                ((Socket)job).close();
            }
            catch (Exception e) {
                Code.ignore(e);
            }
        }
        super.killJob(thread, job);
    }

    public String toString() {
        if (this._address == null) {
            return this.getName() + "@0.0.0.0:0";
        }
        return this.getName() + "@" + this.getInetAddrPort();
    }

    static /* synthetic */ void access$1(ThreadedServer threadedServer, ServerSocket serverSocket) {
        threadedServer._listen = serverSocket;
    }

    static /* synthetic */ Acceptor access$2(ThreadedServer threadedServer) {
        return threadedServer._acceptor;
    }

    static /* synthetic */ void access$3(ThreadedServer threadedServer, Acceptor acceptor) {
        threadedServer._acceptor = acceptor;
    }

    static /* synthetic */ int access$4(ThreadedServer threadedServer) {
        return threadedServer._soTimeOut;
    }

    public ThreadedServer() {
    }

    public ThreadedServer(int port) {
        this.setAddress(new InetAddrPort(port));
    }

    public ThreadedServer(InetAddress address, int port) {
        this.setAddress(new InetAddrPort(address, port));
    }

    public ThreadedServer(String host, int port) throws UnknownHostException {
        this.setAddress(new InetAddrPort(host, port));
    }

    public ThreadedServer(InetAddrPort address) {
        this.setAddress(address);
    }

    private class Acceptor
    extends Thread {
        boolean _running = false;

        /*
         * Unable to fully structure code
         */
        public void run() {
            this.setName("Acceptor " + ThreadedServer.access$0(ThreadedServer.this));
            this._running = true;
            while (this._running) {
                try {
                    socket = ThreadedServer.this.acceptSocket(ThreadedServer.access$0(ThreadedServer.this), ThreadedServer.access$4(ThreadedServer.this));
                    if (socket == null) continue;
                    if (this._running) {
                        ThreadedServer.this.run(socket);
                        continue;
                    }
                    socket.close();
                }
                catch (Exception e) {
                    Code.warning(e);
                }
                catch (Error e) {
                    Code.warning(e);
                }
            }
lbl19:
            // 2 sources

            var2_5 = null;
            Log.event("Stopping " + this.getName());
            try {
                if (ThreadedServer.access$0(ThreadedServer.this) != null) {
                    ThreadedServer.access$0(ThreadedServer.this).close();
                }
            }
            catch (IOException e) {
                Code.ignore(e);
            }
            var3_1 = ThreadedServer.this;
            synchronized (var3_1) {
                ThreadedServer.access$1(ThreadedServer.this, null);
                ThreadedServer.access$3(ThreadedServer.this, null);
            }
            catch (Throwable var1_7) {
                var2_6 = null;
                Log.event("Stopping " + this.getName());
                try {
                    if (ThreadedServer.access$0(ThreadedServer.this) != null) {
                        ThreadedServer.access$0(ThreadedServer.this).close();
                    }
                }
                catch (IOException e) {
                    Code.ignore(e);
                }
                var3_4 = ThreadedServer.this;
                synchronized (var3_4) {
                    ThreadedServer.access$1(ThreadedServer.this, null);
                    ThreadedServer.access$3(ThreadedServer.this, null);
                }
                throw var1_7;
            }
            ** GOTO lbl19
        }

        void forceStop() {
            if (ThreadedServer.this._listen != null && ThreadedServer.this._address != null) {
                try {
                    InetAddress addr = ThreadedServer.this._address.getInetAddress();
                    if (addr == null || addr.toString().startsWith("0.0.0.0")) {
                        addr = InetAddress.getLocalHost();
                    }
                    Code.debug("Self connect to close listener ", addr, ":" + ThreadedServer.this._address.getPort());
                    Socket socket = new Socket(addr, ThreadedServer.this._address.getPort());
                    Thread.yield();
                    socket.close();
                    Thread.yield();
                }
                catch (IOException e) {
                    Code.warning("problem stopping acceptor " + ThreadedServer.this._listen, e);
                }
            }
        }

        Acceptor() {
        }
    }
}

