/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.mortbay.util.Code;
import org.mortbay.util.Frame;

public class Test {
    private static Vector tests = new Vector();
    private static final String pass = "pass";
    private static final String fail = "FAIL";
    private static final char[] spaces = "                                                                                 ".toCharArray();
    static final String SelfFailTest = "org.mortbay.util.Test all fail";
    private String testCase;
    private StringBuffer reportBuf = new StringBuffer(512);
    private boolean passed = true;

    public void check(boolean b, String check) {
        this.reportBuf.append(this.testCase + " : " + check + " - ");
        if (b) {
            this.reportBuf.append(pass);
            Code.debug((Object)check, (Object)" OK");
        } else {
            Frame frame = new Frame(1);
            this.passed = false;
            this.reportBuf.append("FAIL at " + frame);
            this.reportBuf.append('\n');
            this.reportBuf.append(spaces, 0, this.testCase.length() + 3);
            this.reportBuf.append("check!=true");
            Code.debug((Object)check, (Object)" FAILED");
        }
        this.reportBuf.append('\n');
    }

    public int checkContains(String string, String subString, String check) {
        return this.realCheckContains(string, 0, subString, check);
    }

    public int checkContains(String string, int offset, String subString, String check) {
        return this.realCheckContains(string, offset, subString, check);
    }

    public int realCheckContains(String string, int offset, String subString, String check) {
        int index = -1;
        this.reportBuf.append(this.testCase + " : " + check + " - ");
        if (string == null && subString == null || string != null && (subString == null || (index = string.indexOf(subString, offset)) >= 0)) {
            this.reportBuf.append(pass);
            Code.debug((Object)check, (Object)" OK");
        } else {
            Frame frame = new Frame(2);
            this.passed = false;
            this.reportBuf.append("FAIL at " + frame);
            this.reportBuf.append('\n');
            this.reportBuf.append(spaces, 0, this.testCase.length() + 3);
            this.reportBuf.append("\"" + subString + "\" not contained in \"" + string.substring(offset) + "\"");
            Code.debug((Object)check, (Object)" FAILED");
        }
        this.reportBuf.append('\n');
        return index;
    }

    public int checkNotContained(String string, String subString, String check) {
        return this.checkNotContained(string, 0, subString, check);
    }

    public int checkNotContained(String string, int offset, String subString, String check) {
        int index = -1;
        this.reportBuf.append(this.testCase + " : " + check + " - ");
        if (string == null && subString == null || string != null && (subString == null || (index = string.indexOf(subString, offset)) >= 0)) {
            Frame frame = new Frame(1);
            this.passed = false;
            this.reportBuf.append("FAIL at " + frame);
            this.reportBuf.append('\n');
            this.reportBuf.append(spaces, 0, this.testCase.length() + 3);
            this.reportBuf.append("\"" + subString + "\" IS contained in \"" + string.substring(offset) + "\"");
            Code.debug((Object)check, (Object)" FAILED");
        } else {
            this.reportBuf.append(pass);
            Code.debug((Object)check, (Object)" OK");
        }
        this.reportBuf.append('\n');
        return index;
    }

    public void checkEquals(Object o1, Object o2, String check) {
        this.commonCheckEquals(o1, o2, check);
    }

    public void checkEquals(long l1, long l2, String check) {
        this.commonCheckEquals(new Long(l1), new Long(l2), check);
    }

    public void checkEquals(double d1, double d2, String check) {
        this.commonCheckEquals(new Double(d1), new Double(d2), check);
    }

    public void checkEquals(char c1, char c2, String check) {
        this.commonCheckEquals(new Character(c1), new Character(c2), check);
    }

    /*
     * WARNING - void declaration
     */
    public void checkEquals(InputStream in1, InputStream in2, String check) {
        try {
            int c2;
            int c1;
            while ((c1 = in1.read()) == (c2 = in2.read())) {
                void var4_4;
                if (var4_4 != -1) continue;
                this.commonCheckEquals(null, null, check);
                return;
            }
            this.commonCheckEquals("" + c1, "" + c2, check);
        }
        catch (Exception e) {
            this.commonCheckEquals(e.toString(), null, check);
        }
    }

    private void commonCheckEquals(Object o1, Object o2, String check) {
        this.reportBuf.append(this.testCase + " : " + check + " - ");
        if (o1 == o2 || o1 != null && o1.equals(o2)) {
            this.reportBuf.append(pass);
            Code.debug(3, (Object)(check + " OK"));
        } else {
            Frame frame = new Frame(2);
            this.passed = false;
            this.reportBuf.append("FAIL at " + frame);
            this.reportBuf.append('\n');
            this.reportBuf.append(spaces, 0, this.testCase.length() + 3);
            this.reportBuf.append((o1 != null ? o1.toString() : "null") + " != " + (o2 != null ? o2.toString() : "null"));
            Code.debug(3, (Object)(check + " FAILED"));
        }
        this.reportBuf.append('\n');
    }

    public static void report() {
        Enumeration e = tests.elements();
        while (e.hasMoreElements()) {
            Test t = (Test)e.nextElement();
            System.err.print("\nTest Case: " + t.testCase);
            if (t.passed) {
                System.err.println("  - passed");
            } else {
                System.err.println("  - FAILED");
            }
            System.err.println(t.reportBuf.toString());
        }
        System.err.println("\nTEST SUMMARY:");
        e = tests.elements();
        boolean failed = false;
        while (e.hasMoreElements()) {
            Test t = (Test)e.nextElement();
            System.err.print("Test Case: " + t.testCase);
            if (t.passed) {
                System.err.println("  - passed");
                continue;
            }
            if (t.testCase.equals(SelfFailTest)) {
                System.err.println("  - failed as expected");
                continue;
            }
            System.err.println("  - FAILED");
            failed = true;
        }
        if (failed) {
            System.exit(1);
        }
        System.exit(0);
    }

    public Test(String testCase) {
        Code.debug("Constructed test case: " + testCase);
        this.testCase = testCase;
        tests.addElement(this);
    }
}

