/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import org.mortbay.util.BadResource;
import org.mortbay.util.Code;
import org.mortbay.util.FileResource;
import org.mortbay.util.JarFileResource;
import org.mortbay.util.JarResource;
import org.mortbay.util.URI;

public class Resource {
    protected URL _url;
    protected String _urlString;
    protected URLConnection _connection;
    protected InputStream _in = null;
    private static /* synthetic */ Class class$Lorg$mortbay$util$Resource;

    public static Resource newResource(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        String urls = url.toExternalForm();
        if (urls.startsWith("file:")) {
            try {
                URLConnection connection = url.openConnection();
                Permission perm = connection.getPermission();
                if (perm instanceof FilePermission) {
                    File file = new File(perm.getName());
                    FileResource fileResource = new FileResource(url, connection, file);
                    if (fileResource.getAlias() != null) {
                        return fileResource.getAlias();
                    }
                    return fileResource;
                }
                Code.warning("File resource without FilePermission:" + url);
            }
            catch (Exception e) {
                Code.debug(e);
                return new BadResource(url, e.toString());
            }
        } else {
            if (urls.startsWith("jar:file:")) {
                return new JarFileResource(url);
            }
            if (urls.startsWith("jar:")) {
                return new JarResource(url);
            }
        }
        return new Resource(url, null);
    }

    public static Resource newResource(String resource) throws MalformedURLException, IOException {
        URL url = null;
        try {
            url = new URL(resource);
        }
        catch (MalformedURLException e) {
            if (!(resource.startsWith("ftp:") || resource.startsWith("file:") || resource.startsWith("jar:"))) {
                try {
                    URLConnection connection;
                    FileResource fileResource;
                    if (resource.startsWith("./")) {
                        resource = resource.substring(2);
                    }
                    File file = new File(resource);
                    if (resource.indexOf("..") >= 0) {
                        file = new File(file.getCanonicalPath());
                    }
                    if ((fileResource = new FileResource(url = file.toURL(), connection = url.openConnection(), file)).getAlias() != null) {
                        return fileResource.getAlias();
                    }
                    return fileResource;
                }
                catch (Exception e2) {
                    Code.debug(e2);
                    return new BadResource(url, e2.toString());
                }
            }
            Code.debug(e);
            return new BadResource(url, e.toString());
        }
        String nurl = url.toString();
        if (!(nurl.length() <= 0 || nurl.charAt(nurl.length() - 1) == resource.charAt(resource.length() - 1) || nurl.charAt(nurl.length() - 1) == '/' && nurl.charAt(nurl.length() - 2) == resource.charAt(resource.length() - 1) || resource.charAt(resource.length() - 1) == '/' && resource.charAt(resource.length() - 2) == nurl.charAt(nurl.length() - 1))) {
            return new BadResource(url, "Trailing special characters stripped by URL in " + resource);
        }
        return Resource.newResource(url);
    }

    public static Resource newSystemResource(String resource) throws IOException {
        URL url = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null && (url = loader.getResource(resource)) == null && resource.startsWith("/")) {
            url = loader.getResource(resource.substring(1));
        }
        if (url == null && (url = (loader = (class$Lorg$mortbay$util$Resource != null ? class$Lorg$mortbay$util$Resource : (class$Lorg$mortbay$util$Resource = Resource.class$("org.mortbay.util.Resource"))).getClassLoader()).getResource(resource)) == null && resource.startsWith("/")) {
            url = loader.getResource(resource.substring(1));
        }
        if (url == null) {
            return null;
        }
        return Resource.newResource(url);
    }

    protected synchronized boolean checkConnection() {
        if (this._connection == null) {
            try {
                this._connection = this._url.openConnection();
            }
            catch (IOException e) {
                Code.ignore(e);
            }
        }
        return this._connection != null;
    }

    protected void finalize() {
        this.release();
    }

    public synchronized void release() {
        if (this._in != null) {
            try {
                this._in.close();
            }
            catch (IOException e) {
                Code.ignore(e);
            }
            this._in = null;
        }
        if (this._connection != null) {
            this._connection = null;
        }
    }

    public boolean exists() {
        block6: {
            try {
                if (!this.checkConnection() || this._in != null) break block6;
                Resource resource = this;
                synchronized (resource) {
                    if (this._in == null) {
                        this._in = this._connection.getInputStream();
                    }
                }
            }
            catch (IOException e) {
                Code.ignore(e);
            }
        }
        return this._in != null;
    }

    public boolean isDirectory() {
        return this.exists() && this._url.toString().endsWith("/");
    }

    public long lastModified() {
        if (this.checkConnection()) {
            return this._connection.getLastModified();
        }
        return -1L;
    }

    public long length() {
        if (this.checkConnection()) {
            return this._connection.getContentLength();
        }
        return -1L;
    }

    public URL getURL() {
        return this._url;
    }

    public File getFile() {
        return null;
    }

    public String getName() {
        return this._url.toExternalForm();
    }

    public InputStream getInputStream() throws IOException {
        InputStream inputStream;
        if (!this.checkConnection()) {
            throw new IOException("Invalid resource");
        }
        try {
            if (this._in != null) {
                InputStream in = this._in;
                this._in = null;
                InputStream inputStream2 = in;
                Object var2_4 = null;
                this._connection = null;
                return inputStream2;
            }
            inputStream = this._connection.getInputStream();
        }
        catch (Throwable throwable) {
            Object var2_6 = null;
            this._connection = null;
            throw throwable;
        }
        Object var2_5 = null;
        this._connection = null;
        return inputStream;
    }

    public OutputStream getOutputStream() throws IOException, SecurityException {
        throw new IOException("Output not supported");
    }

    public boolean delete() throws SecurityException {
        throw new SecurityException("Delete not supported");
    }

    public boolean renameTo(Resource dest) throws SecurityException {
        throw new SecurityException("RenameTo not supported");
    }

    public String[] list() {
        return null;
    }

    public Resource addPath(String path) throws IOException, MalformedURLException {
        if (path == null) {
            return null;
        }
        path = Resource.canonicalPath(path);
        return Resource.newResource(URI.addPaths(this._url.toExternalForm(), path));
    }

    public String toString() {
        return this._urlString;
    }

    public int hashCode() {
        return this._url.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof Resource && this._url.equals(((Resource)o)._url);
    }

    public static String canonicalPath(String path) {
        return URI.canonicalPath(path);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Resource(URL url, URLConnection connection) {
        this._url = url;
        this._urlString = this._url.toString();
        this._connection = connection;
    }
}

