/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.mortbay.util.Code;
import org.mortbay.util.ThreadPool;

public class IO
extends ThreadPool {
    public static int bufferSize = 8192;
    private static NullOS __nullStream = new NullOS();
    private static NullWrite __nullWriter = new NullWrite();

    public static IO instance() {
        return Singleton.__instance;
    }

    public static void copyThread(InputStream in, OutputStream out) {
        try {
            IO.instance().run(new Job(in, out));
        }
        catch (InterruptedException e) {
            Code.warning(e);
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        IO.copy(in, out, -1L);
    }

    public static void copyThread(Reader in, Writer out) {
        try {
            IO.instance().run(new Job(in, out));
        }
        catch (InterruptedException e) {
            Code.warning(e);
        }
    }

    public static void copy(Reader in, Writer out) throws IOException {
        IO.copy(in, out, -1L);
    }

    public static void copy(InputStream in, OutputStream out, long byteCount) throws IOException {
        byte[] buffer = new byte[bufferSize];
        int len = bufferSize;
        if (byteCount >= 0L) {
            while (byteCount > 0L) {
                len = byteCount < (long)bufferSize ? in.read(buffer, 0, (int)byteCount) : in.read(buffer, 0, bufferSize);
                if (len != -1) {
                    byteCount -= (long)len;
                    out.write(buffer, 0, len);
                    continue;
                }
                break;
            }
        } else {
            while ((len = in.read(buffer, 0, bufferSize)) >= 0) {
                out.write(buffer, 0, len);
            }
        }
    }

    public static void copy(Reader in, Writer out, long byteCount) throws IOException {
        char[] buffer = new char[bufferSize];
        int len = bufferSize;
        if (byteCount >= 0L) {
            while (byteCount > 0L) {
                len = byteCount < (long)bufferSize ? in.read(buffer, 0, (int)byteCount) : in.read(buffer, 0, bufferSize);
                if (len != -1) {
                    byteCount -= (long)len;
                    out.write(buffer, 0, len);
                    continue;
                }
                break;
            }
        } else {
            while ((len = in.read(buffer, 0, bufferSize)) != -1) {
                out.write(buffer, 0, len);
            }
        }
    }

    public static String toString(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IO.copy(in, out);
        return new String(out.toByteArray());
    }

    public void handle(Object o) {
        Job job = (Job)o;
        try {
            if (job.in != null) {
                IO.copy(job.in, job.out, -1L);
            } else {
                IO.copy(job.read, job.write, -1L);
            }
        }
        catch (IOException e) {
            Code.ignore(e);
            try {
                if (job.out != null) {
                    job.out.close();
                }
                if (job.write != null) {
                    job.write.close();
                }
            }
            catch (IOException e2) {
                Code.ignore(e2);
            }
        }
    }

    public static OutputStream getNullStream() {
        return __nullStream;
    }

    public static Writer getNullWriter() {
        return __nullWriter;
    }

    private static class Singleton {
        static final IO __instance = new IO();

        Singleton() {
        }

        static {
            try {
                __instance.start();
            }
            catch (Exception e) {
                Code.fail(e);
            }
        }
    }

    static class Job {
        InputStream in;
        OutputStream out;
        Reader read;
        Writer write;

        Job(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
            this.read = null;
            this.write = null;
        }

        Job(Reader read, Writer write) {
            this.in = null;
            this.out = null;
            this.read = read;
            this.write = write;
        }
    }

    private static class NullOS
    extends OutputStream {
        public void close() {
        }

        public void flush() {
        }

        public void write(byte[] b) {
        }

        public void write(byte[] b, int i, int l) {
        }

        public void write(int b) {
        }

        NullOS() {
        }
    }

    private static class NullWrite
    extends Writer {
        public void close() {
        }

        public void flush() {
        }

        public void write(char[] b) {
        }

        public void write(char[] b, int o, int l) {
        }

        public void write(int b) {
        }

        public void write(String s) {
        }

        public void write(String s, int o, int l) {
        }

        NullWrite() {
        }
    }
}

