/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.mortbay.util.BadResource;
import org.mortbay.util.Code;
import org.mortbay.util.Log;
import org.mortbay.util.Resource;

class FileResource
extends Resource {
    private static boolean __checkAliases = "true".equalsIgnoreCase(System.getProperty("org.mortbay.util.FileResource.checkAliases", File.separatorChar == '/' ? "false" : "true"));
    private File _file;
    private BadResource _alias = null;

    BadResource getAlias() {
        return this._alias;
    }

    public boolean exists() {
        return this._file.exists();
    }

    public long lastModified() {
        return this._file.lastModified();
    }

    public boolean isDirectory() {
        return this._file.isDirectory();
    }

    public long length() {
        return this._file.length();
    }

    public String getName() {
        return this._file.getAbsolutePath();
    }

    public File getFile() {
        return this._file;
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this._file);
    }

    public OutputStream getOutputStream() throws IOException, SecurityException {
        return new FileOutputStream(this._file);
    }

    public boolean delete() throws SecurityException {
        return this._file.delete();
    }

    public boolean renameTo(Resource dest) throws SecurityException {
        if (dest instanceof FileResource) {
            return this._file.renameTo(((FileResource)dest)._file);
        }
        return false;
    }

    public String[] list() {
        String[] list = this._file.list();
        if (list == null) {
            return null;
        }
        int i = list.length;
        while (i-- > 0) {
            if (!new File(this._file, list[i]).isDirectory() || list[i].endsWith("/")) continue;
            int n = i;
            list[n] = list[n] + "/";
        }
        return list;
    }

    public boolean equals(Object o) {
        return o instanceof FileResource && this._file.equals(((FileResource)o)._file);
    }

    FileResource(URL url, URLConnection connection, File file) {
        super(url, connection);
        this._file = file;
        if (__checkAliases) {
            try {
                String abs = this._file.getAbsolutePath();
                String can = this._file.getCanonicalPath();
                if (!abs.equals(can)) {
                    this._alias = new BadResource(url, abs + " is alias of " + can);
                }
                if (this._alias != null && Code.debug()) {
                    Code.debug((Object)"ALIAS abs=", (Object)abs);
                    Code.debug((Object)"ALIAS can=", (Object)can);
                }
            }
            catch (IOException e) {
                Code.ignore(e);
            }
        }
    }

    static {
        if (__checkAliases) {
            Log.event("Checking Resource aliases");
        }
    }
}

