/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.mortbay.util.Code;

public class DateCache {
    private String _formatString;
    private SimpleDateFormat _minuteFormat;
    private SimpleDateFormat _format;
    private boolean _millis = false;
    private long _lastMinutes = -1L;
    private long _lastSeconds = -1L;
    private String _lastResult = null;
    private Locale _locale = null;
    private DateFormatSymbols _dfs = null;

    private String getOffsetString(int msOffset) {
        StringBuffer sb = new StringBuffer("'");
        if (msOffset >= 0) {
            sb.append('+');
        } else {
            msOffset *= -1;
            sb.append('-');
        }
        int raw = msOffset / 60000;
        int hr = raw / 60;
        int min = raw % 60;
        if (hr < 10) {
            sb.append('0');
        }
        sb.append(hr);
        sb.append(':');
        if (min < 10) {
            sb.append('0');
        }
        sb.append(min);
        sb.append('\'');
        return sb.toString();
    }

    private String mFormat(String format, TimeZone tz) {
        int zIndex = format.indexOf("ZZZ");
        if (zIndex >= 0) {
            String ss1 = format.substring(0, zIndex);
            String ss2 = format.substring(zIndex + 3);
            format = ss1 + this.getOffsetString(tz.getRawOffset()) + ss2;
        }
        int i = format.indexOf("ss.SSS");
        int l = 6;
        if (i >= 0) {
            this._millis = true;
        } else {
            l = 2;
            i = format.indexOf("ss");
        }
        Code.assert(i >= 0, "No seconds in format");
        String ss1 = format.substring(0, i);
        String ss2 = format.substring(i + l);
        String mFormat = (i > 0 ? "@" + ss1 + "@" : "") + (l == 2 ? "'ss'" : "'ss.SSS'") + (ss2.length() > 0 ? "@" + ss2 + "@" : "");
        return mFormat;
    }

    public synchronized String format(Date inDate) {
        return this.format(inDate.getTime());
    }

    public synchronized String format(long inDate) {
        long seconds = inDate / 1000L;
        if (this._lastSeconds == seconds && !this._millis) {
            return this._lastResult;
        }
        Date d = new Date(inDate);
        long minutes = seconds / 60L;
        if (this._lastMinutes != minutes) {
            this._format = new SimpleDateFormat(this._minuteFormat.format(d).replace('@', '\''));
            this._lastMinutes = minutes;
        }
        this._lastSeconds = seconds;
        this._lastResult = this._format.format(d);
        return this._lastResult;
    }

    public void format(long inDate, StringBuffer buffer) {
        buffer.append(this.format(inDate));
    }

    public SimpleDateFormat getFormat() {
        return this._minuteFormat;
    }

    public String getFormatString() {
        return this._formatString;
    }

    public void setTimeZone(TimeZone tz) {
        this._minuteFormat = this._locale != null ? new SimpleDateFormat(this.mFormat(this._formatString, tz), this._locale) : (this._dfs != null ? new SimpleDateFormat(this.mFormat(this._formatString, tz), this._dfs) : new SimpleDateFormat(this.mFormat(this._formatString, tz)));
        this._minuteFormat.setTimeZone(tz);
        if (this._format != null) {
            this._format.setTimeZone(tz);
        }
    }

    public void setTimeZoneID(String timeZoneId) {
        this.setTimeZone(TimeZone.getTimeZone(timeZoneId));
    }

    public DateCache() {
        this("EEE MMM dd HH:mm:ss zzz yyyy");
        this.getFormat().setTimeZone(TimeZone.getDefault());
    }

    public DateCache(String format) {
        this._formatString = format;
        this._minuteFormat = new SimpleDateFormat(this.mFormat(format, TimeZone.getDefault()));
    }

    public DateCache(String format, Locale l) {
        this._formatString = format;
        this._locale = l;
        this._minuteFormat = new SimpleDateFormat(this.mFormat(format, TimeZone.getDefault()), l);
    }

    public DateCache(String format, DateFormatSymbols s) {
        this._formatString = format;
        this._dfs = s;
        this._minuteFormat = new SimpleDateFormat(this.mFormat(format, TimeZone.getDefault()), s);
    }
}

