/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.applet.Applet;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.mortbay.util.CodeException;
import org.mortbay.util.Frame;
import org.mortbay.util.Log;
import org.mortbay.util.MultiException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Code {
    private static final String __lock = "LOCK";
    private static final Class[] __noArgs = new Class[0];
    private static final String[] __nestedEx = new String[]{"getTargetException", "getTargetError", "getException", "getRootCause"};
    private static StringWriter __stringWriter = new StringWriter();
    private static StringBuffer __writerBuffer = __stringWriter.getBuffer();
    private static PrintWriter __out = new PrintWriter((Writer)__stringWriter, false);
    boolean _debugOn = false;
    private boolean _suppressStack = true;
    private boolean _suppressWarnings = false;
    private int _verbose = 0;
    Vector _debugPatterns = null;
    private Vector _debugTriggers = null;
    private String _patterns = null;
    private String _triggers = null;
    private Hashtable _triggerSet = new Hashtable();

    public static Code instance() {
        return Singleton.__instance;
    }

    public static void initParamsFromApplet(Applet appl) {
        boolean d = appl.getParameter("DEBUG") != null;
        Code.setDebug(d);
        String o = appl.getParameter("DEBUG_OPTIONS");
        if (o != null) {
            Code.setSuppressStack(o.indexOf(83) >= 0);
            Code.setSuppressWarnings(o.indexOf(87) >= 0);
        } else {
            Code.setSuppressStack(false);
            Code.setSuppressWarnings(false);
        }
        String dp = appl.getParameter("DEBUG_PATTERNS");
        Code.setDebugPatterns(dp);
        String dt = appl.getParameter("DEBUG_TRIGGERS");
        Code.setDebugTriggers(dt);
        String v = appl.getParameter("DEBUG_VERBOSE");
        if (v != null) {
            Code.setVerbose(Integer.parseInt(v));
        }
    }

    public static synchronized void setDebug(boolean debug) {
        Code code = Code.instance();
        boolean oldDebug = code._debugOn;
        if (code._debugOn && !debug) {
            Code.debug(2, (Object)"DEBUG OFF");
        }
        code._debugOn = debug;
        if (!oldDebug && debug) {
            Code.debug(2, (Object)"DEBUG ON");
        }
    }

    public static boolean getDebug() {
        return Code.instance()._debugOn;
    }

    public static void setSuppressStack(boolean stack) {
        Code.instance()._suppressStack = stack;
    }

    public static boolean getSuppressStack() {
        return Code.instance()._suppressStack;
    }

    public static void setSuppressWarnings(boolean warnings) {
        Code.instance()._suppressWarnings = warnings;
    }

    public static boolean getSuppressWarnings() {
        return Code.instance()._suppressWarnings;
    }

    public static void setVerbose(int verbose) {
        Code.instance()._verbose = verbose;
    }

    public static int getVerbose() {
        return Code.instance()._verbose;
    }

    public static void setDebugPatterns(String patterns) {
        Code code = Code.instance();
        code._patterns = patterns;
        if (patterns != null && patterns.length() > 0) {
            code._debugPatterns = new Vector();
            StringTokenizer tok = new StringTokenizer(patterns, ", \t");
            while (tok.hasMoreTokens()) {
                String pattern = tok.nextToken();
                code._debugPatterns.addElement(pattern);
            }
        } else {
            code._debugPatterns = null;
        }
    }

    public static String getDebugPatterns() {
        return Code.instance()._patterns;
    }

    public static void setDebugTriggers(String triggers) {
        Code code = Code.instance();
        code._triggers = triggers;
        if (triggers != null && triggers.length() > 0) {
            code._debugTriggers = new Vector();
            StringTokenizer tok = new StringTokenizer(triggers, ", \t");
            while (tok.hasMoreTokens()) {
                String trigger = tok.nextToken();
                code._debugTriggers.addElement(trigger);
            }
        } else {
            code._debugTriggers = null;
        }
    }

    public static String getDebugTriggers() {
        return Code.instance()._triggers;
    }

    public static void triggerOn(String trigger) {
        Code code = Code.instance();
        int i = code._debugTriggers.size();
        while (--i >= 0) {
            if (trigger.indexOf((String)code._debugTriggers.elementAt(i)) < 0) continue;
            if (code._triggerSet.put(trigger, "") == null) {
                Log.message("DEBUG  ", "TRIGGERED ON " + trigger, new Frame(1));
            }
            Code.setDebug(true);
        }
    }

    public static void triggerOff(String trigger) {
        Code code = Code.instance();
        int i = code._debugTriggers.size();
        while (--i >= 0) {
            if (trigger.indexOf((String)code._debugTriggers.elementAt(i)) < 0) continue;
            if (code._triggerSet.remove(trigger) != null) {
                Log.message("DEBUG  ", "TRIGGERED OFF " + trigger, new Frame(1));
            }
            Code.setDebug(code._triggerSet.size() > 0);
        }
    }

    public static void assert(boolean b, String m) {
        if (!b) {
            Log.message("ASSERT ", m, new Frame(1));
            throw new CodeException("ASSERT FAIL: " + m);
        }
    }

    public static void assertEquals(Object o1, Object o2, String m) {
        if (o1 != o2 && o1 != null && !o1.equals(o2)) {
            Log.message("ASSERT ", o1 + " != " + o2 + " : " + m, new Frame(1));
            throw new CodeException("ASSERT FAIL: " + m);
        }
    }

    public static void assertEquals(long o1, long o2, String m) {
        if (o1 != o2) {
            Log.message("ASSERT ", o1 + " != " + o2 + " : " + m, new Frame(1));
            throw new CodeException("ASSERT FAIL: " + m);
        }
    }

    public static void assertEquals(double o1, double o2, String m) {
        if (o1 != o2) {
            Log.message("ASSERT ", o1 + " != " + o2 + " : " + m, new Frame(1));
            throw new CodeException("ASSERT FAIL: " + m);
        }
    }

    public static void assertEquals(char o1, char o2, String m) {
        if (o1 != o2) {
            Log.message("ASSERT ", o1 + " != " + o2 + " : " + m, new Frame(1));
            throw new CodeException("ASSERT FAIL: " + m);
        }
    }

    public static void assertContains(String string, String sub, String m) {
        if (sub != null && (string == null || string.indexOf(sub) == -1)) {
            Log.message("ASSERT ", "\"" + string + "\" does not contain \"" + sub + "\" : " + m, new Frame(1));
            throw new CodeException("ASSERT FAIL: " + m);
        }
    }

    public static void warning(String m) {
        Code code = Code.instance();
        Frame frame = new Frame(1);
        if (!code._suppressWarnings || code.isDebugOnFor(frame)) {
            Log.message("WARN!! ", m, frame);
        }
    }

    public static void warning(String m, Throwable ex) {
        Code code = Code.instance();
        Frame frame = new Frame(1);
        if (!code._suppressWarnings || code.isDebugOnFor(frame)) {
            Log.message("WARN!! ", Code.formatThrowable(m, ex), frame);
        }
    }

    public static void warning(Throwable ex) {
        Code code = Code.instance();
        Frame frame = new Frame(1);
        if (!code._suppressWarnings || code.isDebugOnFor(frame)) {
            Log.message("WARN!! ", Code.formatThrowable("", ex), frame);
        }
    }

    public static void fail(String m) {
        Log.message("FAIL!! ", m, new Frame(1));
        throw new CodeException("FAIL: " + m);
    }

    public static void fail(String m, Throwable ex) {
        Code code = Code.instance();
        Log.message("FAIL!! ", Code.formatThrowable(m, ex), new Frame(1));
        throw new CodeException("FAIL: " + m);
    }

    public static void fail(Throwable ex) {
        Code code = Code.instance();
        String m = Code.formatThrowable("", ex);
        Log.message("FAIL!! ", m, new Frame(1));
        throw new CodeException("FAIL: " + m);
    }

    public static void notImplemented() {
        Log.message("FAIL!! ", "Not Implemented", new Frame(1));
        throw new CodeException("Not Implemented");
    }

    public static boolean verbose() {
        return Code.instance()._verbose > 0;
    }

    public static boolean verbose(int v) {
        return Code.instance()._verbose >= v;
    }

    public static boolean debug() {
        Code code = Code.instance();
        if (code._debugOn) {
            Frame frame = new Frame(1, true);
            return code.isDebugOnFor(frame);
        }
        return false;
    }

    public static void debug(String m) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            frame.complete();
            Log.message("DEBUG  ", m, frame);
        }
    }

    public static void debug(String m, Throwable ex) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            StringBuffer buf;
            frame.complete();
            StringBuffer stringBuffer = buf = new StringBuffer(256);
            synchronized (stringBuffer) {
                buf.append(m);
                Code.formatObject(buf, ex);
            }
            Log.message("DEBUG  ", buf.toString(), frame);
        }
    }

    public static void debug(Throwable ex) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            StringBuffer buf;
            frame.complete();
            StringBuffer stringBuffer = buf = new StringBuffer(256);
            synchronized (stringBuffer) {
                Code.formatObject(buf, ex);
            }
            Log.message("DEBUG  ", buf.toString(), frame);
        }
    }

    public static void debug(int depth, Object o) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(depth, true))) {
            StringBuffer buf;
            frame.complete();
            StringBuffer stringBuffer = buf = new StringBuffer(256);
            synchronized (stringBuffer) {
                Code.formatObject(buf, o);
            }
            Log.message("DEBUG  ", buf.toString(), frame);
        }
    }

    public static void debug(Object o) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            StringBuffer buf;
            frame.complete();
            StringBuffer stringBuffer = buf = new StringBuffer(256);
            synchronized (stringBuffer) {
                Code.formatObject(buf, o);
            }
            Log.message("DEBUG  ", buf.toString(), frame);
        }
    }

    public static void debug(Object o1, Object o2) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            StringBuffer buf;
            frame.complete();
            StringBuffer stringBuffer = buf = new StringBuffer(256);
            synchronized (stringBuffer) {
                Code.formatObject(buf, o1);
                Code.formatObject(buf, o2);
            }
            Log.message("DEBUG  ", buf.toString(), frame);
        }
    }

    public static void debug(Object o1, long i) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            StringBuffer buf;
            frame.complete();
            StringBuffer stringBuffer = buf = new StringBuffer(256);
            synchronized (stringBuffer) {
                Code.formatObject(buf, o1);
                Code.formatObject(buf, new Long(i));
            }
            Log.message("DEBUG  ", buf.toString(), frame);
        }
    }

    public static void debug(Object o1, Object o2, Object o3) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            StringBuffer buf;
            frame.complete();
            StringBuffer stringBuffer = buf = new StringBuffer(256);
            synchronized (stringBuffer) {
                Code.formatObject(buf, o1);
                Code.formatObject(buf, o2);
                Code.formatObject(buf, o3);
            }
            Log.message("DEBUG  ", buf.toString(), frame);
        }
    }

    public static void debug(Object o1, Object o2, Object o3, Object o4) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            StringBuffer buf;
            frame.complete();
            StringBuffer stringBuffer = buf = new StringBuffer(256);
            synchronized (stringBuffer) {
                Code.formatObject(buf, o1);
                Code.formatObject(buf, o2);
                Code.formatObject(buf, o3);
                Code.formatObject(buf, o4);
            }
            Log.message("DEBUG  ", buf.toString(), frame);
        }
    }

    public static void debug(Object o1, long l1, Object o2, long l2) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            StringBuffer buf;
            frame.complete();
            StringBuffer stringBuffer = buf = new StringBuffer(256);
            synchronized (stringBuffer) {
                Code.formatObject(buf, o1);
                Code.formatObject(buf, new Long(l1));
                Code.formatObject(buf, o2);
                Code.formatObject(buf, new Long(l2));
            }
            Log.message("DEBUG  ", buf.toString(), frame);
        }
    }

    public static void debug(Object o1, Object o2, Object o3, Object o4, Object o5) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            StringBuffer buf;
            frame.complete();
            StringBuffer stringBuffer = buf = new StringBuffer(256);
            synchronized (stringBuffer) {
                Code.formatObject(buf, o1);
                Code.formatObject(buf, o2);
                Code.formatObject(buf, o3);
                Code.formatObject(buf, o4);
                Code.formatObject(buf, o5);
            }
            Log.message("DEBUG  ", buf.toString(), frame);
        }
    }

    public static void debug(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            StringBuffer buf;
            frame.complete();
            StringBuffer stringBuffer = buf = new StringBuffer(256);
            synchronized (stringBuffer) {
                Code.formatObject(buf, o1);
                Code.formatObject(buf, o2);
                Code.formatObject(buf, o3);
                Code.formatObject(buf, o4);
                Code.formatObject(buf, o5);
                Code.formatObject(buf, o6);
            }
            Log.message("DEBUG  ", buf.toString(), frame);
        }
    }

    public static void debug(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            StringBuffer buf;
            frame.complete();
            StringBuffer stringBuffer = buf = new StringBuffer(256);
            synchronized (stringBuffer) {
                Code.formatObject(buf, o1);
                Code.formatObject(buf, o2);
                Code.formatObject(buf, o3);
                Code.formatObject(buf, o4);
                Code.formatObject(buf, o5);
                Code.formatObject(buf, o6);
                Code.formatObject(buf, o7);
            }
            Log.message("DEBUG  ", buf.toString(), frame);
        }
    }

    public static void debug(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            StringBuffer buf;
            frame.complete();
            StringBuffer stringBuffer = buf = new StringBuffer(256);
            synchronized (stringBuffer) {
                Code.formatObject(buf, o1);
                Code.formatObject(buf, o2);
                Code.formatObject(buf, o3);
                Code.formatObject(buf, o4);
                Code.formatObject(buf, o5);
                Code.formatObject(buf, o6);
                Code.formatObject(buf, o7);
                Code.formatObject(buf, o8);
            }
            Log.message("DEBUG  ", buf.toString(), frame);
        }
    }

    public static void ignore(Throwable ex) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            StringBuffer buf;
            frame.complete();
            StringBuffer stringBuffer = buf = new StringBuffer(256);
            synchronized (stringBuffer) {
                buf.append("IGNORED ");
                if (code._verbose > 0) {
                    Code.formatObject(buf, ex);
                } else {
                    Code.formatObject(buf, ex.toString());
                }
            }
            Log.message("DEBUG  ", buf.toString(), frame);
        }
    }

    private boolean isDebugOnFor(Frame frame) {
        if (this._debugOn) {
            if (this._debugPatterns == null) {
                return true;
            }
            int i = this._debugPatterns.size();
            while (--i >= 0) {
                if (frame._where.indexOf((String)this._debugPatterns.elementAt(i)) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private static void formatObject(StringBuffer buf, Object o) {
        if (o == null) {
            buf.append("null");
        } else if (o instanceof Throwable) {
            Throwable ex = (Throwable)o;
            buf.append('\n');
            if (Code.instance()._suppressStack) {
                buf.append(ex.toString());
                buf.append("\nNo stack available\n--");
            } else {
                StringBuffer stringBuffer = __writerBuffer;
                synchronized (stringBuffer) {
                    __writerBuffer.setLength(0);
                    Code.expandThrowable(ex);
                    __out.flush();
                    buf.append(__writerBuffer.toString());
                }
            }
        } else {
            buf.append(o.toString());
        }
    }

    private static void expandThrowable(Throwable ex) {
        ex.printStackTrace(__out);
        if (ex instanceof MultiException) {
            MultiException mx = (MultiException)ex;
            int i = 0;
            while (i < mx.size()) {
                __out.println("getException(" + i + "):");
                ex = mx.getException(i);
                Code.expandThrowable(ex);
                ++i;
            }
        } else {
            int i = 0;
            while (i < __nestedEx.length) {
                try {
                    Method getTargetException = ex.getClass().getMethod(__nestedEx[i], __noArgs);
                    ex = (Throwable)getTargetException.invoke((Object)ex, null);
                    __out.println(__nestedEx[i] + "():");
                    Code.expandThrowable(ex);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    private static String formatThrowable(String msg, Throwable ex) {
        StringBuffer buf = new StringBuffer(msg);
        Code.formatObject(buf, ex);
        return buf.toString();
    }

    protected Code() {
        Singleton.__instance = this;
        try {
            this._debugOn = System.getProperty("DEBUG") != null;
            String o = System.getProperty("DEBUG_OPTIONS");
            if (o != null) {
                Code.setSuppressStack(!(o.indexOf(83) >= 0));
                Code.setSuppressWarnings(!(o.indexOf(87) >= 0));
            } else {
                Code.setSuppressStack(false);
                Code.setSuppressWarnings(false);
            }
            String dp = System.getProperty("DEBUG_PATTERNS");
            Code.setDebugPatterns(dp);
            String dt = System.getProperty("DEBUG_TRIGGERS");
            Code.setDebugTriggers(dt);
            String v = System.getProperty("DEBUG_VERBOSE");
            if (v != null) {
                Code.setVerbose(Integer.parseInt(v));
            }
        }
        catch (Exception e) {
            System.err.println("Exception from getProperty!\nProbably running in applet\nUse Code.initParamsFromApplet or Code.setOption to control debug output.");
        }
    }

    private static class Singleton {
        static Code __instance = new Code();

        Singleton() {
        }
    }
}

