/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.IOException;
import java.io.OutputStream;

public class ByteBufferOutputStream
extends OutputStream {
    private int _fullAt;
    private byte[] _buf;
    private int _start;
    private int _end;
    private int _reserve;

    public int size() {
        return this._end - this._start;
    }

    public int getCapacity() {
        return this._buf.length - this._start;
    }

    public boolean isFull() {
        return this._end >= this._fullAt;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this._buf, this._start, this._end - this._start);
    }

    public void write(int b) {
        this.ensureCapacity(1);
        this._buf[this._end++] = (byte)b;
    }

    public void write(byte[] b) {
        this.ensureCapacity(b.length);
        System.arraycopy(b, 0, this._buf, this._end, b.length);
        this._end += b.length;
    }

    public void write(byte[] b, int offset, int length) {
        this.ensureCapacity(length);
        System.arraycopy(b, offset, this._buf, this._end, length);
        this._end += length;
    }

    public void prewrite(int b) {
        this.ensureReserve(1);
        this._buf[--this._start] = (byte)b;
    }

    public void prewrite(byte[] b) {
        this.ensureReserve(b.length);
        System.arraycopy(b, 0, this._buf, this._start - b.length, b.length);
        this._start -= b.length;
    }

    public void prewrite(byte[] b, int offset, int length) {
        this.ensureReserve(length);
        System.arraycopy(b, offset, this._buf, this._start - length, length);
        this._start -= length;
    }

    public void flush() {
    }

    public void reset() {
        this._end = this._reserve;
        this._start = this._reserve;
    }

    public void close() {
    }

    public void ensureReserve(int n) {
        if (n > this._start) {
            byte[] buf = new byte[this._buf.length + n - this._start];
            System.arraycopy(this._buf, this._start, buf, n, this._end - this._start);
            this._end = n + this._end - this._start;
            this._start = n;
            this._buf = buf;
        }
    }

    public void ensureCapacity(int n) {
        if (this._end + n > this._buf.length) {
            byte[] buf = new byte[(this._buf.length + n) * 4 / 3];
            System.arraycopy(this._buf, this._start, buf, this._start, this._end - this._start);
            this._buf = buf;
        }
    }

    public ByteBufferOutputStream() {
        this(4096, 4000, 1024);
    }

    public ByteBufferOutputStream(int capacity) {
        this(capacity, capacity * 95 / 100, capacity / 4);
    }

    public ByteBufferOutputStream(int capacity, int fullAt, int reserve) {
        this._buf = new byte[capacity + reserve];
        this._reserve = reserve;
        this._start = reserve;
        this._end = reserve;
        this._fullAt = fullAt + this._start;
    }
}

