/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.UnavailableException;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SecurityConstraint;
import org.mortbay.http.handler.NotFoundHandler;
import org.mortbay.http.handler.NullHandler;
import org.mortbay.http.handler.ResourceHandler;
import org.mortbay.http.handler.SecurityHandler;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHandlerContext;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.util.Code;
import org.mortbay.util.JarResource;
import org.mortbay.util.Log;
import org.mortbay.util.Resource;
import org.mortbay.util.StringUtil;
import org.mortbay.xml.XmlConfiguration;
import org.mortbay.xml.XmlParser;

public class WebApplicationContext
extends ServletHandlerContext {
    private String _name;
    private Resource _webApp;
    private Resource _webInf;
    private ServletHandler _servletHandler;
    private SecurityHandler _securityHandler;
    private Context _context;
    private Map _tagLibMap = new HashMap(3);
    private NotFoundHandler _notFoundHandler;
    private String _deploymentDescriptor;
    private String _defaultsDescriptor;
    private String _war;
    private boolean _extract;
    private XmlParser _xmlParser = new XmlParser();
    private static /* synthetic */ Class class$Lorg$mortbay$http$handler$SecurityHandler;
    private static /* synthetic */ Class class$Lorg$mortbay$jetty$servlet$ServletHandler;
    private static /* synthetic */ Class class$Lorg$mortbay$http$handler$ResourceHandler;

    public void initialize(String webApp, String defaults, boolean extractWar) throws IOException {
        this._war = webApp;
        this._defaultsDescriptor = defaults;
        this._extract = extractWar;
        this._webApp = null;
        this.resolveWebApp();
    }

    private void resolveWebApp() throws IOException {
        if (this._webApp == null) {
            this._webApp = Resource.newResource(this._war);
            if (this._webApp.exists() && !this._webApp.isDirectory()) {
                this._webApp = Resource.newResource("jar:" + this._webApp + "!/");
                if (this._webApp.exists()) {
                    this._war = this._webApp.toString();
                }
            }
            if (!this._webApp.exists()) {
                Code.warning("Web application not found " + this._war);
                throw new FileNotFoundException(this._war);
            }
            if (this._extract && this._webApp instanceof JarResource) {
                File tempDir = File.createTempFile("Jetty-", ".war");
                if (tempDir.exists()) {
                    tempDir.delete();
                }
                tempDir.mkdir();
                tempDir.deleteOnExit();
                Log.event("Extract " + this._war + " to " + tempDir);
                ((JarResource)this._webApp).extract(tempDir, true);
                this._webApp = Resource.newResource(tempDir.getCanonicalPath());
            }
            this._webInf = this._webApp.addPath("WEB-INF/");
            if (!this._webInf.exists() || !this._webInf.isDirectory()) {
                this._webInf = null;
            }
            super.setBaseResource(this._webApp);
        }
    }

    public void start() throws Exception {
        XmlParser xmlParser = this._xmlParser == null ? new XmlParser() : this._xmlParser;
        Resource dtd = Resource.newSystemResource("org/mortbay/jetty/servlet/web.dtd");
        xmlParser.redirectEntity("web.dtd", dtd);
        xmlParser.redirectEntity("web-app_2_2.dtd", dtd);
        xmlParser.redirectEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", dtd);
        this.resolveWebApp();
        this._securityHandler = (SecurityHandler)this.getHandler(class$Lorg$mortbay$http$handler$SecurityHandler != null ? class$Lorg$mortbay$http$handler$SecurityHandler : (class$Lorg$mortbay$http$handler$SecurityHandler = WebApplicationContext.class$("org.mortbay.http.handler.SecurityHandler")));
        if (this._securityHandler == null) {
            this._securityHandler = new SecurityHandler();
        }
        if (this.getHandlerIndex(this._securityHandler) != 0) {
            this.removeHandler(this._securityHandler);
            this.addHandler(0, this._securityHandler);
        }
        this._servletHandler = (ServletHandler)this.getHandler(class$Lorg$mortbay$jetty$servlet$ServletHandler != null ? class$Lorg$mortbay$jetty$servlet$ServletHandler : (class$Lorg$mortbay$jetty$servlet$ServletHandler = WebApplicationContext.class$("org.mortbay.jetty.servlet.ServletHandler")));
        if (this._servletHandler == null) {
            this._servletHandler = new ServletHandler();
            this.addHandler(this._servletHandler);
        }
        this._servletHandler.setDynamicServletPathSpec("/servlet/*");
        this._context = this._servletHandler.getContext();
        ResourceHandler rh = (ResourceHandler)this.getHandler(class$Lorg$mortbay$http$handler$ResourceHandler != null ? class$Lorg$mortbay$http$handler$ResourceHandler : (class$Lorg$mortbay$http$handler$ResourceHandler = WebApplicationContext.class$("org.mortbay.http.handler.ResourceHandler")));
        if (rh == null) {
            rh = new ResourceHandler();
            rh.setPutAllowed(false);
            rh.setDelAllowed(false);
            this.addHandler(rh);
        }
        if (this.getHandlerIndex(rh) < this.getHandlerIndex(this._servletHandler)) {
            this.removeHandler(rh);
            this.addHandler(rh);
        }
        this.addHandler(this.getHandlerIndex(rh), new WebInfProtect());
        try {
            if (this._defaultsDescriptor != null && this._defaultsDescriptor.length() > 0) {
                Resource dftResource = Resource.newResource(this._defaultsDescriptor);
                this._defaultsDescriptor = dftResource.toString();
                XmlParser.Node defaultConfig = xmlParser.parse(dftResource.getURL().toString());
                this.initialize(defaultConfig);
            }
        }
        catch (IOException e) {
            Code.warning("Parse error on " + this._war, e);
            throw e;
        }
        catch (Exception e) {
            Code.warning("Configuration error " + this._war, e);
            throw new IOException("Parse error on " + this._war + ": " + e.toString());
        }
        if (this._webInf == null || !this._webInf.isDirectory()) {
            Code.warning("No WEB-INF in " + this._war + ". Serving files only.");
        } else {
            Resource classes = this._webInf.addPath("classes/");
            String classPath = "";
            if (classes.exists()) {
                super.setClassPath(classes.toString());
            }
            Resource lib = this._webInf.addPath("lib/");
            super.setClassPaths(lib, true);
            Resource web = this._webInf.addPath("web.xml");
            if (!web.exists()) {
                Code.warning("No WEB-INF/web.xml in " + this._war + ". Serving files and default/dynamic servlets only");
            } else {
                try {
                    this._deploymentDescriptor = web.toString();
                    XmlParser.Node config = xmlParser.parse(web.getURL().toString());
                    this.initialize(config);
                }
                catch (IOException e) {
                    Code.warning("Parse error on " + this._war, e);
                    throw e;
                }
                catch (Exception e) {
                    Code.warning("Configuration error " + this._war, e);
                    throw new IOException("Parse error on " + this._war + ": " + e.toString());
                }
            }
            Resource jetty = this._webInf.addPath("web-jetty.xml");
            if (jetty.exists()) {
                try {
                    Log.event("Configure: " + jetty);
                    XmlConfiguration jetty_config = new XmlConfiguration(jetty.getURL());
                    jetty_config.configure(this);
                }
                catch (IOException e) {
                    Code.warning("Parse error on " + this._war, e);
                    throw e;
                }
                catch (Exception e) {
                    Code.warning("Configuration error " + this._war, e);
                    throw new IOException("Parse error on " + this._war + ": " + e.toString());
                }
            }
        }
        super.start();
        if (rh.isPutAllowed()) {
            Log.event("PUT allowed in " + this);
        }
        if (rh.isDelAllowed()) {
            Log.event("DEL allowed in " + this);
        }
    }

    public XmlParser getXmlParser() {
        return this._xmlParser;
    }

    public String getDisplayName() {
        return this._name;
    }

    public String getDeploymentDescriptor() {
        return this._deploymentDescriptor;
    }

    public void setDefaultsDescriptor(String defaults) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this._defaultsDescriptor = defaults;
    }

    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public void setWAR(String war) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this._war = war;
    }

    public String getWAR() {
        return this._war;
    }

    public void setExtractWAR(boolean extract) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this._extract = extract;
    }

    public boolean getExtractWAR() {
        return this._extract;
    }

    private void initialize(XmlParser.Node config) throws ClassNotFoundException, UnavailableException {
        Iterator iter = config.iterator();
        XmlParser.Node node = null;
        while (iter.hasNext()) {
            try {
                Object o = iter.next();
                if (!(o instanceof XmlParser.Node)) continue;
                node = (XmlParser.Node)o;
                String name = node.getTag();
                if ("display-name".equals(name)) {
                    this.initDisplayName(node);
                    continue;
                }
                if ("description".equals(name)) continue;
                if ("distributable".equals(name)) {
                    Code.warning("Not implemented: " + name);
                    System.err.println(node);
                    continue;
                }
                if ("context-param".equals(name)) {
                    this.initContextParam(node);
                    continue;
                }
                if ("servlet".equals(name)) {
                    this.initServlet(node);
                    continue;
                }
                if ("servlet-mapping".equals(name)) {
                    this.initServletMapping(node);
                    continue;
                }
                if ("session-config".equals(name)) {
                    this.initSessionConfig(node);
                    continue;
                }
                if ("mime-mapping".equals(name)) {
                    this.initMimeConfig(node);
                    continue;
                }
                if ("welcome-file-list".equals(name)) {
                    this.initWelcomeFileList(node);
                    continue;
                }
                if ("error-page".equals(name)) {
                    this.initErrorPage(node);
                    continue;
                }
                if ("taglib".equals(name)) {
                    this.initTagLib(node);
                    continue;
                }
                if ("resource-ref".equals(name)) {
                    Code.debug((Object)"No implementation: ", (Object)node);
                    continue;
                }
                if ("security-constraint".equals(name)) {
                    this.initSecurityConstraint(node);
                    continue;
                }
                if ("login-config".equals(name)) {
                    this.initLoginConfig(node);
                    continue;
                }
                if ("security-role".equals(name)) {
                    this.initSecurityRole(node);
                    continue;
                }
                if ("env-entry".equals(name)) {
                    Code.debug((Object)"No implementation: ", (Object)node);
                    continue;
                }
                if ("ejb-ref".equals(name)) {
                    Code.debug((Object)"No implementation: ", (Object)node);
                    continue;
                }
                Code.warning("UNKNOWN TAG: " + name);
                System.err.println(node);
            }
            catch (Exception e) {
                Code.warning("Configuration problem at " + node, e);
            }
        }
    }

    private void initDisplayName(XmlParser.Node node) {
        this._name = node.toString(false, true);
    }

    private void initContextParam(XmlParser.Node node) {
        String name = node.getString("param-name", false, true);
        String value = node.getString("param-value", false, true);
        Code.debug((Object)"ContextParam: ", name, (Object)"=", value);
        this.setInitParameter(name, value);
    }

    private void initServlet(XmlParser.Node node) throws ClassNotFoundException, UnavailableException {
        XmlParser.Node securityRef;
        String name = node.getString("servlet-name", false, true);
        String className = node.getString("servlet-class", false, true);
        String jspFile = null;
        if (className == null) {
            jspFile = node.getString("jsp-file", false, true);
            if (jspFile != null) {
                className = this._servletHandler.getJSPClassName();
            } else {
                Code.warning("Missing servlet-class|jsp-file in " + node);
                return;
            }
        }
        if (name == null) {
            name = className;
        }
        ServletHolder holder = this._servletHandler.newServletHolder(className, jspFile);
        holder.setServletName(name);
        Iterator iter = node.iterator("init-param");
        while (iter.hasNext()) {
            XmlParser.Node paramNode = (XmlParser.Node)iter.next();
            String pname = paramNode.getString("param-name", false, true);
            String pvalue = paramNode.getString("param-value", false, true);
            holder.put(pname, pvalue);
        }
        XmlParser.Node startup = node.get("load-on-startup");
        if (startup != null) {
            String s = startup.toString(false, true).toLowerCase();
            if (s.startsWith("t")) {
                Code.warning("Deprecated boolean load-on-startup.  Please use integer");
                holder.setInitOrder(1);
            } else {
                int order = 0;
                try {
                    if (s != null && s.trim().length() > 0) {
                        order = Integer.parseInt(s);
                    }
                }
                catch (Exception e) {
                    Code.warning("Cannot parse load-on-startup " + s + ". Please use integer");
                    Code.ignore(e);
                }
                holder.setInitOrder(order);
            }
        }
        if ((securityRef = node.get("security-role-ref")) != null) {
            String roleName = securityRef.getString("role-name", false, true);
            String roleLink = securityRef.getString("role-link", false, true);
            Code.debug("link role ", roleName, " to ", roleLink, " for ", this);
            holder.setUserRoleLink(roleName, roleLink);
        }
        String defaultPath = "/servlet/" + name + "/*";
        Code.debug((Object)"ServletMapping: ", holder.getServletName(), (Object)"=", defaultPath);
        this._servletHandler.addHolder(defaultPath, holder);
        if (!className.equals(name)) {
            defaultPath = "/servlet/" + className + "/*";
            Code.debug((Object)"ServletMapping: ", holder.getServletName(), (Object)"=", defaultPath);
            this._servletHandler.addHolder(defaultPath, holder);
        }
    }

    private void initServletMapping(XmlParser.Node node) {
        String name = node.getString("servlet-name", false, true);
        String pathSpec = node.getString("url-pattern", false, true);
        ServletHolder holder = this._servletHandler.getServletHolder(name);
        if (holder == null) {
            Code.warning("No such servlet: " + name);
        } else {
            Code.debug((Object)"ServletMapping: ", name, (Object)"=", pathSpec);
            this._servletHandler.addHolder(pathSpec, holder);
        }
    }

    private void initSessionConfig(XmlParser.Node node) {
        XmlParser.Node tNode = node.get("session-timeout");
        if (tNode != null) {
            int timeout = Integer.parseInt(tNode.toString(false, true));
            this._context.setSessionTimeout(timeout);
        }
    }

    private void initMimeConfig(XmlParser.Node node) {
        String extension = node.getString("extension", false, true);
        if (extension != null && extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        String mimeType = node.getString("mime-type", false, true);
        this.setMimeMapping(extension, mimeType);
    }

    private void initWelcomeFileList(XmlParser.Node node) {
        ResourceHandler rh = this.getResourceHandler();
        rh.setIndexFiles(null);
        Iterator iter = node.iterator("welcome-file");
        while (iter.hasNext()) {
            XmlParser.Node indexNode = (XmlParser.Node)iter.next();
            String index = indexNode.toString(false, true);
            Code.debug((Object)"Index: ", (Object)index);
            rh.addIndexFile(index);
        }
    }

    private void initErrorPage(XmlParser.Node node) {
        String error = node.getString("error-code", false, true);
        if (error == null || error.length() == 0) {
            error = node.getString("exception-type", false, true);
        } else if (this._notFoundHandler == null) {
            this._notFoundHandler = new NotFoundHandler();
            this.addHandler(this._notFoundHandler);
        }
        String location = node.getString("location", false, true);
        this.setErrorPage(error, location);
    }

    private void initTagLib(XmlParser.Node node) {
        String uri = node.getString("taglib-uri", false, true);
        String location = node.getString("taglib-location", false, true);
        this._tagLibMap.put(uri, location);
        this.setResourceAlias(uri, location);
    }

    private void initSecurityConstraint(XmlParser.Node node) {
        XmlParser.Node data;
        SecurityConstraint scBase = new SecurityConstraint();
        XmlParser.Node auths = node.get("auth-constraint");
        if (auths != null) {
            scBase.setAuthenticated(true);
            Iterator iter = auths.iterator("role-name");
            while (iter.hasNext()) {
                XmlParser.Node role = (XmlParser.Node)iter.next();
                scBase.addRole(role.toString(false, true));
            }
        }
        if ((data = node.get("user-data-constraint")) != null) {
            String guarantee = (data = data.get("transport-guarantee")).toString(false, true).toUpperCase();
            if (guarantee == null || guarantee.length() == 0 || "NONE".equals(guarantee)) {
                scBase.setDataConstraint(SecurityConstraint.DC_NONE);
            } else if ("INTEGRAL".equals(guarantee)) {
                scBase.setDataConstraint(SecurityConstraint.DC_INTEGRAL);
            } else if ("CONFIDENTIAL".equals(guarantee)) {
                scBase.setDataConstraint(SecurityConstraint.DC_CONFIDENTIAL);
            } else {
                Code.warning("Unknown user-data-constraint:" + guarantee);
                scBase.setDataConstraint(SecurityConstraint.DC_CONFIDENTIAL);
            }
        }
        Iterator iter = node.iterator("web-resource-collection");
        while (iter.hasNext()) {
            XmlParser.Node collection = (XmlParser.Node)iter.next();
            String name = collection.getString("web-resource-name", false, true);
            SecurityConstraint sc = (SecurityConstraint)scBase.clone();
            sc.setName(name);
            Iterator iter2 = collection.iterator("http-method");
            while (iter2.hasNext()) {
                sc.addMethod(((XmlParser.Node)iter2.next()).toString(false, true));
            }
            iter2 = collection.iterator("url-pattern");
            while (iter2.hasNext()) {
                String url = ((XmlParser.Node)iter2.next()).toString(false, true);
                this.addSecurityConstraint(url, sc);
            }
        }
    }

    private void initLoginConfig(XmlParser.Node node) {
        XmlParser.Node formConfig;
        XmlParser.Node name;
        SecurityHandler sh = this.getSecurityHandler();
        if (sh == null) {
            return;
        }
        XmlParser.Node method = node.get("auth-method");
        if (method != null) {
            sh.setAuthMethod(method.toString(false, true));
        }
        if ((name = node.get("realm-name")) != null) {
            sh.setRealmName(name.toString(false, true));
        }
        if ((formConfig = node.get("form-login-config")) != null) {
            XmlParser.Node errorPage;
            XmlParser.Node loginPage = formConfig.get("form-login-page");
            if (loginPage != null) {
                sh.setLoginPage(loginPage.toString(false, true));
            }
            if ((errorPage = formConfig.get("form-error-page")) != null) {
                sh.setErrorPage(errorPage.toString(false, true));
            }
        }
    }

    private void initSecurityRole(XmlParser.Node node) {
        Log.event("Security role " + node.get("role-name").toString(false, true) + " defined");
    }

    public String toString() {
        return "WebApplicationContext[" + this.getHandlerContextName() + "," + (this._name == null ? this._war : this._name) + "]";
    }

    public void setClassPath(String classPath) {
        Code.warning("ClassPath should not be set for WebApplication");
        super.setClassPath(classPath);
    }

    public void setResourceBase(String resourceBase) {
        Code.warning("ResourceBase should not be set for WebApplication");
        super.setResourceBase(resourceBase);
    }

    public void setBaseResource(Resource baseResource) {
        Code.warning("BaseResource should not be set for WebApplication");
        super.setBaseResource(baseResource);
    }

    public Map getTagLibMap() {
        return this._tagLibMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public WebApplicationContext(HttpServer httpServer, String contextPathSpec) {
        super(httpServer, contextPathSpec);
    }

    WebApplicationContext(HttpServer httpServer, String contextPathSpec, String webApp, String defaults) throws IOException {
        super(httpServer, contextPathSpec);
        this.initialize(webApp, defaults, false);
    }

    public WebApplicationContext(HttpServer httpServer, String contextPathSpec, String webApp, String defaults, boolean extractWar) throws IOException {
        super(httpServer, contextPathSpec);
        this.initialize(webApp, defaults, extractWar);
    }

    private class WebInfProtect
    extends NullHandler {
        public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
            String path = Resource.canonicalPath(StringUtil.asciiToLowerCase(pathInContext));
            if (path.startsWith("/web-inf") || path.startsWith("/meta-inf")) {
                response.sendError(403);
            }
        }

        public String toString() {
            return "WebInfProtect";
        }

        WebInfProtect() {
        }
    }
}

