/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.mortbay.http.ChunkableOutputStream;
import org.mortbay.http.HttpResponse;
import org.mortbay.jetty.servlet.ServletOut;
import org.mortbay.jetty.servlet.ServletRequest;
import org.mortbay.jetty.servlet.ServletWriter;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URI;

public class ServletResponse
implements HttpServletResponse {
    private static Map __charSetMap = new HashMap();
    private HttpResponse _httpResponse;
    private ServletRequest _servletRequest;
    private int _outputState = 0;
    private ServletOut _out = null;
    private ServletWriter _writer = null;
    private HttpSession _session = null;
    private boolean _noSession = false;
    private boolean _locked = false;
    private Locale _locale = null;

    boolean getLocked() {
        return this._locked;
    }

    void setLocked(boolean locked) {
        this._locked = locked;
    }

    int getOutputState() {
        return this._outputState;
    }

    void setOutputState(int s) throws IOException {
        if (s < 0) {
            this._outputState = 0;
            if (this._writer != null) {
                this._writer.disable();
            }
            this._writer = null;
            if (this._out != null) {
                this._out.disable();
            }
            this._out = null;
        } else {
            this._outputState = s;
            if (this._writer != null) {
                this._writer.flush();
            }
            if (this._out != null) {
                this._out.flush();
            }
        }
    }

    HttpResponse getHttpResponse() {
        return this._httpResponse;
    }

    void commit() throws IOException {
        this._httpResponse.commit();
    }

    public boolean isCommitted() {
        return this._httpResponse.isCommitted();
    }

    boolean isDirty() {
        return this._httpResponse.isDirty();
    }

    public void setBufferSize(int size) {
        ChunkableOutputStream out = this._httpResponse.getOutputStream();
        if (out.isWritten()) {
            throw new IllegalStateException("Output written");
        }
        out.setBufferCapacity(size);
    }

    public int getBufferSize() {
        return this._httpResponse.getOutputStream().getBufferCapacity();
    }

    public void flushBuffer() throws IOException {
        if (this._writer != null) {
            this._writer.flush();
        }
        if (this._out != null) {
            this._out.flush();
        }
        if (this._writer == null && this._out == null) {
            this._httpResponse.getOutputStream().flush();
        }
        this._httpResponse.commit();
    }

    void resetBuffer() {
        this._httpResponse.getOutputStream().resetBuffer();
    }

    public void reset() {
        this._httpResponse.reset();
    }

    public void setLocale(Locale locale) {
        String charset;
        if (locale == null) {
            return;
        }
        this._locale = locale;
        String lang = locale.getLanguage();
        this.setHeader("Content-Language", lang);
        String type = this._httpResponse.getField("Content-Type");
        if (type == null) {
            type = "application/octet-stream";
        } else if (type.startsWith("text/") && this._httpResponse.getCharacterEncoding() == null && (charset = (String)__charSetMap.get(lang)) != null) {
            int semi = type.indexOf(59);
            type = semi < 0 ? type + "; charset=" + charset : type.substring(0, semi) + "; charset=" + charset;
        }
        this.setHeader("Content-Type", type);
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void addCookie(Cookie cookie) {
        this._httpResponse.addSetCookie(cookie);
    }

    public boolean containsHeader(String name) {
        return this._httpResponse.containsField(name);
    }

    public String encodeURL(String url) {
        if (this._servletRequest == null || this._servletRequest.isRequestedSessionIdFromCookie() && this._servletRequest.getContext().getServletHandler().isUsingCookies()) {
            return url;
        }
        if (this._session == null && !this._noSession) {
            this._session = this._servletRequest.getSession(false);
            boolean bl = this._noSession = this._session == null;
        }
        if (this._session == null || url == null) {
            return url;
        }
        String id = this._session.getId();
        if (id == null) {
            return url;
        }
        int prefix = url.indexOf(";jsessionid=");
        if (prefix != -1) {
            int suffix = url.indexOf("?", prefix);
            if (suffix < 0) {
                suffix = url.indexOf("#", prefix);
            }
            if (suffix <= prefix) {
                return url.substring(0, prefix + ";jsessionid=".length()) + id;
            }
            return url.substring(0, prefix + ";jsessionid=".length()) + id + url.substring(suffix);
        }
        int suffix = url.indexOf(63);
        if (suffix < 0) {
            suffix = url.indexOf(35);
        }
        if (suffix < 0) {
            return url + ";jsessionid=" + id;
        }
        return url.substring(0, suffix) + ";jsessionid=" + id + url.substring(suffix);
    }

    public String encodeRedirectURL(String url) {
        return this.encodeURL(url);
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public void sendError(int status, String message) throws IOException {
        this._httpResponse.sendError(status, message);
    }

    public void sendError(int status) throws IOException {
        this._httpResponse.sendError(status);
    }

    public void sendRedirect(String url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException();
        }
        if (url.indexOf(":/") < 0) {
            StringBuffer buf = new StringBuffer(48);
            String scheme = this._servletRequest.getScheme();
            buf.append(scheme);
            buf.append("://");
            String hostport = this._servletRequest.getHeader("Host");
            if (hostport != null) {
                buf.append(hostport);
            } else {
                buf.append(this._servletRequest.getServerName());
                int port = this._servletRequest.getServerPort();
                if (port > 0 && (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443)) {
                    buf.append(':');
                    buf.append(port);
                }
            }
            if (url.startsWith("/")) {
                buf.append(URI.canonicalPath(url));
            } else {
                buf.append(URI.canonicalPath(URI.addPaths(URI.parentPath(this._servletRequest.getRequestURI()), url)));
            }
            url = buf.toString();
        }
        this._httpResponse.sendRedirect(url);
    }

    public void setDateHeader(String name, long value) {
        if (this._locked) {
            return;
        }
        this._httpResponse.setDateField(name, value);
    }

    public void setHeader(String name, String value) {
        if (this._locked) {
            return;
        }
        this._httpResponse.setField(name, value);
    }

    public void setIntHeader(String name, int value) {
        if (this._locked) {
            return;
        }
        this._httpResponse.setIntField(name, value);
    }

    public void addDateHeader(String name, long value) {
        if (this._locked) {
            return;
        }
        this._httpResponse.addDateField(name, new Date(value));
    }

    public void addHeader(String name, String value) {
        if (this._locked) {
            return;
        }
        this._httpResponse.addField(name, value);
    }

    public void addIntHeader(String name, int value) {
        if (this._locked) {
            return;
        }
        this._httpResponse.addIntField(name, value);
    }

    public void setStatus(int status) {
        this._httpResponse.setStatus(status);
    }

    public void setStatus(int status, String message) {
        this.setStatus(status);
        this._httpResponse.setReason(message);
    }

    public String getCharacterEncoding() {
        String encoding = this._httpResponse.getCharacterEncoding();
        return encoding == null ? StringUtil.__ISO_8859_1 : encoding;
    }

    public ServletOutputStream getOutputStream() {
        if (this._outputState != 0 && this._outputState != 1) {
            throw new IllegalStateException();
        }
        if (this._writer != null) {
            this._writer.flush();
            this._writer.disable();
            this._writer = null;
        }
        if (this._out == null) {
            this._out = new ServletOut(this._servletRequest.getHttpRequest().getOutputStream());
        }
        this._outputState = 1;
        return this._out;
    }

    public PrintWriter getWriter() throws IOException {
        if (this._outputState != 0 && this._outputState != 2) {
            throw new IllegalStateException();
        }
        if (this._writer == null) {
            String encoding = this.getCharacterEncoding();
            if (encoding == null && this._servletRequest != null) {
                String mimeType = this._httpResponse.getMimeType();
                encoding = this._servletRequest.getContext().getServletHandler().getHandlerContext().getEncodingByMimeType(mimeType);
            }
            if (encoding == null) {
                encoding = StringUtil.__ISO_8859_1;
            }
            this._writer = new ServletWriter((OutputStream)this._httpResponse.getOutputStream(), encoding);
        }
        this._outputState = 2;
        return this._writer;
    }

    public void setContentLength(int len) {
        if (!this.isCommitted()) {
            this.setIntHeader("Content-Length", len);
        }
    }

    public void setContentType(String contentType) {
        this.setHeader("Content-Type", contentType);
        if (this._locale != null) {
            this.setLocale(this._locale);
        }
    }

    ServletResponse(ServletRequest request, HttpResponse response) {
        this._servletRequest = request;
        this._servletRequest.setServletResponse(this);
        this._httpResponse = response;
    }

    static {
        __charSetMap.put("ar", "ISO-8859-6");
        __charSetMap.put("be", "ISO-8859-5");
        __charSetMap.put("bg", "ISO-8859-5");
        __charSetMap.put("ca", StringUtil.__ISO_8859_1);
        __charSetMap.put("cs", "ISO-8859-2");
        __charSetMap.put("da", StringUtil.__ISO_8859_1);
        __charSetMap.put("de", StringUtil.__ISO_8859_1);
        __charSetMap.put("el", "ISO-8859-7");
        __charSetMap.put("en", StringUtil.__ISO_8859_1);
        __charSetMap.put("es", StringUtil.__ISO_8859_1);
        __charSetMap.put("et", StringUtil.__ISO_8859_1);
        __charSetMap.put("fi", StringUtil.__ISO_8859_1);
        __charSetMap.put("fr", StringUtil.__ISO_8859_1);
        __charSetMap.put("hr", "ISO-8859-2");
        __charSetMap.put("hu", "ISO-8859-2");
        __charSetMap.put("is", StringUtil.__ISO_8859_1);
        __charSetMap.put("it", StringUtil.__ISO_8859_1);
        __charSetMap.put("iw", "ISO-8859-8");
        __charSetMap.put("ja", "Shift__JIS");
        __charSetMap.put("ko", "EUC-KR");
        __charSetMap.put("lt", "ISO-8859-2");
        __charSetMap.put("lv", "ISO-8859-2");
        __charSetMap.put("mk", "ISO-8859-5");
        __charSetMap.put("nl", StringUtil.__ISO_8859_1);
        __charSetMap.put("no", StringUtil.__ISO_8859_1);
        __charSetMap.put("pl", "ISO-8859-2");
        __charSetMap.put("pt", StringUtil.__ISO_8859_1);
        __charSetMap.put("ro", "ISO-8859-2");
        __charSetMap.put("ru", "ISO-8859-5");
        __charSetMap.put("sh", "ISO-8859-5");
        __charSetMap.put("sk", "ISO-8859-2");
        __charSetMap.put("sl", "ISO-8859-2");
        __charSetMap.put("sq", "ISO-8859-2");
        __charSetMap.put("sr", "ISO-8859-5");
        __charSetMap.put("sv", StringUtil.__ISO_8859_1);
        __charSetMap.put("tr", "ISO-8859-9");
        __charSetMap.put("uk", "ISO-8859-5");
        __charSetMap.put("zh", "GB2312");
        __charSetMap.put("zh_TW", "Big5");
    }
}

