/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpFields;
import org.mortbay.http.HttpRequest;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletIn;
import org.mortbay.jetty.servlet.ServletResponse;
import org.mortbay.util.Code;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiMap;
import org.mortbay.util.Resource;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URI;

public class ServletRequest
implements HttpServletRequest {
    public static final String __SESSIONID_NOT_CHECKED = "not checked";
    public static final String __SESSIONID_URL = "url";
    public static final String __SESSIONID_COOKIE = "cookie";
    public static final String __SESSIONID_NONE = "none";
    private static final Enumeration __emptyEnum = Collections.enumeration(Collections.EMPTY_LIST);
    private static final Collection __defaultLocale = Collections.singleton(Locale.getDefault());
    private HttpRequest _httpRequest;
    private ServletResponse _servletResponse;
    private String _uri = null;
    private String _contextPath = null;
    private String _servletPath = null;
    private String _pathInfo = null;
    private String _query = null;
    private String _pathTranslated = null;
    private String _sessionId = null;
    private HttpSession _session = null;
    private String _sessionIdState = "not checked";
    private ServletIn _in = null;
    private BufferedReader _reader = null;
    private int _inputState = 0;
    private Context _context;
    private ArrayList _mergedParameters;

    void setPaths(String servletPath, String pathInfo) {
        this._servletPath = servletPath;
        this._pathInfo = pathInfo;
    }

    void setForwardPaths(Context context, String servletPath, String pathInfo, String query) {
        this._context = context;
        this._contextPath = context.getContextPath();
        if (this._contextPath.length() == 1) {
            this._contextPath = "";
        }
        this._servletPath = servletPath;
        this._pathInfo = pathInfo;
        this._query = query;
        this._uri = URI.addPaths(this.getContextPath(), URI.addPaths(this._servletPath, this._pathInfo));
    }

    HttpRequest getHttpRequest() {
        return this._httpRequest;
    }

    public ServletResponse getServletResponse() {
        return this._servletResponse;
    }

    void setServletResponse(ServletResponse response) {
        this._servletResponse = response;
    }

    Context getContext() {
        return this._context;
    }

    public Locale getLocale() {
        Enumeration enumeration = this._httpRequest.getHeader().getValues("Accept-Language", ", \t");
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return Locale.getDefault();
        }
        List acceptLanguage = HttpFields.qualityList(enumeration);
        if (acceptLanguage.size() == 0) {
            return Locale.getDefault();
        }
        Object langs = null;
        int size = acceptLanguage.size();
        int i = 0;
        if (i < size) {
            String language = (String)acceptLanguage.get(i);
            language = HttpFields.valueParameters(language, null);
            String country = "";
            int dash = language.indexOf(45);
            if (dash > -1) {
                country = language.substring(dash + 1).trim();
                language = language.substring(0, dash).trim();
            }
            return new Locale(language, country);
        }
        return Locale.getDefault();
    }

    public Enumeration getLocales() {
        Enumeration enumeration = this._httpRequest.getHeader().getValues("Accept-Language", ", \t");
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return Collections.enumeration(__defaultLocale);
        }
        List acceptLanguage = HttpFields.qualityList(enumeration);
        if (acceptLanguage.size() == 0) {
            return Collections.enumeration(__defaultLocale);
        }
        LazyList langs = null;
        int size = acceptLanguage.size();
        int i = 0;
        while (i < size) {
            String language = (String)acceptLanguage.get(i);
            language = HttpFields.valueParameters(language, null);
            String country = "";
            int dash = language.indexOf(45);
            if (dash > -1) {
                country = language.substring(dash + 1).trim();
                language = language.substring(0, dash).trim();
            }
            langs = LazyList.add(langs, size, new Locale(language, country));
            ++i;
        }
        if (LazyList.size(langs) == 0) {
            return Collections.enumeration(__defaultLocale);
        }
        return Collections.enumeration(LazyList.getList(langs));
    }

    public String getAuthType() {
        Object o = this._httpRequest.getAttribute("org.mortbay.http.HttpRequest.AuthType");
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public boolean isSecure() {
        return "https".equals(this._httpRequest.getScheme());
    }

    public Cookie[] getCookies() {
        return this._httpRequest.getCookies();
    }

    public long getDateHeader(String name) {
        return this._httpRequest.getDateField(name);
    }

    public Enumeration getHeaderNames() {
        return this._httpRequest.getFieldNames();
    }

    public String getHeader(String name) {
        return this._httpRequest.getField(name);
    }

    public Enumeration getHeaders(String s) {
        Enumeration enumeration = this._httpRequest.getFieldValues(s);
        if (enumeration == null) {
            return __emptyEnum;
        }
        return enumeration;
    }

    public int getIntHeader(String name) throws NumberFormatException {
        return this._httpRequest.getIntField(name);
    }

    public String getMethod() {
        return this._httpRequest.getMethod();
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public String getPathInfo() {
        return this._pathInfo;
    }

    public String getPathTranslated() {
        if (this._pathInfo == null || this._pathInfo.length() == 0) {
            return null;
        }
        if (this._pathTranslated == null) {
            Resource resource = this._context.getHandler().getHandlerContext().getBaseResource();
            if (resource == null) {
                return null;
            }
            try {
                resource = resource.addPath(this._pathInfo);
                File file = resource.getFile();
                if (file == null) {
                    return null;
                }
                this._pathTranslated = file.getAbsolutePath();
            }
            catch (Exception e) {
                Code.debug(e);
            }
        }
        return this._pathTranslated;
    }

    public String getQueryString() {
        if (this._query == null) {
            this._query = this._httpRequest.getQuery();
        }
        return this._query;
    }

    public String getRemoteUser() {
        Object o = this._httpRequest.getAttribute("org.mortbay.http.HttpRequest.AuthUser");
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public boolean isUserInRole(String role) {
        return this._httpRequest.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this._httpRequest.getUserPrincipal();
    }

    void setSessionId(String pathParams) {
        Cookie[] cookies;
        this._sessionId = null;
        if (this._context.getServletHandler().isUsingCookies() && (cookies = this._httpRequest.getCookies()) != null && cookies.length > 0) {
            int i = 0;
            while (i < cookies.length) {
                if ("jsessionid".equals(cookies[i].getName())) {
                    this._sessionId = cookies[i].getValue();
                    this._sessionIdState = __SESSIONID_COOKIE;
                    Code.debug("Got Session ", this._sessionId, " from cookie");
                    break;
                }
                ++i;
            }
        }
        if (pathParams != null && pathParams.startsWith("jsessionid")) {
            String id = pathParams.substring("jsessionid".length() + 1);
            Code.debug("Got Session ", id, " from URL");
            try {
                Long.parseLong(id, 36);
                if (this._sessionId == null) {
                    this._sessionId = id;
                    this._sessionIdState = __SESSIONID_URL;
                } else if (!id.equals(this._sessionId)) {
                    Code.warning("Mismatched session IDs");
                }
            }
            catch (NumberFormatException e) {
                Code.ignore(e);
            }
        }
        if (this._sessionId == null) {
            this._sessionIdState = __SESSIONID_NONE;
        }
    }

    public String getRequestedSessionId() {
        return this._sessionId;
    }

    public String getRequestURI() {
        if (this._uri != null) {
            return this._uri;
        }
        String path = this._httpRequest.getPath();
        int prefix = path.indexOf(";jsessionid=");
        if (prefix != -1) {
            path = path.substring(0, prefix);
        }
        return path;
    }

    public String getServletPath() {
        return this._servletPath;
    }

    public HttpSession getSession(boolean create) {
        if (this._session != null && Context.isValid(this._session)) {
            return this._session;
        }
        String id = this.getRequestedSessionId();
        if (id != null) {
            this._session = this._context.getHttpSession(id);
            if (this._session == null && !create) {
                return null;
            }
        }
        if (this._session == null && create) {
            this._session = this._context.newSession();
            if (this._context.getServletHandler().isUsingCookies()) {
                Cookie cookie = new Cookie(Context.__SessionId, this._session.getId());
                String path = this.getContextPath();
                if (path == null || path.length() == 0) {
                    path = "/";
                }
                cookie.setPath(path);
                this._servletResponse.getHttpResponse().addSetCookie(cookie, false);
                cookie.setVersion(1);
                this._servletResponse.getHttpResponse().addSetCookie(cookie, true);
            }
        }
        return this._session;
    }

    public HttpSession getSession() {
        HttpSession session = this.getSession(false);
        return session == null ? this.getSession(true) : session;
    }

    public boolean isRequestedSessionIdValid() {
        return this._sessionId != null && this.getSession(false) != null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this._sessionIdState == __SESSIONID_COOKIE;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this._sessionIdState == __SESSIONID_URL;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this._httpRequest.getAttributeNames());
    }

    public Object getAttribute(String name) {
        return this._httpRequest.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        if (name.startsWith("org.mortbay.http")) {
            Code.warning("Servlet attempted update of " + name);
            return;
        }
        this._httpRequest.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        if (name.startsWith("org.mortbay.http")) {
            Code.warning("Servlet attempted update of " + name);
            return;
        }
        this._httpRequest.removeAttribute(name);
    }

    public String getCharacterEncoding() {
        return this._httpRequest.getCharacterEncoding();
    }

    public int getContentLength() {
        return this._httpRequest.getIntField("Content-Length");
    }

    public String getContentType() {
        return this._httpRequest.getField("Content-Type");
    }

    public ServletInputStream getInputStream() {
        if (this._inputState != 0 && this._inputState != 1) {
            throw new IllegalStateException();
        }
        if (this._in == null) {
            this._in = new ServletIn(this._httpRequest.getInputStream());
        }
        this._inputState = 1;
        return this._in;
    }

    void popParameters() {
        this._mergedParameters.remove(this._mergedParameters.size() - 1);
    }

    void pushParameters(MultiMap parameters) {
        if (this._mergedParameters == null) {
            this._mergedParameters = new ArrayList(2);
        }
        this._mergedParameters.add(parameters);
    }

    public String getParameter(String name) {
        if (this._mergedParameters != null) {
            int p = this._mergedParameters.size();
            while (p-- > 0) {
                MultiMap params = (MultiMap)this._mergedParameters.get(p);
                String param = params.getString(name);
                if (param == null) continue;
                return param;
            }
        }
        return this._httpRequest.getParameter(name);
    }

    public Enumeration getParameterNames() {
        if (this._mergedParameters != null) {
            HashSet set = new HashSet(this._httpRequest.getParameterNames());
            int p = this._mergedParameters.size();
            while (p-- > 0) {
                MultiMap params = (MultiMap)this._mergedParameters.get(p);
                set.addAll(params.keySet());
            }
            return Collections.enumeration(set);
        }
        return Collections.enumeration(this._httpRequest.getParameterNames());
    }

    public String[] getParameterValues(String name) {
        List v = null;
        if (this._mergedParameters != null) {
            int p = this._mergedParameters.size();
            while (v == null && p-- > 0) {
                MultiMap params = (MultiMap)this._mergedParameters.get(p);
                v = params.getValues(name);
            }
        }
        if (v == null) {
            v = this._httpRequest.getParameterValues(name);
        }
        if (v == null) {
            return null;
        }
        String[] a = new String[v.size()];
        return v.toArray(a);
    }

    public String getProtocol() {
        return this._httpRequest.getVersion();
    }

    public String getScheme() {
        return this._httpRequest.getScheme();
    }

    public String getServerName() {
        return this._httpRequest.getHost();
    }

    public int getServerPort() {
        int port = this._httpRequest.getPort();
        if (port == 0) {
            if (this.getScheme().equalsIgnoreCase("https")) {
                return 443;
            }
            return 80;
        }
        return port;
    }

    public BufferedReader getReader() {
        if (this._inputState != 0 && this._inputState != 2) {
            throw new IllegalStateException();
        }
        if (this._reader == null) {
            try {
                String encoding = this.getCharacterEncoding();
                if (encoding == null) {
                    encoding = StringUtil.__ISO_8859_1;
                }
                this._reader = new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), encoding));
            }
            catch (UnsupportedEncodingException e) {
                Code.warning(e);
                this._reader = new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
            }
            this._inputState = 2;
        }
        return this._reader;
    }

    public String getRemoteAddr() {
        return this._httpRequest.getRemoteAddr();
    }

    public String getRemoteHost() {
        InetAddress addr;
        String remoteHost = null;
        HttpConnection connection = this._httpRequest.getHttpConnection();
        if (connection != null && (addr = connection.getRemoteAddr()) != null) {
            remoteHost = addr.getHostName();
        }
        return remoteHost;
    }

    public String getRealPath(String path) {
        return this._context.getRealPath(path);
    }

    public RequestDispatcher getRequestDispatcher(String url) {
        if (url == null) {
            return null;
        }
        if (!url.startsWith("/")) {
            String relTo = URI.addPaths(this._servletPath, this._pathInfo);
            int slash = relTo.lastIndexOf(47);
            relTo = relTo.substring(0, slash);
            while (url.startsWith("../")) {
                if (relTo.length() == 0) {
                    return null;
                }
                url = url.substring(3);
                slash = relTo.lastIndexOf(47);
                relTo = relTo.substring(0, slash);
            }
            url = relTo + url;
        }
        return this._context.getRequestDispatcher(url);
    }

    public String toString() {
        return this._httpRequest.toString();
    }

    ServletRequest(Context context, HttpRequest request) {
        this._context = context;
        this._contextPath = context.getContextPath();
        if (this._contextPath.length() == 1) {
            this._contextPath = "";
        }
        this._httpRequest = request;
    }
}

