/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import org.mortbay.http.ContextLoader;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletRequest;
import org.mortbay.jetty.servlet.ServletResponse;
import org.mortbay.util.Code;

public class ServletHolder
extends AbstractMap
implements Comparable {
    private ServletHandler _handler;
    private Context _context;
    private boolean _singleThreadModel;
    private Class _servletClass = null;
    private Stack _servlets = new Stack();
    private Servlet _servlet = null;
    private String _name = null;
    private String _className;
    private Map _initParams;
    private int _initOrder;
    private boolean _initOnStartup = false;
    private Config _config;
    private Map _roleMap;
    private int _checks;
    private String _path;
    private static /* synthetic */ Class class$Ljavax$servlet$Servlet;

    public String getServletName() {
        return this._name;
    }

    public void setServletName(String name) {
        ServletHandler servletHandler = this._handler;
        synchronized (servletHandler) {
            this._handler.mapHolder(name, this, this._name);
            this._name = name;
        }
    }

    public String getClassName() {
        return this._className;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public boolean isInitOnStartup() {
        return this._initOrder != 0 || this._initOnStartup;
    }

    public void setInitOnStartup(boolean b) {
        this._initOrder = b ? 0 : -1;
    }

    public int getInitOrder() {
        return this._initOrder;
    }

    public void setInitOrder(int order) {
        this._initOnStartup = true;
        this._initOrder = order;
    }

    public int compareTo(Object o) {
        if (o instanceof ServletHolder) {
            ServletHolder sh = (ServletHolder)o;
            if (sh == this) {
                return 0;
            }
            if (sh._initOrder < this._initOrder) {
                return 1;
            }
            if (sh._initOrder > this._initOrder) {
                return -1;
            }
            int c = this._className.compareTo(sh._className);
            if (c == 0) {
                c = this._name.compareTo(sh._name);
            }
            if (c == 0) {
                c = this.hashCode() > o.hashCode() ? 1 : -1;
            }
            return c;
        }
        return 1;
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public void initialize() {
        try {
            this.getServlet();
        }
        catch (UnavailableException e) {
            Code.warning(e);
            throw new IllegalStateException(e.toString());
        }
    }

    synchronized void initializeClass() throws UnavailableException {
        try {
            Code.debug("InitializeClass " + this.getClassName());
            if (this.getClassName().equals(this._handler.getJSPClassName())) {
                Code.debug("Jasper hack");
                ClassLoader jettyLoader = this._handler.getHandlerContext().getClassLoader();
                ClassLoader jasperLoader = (ClassLoader)this._context.getAttribute("org.apache.tomcat.classloader");
                if (jettyLoader != null && jasperLoader == null) {
                    Code.debug("Fiddle classloader for Jasper: " + jettyLoader);
                    this._context.setAttribute("org.apache.tomcat.classloader", jettyLoader);
                }
                String classpath = this.getInitParameter("classpath");
                String ctxClasspath = jettyLoader instanceof ContextLoader ? ((ContextLoader)jettyLoader).getFileClassPath() : this._handler.getHandlerContext().getClassPath();
                String tomcatpath = (String)this._context.getAttribute("org.apache.tomcat.jsp_classpath");
                if (classpath == null && tomcatpath != null) {
                    classpath = tomcatpath;
                    Code.debug("Fiddle classpath for Jasper: " + classpath);
                    this.setInitParameter("classpath", classpath);
                }
                if ((classpath == null || classpath.length() == 0) && ctxClasspath != null && ctxClasspath.length() > 0) {
                    classpath = ctxClasspath;
                    Code.debug("Fiddle classpath for Jasper: " + classpath);
                    this.setInitParameter("classpath", classpath);
                }
            }
            ClassLoader loader = this._context.getHandler().getClassLoader();
            Code.debug((Object)"Servlet loader ", (Object)loader);
            this._servletClass = loader == null ? Class.forName(this.getClassName()) : loader.loadClass(this.getClassName());
            Code.debug((Object)"Servlet Class ", (Object)this._servletClass);
            if (!(class$Ljavax$servlet$Servlet != null ? class$Ljavax$servlet$Servlet : (class$Ljavax$servlet$Servlet = ServletHolder.class$("javax.servlet.Servlet"))).isAssignableFrom(this._servletClass)) {
                Code.fail("Servlet class " + this.getClassName() + " is not a javax.servlet.Servlet");
            }
        }
        catch (ClassNotFoundException e) {
            Code.debug(e);
            throw new UnavailableException(e.toString());
        }
    }

    public synchronized void destroy() {
        if (this._servlet != null) {
            this._servlet.destroy();
        }
        this._servlet = null;
        this._checks = 0;
        while (this._servlets != null && this._servlets.size() > 0) {
            Servlet s = (Servlet)this._servlets.pop();
            s.destroy();
        }
        this._servlets = new Stack();
        this._servletClass = null;
    }

    public synchronized Servlet getServlet() throws UnavailableException {
        try {
            if (this._servletClass == null) {
                this.initializeClass();
            }
            if (this._servlet == null) {
                Servlet newServlet = (Servlet)this._servletClass.newInstance();
                newServlet.init((ServletConfig)this._config);
                this._singleThreadModel = newServlet instanceof SingleThreadModel;
                if (this._servlet == null && !this._singleThreadModel) {
                    this._servlet = newServlet;
                }
            }
            return this._servlet;
        }
        catch (UnavailableException e) {
            throw e;
        }
        catch (Exception e) {
            Code.warning(e);
            throw new UnavailableException(e.toString());
        }
    }

    public ServletContext getServletContext() {
        return this._context;
    }

    public void setInitParameter(String param, String value) {
        this.put(param, value);
    }

    public String getInitParameter(String param) {
        if (this._initParams == null) {
            return null;
        }
        return (String)this._initParams.get(param);
    }

    public Enumeration getInitParameterNames() {
        if (this._initParams == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return Collections.enumeration(this._initParams.keySet());
    }

    public synchronized void setUserRoleLink(String name, String link) {
        if (this._roleMap == null) {
            this._roleMap = new HashMap();
        }
    }

    public String getUserRoleLink(String name) {
        if (this._roleMap == null) {
            return name;
        }
        String link = (String)this._roleMap.get(name);
        return link == null ? name : link;
    }

    /*
     * Unable to fully structure code
     */
    public void handle(ServletRequest request, ServletResponse response) throws ServletException, UnavailableException, IOException {
        block27: {
            if (this._servletClass == null) {
                throw new UnavailableException("Servlet class not initialized");
            }
            useServlet = null;
            pool = this._servlets;
            if (this._singleThreadModel) {
                try {
                    useServlet = (Servlet)pool.pop();
                }
                catch (EmptyStackException e) {
                    try {
                        useServlet = (Servlet)this._servletClass.newInstance();
                        useServlet.init((ServletConfig)this._config);
                    }
                    catch (Exception e2) {
                        Code.warning(e2);
                        useServlet = null;
                    }
                }
            } else if (this._servlet == null || this._checks < 2) {
                var5_6 = this;
                synchronized (var5_6) {
                    if (this._servlet == null) {
                        try {
                            useServlet = (Servlet)this._servletClass.newInstance();
                            useServlet.init((ServletConfig)this._config);
                            this._servlet = useServlet;
                            this._singleThreadModel = this._servlet instanceof SingleThreadModel;
                            if (!this._singleThreadModel) ** GOTO lbl39
                            this._servlet = null;
                        }
                        catch (UnavailableException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            Code.warning(e);
                            this._servlet = null;
                            useServlet = null;
                        }
                    } else {
                        useServlet = this._servlet;
                    }
lbl39:
                    // 4 sources

                    ++this._checks;
                }
            } else {
                useServlet = this._servlet;
            }
            if (useServlet == null) {
                throw new UnavailableException("Could not construct servlet");
            }
            try {
                if (this._path != null) {
                    request.setAttribute("javax.servlet.include.request_uri", request.getContextPath() + (this._path.startsWith("/") != false ? "" : "/") + this._path);
                    request.setAttribute("javax.servlet.include.servlet_path", this._path);
                }
                useServlet.service((javax.servlet.ServletRequest)request, (javax.servlet.ServletResponse)response);
                response.flushBuffer();
                var6_9 = null;
                if (!this._singleThreadModel || useServlet == null) break block27;
                pool.push(useServlet);
            }
            catch (Throwable var5_7) {
                var6_10 = null;
                if (this._singleThreadModel && useServlet != null) {
                    pool.push(useServlet);
                }
                throw var5_7;
            }
            {
                break block27;
                catch (UnavailableException e) {
                    if (this._singleThreadModel && useServlet != null) {
                        useServlet.destroy();
                    } else {
                        this.destroy();
                    }
                    useServlet = null;
                    throw e;
                }
            }
        }
    }

    public synchronized Set entrySet() {
        if (this._initParams == null) {
            this._initParams = new HashMap(3);
        }
        return this._initParams.entrySet();
    }

    public synchronized Object put(Object name, Object value) {
        if (this._initParams == null) {
            this._initParams = new HashMap(3);
        }
        return this._initParams.put(name, value);
    }

    public String toString() {
        return this._name;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ServletHolder(ServletHandler handler, String className) {
        this._handler = handler;
        this._context = this._handler.getContext();
        this.setServletName(className);
        this._className = className;
        this._name = className;
        this._config = new Config();
    }

    public ServletHolder(ServletHandler handler, String className, String path) {
        this(handler, className);
        this._path = path;
    }

    class Config
    implements ServletConfig {
        public String getServletName() {
            return ServletHolder.this.getServletName();
        }

        public ServletContext getServletContext() {
            return ServletHolder.this._context;
        }

        public String getInitParameter(String param) {
            return ServletHolder.this.getInitParameter(param);
        }

        public Enumeration getInitParameterNames() {
            return ServletHolder.this.getInitParameterNames();
        }

        Config() {
        }
    }
}

