/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpSession;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.PathMap;
import org.mortbay.http.UserPrincipal;
import org.mortbay.http.handler.NullHandler;
import org.mortbay.http.handler.SecurityHandler;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletRequest;
import org.mortbay.jetty.servlet.ServletResponse;
import org.mortbay.util.Code;
import org.mortbay.util.Log;
import org.mortbay.util.URI;

public class ServletHandler
extends NullHandler
implements SecurityHandler.FormAuthenticator {
    public static final String __JSP_SERVLET = "org.apache.jasper.servlet.JspServlet";
    public static final String __SERVLET_REQUEST = "org.mortbay.jetty.Request";
    public static final String __SERVLET_HOLDER = "org.mortbay.jetty.Holder";
    public static final String __J_URI = "org.mortbay.jetty.URI";
    public static final String __J_AUTHENTICATED = "org.mortbay.jetty.Auth";
    private PathMap _servletMap = new PathMap();
    private Map _nameMap = new HashMap();
    private Context _context = new Context(this);
    private ClassLoader _loader;
    private String _dynamicServletPathSpec;
    private Map _dynamicInitParams;
    private boolean _serveDynamicSystemServlets = false;
    private boolean _usingCookies = true;

    public Context getContext() {
        return this._context;
    }

    public PathMap getServletMap() {
        return this._servletMap;
    }

    public boolean isAutoReload() {
        return false;
    }

    public String getDynamicServletPathSpec() {
        return this._dynamicServletPathSpec;
    }

    public Map getDynamicInitParams() {
        return this._dynamicInitParams;
    }

    public boolean isUsingCookies() {
        return this._usingCookies;
    }

    public boolean getServeDynamicSystemServlets() {
        return this._serveDynamicSystemServlets;
    }

    public void setDynamicServletPathSpec(String dynamicServletPathSpec) {
        if (dynamicServletPathSpec != null && !dynamicServletPathSpec.equals("/") && !dynamicServletPathSpec.endsWith("/*")) {
            throw new IllegalArgumentException("dynamicServletPathSpec must end with /*");
        }
        this._dynamicServletPathSpec = dynamicServletPathSpec;
    }

    public void setDynamicInitParams(Map initParams) {
        this._dynamicInitParams = initParams;
    }

    public void setServeDynamicSystemServlets(boolean b) {
        this._serveDynamicSystemServlets = b;
    }

    public void setAutoReload(boolean autoReload) {
        if (autoReload) {
            Code.warning("AutoReload is no longer supported!\nIt may be resurrected once the URL libraries fully support lastModified");
        }
    }

    public ClassLoader getClassLoader() {
        return this._loader;
    }

    public void setUsingCookies(boolean uc) {
        this._usingCookies = uc;
    }

    public synchronized boolean isStarted() {
        return super.isStarted();
    }

    public synchronized void start() throws Exception {
        this._context.setHandlerContext(this.getHandlerContext());
        this._loader = this.getHandlerContext().getClassLoader();
        super.start();
        Object[] holders = ((AbstractCollection)new HashSet(this._servletMap.values())).toArray(new ServletHolder[0]);
        Arrays.sort(holders);
        int i = 0;
        while (i < holders.length) {
            Object holder = holders[i];
            if (((ServletHolder)holder).isInitOnStartup()) {
                ((ServletHolder)holder).initialize();
            } else {
                try {
                    ((ServletHolder)holder).initializeClass();
                }
                catch (UnavailableException e) {
                    Code.warning(e);
                }
            }
            ++i;
        }
    }

    public synchronized void stop() {
        this._loader = null;
        Iterator i = this._servletMap.values().iterator();
        while (i.hasNext()) {
            ServletHolder holder = (ServletHolder)i.next();
            holder.destroy();
        }
        if (this._context != null) {
            this._context.stop();
        }
        super.stop();
    }

    public ServletHolder addServlet(String name, String pathSpec, String servletClass) {
        ServletHolder holder = this.addServlet(pathSpec, servletClass);
        holder.setServletName(name);
        return holder;
    }

    /*
     * WARNING - void declaration
     */
    public ServletHolder addServlet(String pathSpec, String servletClass) {
        try {
            void e;
            ServletHolder holder = this.newServletHolder(servletClass);
            this.addHolder(pathSpec, holder);
            return e;
        }
        catch (Exception e) {
            Code.warning(e);
            throw new IllegalArgumentException(e.toString());
        }
    }

    public ServletHolder getServletHolder(String name) {
        return (ServletHolder)this._nameMap.get(name);
    }

    public void addHolder(String pathSpec, ServletHolder holder) {
        try {
            if (this.isStarted()) {
                holder.initializeClass();
            }
            this._servletMap.put(pathSpec, holder);
        }
        catch (UnavailableException e) {
            Code.warning(e);
        }
    }

    public ServletRequest getServletRequest(HttpRequest httpRequest, HttpResponse httpResponse) {
        ServletRequest servletRequest = (ServletRequest)httpRequest.getAttribute(__SERVLET_REQUEST);
        if (servletRequest == null) {
            servletRequest = new ServletRequest(this._context, httpRequest);
            httpRequest.setAttribute(__SERVLET_REQUEST, servletRequest);
            ServletResponse servletResponse = new ServletResponse(servletRequest, httpResponse);
        }
        return servletRequest;
    }

    public void setSessionId(String pathParams, ServletRequest request) {
        request.setSessionId(pathParams);
        HttpSession session = request.getSession(false);
        if (session != null) {
            Context.access(session);
        }
    }

    public int sessionCount() {
        return this._context.sessionCount();
    }

    public void handle(String pathInContext, String pathParams, HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        try {
            ServletRequest request = null;
            ServletResponse response = null;
            Code.debug((Object)"Looking for servlet at ", (Object)pathInContext);
            ServletHolder holder = (ServletHolder)httpRequest.getAttribute(__SERVLET_HOLDER);
            if (holder != null) {
                request = this.getServletRequest(httpRequest, httpResponse);
                response = request.getServletResponse();
                this.setSessionId(pathParams, request);
            } else {
                Map.Entry entry = this.getHolderEntry(pathInContext);
                if (entry != null) {
                    request = this.getServletRequest(httpRequest, httpResponse);
                    response = request.getServletResponse();
                    this.setSessionId(pathParams, request);
                    String servletPathSpec = (String)entry.getKey();
                    holder = (ServletHolder)entry.getValue();
                    Code.debug((Object)"Pass request to servlet at ", (Object)entry);
                    request.setPaths(PathMap.pathMatch(servletPathSpec, pathInContext), PathMap.pathInfo(servletPathSpec, pathInContext));
                }
            }
            if (holder != null) {
                holder.handle(request, response);
                response.setOutputState(0);
                Code.debug((Object)"Handled by ", (Object)holder);
                if (!httpResponse.isCommitted()) {
                    httpResponse.commit();
                }
            }
        }
        catch (Exception e) {
            Code.debug(e);
            Throwable th = e;
            if (e instanceof ServletException && ((ServletException)e).getRootCause() != null) {
                Code.debug("Extracting root cause from ", e);
                th = ((ServletException)e).getRootCause();
            }
            if (th instanceof HttpException) {
                throw (HttpException)th;
            }
            if (th instanceof IOException) {
                throw (IOException)th;
            }
            Code.warning("Servlet Exception for " + httpRequest.getURI(), th);
            Code.debug(httpRequest);
            httpResponse.getHttpConnection().forceClose();
            if (!httpResponse.isCommitted()) {
                httpResponse.sendError(503, th);
            } else {
                Code.debug("Response already committed for handling ", th);
            }
        }
        catch (Error e) {
            Code.warning("Servlet Error for " + httpRequest.getURI(), e);
            Code.debug(httpRequest);
            httpResponse.getHttpConnection().forceClose();
            if (!httpResponse.isCommitted()) {
                httpResponse.sendError(503, e);
            }
            Code.debug("Response already committed for handling ", e);
        }
    }

    public Map.Entry getHolderEntry(String pathInContext) {
        Map.Entry entry = this._servletMap.getMatch(pathInContext);
        String servletClass = null;
        if (this._dynamicServletPathSpec != null) {
            servletClass = PathMap.pathInfo(this._dynamicServletPathSpec, pathInContext);
        }
        if (entry != null && servletClass == null) {
            return entry;
        }
        ServletHandler servletHandler = this;
        synchronized (servletHandler) {
            entry = this._servletMap.getMatch(pathInContext);
            if (entry != null && servletClass == null) {
                Map.Entry entry2 = entry;
                Object var5_6 = null;
                return entry2;
            }
            if (!(servletClass == null || servletClass.length() <= 2 || entry != null && PathMap.match(this._dynamicServletPathSpec, (String)entry.getKey()))) {
                try {
                    String path = pathInContext;
                    Code.debug((Object)"looking for ", servletClass, (Object)" in ", this.getHandlerContext().getClassPath());
                    servletClass = servletClass.substring(1);
                    int slash = servletClass.indexOf(47);
                    if (slash >= 0) {
                        servletClass = servletClass.substring(0, slash);
                    }
                    if (servletClass.endsWith(".class")) {
                        servletClass = servletClass.substring(0, servletClass.length() - 6);
                    }
                    path = "/".equals(this._dynamicServletPathSpec) ? "/" + servletClass : PathMap.pathMatch(this._dynamicServletPathSpec, path) + "/" + servletClass;
                    Code.debug((Object)"Dynamic path=", (Object)path);
                    ServletHolder holder = this.newServletHolder(servletClass);
                    Map params = this.getDynamicInitParams();
                    if (params != null) {
                        holder.putAll(params);
                    }
                    Servlet servlet = holder.getServlet();
                    if (!this._serveDynamicSystemServlets && this._loader != null && this._loader != this.getClass().getClassLoader() && servlet.getClass().getClassLoader() != this._loader) {
                        holder.destroy();
                        String msg = "Dynamic servlet " + servletClass + " is not loaded from context: " + this.getContext().getHandlerContext().getContextPath();
                        Code.warning(msg);
                        throw new UnavailableException(msg);
                    }
                    Log.event("Dynamic load '" + servletClass + "' at " + path);
                    this.addHolder(path + "/*", holder);
                    this.addHolder(path + ".class/*", holder);
                    entry = this._servletMap.getMatch(pathInContext);
                }
                catch (Exception e) {
                    Code.ignore(e);
                }
            }
        }
        return entry;
    }

    public ServletHolder newServletHolder(String servletClass) throws UnavailableException, ClassNotFoundException {
        return new ServletHolder(this, servletClass);
    }

    public ServletHolder newServletHolder(String servletClass, String path) throws UnavailableException, ClassNotFoundException {
        return new ServletHolder(this, servletClass, path);
    }

    public synchronized void destroy() {
        Iterator i = this._servletMap.values().iterator();
        while (i.hasNext()) {
            ServletHolder holder = (ServletHolder)i.next();
            holder.destroy();
        }
    }

    void mapHolder(String name, ServletHolder holder, String oldName) {
        Map map = this._nameMap;
        synchronized (map) {
            if (oldName != null) {
                this._nameMap.remove(oldName);
            }
            this._nameMap.put(name, holder);
        }
    }

    public String getJSPClassName() {
        return __JSP_SERVLET;
    }

    public boolean formAuthenticated(SecurityHandler shandler, String pathInContext, String pathParams, HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        ServletRequest request = this.getServletRequest(httpRequest, httpResponse);
        ServletResponse response = request.getServletResponse();
        request.setSessionId(pathParams);
        String uri = pathInContext;
        HttpSession session = request.getSession(true);
        if (uri.substring(uri.lastIndexOf("/") + 1).startsWith("j_security_check")) {
            String username = request.getParameter("j_username");
            String password = request.getParameter("j_password");
            UserPrincipal user = shandler.getUserRealm().getUser(username);
            if (user != null && user.authenticate(password, httpRequest)) {
                Code.debug((Object)"Form authentication OK for ", (Object)username);
                httpRequest.setAttribute("org.mortbay.http.HttpRequest.AuthType", "FORM");
                httpRequest.setAttribute("org.mortbay.http.HttpRequest.AuthUser", username);
                httpRequest.setAttribute("org.mortbay.http.UserPrincipal", user);
                session.setAttribute(__J_AUTHENTICATED, (Object)username);
                String nuri = (String)session.getAttribute(__J_URI);
                if (nuri == null) {
                    response.sendRedirect(URI.addPaths(request.getContextPath(), shandler.getErrorPage()));
                } else {
                    response.sendRedirect(nuri);
                }
            } else {
                Code.debug((Object)"Form authentication FAILED for ", (Object)username);
                response.sendRedirect(URI.addPaths(request.getContextPath(), shandler.getErrorPage()));
            }
            return false;
        }
        if (session.getAttribute(__J_AUTHENTICATED) != null) {
            String username = (String)session.getAttribute(__J_AUTHENTICATED);
            UserPrincipal user = shandler.getUserRealm().getUser(username);
            Code.debug((Object)"FORM Authenticated for ", (Object)username);
            httpRequest.setAttribute("org.mortbay.http.HttpRequest.AuthType", "FORM");
            httpRequest.setAttribute("org.mortbay.http.HttpRequest.AuthUser", username);
            httpRequest.setAttribute("org.mortbay.http.UserPrincipal", user);
            return true;
        }
        if (httpRequest.getQuery() != null) {
            uri = uri + "?" + httpRequest.getQuery();
        }
        session.setAttribute(__J_URI, (Object)URI.addPaths(request.getContextPath(), uri));
        response.sendRedirect(URI.addPaths(request.getContextPath(), shandler.getLoginPage()));
        return false;
    }
}

