/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import org.mortbay.http.HandlerContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.PathMap;
import org.mortbay.http.handler.ResourceHandler;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletRequest;
import org.mortbay.jetty.servlet.ServletResponse;
import org.mortbay.util.Code;
import org.mortbay.util.MultiMap;
import org.mortbay.util.Resource;
import org.mortbay.util.UrlEncoded;

public class Dispatcher
implements RequestDispatcher {
    public static final String __REQUEST_URI = "javax.servlet.include.request_uri";
    public static final String __SERVLET_PATH = "javax.servlet.include.servlet_path";
    public static final String __CONTEXT_PATH = "javax.servlet.include.context_path";
    public static final String __QUERY_STRING = "javax.servlet.include.query_string";
    public static final String __PATH_INFO = "javax.servlet.include.path_info";
    Context _context;
    HandlerContext _handlerContext;
    ServletHolder _holder = null;
    String _pathSpec;
    String _path;
    String _query;
    Resource _resource;
    ResourceHandler _resourceHandler;

    public void forward(javax.servlet.ServletRequest request, javax.servlet.ServletResponse response) throws ServletException, IOException {
        ServletRequest servletRequest = (ServletRequest)request;
        HttpRequest httpRequest = servletRequest.getHttpRequest();
        ServletResponse servletResponse = (ServletResponse)response;
        HttpResponse httpResponse = servletResponse.getHttpResponse();
        if (servletRequest.getHttpRequest().isCommitted()) {
            throw new IllegalStateException("Request is committed");
        }
        servletResponse.resetBuffer();
        servletResponse.setOutputState(-1);
        httpRequest.removeAttribute(__REQUEST_URI);
        httpRequest.removeAttribute(__SERVLET_PATH);
        httpRequest.removeAttribute(__CONTEXT_PATH);
        httpRequest.removeAttribute(__QUERY_STRING);
        httpRequest.removeAttribute(__PATH_INFO);
        if (this._query != null && this._query.length() > 0) {
            MultiMap parameters = new MultiMap();
            UrlEncoded.decodeTo(this._query, parameters);
            servletRequest.pushParameters(parameters);
            String oldQ = servletRequest.getQueryString();
            if (oldQ != null && oldQ.length() > 0) {
                UrlEncoded encoded = new UrlEncoded(oldQ);
                Iterator iter = parameters.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    encoded.put(entry.getKey(), entry.getValue());
                }
                this._query = encoded.encode(false);
            }
        }
        if (this._path == null) {
            this._holder.handle(servletRequest, servletResponse);
        } else {
            if (this._pathSpec != null) {
                Code.debug((Object)"Forward request to ", this._holder, (Object)" at ", this._pathSpec);
                servletRequest.setForwardPaths(this._context, PathMap.pathMatch(this._pathSpec, this._path), PathMap.pathInfo(this._pathSpec, this._path), this._query);
            }
            if (this._holder != null) {
                this._holder.handle(servletRequest, servletResponse);
            } else {
                this._context.getHandlerContext().handle(this._path, null, httpRequest, httpResponse);
            }
        }
    }

    public void include(javax.servlet.ServletRequest request, javax.servlet.ServletResponse response) throws ServletException, IOException {
        ServletRequest servletRequest = (ServletRequest)request;
        HttpRequest httpRequest = servletRequest.getHttpRequest();
        ServletResponse servletResponse = (ServletResponse)response;
        HttpResponse httpResponse = servletResponse.getHttpResponse();
        boolean old_locked = servletResponse.getLocked();
        servletResponse.setLocked(true);
        int old_output_state = servletResponse.getOutputState();
        servletResponse.setOutputState(0);
        if (this._resource != null) {
            Code.debug((Object)"Include resource ", (Object)this._resource);
            InputStream in = this._resource.getInputStream();
            try {
                int len = (int)this._resource.length();
                httpResponse.getOutputStream().write(in, len);
                Object var11_16 = null;
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                try {
                    in.close();
                }
                catch (IOException e) {
                    Code.ignore(e);
                }
                servletResponse.setLocked(old_locked);
                servletResponse.setOutputState(old_output_state);
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException e) {
                Code.ignore(e);
            }
            servletResponse.setLocked(old_locked);
            servletResponse.setOutputState(old_output_state);
            return;
        }
        if (this._pathSpec == null) {
            Code.debug((Object)"Include named ", (Object)this._holder);
            try {
                this._holder.handle(servletRequest, servletResponse);
                Object var10_20 = null;
                servletResponse.setLocked(old_locked);
            }
            catch (Throwable in) {
                Object var10_21 = null;
                servletResponse.setLocked(old_locked);
                servletResponse.setOutputState(old_output_state);
                throw in;
            }
            servletResponse.setOutputState(old_output_state);
            return;
        }
        if (this._query != null && this._query.length() > 0) {
            MultiMap parameters = new MultiMap();
            UrlEncoded.decodeTo(this._query, parameters);
            servletRequest.pushParameters(parameters);
        }
        Object old_request_uri = request.getAttribute(__REQUEST_URI);
        httpRequest.setAttribute(__REQUEST_URI, servletRequest.getRequestURI());
        Object old_context_path = request.getAttribute(__CONTEXT_PATH);
        httpRequest.setAttribute(__CONTEXT_PATH, servletRequest.getContextPath());
        Object old_query_string = request.getAttribute(__QUERY_STRING);
        httpRequest.setAttribute(__QUERY_STRING, this._query);
        Object old_servlet_path = request.getAttribute(__SERVLET_PATH);
        Object old_path_info = request.getAttribute(__PATH_INFO);
        try {
            Code.debug((Object)"Include request to ", this._holder, (Object)" at ", this._pathSpec);
            httpRequest.setAttribute(__SERVLET_PATH, PathMap.pathMatch(this._pathSpec, this._path));
            httpRequest.setAttribute(__PATH_INFO, PathMap.pathInfo(this._pathSpec, this._path));
            this._holder.handle(servletRequest, servletResponse);
        }
        finally {
            Object var15_24 = null;
            servletResponse.setLocked(old_locked);
            servletResponse.setOutputState(old_output_state);
            if (this._query != null && this._query.length() > 0) {
                servletRequest.popParameters();
            }
            httpRequest.setAttribute(__REQUEST_URI, old_request_uri);
            httpRequest.setAttribute(__CONTEXT_PATH, old_context_path);
            httpRequest.setAttribute(__QUERY_STRING, old_query_string);
            httpRequest.setAttribute(__SERVLET_PATH, old_servlet_path);
            httpRequest.setAttribute(__PATH_INFO, old_path_info);
        }
    }

    Dispatcher(Context context, String pathInContext, String query) throws IllegalStateException {
        Code.debug("Dispatcher for ", context, ",", pathInContext, ",", query);
        this._path = Resource.canonicalPath(pathInContext);
        this._query = query;
        this._context = context;
        this._handlerContext = this._context.getHandler().getHandlerContext();
        int i = this._handlerContext.getHandlerSize();
        while (i-- > 0) {
            HttpHandler handler = this._handlerContext.getHandler(i);
            if (handler instanceof ServletHandler) {
                Map.Entry entry;
                ServletHandler shandler = (ServletHandler)handler;
                if (!shandler.isStarted() || (entry = shandler.getHolderEntry(this._path)) == null) continue;
                this._pathSpec = (String)entry.getKey();
                this._holder = (ServletHolder)entry.getValue();
                break;
            }
            if (!(handler instanceof ResourceHandler) || this._resourceHandler != null) continue;
            this._resourceHandler = (ResourceHandler)handler;
        }
        if (this._holder == null && this._resourceHandler != null) {
            try {
                Resource resource = context.getServletHandler().getHandlerContext().getBaseResource();
                if (resource != null) {
                    resource = resource.addPath(this._path);
                }
                if (resource.exists() && !resource.isDirectory()) {
                    this._resource = resource;
                    Code.debug((Object)"Dispatcher for resource ", (Object)this._resource);
                }
            }
            catch (IOException e) {
                Code.ignore(e);
            }
        }
        if (this._holder == null && this._resource == null) {
            throw new IllegalStateException("No servlet handlers in context");
        }
    }

    Dispatcher(Context context, String name) throws IllegalStateException {
        this._context = context;
        this._handlerContext = this._context.getHandler().getHandlerContext();
        int i = this._handlerContext.getHandlerSize();
        while (i-- > 0) {
            ServletHandler handler;
            if (!(this._handlerContext.getHandler(i) instanceof ServletHandler) || !(handler = (ServletHandler)this._handlerContext.getHandler(i)).isStarted()) continue;
            this._holder = handler.getServletHolder(name);
            break;
        }
        if (this._holder == null) {
            throw new IllegalStateException("No named servlet handler in context");
        }
    }
}

